/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by
 *              Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include "config.h"
#include <glib.h>
#include <glib-object.h>

#include <gtx.h>
#include <dee.h>

/* Expects a clone with 3 rows in it */
gint
main (gint argc, gchar *argv[])
{
  DeeModel     *model;
  DeeModelIter *iter;
  
  g_type_init (); 
  g_thread_init (NULL);

  model = dee_shared_model_new (argv[1]);
  
  if (gtx_wait_for_signal (G_OBJECT (model), 100000, "notify::synchronized", NULL))
    g_error ("Helper model timed out waiting for 'ready' signal");

  g_assert_cmpint (dee_model_get_n_rows (model), ==, 3);

  iter = dee_model_get_iter_at_row (model, 0);
  g_assert_cmpint (dee_model_get_int32 (model, iter, 0), == , 0);
  g_assert_cmpstr (dee_model_get_string (model, iter, 1), == , "zero");

  iter = dee_model_get_iter_at_row (model, 1);
  g_assert_cmpint (dee_model_get_int32 (model, iter, 0), == , 1);
  g_assert_cmpstr (dee_model_get_string (model, iter, 1), == , "one");

  iter = dee_model_get_iter_at_row (model, 2);
  g_assert_cmpint (dee_model_get_int32 (model, iter, 0), == , 2);
  g_assert_cmpstr (dee_model_get_string (model, iter, 1), == , "two");
  
  return 0;
}
