#ifndef xcontrol_control_file_h_
#define xcontrol_control_file_h_ 1

#include "binary_section.h"
#include "source_section.h"

#include "control_file_stream.h"

#include <stdexcept>

#include <string>
#include <istream>

#include <list>

#include <boost/optional.hpp>

class control_file
{
public:
	control_file(void);
	control_file(std::string const &);

	void merge(std::string const &);
	void merge(std::istream &);

	bool operator==(control_file const &) const;
	bool operator!=(control_file const &rhs) const
	{
		return !operator==(rhs);
	}

	class unknown_section_type :
		public std::logic_error
	{
	public:
		unknown_section_type(std::string const &);
	};

	source_section const &source(void) const;
	source_section &source(void);

	typedef std::list<binary_section>::iterator binary_iterator;
	typedef std::list<binary_section>::const_iterator binary_const_iterator;

	binary_iterator binaries_begin(void) { return bin.begin(); }
	binary_iterator binaries_end(void) { return bin.end(); }

	binary_const_iterator binaries_begin(void) const { return bin.begin(); }
	binary_const_iterator binaries_end(void) const { return bin.end(); }

private:
	boost::optional<source_section> src;
	std::list<binary_section> bin;
};

control_file_ostream &operator<<(control_file_ostream &, control_file const &);

#endif
