//
// C++ Implementation: shareitemmodel
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "shareitemmodel.h"
#include <QtGui>
#include "log.h"

ShareItemModel::ShareItemModel()
{
}

QVariant ShareItemModel::data ( const QModelIndex & index, int role ) const
{
    if(!index.isValid()) return QVariant();
	
	// Special case
	if(role == Qt::DisplayRole && items.size()==0) return tr("Click or drag to add directories");
	if(role == Qt::TextColorRole && items.size()==0) return QColor(100,100,100,255);
	if(role == Qt::TextAlignmentRole && items.size()==0) return Qt::AlignCenter;
	
    if(index.row() < 0 || index.row() >= items.size()) return QVariant();
    if(index.column() < 0 || index.column()>2) return QVariant();
    if(role == Qt::DisplayRole) {
		
    switch(index.column()) {
        case 0:
            return items[index.row()].virtualDir;
        case 1:
            return items[index.row()].realDir;
        case 2:
            if(items[index.row()].shareSize==-1) return "pending";
            return items[index.row()].shareSize;                                                         
    }
    }   
    return QVariant();
}

QVariant ShareItemModel::headerData ( int section, Qt::Orientation orientation, int role ) const
{
    if (role != Qt::DisplayRole)
        return QVariant();

	if(items.size()==0) return QVariant();
	
    if(orientation==Qt::Horizontal) {
        if(section==0) return "Name";
        if(section==1) return "Directory";
        if(section==2) return "Size";
    }      
    return QVariant();
}

void ShareItemModel::add(const QString& name,const QString& dir)
{
    items.push_back(ShareItem(name,dir,-1));
    emit layoutChanged();
}

void ShareItemModel::remove(int row)
{
    vector<ShareItem>::iterator it = items.begin();          
    while(row--) it++;
    items.erase(it);
    emit layoutChanged();   
}

void ShareItemModel::clear( )
{
	items.clear();	
}

bool ShareItemModel::dropMimeData( const QMimeData * data, Qt::DropAction /*action*/, int /*row*/, int /*column*/, const QModelIndex & /*parent*/ )
{
	if(data->hasUrls()) {
		QList<QUrl> urls = data->urls();
		for(int i =0;i < urls.size();i++) {
			QString url = urls[i].toLocalFile();
			if(!url.isEmpty()) {
				// Obtain a name for this url
				//QString name = QInputDialog::getText(0,"Enter a name", "Enter a name for " + url);
				//if(!name.isEmpty() && !name.isNull())
				//	add(name,url);
				emit dirDropped(url);
			}
		}
	}
	return true;
}

Qt::DropActions ShareItemModel::supportedDropActions( ) const
{
	return Qt::ActionMask;
}

 Qt::ItemFlags ShareItemModel::flags(const QModelIndex &index) const
{
	Qt::ItemFlags defaultFlags = QAbstractTableModel::flags(index);

	if (index.isValid())
		return Qt::ItemIsDragEnabled | Qt::ItemIsDropEnabled | defaultFlags;
	else
		return Qt::ItemIsDropEnabled | defaultFlags;
}

QStringList ShareItemModel::mimeTypes( ) const
{
	QStringList sl;
	sl+="text/uri-list";
	return sl;
}


