/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;

namespace Db4objects.Db4o.Internal
{
	[System.Serializable]
	public class ClassIndexException : Exception
	{
		private string _className;

		public ClassIndexException(string className) : this(null, null, className)
		{
		}

		public ClassIndexException(string msg, string className) : this(msg, null, className
			)
		{
		}

		public ClassIndexException(Exception cause, string className) : this(null, cause, 
			className)
		{
		}

		public ClassIndexException(string msg, Exception cause, string className) : base(
			EnhancedMessage(msg, className), cause)
		{
			_className = className;
		}

		public virtual string ClassName()
		{
			return _className;
		}

		private static string EnhancedMessage(string msg, string className)
		{
			string enhancedMessage = "Class index for " + className;
			if (msg != null)
			{
				enhancedMessage += ": " + msg;
			}
			return enhancedMessage;
		}
	}
}
