/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Internal.CS.Messages;
using Db4objects.Db4o.Internal.Query.Processor;
using Db4objects.Db4o.Internal.Query.Result;
using Sharpen.Lang;

namespace Db4objects.Db4o.Internal.CS.Messages
{
	public sealed class MQueryExecute : MsgQuery, IServerSideMessage
	{
		private QueryEvaluationMode _evaluationMode;

		public bool ProcessAtServer()
		{
			try
			{
				Unmarshall(_payLoad._offset);
				lock (StreamLock())
				{
					Stream().WithTransaction(Transaction(), new _IRunnable_18(this));
				}
			}
			catch (Db4oException e)
			{
				WriteException(e);
			}
			return true;
		}

		private sealed class _IRunnable_18 : IRunnable
		{
			public _IRunnable_18(MQueryExecute _enclosing)
			{
				this._enclosing = _enclosing;
			}

			public void Run()
			{
				this._enclosing.WriteQueryResult(this._enclosing.Execute(), this._enclosing._evaluationMode
					);
			}

			private readonly MQueryExecute _enclosing;
		}

		private AbstractQueryResult Execute()
		{
			lock (StreamLock())
			{
				// TODO: The following used to run outside of the
				// synchronisation block for better performance but
				// produced inconsistent results, cause unknown.
				QQuery query = (QQuery)ReadObjectFromPayLoad();
				query.Unmarshall(Transaction());
				_evaluationMode = query.EvaluationMode();
				return ExecuteFully(query);
			}
		}

		private AbstractQueryResult ExecuteFully(QQuery query)
		{
			AbstractQueryResult qr = NewQueryResult(query.EvaluationMode());
			qr.LoadFromQuery(query);
			return qr;
		}
	}
}
