.\" vim:ft=nroff
.TH DATEFUDGE "1" "June 23th, 2011" "datefudge @VERSION@" Debian
.SH NAME
datefudge \- pretend the system time is different
.SH SYNOPSIS
\fBdatefudge\fR [\fI\-s\fR|\fI\-\-static\fR] \fIat_date program\fR [\fIarguments\fR ...]
.SH DESCRIPTION
.PP
\fBdatefudge\fR is a small utility that pretends that the system time is different
by pre-loading a small library which modifies the
\fBtime\fR(2), \fBgettimeofday\fR(2) and \fBclock_gettime\fR(2)  system calls.
.SH OPTIONS
.TP
\fB\-\-static\fR, \fB\-s\fR
set date as a `static' one. The above mentioned system calls will always return the date passed 
as a parameter of the program regardless of time passing. See EXAMPLES below.
.TP
\fB\-\-help\fR, \fB\-h\fR
print short usage information and exit.
.TP
\fB\-\-version\fR, \fB\-v\fR
print version information and exit.
.SH EXAMPLES
.SS Basic example:
.nf
\fI$ datefudge "2007\-04\-01 10:23" date \-R\fR
Sun, 01 Apr 2007 10:23:00 +0200
.fi
.SS Non-static vs. static example:
.nf
\fI$ datefudge "2007\-04\-01 10:23" sh \-c "\fBsleep 3\fI; date \-R"\fR
Sun, 01 Apr 2007 10:23:\fB03\fR +0200
.fi
.nf
\fI$ datefudge \fB\-\-static\fI "2007\-04\-01 10:23" sh \-c "\fBsleep 3\fI; date \-R"\fR
Sun, 01 Apr 2007 10:23:\fB00\fR +0200
.fi
.SH AUTHOR
Written by Matthias Urlichs <smurf@noris.de>. Modified by 
Robert Luberda <robert@debian.org>.
.SH BUGS
There is no attempt to make this change undetectable by the program.
In particular, file modification times are \fBnot\fR modified.
.\".SH "REPORTING BUGS"
.\"Send email to Matthias Urlichs <smurf@noris.de>.
.SH COPYRIGHT
Copyright \(co 2003 by Matthias Urlichs.
.br
Copyright \(co 2008-2011 by Robert Luberda.
.PP
There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  You may redistribute copies of datefudge under the
terms of the GNU General Public License.
.br
For more information about these matters, see the file named COPYING.
.SH "SEE ALSO"
\fBld.so\fR(1), \fBtime\fR(2), \fBgettimeofday\fR(2), \fBclock_gettime\fR(2)
