#!/usr/bin/env perl

# Some tests for 'darcs obliterate'

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;

init_tmp_repo();

touch qw/a.txt/;
darcs "add a.txt";
darcs "record -a -m 'adding a' a.txt";

touch qw/b.txt/;
darcs "add b.txt";
darcs "record -a -m 'adding b' b.txt";

like(
  echo_to_darcs("obliterate -p add","an"),
  qr/really obliterate/i, 
  "additional confirmation is given when 'all' option is selected");

like(
  echo_to_darcs("obliterate --last 1","n"),
  qr/adding b/, 
  "obliterate --last 1 gives expected result");


# Add a patch that depends on 'adding a' and try to obliterate 'adding a'

`date >> a.txt`;
darcs "record -a -m 'modifying a' a.txt";

like(
  echo_to_darcs("obliterate -p 'adding a'","n"),
  qr/modifying a/ && qr/No patches selected/,
  "obliterate asks about depending patches");

