/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "unix_platform.hpp"

#include "parallel_node.hpp"
#include "project_node.hpp"
#include "configuration_node.hpp"
#include "input_node.hpp"
#include "temporary_node.hpp"
#include "output_node.hpp"
#include "tool_node.hpp"
#include "environment_node.hpp"
#include "action_node.hpp"

#include "exceptions.hpp"

namespace dammit {

intrusive_ptr<node> unix_platform::visit(parallel_node &n)
{
	for(parallel_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); ++i)
	{
		*i = (**i).apply(*this);
	}
	return &n;
}

intrusive_ptr<node> unix_platform::visit(project_node &n)
{
	unix_platform pf;
	pf.current_project = &n;

	for(project_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); ++i)
		*i = (**i).apply(pf);

	return &n;
}

intrusive_ptr<node> unix_platform::visit(configuration_node &n)
{
	if(!current_project)
		throw invalid_tree_state("configurations must be below projects when applying platform config");

	if(n.nodes.empty())
		return &n;

	if(n.platform != "linux")
		return &n;

	intrusive_ptr<output_node> output(new output_node);

	output->directory = n.temporary_dir;

	switch(current_project->project_type)
	{
	case build_project::program:
		output->filename = current_project->project_name;
		output->filetype = output_node::executable;
		break;
	case build_project::library:
		output->filename = "lib" + current_project->project_name + ".a";
		output->filetype = output_node::static_library;
		break;
	}

	for(configuration_node::node_iterator i = n.nodes.begin();
			i != n.nodes.end(); ++i)
	{
		if(typeid(**i) == typeid(output_node))
			continue;

		output->inputs.push_back((**i).apply(*this));
	}

	if(output->inputs.size())
	{
		n.nodes.clear();
		n.nodes.push_back(output);
	}
	return &n;
}

intrusive_ptr<node> unix_platform::visit(input_node &n)
{
	return &n;
}

intrusive_ptr<node> unix_platform::visit(temporary_node &n)
{
	return &n;
}

intrusive_ptr<node> unix_platform::visit(output_node &n)
{
	return &n;
}

intrusive_ptr<node> unix_platform::visit(tool_node &n)
{
	return &n;
}

intrusive_ptr<node> unix_platform::visit(environment_node &n)
{
	return &n;
}

intrusive_ptr<node> unix_platform::visit(action_node &n)
{
	return &n;
}

}
