/* Copyright 2008 Simon Richter <Simon.Richter@hogyros.de>
 *
 * Released under the GNU General Public Licence version 3.
 */

#ifndef dammit_gnu_toolchain_hpp_
#define dammit_gnu_toolchain_hpp_ 1

#include "visitor.hpp"

#include "configuration_node.hpp"

namespace dammit {

class gnu_toolchain :
	public visitor
{
public:
	virtual ~gnu_toolchain(void) throw() { }

	virtual intrusive_ptr<node> visit(parallel_node &);
	virtual intrusive_ptr<node> visit(project_node &);
	virtual intrusive_ptr<node> visit(configuration_node &);
	virtual intrusive_ptr<node> visit(input_node &);
	virtual intrusive_ptr<node> visit(temporary_node &);
	virtual intrusive_ptr<node> visit(output_node &);
	virtual intrusive_ptr<node> visit(tool_node &);
	virtual intrusive_ptr<node> visit(environment_node &);
	virtual intrusive_ptr<node> visit(action_node &);

private:
	intrusive_ptr<configuration_node> configuration;
};

}

#endif
