PAMD(8)                    DACS Web Services Manual                    PAMD(8)



NNAAMMEE
       pamd - PAM transaction server

SSYYNNOOPPSSIISS
       ppaammdd [ddaaccssooppttiioonnss[1]] [--ddaaeemmoonn] [--ffoorrkk] [--hh _h_o_s_t_n_a_m_e] [--hhttttpp] [--iinneettdd]
            [--nnooffoorrkk]
            [--pp _p_o_r_t_n_u_m] [--ppoolliiccyy _n_a_m_e] [--sseeccuurree] [--uunnsseeccuurree]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ppaammdd server is required by the llooccaall__ppaamm__aauutthheennttiiccaattee[2]
       authentication module. It acts as a proxy for llooccaall__ppaamm__aauutthheennttiiccaattee,
       calling PAM functions on its behalf. The ppaammdd server may be started
       from iinneettdd((88))[3] or from the command line, but it must be running for
       DDAACCSS to perform PAM-based authentication.

       Each ppaammdd process is involved in an arbitrarily long "conversation" or
       "transaction" with one or more executions of llooccaall__ppaamm__aauutthheennttiiccaattee.
       For instance, ppaammdd''ss initial response to llooccaall__ppaamm__aauutthheennttiiccaattee might
       be that it requires an account name; upon receiving the account name
       from llooccaall__ppaamm__aauutthheennttiiccaattee, ppaammdd''ss response might be that it requires
       the password for the account; and upon receiving the password, ppaammdd
       would indicate success or failure, depending on whether an acceptable
       username/password pair was received. The eventual outcome of a
       transaction is that authentication succeeds, fails, or could not be
       completed because an error occurs.

       ppaammdd must be run on the host where ppaamm((33))[4] processing is being
       performed, which is not necessarily the same host where
       llooccaall__ppaamm__aauutthheennttiiccaattee is executed.

           SSeeccuurriittyy
           +o   ppaammdd will usually be run as root so that it can access the
               files it needs to perform authentication.

           +o   ppaammdd is not a DDAACCSS web service and is not protected by DDAACCSS.

           +o   The protocol between ppaammdd and its client may include sensitive
               material, such as passwords. If both programs are run on the
               same host, this is probably not an issue. If there is any
               possibility of eavesdropping etc. by an attacker, however,
               communication should be secured through an SSL wrapper.

           +o   ppaammdd should probably not be run on a world-accessible server,
               since it would offer a way for attackers to try to guess
               passwords.

       The operating system's PAM policy file is consulted - see
       ppaamm..ccoonnff((55))[5]. The default PAM service name is "dacs" (see
       ppaamm__ssttaarrtt((33))[6]), which may be used by PAM to locate the appropriate
       policy file. A different policy name can be specified using the --ppoolliiccyy
       flag.

       The prompts that passed from PAM to ppaammdd to llooccaall__ppaamm__aauutthheennttiiccaattee to
       ddaaccss__aauutthheennttiiccaattee (or ddaaccssaauutthh) are simply displayed to the user. The
       user must understand what the prompts mean (e.g., that "Login:" means
       to provide a Unix account name).

       ppaammdd can be used by non-DDAACCSS applications. The protocol, though simple,
       is not yet documented other than within the source code. A program
       called ppaammdd--cclliieenntt is available for testing and debugging ppaammdd; it is
       built when PAM support is required, but is neither installed nor
       documented (see the source code for basic instructions).

OOPPTTIIOONNSS
       In addition to the standard _d_a_c_s_o_p_t_i_o_n_s[1], ppaammdd recognizes these
       command line flags:

       --ddaaeemmoonn
           Wait for a connection, then service the request. Mutually exclusive
           with --iinneettdd.

       --ffoorrkk
           Create a new process to service each request. It implies the
           --ddaaeemmoonn flag.

       --hh _h_o_s_t_n_a_m_e
           If ppaammdd is running on a host with multiple IP addresses, this
           specifies the hostname (or IP address) to listen to for incoming
           requests. If not provided, the PPAAMMDD__HHOOSSTT[7] directive will be
           consulted; if unavailable, ggeetthhoossttnnaammee((33))[8] will be used.

       --hhttttpp
           This flag is reserved for future use.

       --iinneettdd
           The server assumes it has been started by iinneettdd((88))[3] and therefore
           does not wait for a connection. It exits after servicing the
           request. This is the default behaviour and preferred way to
           configure ppaammdd. This mode of operation assumes that an entry has
           been added to iinneettdd..ccoonnff((55))[9] that looks much like this:

               dacs-pamd stream tcp nowait root /usr/local/dacs/sbin/pamd pamd -uj EXAMPLE -inetd


       --nnooffoorrkk
           This flag, which implies the --ddaaeemmoonn, causes the ppaammdd server to
           exit after servicing one request (which is useful when debugging).
           This is the default behaviour of --ddaaeemmoonn mode.

       --pp _p_o_r_t_n_u_m
           This specifies the port number to listen to, overriding any
           PPAAMMDD__PPOORRTT[10] directive in effect. It can also be a service name.
           Any otherwise unassigned port number on the system from 49152
           through 65535 (i.e., one in the dynamic and/or private range) ought
           to be acceptable.

           If neither this flag nor a PAMD_PORT directive is provided, the
           program will try to find the port associated with the dacs-pamd
           service name in sseerrvviicceess((55))[11]. For example:

               dacs-pamd       17000/tcp  # DACS pamd


       --ppoolliiccyy _n_a_m_e
           Use _n_a_m_e as the PAM policy name instead of the default.

       --sseeccuurree
           The client must supply valid DDAACCSS administrative credentials
           encapsulated within a DDAACCSS cookie. This is the default.

       --uunnsseeccuurree
           Administrative credentials are not required, but if they are
           provided they must be valid. This should probably be used only when
           testing or if client identification is not an issue or has been
           addressed in some other way.

           NNoottee
           When the --sseeccuurree flag is in effect, ppaammdd must be associated with a
           jurisdiction. Therefore, the DDAACCSS configuration files are read and
           the jurisdiction must be specified on the command line (e.g., using
           the --uujj flag).

EEXXAAMMPPLLEE
       For testing purposes, or to better understand how ppaammdd works, you can
       run it manually and interact with it using tteellnneett((11))[12], for example,
       which takes the place of llooccaall__ppaamm__aauutthheennttiiccaattee. You must have PAM
       authentication configured on the host where you run ppaammdd and you will
       probably need to run it as root. This is best done using two windows;
       start ppaammdd in the first window and then tteellnneett to it from the second
       window.

       An interaction to perform username/password authentication will look
       something like the following (substitute your jurisdiction's name for
       myjur, your jurisdiction's domain name or IP address for
       myjur.example.com, and use a username and password pair that is
       recognized on your system). The first tteellnneett connection receives a
       prompt for a username (labeled "Login:" and assigned the variable name
       _A_U_T_H___P_R_O_M_P_T___V_A_R_1) from ppaammdd, a transaction identifier (_T_R_A_N_S_I_D)
       "10.0.0.124:56372:66664:53983facb39881b2" for this session, and port
       number to use for subsequent operations belonging to this transaction
       (62475). The second tteellnneett connection provides the _T_R_A_N_S_I_D and username
       (AUTH_PROMPT_VAR1="auggie"), and receives a prompt for a password
       ("Password:", assigned the variable name _A_U_T_H___P_R_O_M_P_T___V_A_R_2). The third
       tteellnneett connection provides the _T_R_A_N_S_I_D and the password
       (AUTH_PROMPT_VAR2="doggy"), and receives the result of authentication
       ("Success").

           # ./pamd -uj myjur -ll debug -daemon -unsecure -nofork
           pamd[info]: Site config file is "/usr/local/dacs/federations/site.conf"
           pamd[info]: Config file is "/usr/local/dacs/federations/dacs.conf"
           pamd[info]: This is jurisdiction DSS::myjur
           pamd[info]: Secure mode is off
           pamd[debug]: Waiting for initial input block...
           pamd[debug]: No username
           pamd[debug]: Calling pam_authenticate
           pamd[debug]: pamd_conv: reply to port 62475
           pamd[debug]: TRANSID is "10.0.0.124:56372:66664:53983facb39881b2"
           pamd[debug]:   type="text"
           pamd[debug]:   label="Login:"
           pamd[debug]:   varname="AUTH_PROMPT_VAR1"
           pamd[debug]: pamd_conv: waiting 60 seconds for reply
           pamd[debug]: pamd_conv: received connection
           pamd[debug]: Reading reply...
           pamd[debug]: pamd_conv: reply to port 62475
           pamd[debug]: TRANSID is "10.0.0.124:62475:66695:fc855a7d68e8b1eb"
           pamd[debug]:   type="password"
           pamd[debug]:   label="Password:"
           pamd[debug]:   varname="AUTH_PROMPT_VAR2"
           pamd[debug]: pamd_conv: waiting 60 seconds for reply
           pamd[debug]: pamd_conv: received connection
           pamd[debug]: Reading reply...
           pamd[debug]: Success
           pamd[debug]: result="ok"
           pamd[debug]: username="auggie"



           % telnet myjur.example.com 17000
           Trying 10.0.0.124...
           Connected to bsd6.dss.bc.ca.
           Escape character is '^]'.

           Connection closed by foreign host.
           % telnet myjur.example.com 62475
           Trying 10.0.0.124...
           Connected to bsd6.dss.bc.ca.
           Escape character is '^]'.
           TRANSID="10.0.0.124:62475:66695:fc855a7d68e8b1eb"
           AUTH_PROMPT_VAR1="auggie"

           Connection closed by foreign host.
           % telnet myjur.example.com 62475
           Trying 10.0.0.124...
           Connected to bsd6.dss.bc.ca.
           Escape character is '^]'.
           TRANSID="10.0.0.124:62475:66695:fc855a7d68e8b1eb"
           AUTH_PROMPT_VAR2="doggy"

           result="ok"
           username="auggie"
           Connection closed by foreign host.


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       The --ddaaeemmoonn flag should cause the process to detach and put itself in
       the background unless overridden by another flag; at present it must be
       started in the background "manually".

       The --hhttttpp flag, which would allow a ppaammdd session to be started with a
       web service request, is not implemented.

SSEEEE AALLSSOO
       ddaaccss__aauutthheennttiiccaattee((88))[13], ddaaccssaauutthh((11))[14], ppaamm((33))[15], XX//OOppeenn SSiinnggllee
       SSiiggnn--OOnn SSeerrvviiccee ((XXSSSSOO)) pprreelliimmiinnaarryy ssppeecciiffiiccaattiioonn[16]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[17])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[18] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_pam_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_pam_authenticate

        3. inetd(8)
           http://www.freebsd.org/cgi/man.cgi?query=inetd&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

        4. pam(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam&apropos=0&sektion=0&manpath=FreeBSD+7.2-RELEASE&format=html

        5. pam.conf(5)
           http://www.freebsd.org/cgi/man.cgi?query=pam.conf&apropos=0&sektion=5&manpath=FreeBSD+7.2-RELEASE&format=html

        6. pam_start(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam_start&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        7. PAMD_HOST
           http://dacs.dss.ca/man/dacs.conf.5.html#PAMD_HOST

        8. gethostname(3)
           http://www.freebsd.org/cgi/man.cgi?query=gethostname&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

        9. inetd.conf(5)
           http://www.freebsd.org/cgi/man.cgi?query=inetd.conf&apropos=0&sektion=5&manpath=FreeBSD+7.2-RELEASE&format=html

       10. PAMD_PORT
           http://dacs.dss.ca/man/dacs.conf.5.html#PAMD_PORT

       11. services(5)
           http://www.freebsd.org/cgi/man.cgi?query=services&apropos=0&sektion=5&manpath=FreeBSD+7.2-RELEASE&format=html

       12. telnet(1)
           http://www.freebsd.org/cgi/man.cgi?query=telnet&apropos=0&sektion=1&manpath=FreeBSD+7.2-RELEASE&format=html

       13. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       14. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       15. pam(3)
           http://www.freebsd.org/cgi/man.cgi?query=pam&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       16. X/Open Single Sign-On Service (XSSO) preliminary specification
           http://www.opengroup.org/pubs/catalog/p702.htm

       17. www.dss.ca
           http://www.dss.ca

       18. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                           PAMD(8)
