DACSEMAIL(1)                 DACS Commands Manual                 DACSEMAIL(1)



NNAAMMEE
       dacsemail - Simple outgoing email agent

SSYYNNOOPPSSIISS
       ddaaccsseemmaaiill [--bbcccc _a_d_d_r] [{--bbff | ----bbooddyyffiillee} _p_a_t_h]
                 [{--bbss | ----bbooddyyssttrriinngg} _s_t_r_i_n_g] [--cccc _a_d_d_r]
                 [--cctt _v_a_l_u_e] [{--ff | ----ffrroomm} _f_r_o_m] [--hh | ----hheellpp]
                 [--hheeaaddeerr _n_a_m_e _v_a_l_u_e]
                 [{--mmaaiilleerr | --mmttaa} _p_a_t_h] [{--mmaaiilleerr--ffllaaggss | --mmttaa--ffllaaggss} _s_t_r_i_n_g]
                 [--pp | ----pprroommpptt] [--ssaavvee _p_a_t_h] [{--ss | ----ssuubbjjeecctt} _s_u_b_j_e_c_t]
                 [--sseennddeerr _s_e_n_d_e_r] [{--tt | ----ttoo} _a_d_d_r] [--ttrraannssffoorrmm] [--vv |
                 ----vveerrbboossee] [--vvaarr _n_a_m_e _v_a_l_u_e]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccsseemmaaiill utility is a simple agent for sending email messages. It
       is a stand-alone program that neither accepts the usual DDAACCSS command
       line options (ddaaccssooppttiioonnss[1]) nor accesses any DDAACCSS configuration
       files.

       ddaaccsseemmaaiill constructs an RRFFCC 882222[2] format message but does not transmit
       it. It requires an external mailer, such as sseennddmmaaiill((88))[3], to transfer
       the message. The mailer command and its arguments can be specified on
       the ddaaccsseemmaaiill command line (see --mmaaiilleerr) or at build time (see
       ddaaccss..iinnssttaallll((77))[4]).

OOPPTTIIOONNSS
       If the source for the message body is not specified on the command
       line, it will be read from the standard input. At least one recipient
       must be specified using --tt, --cccc, or --bbcccc.

       --bbcccc _a_d_d_r
           Send the message to the undisclosed recipient address _a_d_d_r. It is
           the responsibility of the mailer to delete these recipient
           addresses before transmitting the message. This flag may be
           repeated.

       --bbff _p_a_t_h
       ----bbooddyyffiillee _p_a_t_h
           Read the message body from _p_a_t_h. If _p_a_t_h is -, the standard input
           is read.

       --bbss _s_t_r_i_n_g
       ----bbooddyyssttrriinngg _s_t_r_i_n_g
           Use _s_t_r_i_n_g as the message body.

       --cccc _a_d_d_r
           Send the message to recipient _a_d_d_r as a carbon copy. This flag may
           be repeated.

       --cctt _v_a_l_u_e
           Add a Content-type header of MIME type _v_a_l_u_e to the message. If
           _v_a_l_u_e is multipart/alternative, an appropriate _b_o_u_n_d_a_r_y variable
           will be created, unless one has already been specified on the
           command line with the --vvaarr flag. It is assumed that the message
           body has already been correctly formatted for this MIME type, or
           will be after it has been transformed (see --ttrraannssffoorrmm).

       --ff _f_r_o_m
       ----ffrroomm _f_r_o_m
           Use _f_r_o_m as the value of the message's From header.

       --hh
       ----hheellpp
           Print usage information and then exit.

       --hheeaaddeerr _n_a_m_e _v_a_l_u_e
           Add a message header named _n_a_m_e with value _v_a_l_u_e. This flag should
           only be used for headers that do not have specific flags (--tt, --cctt,
           --ff, and so on).

       --mmaaiilleerr _p_a_t_h
       --mmttaa _p_a_t_h
           Use the message transfer agent command _p_a_t_h (a full pathname)
           instead of the configured program. This program must read the
           message from its standard input and extract the list of recipients
           from the message's To, Cc, and Bcc headers. (If such a mailer is
           unavailable, it will be necessary to write a small program to wrap
           a mailer and provide the required interface to ddaaccsseemmaaiill.) The
           default is to run sseennddmmaaiill((88))[3] with its --tt flag.

       --mmaaiilleerr--ffllaaggss _s_t_r_i_n_g
       --mmttaa--ffllaaggss _s_t_r_i_n_g
           Regardless of the mailer, use _s_t_r_i_n_g for its command line flags.

       --pp
       ----pprroommpptt
           Just before the message is to be sent, display it (to stderr) and
           wait for the user to respond to a prompt. At the prompt, the user
           may abort the message or allow it to be sent.

       --ssaavvee _p_a_t_h
           Just before sending (or prompting), write a copy of the outgoing
           message to _p_a_t_h, replacing any previous contents of the file.

       --ss _s_u_b_j_e_c_t
       ----ssuubbjjeecctt _s_u_b_j_e_c_t
           Set the message's Subject header to _s_u_b_j_e_c_t.

       --sseennddeerr _s_e_n_d_e_r
           Set the message's Sender header to _s_e_n_d_e_r.

       --tt _a_d_d_r
       ----ttoo _a_d_d_r
           Add _a_d_d_r as a "To" recipient. This flag may be repeated.

       --ttrraannssffoorrmm
           The message body, regardless of how it is specified, is filtered
           through the DDAACCSS transformation function. Please refer to
           ddaaccss__ttrraannssffoorrmm((88))[5] for details. No access control rules may be
           associated with any transformation; i.e., they are all
           unconditional. A similar effect can be obtained by piping the
           output of ddaaccssttrraannssffoorrmm((11))[6] into ddaaccsseemmaaiill.

       --vv
       ----vveerrbboossee
           Enable verbose output for debugging.

       --vvaarr _n_a_m_e _v_a_l_u_e
           Create aa vvaarriiaabbllee[7] named _n_a_m_e set to _v_a_l_u_e for the transform
           function. The variable's value can be referenced within the message
           body in the _D_A_C_S namespace as _$_{_D_A_C_S_:_:_n_a_m_e_}. The variable must not
           already be defined.

EEXXAAMMPPLLEESS
       Suppose the myfile contains the following text:


           <!--DACS expand="*" -->
           This is a multi-part message in MIME format.

           --${DACS::boundary}
           Content-Type: text/plain; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           Hello, ${DACS::user}!

           --${DACS::boundary}
           Content-Type: text/html; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           <p>
           <font color="red">Hello, ${DACS::user}!</font>
           </p>
           --${DACS::boundary}--
           <!--DACS end="*" -->

       The following command might be used to send a message with a
       multipart/alternative structured body:

           % dacsemail -ct multipart/alternative -f auggie@example.com \
                 -t harley@example.com -s "Hello" -transform -var user Auggie -bf myfile

       The resulting message will look something like the following:

           To: harley@example.com
           From: auggie@example.com
           Subject: Hello
           Content-type: multipart/alternative; boundary="_----------=_03885942562898683484"
           Date: Wed, 07 Apr 2010 16:48:41 -0700 (PDT)
           Content-transfer-encoding: 7bit
           X-mailer: DACS 1.4.24a

           This is a multi-part message in MIME format.

           --_----------=_03885942562898683484
           Content-Type: text/plain; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           Hello, Auggie!

           --_----------=_03885942562898683484
           Content-Type: text/html; charset=us-ascii
           Content-Disposition: inline
           Content-Transfer-Encoding: 7bit

           <p>
           <font color="red">Hello, Auggie!</font>
           </p>
           --_----------=_03885942562898683484--


FFIILLEESS
       None.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.
       Error messages are printed to stderr. Errors and routine messages from
       the mailer are recorded wherever they usually logged, outside of DDAACCSS

BBUUGGSS
       This program's primary purpose is for testing DDAACCSS functionality that
       is needed for internal purposes. No significant improvements are
       envisioned. You could throw a rock and hit a better email agent.

SSEEEE AALLSSOO
       ddaaccss..eexxpprrss((55))[8], ddaaccss..iinnssttaallll((77))[4], ddaaccss__ttrraannssffoorrmm((88))[5],
       sseennddmmaaiill((88))[3]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[9])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[10] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. RFC 822
           http://www.rfc-editor.org/rfc/rfc822.txt

        3. sendmail(8)
           http://www.freebsd.org/cgi/man.cgi?query=sendmail&apropos=0&sektion=8&manpath=FreeBSD+7.2-RELEASE&format=html

        4. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html#configure_options

        5. dacs_transform(8)
           http://dacs.dss.ca/man/dacs_transform.8.html

        6. dacstransform(1)
           http://dacs.dss.ca/man/dacstransform.1.html

        7. a variable
           http://dacs.dss.ca/man/dacs.exprs.5.html#variable_syntax

        8. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#transform

        9. www.dss.ca
           http://www.dss.ca

       10. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                      DACSEMAIL(1)
