DACS_UPROXY(8)             DACS Web Services Manual             DACS_UPROXY(8)



NNAAMMEE
       dacs_uproxy - minimal HTTP proxying

SSYYNNOOPPSSIISS
       ddaaccss__uupprrooxxyy [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This web service is part of the DDAACCSS suite.

       The ddaaccss__uupprrooxxyy web service accepts an incoming HTTP request (the
       initial request), then reissues a nearly identical HTTP request to a
       different URL (the proxied request) and returns its unaltered response.
       The initial request must use either the GET or POST HTTP method; the
       proxied request will use the same method as the initial request. Note
       that the origin server (the web server that receives the proxied
       request) will see a request that originates at the host that runs
       ddaaccss__uupprrooxxyy, not the host that issues the initial request.

       When run on a firewall host, the program can be useful for forwarding
       incoming requests to interior hosts. An origin server does not need to
       be running DDAACCSS. All access control is performed by the jurisdiction
       that runs ddaaccss__uupprrooxxyy. Similarly, the program can be useful for
       forwarding requests that originate behind the firewall, subject to
       access control permission.

       ddaaccss__uupprrooxxyy is not a transparent proxy server. A request URL must be
       explicitly addressed to it and include a (partial) name for the target
       resource.

           SSeeccuurriittyy
           The program must be configured with care because it can expose
           otherwise inaccessible hosts to arbitrary HTTP requests from any
           source that can connect to ddaaccss__uupprrooxxyy.

           Particular care must be taken if a program that is invoked by
           ddaaccss__uupprrooxxyy generates a redirect that may be handled internally by
           the program's web server. In this event the new request arising
           from the redirection _w_i_l_l _n_o_t _a_u_t_o_m_a_t_i_c_a_l_l_y _b_e _s_u_b_j_e_c_t_e_d _t_o _a_c_c_e_s_s
           _c_o_n_t_r_o_l because the new request does come through ddaaccss__uupprrooxxyy.
           Therefore, local redirects must be avoided by proxied web services,
           resources that might be invoked through a local redirect must be
           publicly accessible, or authorization checking must somehow be
           arranged for these resources.

           Access control rules are primarily responsible for expressing
           restrictions on what can be proxied and who can use this service.
           By default, all access to this service is denied. Additionally,
           UUPPRROOXXYY__AAPPPPRROOVVEEDD[2] directives must be configured to allow proxying
           to specific origin servers.

           Although in its current form the program has the effect of
           anonymizing the proxied request, this is more of a bug than a
           feature. Future versions may forward an initial request's headers
           and other information.

       With the exception of the Cookie header, most request headers that
       accompany the initial request are sent with the proxied request.
       ddaaccss__uupprrooxxyy makes no attempt to "impersonate" the user's host, however.
       Therefore, to the origin server it appears as if the request is coming
       from ddaaccss__uupprrooxxyy and the IP address from which the forwarded request is
       sent. Any cookies sent with the initial request are interpreted by
       ddaaccss__uupprrooxxyy (e.g., to identify the user making the request for access
       control purposes). At present, it is not possible to forward cookies
       with the proxied request.

       So that the proxied web service can tell that it is being invoked by
       ddaaccss__uupprrooxxyy, an extension header named DACS-Uproxy-Via is included with
       the forwarded request. Its value is the URL of ddaaccss__uupprrooxxyy with the
       proxied host appended. With Apache, its value can be accessed from the
       environment variable HHTTTTPP__DDAACCSS__UUPPRROOXXYY__VVIIAA.

       If ddaaccss__uupprrooxxyy is passed a DDAACCSS__AAPPPPRROOVVAALL[3] value, that value is
       forwarded with the request through the DACS-Uproxy-Approval header and
       made available by Apache in the HHTTTTPP__DDAACCSS__UUPPRROOXXYY__AAPPPPRROOVVAALL environment
       variable. A program invoked indirectly through ddaaccss__uupprrooxxyy can use this
       information to confirm that DDAACCSS authorized the request.

       If the forwarded request generates a redirect (a 3xx class HTTP status
       code is returned), it causes ddaaccss__uupprrooxxyy to return the redirection
       request.

       The program is a minimal or "micro" HTTP proxy, hence the _u in
       ddaaccss__uupprrooxxyy should really be the Greek letter _m_u.

   WWeebb SSeerrvviiccee AArrgguummeennttss
       With some exceptions, all arguments passed to ddaaccss__uupprrooxxyy are forwarded
       to the proxied request and are not interpreted by ddaaccss__uupprrooxxyy. The
       first exception is DDAACCSS__AACCSS[4]. Another exception is _D_A_C_S___U_P_R_O_X_Y; if
       its value is DEBUG, debugging output is produced. Neither of these
       arguments is forwarded with the proxied request.

   OOppeerraattiioonn
       A specification of the proxied request appears as a component of the
       initial request. It is best to explain this with an example. Let us
       assume that the URL for the ddaaccss__uupprrooxxyy that the client wants to use is
       https://example.com/cgi-bin/dacs/dacs_uproxy. Let us also assume that
       the client wants to access a web service at foo.example.com (the
       proxied host) and that this web service can be invoked from example.com
       (the proxying host) as https://foo.example.com/cgi-bin/some_app. To
       achieve this, the client would invoke this URL:

           https://example.com/cgi-bin/dacs/dacs_uproxy/foo.example.com/cgi-bin/some_app

       Note that no scheme is included with the name of the proxied host. A
       port number may follow it, however, and any path components that follow
       are appended (after the mapping specified by UPROXY_APPROVED) to form
       the final proxied URL.

       For this example to be authorized, an access control rule must grant
       the user access to the initial URL. Whether there is additional access
       control enforced at the proxied host is the responsibility of a web
       administrator. A simple rule that grants access to any authenticated
       user looks like this:

           <acl_rule status="enabled">
             <services>
               <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_uproxy"'/>
               <service url_expr='"${Conf::dacs_cgi_bin_prefix}/dacs_uproxy/*"'/>
             </services>

             <rule order="allow,deny">
              <allow>
                user("auth")
              </allow>
             </rule>
           </acl_rule>

       Most sophisticated rules may of course be used to further constrain how
       ddaaccss__uupprrooxxyy can be used and by whom.

       The UUPPRROOXXYY__AAPPPPRROOVVEEDD[2] directive must be configured before ddaaccss__uupprrooxxyy
       will do anything, even if otherwise permitted by an access control
       rule.

       If SSL is used for the proxied request, the usual DDAACCSS configuration
       directives for SSL apply - see ddaaccss..ccoonnff((55))[5]. SSL can be used for the
       proxied request independently of whether it is used for the initial
       request.

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       The implementation may not yet fully conform to RRFFCC 22661166[6].

SSEEEE AALLSSOO
       RRFFCC 22661166[6]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[7])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[8] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. UPROXY_APPROVED
           http://dacs.dss.ca/man/dacs.conf.5.html#UPROXY_APPROVED

        3. DACS_APPROVAL
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

        4. DACS_ACS
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_acs_argument

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. RFC 2616
           http://www.rfc-editor.org/rfc/rfc2616.txt

        7. www.dss.ca
           http://www.dss.ca

        8. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                    DACS_UPROXY(8)
