DACS_MANAGED_INFOCAR(8)    DACS Web Services Manual    DACS_MANAGED_INFOCAR(8)



NNAAMMEE
       dacs_managed_infocard - create a managed Information Card

SSYYNNOOPPSSIISS
       ddaaccss__mmaannaaggeedd__iinnffooccaarrdd [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccss__mmaannaaggeedd__iinnffooccaarrdd web service is used to create and register a
       managed InfoCard so that it can be used for authentication or other
       purposes. InfoCard-based authentication is performed by
       llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[2], a DDAACCSS authentication module.

       A managed InfoCard must be registered by ddaaccss__mmaannaaggeedd__iinnffooccaarrdd before
       it can be used by DDAACCSS. After registration, use ddaaccss__iinnffooccaarrdd((88))[3] or
       ddaaccssiinnffooccaarrdd((11))[4] to administer self-issued or managed InfoCards.

       There are several operational modes, determined by the _M_O_D_E argument.
       In a self-serve mode, an authenticated user requests a managed InfoCard
       (with various limitations imposed); the new InfoCard is either sent
       directly to the user's browser or written to a file that the user can
       access in a separate operation. In an administrative mode, a DDAACCSS
       administrator requests a managed InfoCard on behalf of a user and is
       responsible for directing it to the user in a separate, secure
       operation.

       There are many ccoonnffiigguurraattiioonn ddiirreeccttiivveess[5] associated with managed
       InfoCards. One of the most important is IINNFFOOCCAARRDD__SSTTSS__AAUUTTHH__TTYYPPEE[6],
       which determines the authentication method ("credential type") used
       between an Identity Selector, such as CCaarrddSSppaaccee, and the managed
       InfoCard's Identity Provider/Secure Token Service (IP/STS), such as
       ddaaccss__ssttss((88))[7]. The following authentication methods are prescribed by
       the InfoCard specification:

       UsernamePasswordCredential
           This is a username/password type of authentication. See
           IINNFFOOCCAARRDD__SSTTSS__PPAASSSSWWOORRDD__MMEETTHHOODD[8]. At present, only a global (but
           changeable) password is allowed, or no password at all. A future
           release might allow a per-InfoCard account password, or tie an
           InfoCard account to some other password-based account.

       X509V3Credential
           In this authentication type, an SSL client certificate must be used
           with the request to ddaaccss__mmaannaaggeedd__iinnffooccaarrdd for a managed InfoCard,
           and the same certificate must be used when the managed InfoCard is
           submitted to a Relying Party. A self-signed certificate may be
           used.

       SelfIssuedCredential
           In this authentication type, a self-issued InfoCard must be
           submitted with the request to ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[9] for a
           managed InfoCard (more precisely, a secure token obtained from a
           self-issued InfoCard that is passed as the argument _x_m_l_T_o_k_e_n) and
           the same self-issued InfoCard must be available to the user's
           Identity Selector when the managed InfoCard is submitted to a
           Relying Party.

       KerberosV5Credential
           This is the Kerberos V5 credential type. This authentication
           credential type is currently unsupported.

           NNoottee
           An Identity Selector will display all claim values returned to it
           by an Identity Provider. An Identity Provider must therefore employ
           cryptographic methods to obtain privacy or check authenticity with
           respect to claim values.

       Accounts are accessed through DDAACCSS''ss virtual filestore using item type
       infocards. It is assumed that file permissions on the account database
       are such that all access is limited to the administrator,
       llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee, ddaaccss__iinnffooccaarrdd((88))[3], and ddaaccss__ssttss((88))[7].

   CCoonnffiigguurraattiioonn
       The following configuration variables are available:

       _i_n_f_o_c_a_r_d___c_a_r_d___i_m_a_g_e___c_a_r_d
           If IINNFFOOCCAARRDD__SSTTSS__AAUUTTHH__TTYYPPEE[6] is "card", this is used as the
           filename of the image to include with a new managed card, relative
           to the IINNFFOOCCAARRDD__CCAARRDD__IIMMAAGGEE__BBAASSEE__UURRLL[10] URI. The default value is
           the string "dacs_selfissued_credential.png" (or similar).

       _i_n_f_o_c_a_r_d___c_a_r_d___i_m_a_g_e___c_e_r_t
           If IINNFFOOCCAARRDD__SSTTSS__AAUUTTHH__TTYYPPEE[6] is "cert", this is used as the
           filename of the image to include with a new managed card, relative
           to the IINNFFOOCCAARRDD__CCAARRDD__IIMMAAGGEE__BBAASSEE__UURRLL[10] URI. The default value is
           the string "dacs_x509certificate_credential.png" (or similar).

       _i_n_f_o_c_a_r_d___c_a_r_d___i_m_a_g_e___p_a_s_s_w_d
           If IINNFFOOCCAARRDD__SSTTSS__AAUUTTHH__TTYYPPEE[6] is "passwd", this is used as the
           filename of the image to include with a new managed card, relative
           to the IINNFFOOCCAARRDD__CCAARRDD__IIMMAAGGEE__BBAASSEE__UURRLL[10] URI. The default value is
           the string "dacs_username_password_credential.png" (or similar).

       _i_n_f_o_c_a_r_d___s_t_s___t_i_t_l_e
           This string identifies the IP/STS and may be displayed on web pages
           and Identity Selector prompts, or in error messages. The default
           value is the string "DACS Managed InfoCard IP/STS" (or similar).

       _i_n_f_o_c_a_r_d___s_t_s___u_s_e_r_n_a_m_e___p_a_s_s_w_o_r_d___p_r_o_m_p_t___f_m_t
           This is a pprriinnttff((33))[11]-type format string. It may contain at most
           one conversion specification, %s, which will interpolate the value
           of _i_n_f_o_c_a_r_d___s_t_s___t_i_t_l_e.

OOPPTTIIOONNSS
   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[12], ddaaccss__mmaannaaggeedd__iinnffooccaarrdd
       understands the following CGI arguments:


       _x_m_l_T_o_k_e_n
           This argument is required if IINNFFOOCCAARRDD__SSTTSS__AAUUTTHH__TTYYPPEE[6] is set to
           "card". The self-issued InfoCard is registered with the account
           associated with the new managed InfoCard and the user's Identity
           Selector must possess the self-issued InfoCard in order to use the
           managed InfoCard.

       _C_A_R_D___I_M_A_G_E___S_U_B_T_Y_P_E
           This optional argument specifies the MIME media subtype (e.g., the
           image format, such as "jpeg") of the image file attached to the new
           InfoCard. By default, the subtype is derived from the extension on
           the end of the last path component of the image's URI. For example,
           if _C_A_R_D___I_M_A_G_E___U_R_L is /card_images/bob.tn.gif, then the extension
           .gif is used to obtain a media subtype of gif and a MIME media type
           of image/gif. It is sometimes necessary to give the image format
           explicitly, however. See IINNFFOOCCAARRDD__CCAARRDD__IIMMAAGGEE__BBAASSEE__UURRLL[10] for
           additional details. Only a DDAACCSS administrator may use this
           argument.

       _C_A_R_D___I_M_A_G_E___U_R_L
           This optional argument specifies the location (as a DDAACCSS VVFFSS
           UURRII[13]) of the image file to attach to the new InfoCard,
           overriding the default method that uses only
           IINNFFOOCCAARRDD__CCAARRDD__IIMMAAGGEE__BBAASSEE__UURRLL[10]. If a file is specified (i.e., the
           value begins with a '/' or uses the file scheme), the path is
           relative to the INFOCARD_CARD_IMAGE_BASE_URL, which must specify a
           directory. Only a DDAACCSS administrator may use this argument.

       _F_O_R_M_A_T
           By default, or if the value of the _F_O_R_M_A_T argument[14] is FILE, the
           new card is sent directly to the user's browser (which should
           automatically invoke the user's Identity Selector); no copy is
           retained on the server. If _F_O_R_M_A_T is HTML, the new managed InfoCard
           is stored in a file, replacing any existing card of the same name
           (see IINNFFOOCCAARRDD__CCAARRDD__OOUUTTPPUUTTDDIIRR[15]). Output is emitted in HTML and
           includes a link to the file (see IINNFFOOCCAARRDD__CCAARRDDIIDD__BBAASSEE__UURRLL[16]).
           Only the owner of new card should be able to access it.

       _I_N_F_O_C_A_R_D___I_D_E_N_T_I_T_Y
           Normally, this argument is omitted and the managed InfoCard is
           created on behalf of the identity that is invoking
           ddaaccss__mmaannaaggeedd__iinnffooccaarrdd. This argument allows a DDAACCSS administrator to
           create a card for a specific identity.

       _M_O_D_E
           This optional argument is used to select how ccllaaiimm iinnffoorrmmaattiioonn[17]
           is stored and retrieved. Four values are recognized:

           DACS
               In this usage mode, which is the default, claims are defined
               and filled depending on DDAACCSS configuration:

               +o   if both IINNFFOOCCAARRDD__CCAARRDD__DDEEFFSS__UURRLL[18] and
                   IINNFFOOCCAARRDD__CCAARRDD__FFIILLLL__UURRLL[19] are configured, the former web
                   service is called (once, by ddaaccss__mmaannaaggeedd__iinnffooccaarrdd) to
                   define the claims that will be assigned to the new managed
                   InfoCard and the latter web service is called (by
                   ddaaccss__ssttss((88))[7], each time the InfoCard is used) to obtain
                   the values of those claims (or the requested and approved
                   subset). The claim definitions may not be modified, but
                   claim values do not need to be static.

               +o   if neither of those web services are configured, a minimal
                   set of claims is automatically defined to facilitate
                   authentication.

               +o   any other configuration is invalid
                   An identity is always associated with these InfoCards using
                   a claim named dacs_identity in the DDAACCSS namespace
                   (http://dacs.dss.ca/claims). By default, the identity used
                   is that of the requestor. An administrator may instead
                   specify the identity using the _I_N_F_O_C_A_R_D___I_D_E_N_T_I_T_Y argument,
                   which need only be a syntactically valid DDAACCSS identity.

               STATIC
                   In this mode, the caller of ddaaccss__mmaannaaggeedd__iinnffooccaarrdd defines
                   the claims and their values when the card is created; DDAACCSS
                   is responsible for storing this information and producing
                   secure tokens from it. Unlike the DACS mode, the values of
                   these claims cannot be changed; a future release may
                   implement this capability.

                   The caller may specify from zero to a compile-time maximum
                   number of claims (MIC_MAX_STATIC_CLAIMS, 1100). A
                   privatepersonalidentifier (PPID) is always created
                   automatically, so any user request for that claim is
                   ignored. Only a DDAACCSS administrator may define the
                   dacs_identity claim in the DDAACCSS namespace; if present, it
                   must be a syntactically valid DDAACCSS identity. Therefore,
                   only a DDAACCSS administrator may use this mode to create an
                   InfoCard that can be used for DDAACCSS authentication.
                   Similiarly, only a DDAACCSS administrator may define the
                   dacs_roles claim in the DDAACCSS namespace; if present, it must
                   be a syntactically valid rroollee ddeessccrriippttoorr ssttrriinngg[20].

                   The claims are specified by up to MIC_MAX_STATIC_CLAIMS
                   arguments (not counting any PPID claims) of the form
                   CLAIM__n_u_m__t_y_p_e, where _n_u_m starts at one and continues with
                   consecutive integers and _t_y_p_e is:

                   +o   NAME for the name of the claim, which must consist of
                       between one and MIC_MAX_STATIC_NAME_CLAIM_SIZE (3322)
                       characters valid in a URI path segment.

                   +o   VALUE is the value associated with the claim and
                       consists of between one and
                       MIC_MAX_STATIC_VALUE_CLAIM_SIZE (6644) printable
                       characters.

                   +o   URI is the URI namespace with which NAME is associated;
                       for convenience, "standard" signifies the self-issued
                       InfoCard namespace
                       (http://schemas.xmlsoap.org/ws/2005/05/identity/claims),
                       and "dacs" is short for the DDAACCSS namespace
                       (http://dacs.dss.ca/claims); any other non-empty string
                       can be any syntactically valid URI of up to
                       MIC_MAX_STATIC_URI_CLAIM_SIZE (112288), and an empty
                       string indicates that the default URI should be used.

                           NNoottee
                           The DDAACCSS namespace is reserved for use by DDAACCSS and
                           identifies claim types with semantics that are
                           defined by DDAACCSS.

                   +o   LABEL is a string that an Identity Selector should
                       display with the claim and consists of between one and
                       MIC_MAX_STATIC_LABEL_CLAIM_SIZE (2200) printable
                       characters.

                   +o   DESC is a string that an Identity Selector should
                       display with the claim and consists of between one and
                       MIC_MAX_STATIC_DESC_CLAIM_SIZE (4400) printable
                       characters; if missing or the empty string, the value
                       of the corresponding LABEL argument is used.

                       The optional argument _C_L_A_I_M___U_R_I has the same syntax as
                       a CLAIM__n_u_m_URI argument and establishes a default URI
                       that will be used if any CLAIM__n_u_m_URI argument is
                       missing or is the empty string.

                       The optional argument _C_A_R_D___N_A_M_E assigns a name to the
                       InfoCard, which will be displayed by an Identity
                       Selector.

                       The first missing or null-string-valued CLAIM__n_u_m_NAME
                       or CLAIM__n_u_m_VALUE argument indicates the end of the
                       list. For example, if two claims are defined, the
                       following arguments might be passed: _C_L_A_I_M___1___N_A_M_E,
                       _C_L_A_I_M___1___V_A_L_U_E, _C_L_A_I_M___1___U_R_I, _C_L_A_I_M___1___L_A_B_E_L,
                       _C_L_A_I_M___1___D_E_S_C, _C_L_A_I_M___2___N_A_M_E, _C_L_A_I_M___2___V_A_L_U_E, _C_L_A_I_M___2___U_R_I,
                       _C_L_A_I_M___2___L_A_B_E_L, and _C_L_A_I_M___2___D_E_S_C. Any syntactical or
                       length violation causes a fatal error.

                   ISTATIC
                       This mode is identical to the STATIC mode except that
                       if it is used by an identity other than a DDAACCSS
                       administrator, a dacs_identity claim in the dacs
                       namespace is automatically added with the value of the
                       caller's identity. The InfoCard may be used for DDAACCSS
                       authentication.

                   DYNAMIC
                       The caller of ddaaccss__mmaannaaggeedd__iinnffooccaarrdd provides URLs for
                       two web services: one to define claims and another to
                       fill claims. The caller is responsible for managing
                       claim definitions and values. These web services are
                       expected to behave exactly the same as those that are
                       specified by IINNFFOOCCAARRDD__CCAARRDD__DDEEFFSS__UURRLL[18] and
                       IINNFFOOCCAARRDD__CCAARRDD__FFIILLLL__UURRLL[19]. This mode is not
                       implemented.


FFIILLEESS
       ddaaccss__mmaannaaggeedd__iinnffooccaarrdd..ccssss[21]

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       It is currently not possible to just register a managed InfoCard (you
       must create and register it), so you cannot import a card.

       This functionality should probably be integrated with
       ddaaccss__iinnffooccaarrdd((88))[3] (and ddaaccssiinnffooccaarrdd((11))[4]).

       Once a managed InfoCard is created, most of its characteristics cannot
       be changed. There should be a way to "refresh" a managed InfoCard that
       has expired or otherwise become invalid.

       The various constraints on claim types should probably be run-time
       configurable, or possibly done away with altogether. The specification
       imposes no limits on them.

       There should be a web service and utility to allow creation of a
       self-issued InfoCard (which may then be imported into a user's Identity
       Selector).

SSEEEE AALLSSOO
       ddaaccssiinnffooccaarrdd((11))[4], ddaaccss..ccoonnff((55))[22], ddaaccss__aauutthheennttiiccaattee((88))[23],
       ddaaccss__iinnffooccaarrdd((88))[3], ddaaccss__mmeexx((88))[24], ddaaccss__ssttss((88))[7], UUssiinngg IInnffooCCaarrddss
       WWiitthh DDAACCSS[25]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[26])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[27] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

        3. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

        4. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

        5. configuration directives
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_prefixed

        6. INFOCARD_STS_AUTH_TYPE
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_STS_AUTH_TYPE

        7. dacs_sts(8)
           http://dacs.dss.ca/man/dacs_sts.8.html

        8. INFOCARD_STS_PASSWORD_METHOD
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_STS_PASSWORD_METHOD

        9. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

       10. INFOCARD_CARD_IMAGE_BASE_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_IMAGE_BASE_URL

       11. printf(3)
           http://www.freebsd.org/cgi/man.cgi?query=printf&apropos=0&sektion=3&manpath=FreeBSD+7.2-RELEASE&format=html

       12. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       13. VFS URI
           http://dacs.dss.ca/man/#VFS

       14. _F_O_R_M_A_T argument
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       15. INFOCARD_CARD_OUTPUTDIR
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_OUTPUTDIR

       16. INFOCARD_CARDID_BASE_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARDID_BASE_URL

       17. claim information
           http://dacs.dss.ca/man/dacs_infocard.8.html#about_claims

       18. INFOCARD_CARD_DEFS_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_DEFS_URL

       19. INFOCARD_CARD_FILL_URL
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_CARD_FILL_URL

       20. role descriptor string
           http://dacs.dss.ca/man/dacs.1.html#roles

       21. dacs_managed_infocard.css
           http://dacs.dss.ca/man//css/dacs_managed_infocard.css

       22. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       23. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       24. dacs_mex(8)
           http://dacs.dss.ca/man/dacs_mex.8.html

       25. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       26. www.dss.ca
           http://www.dss.ca

       27. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012           DACS_MANAGED_INFOCAR(8)
