DACS_INFOCARD(8)           DACS Web Services Manual           DACS_INFOCARD(8)



NNAAMMEE
       dacs_infocard - Information Card administration

SSYYNNOOPPSSIISS
       ddaaccss__iinnffooccaarrdd [ddaaccssooppttiioonnss[1]]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite.

       The ddaaccss__iinnffooccaarrdd web service is used:

       +o   to perform a variety of administrative InfoCard functions;

       +o   as a Relying Party to register a self-issued InfoCard, creating an
           account that can be used for authentication. InfoCard-based
           authentication is performed by llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee[2], a
           DDAACCSS authentication module. These accounts are used only by
           llooccaall__iinnffooccaarrdd__aauutthheennttiiccaattee and are completely separate from any
           other accounts.

       +o   to act on behalf of a Relying Party to validate and extract claim
           values from a secure token created from either a self-issued or
           managed InfoCard.


           NNootteess
           +o   Many Identity Selectors can create a self-issued InfoCard, but
               you must use ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[3] to create a managed
               InfoCard.

           +o   If a Relying Party checks that the security token that it
               receives satisfies the validity window condition expressed by
               the token, as it typically will, then the system clocks at the
               IP/STS (e.g., ddaaccss__ssttss((88))[4]) and Relying Party must be
               adequately synchronized; see IINNFFOOCCAARRDD__TTOOKKEENN__DDRRIIFFTT__SSEECCSS[5].

           +o   Owing to the InfoCard system architecture, a Relying Party need
               not have network connectivity to a user's IP/STS (e.g.,
               ddaaccss__ssttss((88))[4]), although the user's browser must. This means,
               for example, that if a user (or his organization) operates his
               own IP/STS, it can be located on the same side of a firewall as
               the user's browser, which may improve the level of security of
               the IP/STS and any sensitive information it may store and
               access.

           +o   Much of the functionality of this program is also available as
               a DDAACCSS utility, ddaaccssiinnffooccaarrdd((11))[6], which operates on the same
               account files.


       Accounts are accessed through DDAACCSS''ss virtual filestore using item type
       infocards.

           NNoottee
           The official nomenclature for claims can be confusing. In an
           attempt at consistency and simplification, the DDAACCSS documentation
           tries to adhere to the following definitions (with the stated
           compile-time limits):

           Claim
               A pair comprising an attribute name (the Claim type) and an
               attribute value (the Claim value). The attribute value is
               optional. The number of claims is limited to 1100 static claims
               and 2200 dynamic claims.

           Claim type
               A unique UURRII[7] that consists of a Claim URI prefix followed by
               a Claim name. This can be thought of as an attribute name.
               DDAACCSS does not allow the URI to include a query or fragment
               component. A claim type is never dereferenced, it is merely a
               label. Only characters that are valid in a URI are allowed;
               therefore any invalid characters must be properly encoded.
               Claim types are case sensitive, despite the fact that they are
               URIs. There is a compile-time length limit: 112288 characters for
               the URI prefix and 3322 characters for the claim name.

           Claim URI prefix
               This URI identifies a namespace in which the Claim name lives
               (it may not include a query or fragment component). Two
                ccllaaiimm ttyyppeess[8] with different URI prefixes but the same claim
               name are distinct. The InfoCard specification uses the
               namespace http://schemas.xmlsoap.org/ws/2005/05/identity/claims
               for self-issued claims.  DDAACCSS uses the namespace
               http://dacs.dss.ca/claims for its claims. These namespaces
               should be treated as "reserved". User-defined claims should
               live in other namespaces, preferably ones over which the user
               has some authority.

           Claim URI prefix abbreviation
               To avoid the tedious and error-prone task of having to
               repeatedly enter long Claim URI prefix strings, in designated
               contexts DDAACCSS recognizes (but never requires) an abbreviation.
               Two case-sensitive abbreviations are defined: "standard"
               (equivalent to
               http://schemas.xmlsoap.org/ws/2005/05/identity/claims) and
               "dacs" (equivalent to http://dacs.dss.ca/claims).

           Claim name
               This is a URI path component. When appended to a Claim URI
               prefix (or paired with a Claim URI prefix abbreviation), it
               forms a Claim type. Only characters that are valid in a URI
               path component are allowed. It is limited to 3322 characters.

           Claim value
               This can be thought of as an attribute value. Technically, this
               is defined as an xxss::ssttrriinngg[9], which is a sequence of XXMMLL
               cchhaarraacctteerrss[10]. Claim values are limited to 6644 characters.

OOPPTTIIOONNSS
   WWeebb SSeerrvviiccee AArrgguummeennttss
       In addition to the ssttaannddaarrdd CCGGII aarrgguummeennttss[11], ddaaccss__iinnffooccaarrdd
       understands the following CGI arguments:


       _O_P_E_R_A_T_I_O_N
           The following operations are supported:

           +o   _D_E_L_E_T_E

               Delete the account associated with _U_S_E_R_N_A_M_E. This effectively
               revokes the InfoCard; a self-issued InfoCard may be
               re-registered, but a managed InfoCard becomes unusable.

                   NNoottee
                   The quickest way to delete _a_l_l accounts is to delete the
                   contents of the infocards item type; e.g., if infocards
                   points to a file, remove the file or copy /dev/null to it.

           +o   _D_I_S_A_B_L_E

               Disable the account associated with _U_S_E_R_N_A_M_E. InfoCard-based
               authentication on this account will fail; this revokes the
               InfoCard, but in a reversible way. The request is successful if
               the account is already disabled.

           +o   _E_N_A_B_L_E

               Enable the existing account associated with _U_S_E_R_N_A_M_E.
               InfoCard-based authentication on this account will be possible.
               The request is successful if the account is already enabled.

           +o   _L_I_S_T

               List all accounts.

           +o   _R_E_G_I_S_T_E_R

               Register or re-register the submitted InfoCard. Exactly one set
               of credentials must accompany the request, and if registration
               is successful, the submitted InfoCard becomes associated with
               that identity.

           +o   _T_O_K_E_N___A_T_T_R_V_A_L_S

               If the submitted token is valid, display each claim (attribute)
               value associated with the _A_T_T_R_L_I_S_T argument, which consists of
               zero or more claim names separated by a space. If _A_T_T_R_L_I_S_T is
               absent or the empty string, all claims in the token are
               displayed (note that this is not necessarily all of the claims
               associated with the InfoCard). If any requested claim is not
               found, the request is ignored (i.e., it is not an error). The
               privatepersonalidentifier claim is displayed in the friendly
               identifier syntax rather than as a base-64 encoded string. The
               InfoCard (self-issued or managed) does not need to be
               registered at the jurisdiction.

               Three syntaxes are recognized for a claim name. Some claims are
               "predefined" in that they are available in any valid token:
               issuer, confirm_method, ppid (or privatepersonalidentifier),
               exponent (self-issued only), and modulus (self-issued only).
               The second syntax is the full claim URI (e.g.,
               http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage).
               The third syntax uses the DDAACCSS shorthand: the word "standard"
               or "dacs", a colon, and the claim name (e.g.,
               standard:webpage). The token is searched for each claim in the
               _A_T_T_R_L_I_S_T, other than the predefined ones.

                   NNoottee
                   Only the full URI syntax can be used to identify claims in
                   an HTML OBJECT's _r_e_q_u_i_r_e_d_C_l_a_i_m_s and _o_p_t_i_o_n_a_l_C_l_a_i_m_s param
                   tag.

           +o   _T_O_K_E_N___V_A_L_I_D_A_T_E

               Parse the submitted token and test whether it is valid.

           _x_m_l_T_o_k_e_n
           _A_U_X_I_L_I_A_R_Y
               This is the submitted InfoCard. It is required for the
               _T_O_K_E_N___V_A_L_I_D_A_T_E, _T_O_K_E_N___A_T_T_R_V_A_L_S, and _R_E_G_I_S_T_E_R operations. The
               _A_U_X_I_L_I_A_R_Y parameter name may only be used for this purpose if
               the _x_m_l_T_o_k_e_n parameter name is not also used.

           _F_O_R_M_A_T
               By default, output is emitted in HTML. Several varieties of XML
               output can be selected, however, using the _F_O_R_M_A_T argument
               (please refer to ddaaccss((11))[12] and ddaaccss__ppaasssswwdd..ddttdd[13]). A _F_O_R_M_A_T
               of plain may be useful for programs that need to extract claim
               values; claims are listed one per line with the claim type,
               followed by an "=", followed by the claim value.

           _U_S_E_R_N_A_M_E
               For some operations, the name of the account to act on.

           For the _D_E_L_E_T_E, _D_I_S_A_B_L_E, and _E_N_A_B_L_E operations, the request must be
           submitted by the account's owner or the DDAACCSS administrator.

           Here is an example of a form that might be used to register a
           self-issued InfoCard:

               <form name="reg_form" id="reg_form" method="post" action="/cgi-bin/dacs/dacs_infocard">
               <table>
               <tr>
               <td>
                <img src="/infocards/ic_image.jpg" onClick="reg_form.submit()"/>
               <object type="application/x-informationCard" name="xmlToken">
                <param name="tokenType" value="urn:oasis:names:tc:SAML:1.0:assertion">
                <param name="issuer" value="http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self">
                <param name="requiredClaims"
                 value="http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier">
                <param name="privacyUrl" value="https://example.com/infocards/privacy_statement.txt">
                <param Name="privacyVersion" value="3">
               </object>
               </td>
               </tr>
               <tr>
               <td align="center">
                <input type="submit" name="infocard_register" value="Register" id="infocard_register" />
               </td>
               <td>
               </td>
               </table>
               <input type="hidden" name="OPERATION" value="REGISTER">
               </form>



FFIILLEESS
       ddaaccss__iinnffooccaarrdd..ccssss[14]

DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       The compile-time limits are fairly arbitrary and only exist to thwart
       abuse. It should probably be possible to specify them at run-time
       instead.

       XML output is not available yet.

       Registration of a self-issued InfoCard uses the card's PPID (Private
       Personal Identifier), which differs for a given InfoCard for different
       Relying Parties. The specification does not precisely define how two
       Relying Party endpoints are compared for equality, but if an identity
       selector decides that a jurisdiction's endpoint has changed (e.g., its
       domain name has been reconfigured), all self-issued InfoCards
       previously registered at the jurisdiction will become unusable until
       they are re-registered.

       This functionality should be integrated with ddaaccss__aaddmmiinn((88))[15].

SSEEEE AALLSSOO
       ddaaccssiinnffooccaarrdd((11))[6], ddaaccss..ccoonnff((55))[16], ddaaccss__aauutthheennttiiccaattee((88))[17],
       ddaaccss__mmaannaaggeedd__iinnffooccaarrdd((88))[3], UUssiinngg IInnffooCCaarrddss WWiitthh DDAACCSS[18]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[19])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[20] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

        3. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

        4. dacs_sts(8)
           http://dacs.dss.ca/man/dacs_sts.8.html

        5. INFOCARD_TOKEN_DRIFT_SECS
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_TOKEN_DRIFT_SECS

        6. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

        7. URI
           http://www.rfc-editor.org/rfc/rfc3986.txt

        8. claim types
           http://dacs.dss.ca/man/#claim_types

        9. xs:string
           http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/datatypes.html#string

       10. XML characters
           http://www.w3.org/TR/2000/WD-xml-2e-20000814#NT-Char

       11. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       12. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       13. dacs_passwd.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_passwd.dtd

       14. dacs_infocard.css
           http://dacs.dss.ca/man//css/dacs_infocard.css

       15. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       16. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       18. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       19. www.dss.ca
           http://www.dss.ca

       20. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                  DACS_INFOCARD(8)
