CGIPARSE(8)                DACS Web Services Manual                CGIPARSE(8)



NNAAMMEE
       cgiparse - CGI argument parsing utility

SSYYNNOOPPSSIISS
       ccggiippaarrssee [_m_o_d_e] [--eenncc {none | url | mime | dacs}] [--iinn _f_i_l_e_n_a_m_e] [--dd]
                [--nnoonneewwlliinnee]
                [--qqss _q_u_e_r_y_-_s_t_r_i_n_g] [--ccooppyy _f_i_l_e_n_a_m_e] [[--nn _n_a_m_e _f_i_l_e_n_a_m_e]...]

DDEESSCCRRIIPPTTIIOONN
       This program is part of the DDAACCSS suite. It is a stand-alone program
       that neither accepts the usual DDAACCSS command line options (_d_a_c_s_o_p_t_i_o_n_s)
       nor accesses any DDAACCSS configuration files.

       This utility is used by web-based scripts (shell scripts in particular)
       to obtain their CGI arguments, which can be obtained from a URI's query
       component or in an encoded entity-body read from the standard input (as
       with the POST method). The ffoorrmm ccoonntteenntt ttyyppeess[1]
       application/x-www-form-urlencoded and multipart/form-data are both
       understood.

       The program has several different modes of operation, one of which may
       be specified by the first command line argument.

       ccggiippaarrssee combines query arguments found in the QQUUEERRYY__SSTTRRIINNGG environment
       variable with arguments found in the message body it reads from the
       standard input. If an argument name is duplicated the result is
       indeterminate.

OOPPTTIIOONNSS
       The _m_o_d_e may be one of the following:

       --aarrgg _v_a_r_i_a_b_l_e_-_n_a_m_e
           Emit the value of the CGI argument _v_a_r_i_a_b_l_e_-_n_a_m_e, then exit. If
           there is no such argument, the exit status will be 1 instead of 0.

       --ttaarrgg _v_a_r_i_a_b_l_e_-_n_a_m_e
           Test if the CGI argument _v_a_r_i_a_b_l_e_-_n_a_m_e exists. If there is no such
           argument, the exit status will be 1, otherwise it will be 0.

       --hhttmmll
           Emit an HTML document that lists the CGI argument names and their
           values.

       --oonnee
           Emit a listing of the CGI argument values (without the names).

       --sshh
           Emit CGI arguments as a single line in the format:

               _v_a_r_i_a_b_l_e_-_n_a_m_e='_v_a_r_i_a_b_l_e_-_v_a_l_u_e'; [...]

           It is an error if any _v_a_r_i_a_b_l_e_-_n_a_m_e or _v_a_r_i_a_b_l_e_-_v_a_l_u_e is
           syntactically unsuitable for this format. The returned string can
           be used as the argument to eevvaall to set the CGI arguments as shell
           variables.

       --tteexxtt
           Like --hhttmmll except emit text. This is the default. With this mode,
           the program's stdout is usually written to a file. Each line of the
           file has the format:

               _v_a_r_i_a_b_l_e_-_n_a_m_e _v_a_r_i_a_b_l_e_-_v_a_l_u_e

           (a space separates the name from the corresponding value). The file
           is typically read by a script to obtain the arguments, or ccggiippaarrssee
           can be run with the --iinn flag to retrieve an argument.

       Additionally, ccggiippaarrssee recognizes these options:

           If writing the parsed CGI arguments (--tteexxtt), encode the argument
           value using the specified method: url means URL encoding, mime
           means MIME base-64 encoding, and dacs means DDAACCSS base-64 encoding.
           For details about these encodings, please see ddaaccss..eexxpprrss((55))[2]. The
           default is none, which means that no encoding is performed (use
           this only when you are sure this cannot cause a problem). If
           reading the parsed CGI arguments (--iinn), decode the argument values
           using the specified method. The default is none, which means that
           no decoding is performed; if the arguments were encoded, they will
           be returned in that encoding, but other than this case the decoding
           method must match the encoding method previously used or an error
           is likely to occur.

       --qqss _q_u_e_r_y_-_s_t_r_i_n_g
           Instead of using the environment variable _Q_U_E_R_Y___S_T_R_I_N_G to get a
           query component, use _q_u_e_r_y_-_s_t_r_i_n_g.

       --nnoonneewwlliinnee
           With --aarrgg, do not emit a newline after printing an argument value.

       --dd
           Enable debugging output.

       --ccooppyy _f_i_l_e_n_a_m_e
           Append the input stream to _f_i_l_e_n_a_m_e. This can be useful for
           debugging purposes.

       --iinn _f_i_l_e_n_a_m_e
           Instead of parsing CGI arguments, read variable name/value pairs
           (as produced by the --tteexxtt flag) from _f_i_l_e_n_a_m_e. If _f_i_l_e_n_a_m_e is "-",
           stdin is read.

       --nn _n_a_m_e _f_i_l_e_n_a_m_e
           If parsing succeeds, and there is a MIME body part with a name
           exactly matching _n_a_m_e, then:

           +o   if the content disposition is multipart/form-data, write the
               content as quoted-printable text to _f_i_l_e_n_a_m_e;

           +o   if the content disposition is base64, write the decoded content
               to _f_i_l_e_n_a_m_e;

           +o   otherwise the content is written verbatim to _f_i_l_e_n_a_m_e.
               If the output file exists it is truncated.

EEXXAAMMPPLLEESS
       The following shell script demonstrates one way of using ccggiippaarrssee.



           #! /bin/sh

           tmpfile=/tmp/cgiparse.$$

           cgiparse > ${tmpfile}
           chmod 0600 ${tmpfile}

           echo "Context-Type: text/plain"
           echo ""

           done=
           while [ "${done}x" = x ]
           do
             a=
             b=
             read a b
             if [ $? = 1 ]
             then
               done=1
               break
             else
               echo "Arg: ${a}"
               echo "Is: ${b}"
             fi
           done < ${tmpfile}

           rm -f ${tmpfile}
           exit 0

       The following code fragment uses ccggiippaarrssee to save and then look up its
       CGI arguments:

           #! /bin/sh

           tmpfile=/tmp/cgiparse.$$
           trap 'rm -f ${tmpfile}; exit 1' EXIT 1 2 3 13 15

           cgiparse -enc mime > ${tmpfile}
           chmod 0600 ${tmpfile}

           mode=`cgiparse -in ${tmpfile} -enc mime -arg MODE`
           target=`cgiparse -in ${tmpfile} -enc mime -arg TARGET`

       The following script will print "1 2 3" to its standard output:

           #! /bin/sh

           args=`cgiparse -sh -qs "a=1&b=2&c=3"`
           eval "$args"
           echo "$a $b $c"


DDIIAAGGNNOOSSTTIICCSS
       The program exits 0 if everything was fine, 1 if an error occurred.

BBUUGGSS
       There do not appear to be any official recommendations concerning how
       to handle apparently "malformed" CGI query strings that do not look
       like a sequence of _n_a_m_e=_v_a_l_u_e pairs. The parsing routines that ccggiippaarrssee
       uses will flag an error if they see strings containing a component like
       "=foo", for example, although "foo=" is fine.

SSEEEE AALLSSOO
       RRFFCC 33887755[3], TThhee WWWWWW CCoommmmoonn GGaatteewwaayy IInntteerrffaaccee,, VVeerrssiioonn 11..22[4], HHTTMMLL
       44..0011 SSppeecciiffiiccaattiioonn[5], ddaaccss__pprreennvv((88))[6]

AAUUTTHHOORR
       Distributed Systems Software (wwwwww..ddssss..ccaa[7])

CCOOPPYYIINNGG
       Copyright (C) 2003-2011 Distributed Systems Software. See the
       LLIICCEENNSSEE[8] file that accompanies the distribution for licensing
       information.

NNOOTTEESS
        1. form content types
           http://www.w3.org/TR/html401/interact/forms.html#h-17.13.4

        2. dacs.exprs(5)
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

        3. RFC 3875
           http://www.rfc-editor.org/rfc/rfc3875.txt

        4. The WWW Common Gateway Interface, Version 1.2
           http://ken.coar.org/cgi/cgi-120-00a.html

        5. HTML 4.01 Specification
           http://www.w3.org/TR/html4/

        6. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

        7. www.dss.ca
           http://www.dss.ca

        8. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27                       01/16/2012                       CGIPARSE(8)
