#
#   Copyright 2010 by Mark Weyer
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

Trees = {
  name = "Trees"
  author = "Mark Weyer"
  description = "Groups with cycles explode"
  anzahl[easy] = 4
  anzahl = 5
  anzahl[hard] = 6
  w_loch[easy] = 1000000
  w_loch = 100
  w_loch[hard] = 50
  pics = Graph * <anzahl>
  startpic = mtrGras.xpm
  greypic = Grau
  emptypic = Loch
  neighbours = <neighbours_hex6>
  startdist[easy] = "..**..*...","****..***."
  startdist = "......*...","..**..***.","****..****"
  startdist[hard] = "..**..*...","****..***.","****..****"
  numexplode = 0

  << var loche,neu; >>

  Graph = {
    pics = mtr1.xpm, mtr2.xpm, mtr3.xpm, mtr4.xpm, mtr5.xpm, mtr6.xpm
    <<
      Graph = {
        loche=0;

        weight = 1????? + ?1???? + ??1??? + ???1?? + ????1? + ?????1 - 2;
        file = kind-Graph;
        schemaHex4;

        if !exploding -> {
          if 1????? -> {loche@(1,-0.5) += 1:w_loch; loche@(-1,-0.5) += w_loch;};
          if ?1???? || ?????1 -> loche@(0,-1) += 1:w_loch;
        };
      };
    >>
  }

  Loch = {
    pics = mtrGrau.xpm
    <<
      Loch = {
        if loche => {
          if exploding@(-1,0) || exploding@(1,-0.5) || exploding@(1,0.5)
            || exploding@(1,0) || exploding@(-1,0.5) || exploding@(-1,-0.5)
            -> loche=0
          else -> {
            A,B,C,D,E,F,G,H,I,J,K,
            {L; kind@(0,0)=Grau; neu@(0,0)=1}
          };
          *;
        };
      };
    >>
  }

  Grau = {
    pics = mtrGrau.xpm
    <<
      Grau = {
        loche=0;
        if neu => {
          {
            M,N,O,P,P,P,P,P,Q,Q,Q,Q,
            {P;neu=0;}
          };
          *;
        }
        else -> P*;
      };
    >>
  }
}
