#include "tcpdispatcher"

void TcpDispatcher::handle() {
    
    debugmsg (Mstr("TCP dispatcher: About to shuttle between client fd ") +
	      clientfd() +
	      (Mstr(" and backend fd ") + backendfd()) + "\n");
    
    while (1) {
	Fdset readset(maxtimeout(config.client_read_timeout(),
				 config.backend_read_timeout()));
	readset.add(clientfd());
	readset.add(backendfd());
	readset.wait_r();
	
	int sock, othersock, timeout;
	if (readset.readable(clientfd())) {
	    sock = clientfd();
	    othersock = backendfd();
	    timeout = config.backend_write_timeout();
	} else if (readset.readable(backendfd())) {
	    sock = backendfd();
	    othersock = clientfd();
	    timeout = config.client_write_timeout();
	} else
	    break;

	if (!netbuffer.netread(sock))
	    break;
	debugmsg (Mstr("Had data on ") + sock +
		  (Mstr(", sending to ") + othersock) + "\n");
	netbuffer.netwrite (othersock, timeout);
	if (sock == backendfd())
	    balancer.backend(targetbackend()).addbytes(netbuffer.bufsz());
	else
	    IPStore::activity(clientip(), targetbackend());

	netbuffer.reset();
    }
}
