/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

#ifndef COIN_SOGLENVIRONMENTELEMENT_H
#define COIN_SOGLENVIRONMENTELEMENT_H

#include <Inventor/elements/SoEnvironmentElement.h>


class COIN_DLL_API SoGLEnvironmentElement : public SoEnvironmentElement {
  typedef SoEnvironmentElement inherited;

  SO_ELEMENT_HEADER(SoGLEnvironmentElement);
public:
  static void initClass(void);
protected:
  virtual ~SoGLEnvironmentElement();

public:
  virtual void init(SoState * state);
  virtual void pop(SoState * state,
                   const SoElement * prevTopElement);

protected:

  virtual void setElt(SoState * const state,
                      const float ambientIntensity,
                      const SbColor & ambientColor,
                      const SbVec3f & attenuation,
                      const int32_t fogType,
                      const SbColor & fogColor,
                      const float fogVisibility,
                      const float fogStart);
private:
  void updategl(SoState * const state);
};

#endif // !COIN_SOGLENVIRONMENTELEMENT_H
