/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 3664 $
//
//  $LastChangedDate: 2011-12-23 10:28:21 -0800 (Fri, 23 Dec 2011) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include "cmtkUniformVolumeFilter.h"

#include <Base/cmtkDataGridFilter.h>
#include <Base/cmtkGaussianKernel.h>

#include <vector>

namespace
cmtk
{

/** \addtogroup Base */
//@{

TypedArray::SmartPtr
UniformVolumeFilter::GetDataGaussFiltered( const Units::GaussianSigma& sigma, const Types::Coordinate maxError ) const
{
  return DataGridFilter::GetDataKernelFiltered( GaussianKernel<Types::DataItem>::GetHalfKernel( sigma / this->m_UniformVolume->Deltas()[0], maxError ),
						GaussianKernel<Types::DataItem>::GetHalfKernel( sigma / this->m_UniformVolume->Deltas()[1], maxError ),
						GaussianKernel<Types::DataItem>::GetHalfKernel( sigma / this->m_UniformVolume->Deltas()[2], maxError ) );
}

TypedArray::SmartPtr
UniformVolumeFilter::GetDataGaussFiltered1D( const int direction, const Units::GaussianSigma& sigma, const Types::Coordinate maxError ) const
{
  const std::vector<Types::Coordinate> empty( 1, 1.0 );

  switch ( direction )
    {
    default:
    case 0:
      return DataGridFilter::GetDataKernelFiltered( GaussianKernel<Types::DataItem>::GetHalfKernel( sigma / this->m_UniformVolume->Deltas()[0], maxError ), empty, empty );
    case 1:
      return DataGridFilter::GetDataKernelFiltered( empty, GaussianKernel<Types::DataItem>::GetHalfKernel( sigma / this->m_UniformVolume->Deltas()[1], maxError ), empty );
    case 2:
      return DataGridFilter::GetDataKernelFiltered( empty, empty, GaussianKernel<Types::DataItem>::GetHalfKernel( sigma / this->m_UniformVolume->Deltas()[2], maxError ) );
    }
}

} // namespace cmtk
