
#=============================================================================
# Copyright 2004-2011 Kitware, Inc.
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================
# (To distribute this file outside of CMake, substitute the full
#  License text for the above reference.)

# This file sets the basic flags for the C++ language in CMake.
# It also loads the available platform file for the system-compiler
# if it exists.
# It also loads a system - compiler - processor (or target hardware)
# specific file, which is mainly useful for crosscompiling and embedded systems.

# some compilers use different extensions (e.g. sdcc uses .rel)
# so set the extension here first so it can be overridden by the compiler specific file
IF(UNIX)
  SET(CMAKE_CXX_OUTPUT_EXTENSION .o)
ELSE(UNIX)
  SET(CMAKE_CXX_OUTPUT_EXTENSION .obj)
ENDIF(UNIX)

SET(_INCLUDED_FILE 0)

# Load compiler-specific information.
IF(CMAKE_CXX_COMPILER_ID)
  INCLUDE(Compiler/${CMAKE_CXX_COMPILER_ID}-CXX OPTIONAL)
ENDIF(CMAKE_CXX_COMPILER_ID)

SET(CMAKE_BASE_NAME)
GET_FILENAME_COMPONENT(CMAKE_BASE_NAME ${CMAKE_CXX_COMPILER} NAME_WE)
# since the gnu compiler has several names force g++
IF(CMAKE_COMPILER_IS_GNUCXX)
  SET(CMAKE_BASE_NAME g++)
ENDIF(CMAKE_COMPILER_IS_GNUCXX)


# load a hardware specific file, mostly useful for embedded compilers
IF(CMAKE_SYSTEM_PROCESSOR)
  IF(CMAKE_CXX_COMPILER_ID)
    INCLUDE(Platform/${CMAKE_SYSTEM_NAME}-${CMAKE_CXX_COMPILER_ID}-CXX-${CMAKE_SYSTEM_PROCESSOR} OPTIONAL RESULT_VARIABLE _INCLUDED_FILE)
  ENDIF(CMAKE_CXX_COMPILER_ID)
  IF (NOT _INCLUDED_FILE)
    INCLUDE(Platform/${CMAKE_SYSTEM_NAME}-${CMAKE_BASE_NAME}-${CMAKE_SYSTEM_PROCESSOR} OPTIONAL)
  ENDIF (NOT _INCLUDED_FILE)
ENDIF(CMAKE_SYSTEM_PROCESSOR)

# load the system- and compiler specific files
IF(CMAKE_CXX_COMPILER_ID)
  INCLUDE(Platform/${CMAKE_SYSTEM_NAME}-${CMAKE_CXX_COMPILER_ID}-CXX OPTIONAL RESULT_VARIABLE _INCLUDED_FILE)
ENDIF(CMAKE_CXX_COMPILER_ID)
IF (NOT _INCLUDED_FILE)
  INCLUDE(Platform/${CMAKE_SYSTEM_NAME}-${CMAKE_BASE_NAME} OPTIONAL
          RESULT_VARIABLE _INCLUDED_FILE)
ENDIF (NOT _INCLUDED_FILE)
# We specify the compiler information in the system file for some
# platforms, but this language may not have been enabled when the file
# was first included.  Include it again to get the language info.
# Remove this when all compiler info is removed from system files.
IF (NOT _INCLUDED_FILE)
  INCLUDE(Platform/${CMAKE_SYSTEM_NAME} OPTIONAL)
ENDIF (NOT _INCLUDED_FILE)

IF(CMAKE_CXX_SIZEOF_DATA_PTR)
  FOREACH(f ${CMAKE_CXX_ABI_FILES})
    INCLUDE(${f})
  ENDFOREACH()
  UNSET(CMAKE_CXX_ABI_FILES)
ENDIF()

# This should be included before the _INIT variables are
# used to initialize the cache.  Since the rule variables 
# have if blocks on them, users can still define them here.
# But, it should still be after the platform file so changes can
# be made to those values.

IF(CMAKE_USER_MAKE_RULES_OVERRIDE)
  # Save the full path of the file so try_compile can use it.
  INCLUDE(${CMAKE_USER_MAKE_RULES_OVERRIDE} RESULT_VARIABLE _override)
  SET(CMAKE_USER_MAKE_RULES_OVERRIDE "${_override}")
ENDIF()

IF(CMAKE_USER_MAKE_RULES_OVERRIDE_CXX)
  # Save the full path of the file so try_compile can use it.
  INCLUDE(${CMAKE_USER_MAKE_RULES_OVERRIDE_CXX} RESULT_VARIABLE _override)
  SET(CMAKE_USER_MAKE_RULES_OVERRIDE_CXX "${_override}")
ENDIF()


# for most systems a module is the same as a shared library
# so unless the variable CMAKE_MODULE_EXISTS is set just
# copy the values from the LIBRARY variables
IF(NOT CMAKE_MODULE_EXISTS)
  SET(CMAKE_SHARED_MODULE_CXX_FLAGS ${CMAKE_SHARED_LIBRARY_CXX_FLAGS})
ENDIF(NOT CMAKE_MODULE_EXISTS)
# Create a set of shared library variable specific to C++
# For 90% of the systems, these are the same flags as the C versions
# so if these are not set just copy the flags from the c version
IF(NOT CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS)
  SET(CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS ${CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS})
ENDIF(NOT CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS)

IF(NOT CMAKE_SHARED_LIBRARY_CXX_FLAGS)
  SET(CMAKE_SHARED_LIBRARY_CXX_FLAGS ${CMAKE_SHARED_LIBRARY_C_FLAGS})
ENDIF(NOT CMAKE_SHARED_LIBRARY_CXX_FLAGS)

IF(NOT DEFINED CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS)
  SET(CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS ${CMAKE_SHARED_LIBRARY_LINK_C_FLAGS})
ENDIF(NOT DEFINED CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS)

IF(NOT CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG)
  SET(CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG ${CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG}) 
ENDIF(NOT CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG)

IF(NOT CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG_SEP)
  SET(CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG_SEP ${CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG_SEP})
ENDIF(NOT CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG_SEP)

IF(NOT CMAKE_SHARED_LIBRARY_RPATH_LINK_CXX_FLAG)
  SET(CMAKE_SHARED_LIBRARY_RPATH_LINK_CXX_FLAG ${CMAKE_SHARED_LIBRARY_RPATH_LINK_C_FLAG})
ENDIF(NOT CMAKE_SHARED_LIBRARY_RPATH_LINK_CXX_FLAG)

IF(NOT DEFINED CMAKE_EXE_EXPORTS_CXX_FLAG)
  SET(CMAKE_EXE_EXPORTS_CXX_FLAG ${CMAKE_EXE_EXPORTS_C_FLAG})
ENDIF()

IF(NOT DEFINED CMAKE_SHARED_LIBRARY_SONAME_CXX_FLAG)
  SET(CMAKE_SHARED_LIBRARY_SONAME_CXX_FLAG ${CMAKE_SHARED_LIBRARY_SONAME_C_FLAG})
ENDIF()

IF(NOT CMAKE_EXECUTABLE_RUNTIME_CXX_FLAG)
  SET(CMAKE_EXECUTABLE_RUNTIME_CXX_FLAG ${CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG})
ENDIF(NOT CMAKE_EXECUTABLE_RUNTIME_CXX_FLAG)

IF(NOT CMAKE_EXECUTABLE_RUNTIME_CXX_FLAG_SEP)
  SET(CMAKE_EXECUTABLE_RUNTIME_CXX_FLAG_SEP ${CMAKE_SHARED_LIBRARY_RUNTIME_CXX_FLAG_SEP})
ENDIF(NOT CMAKE_EXECUTABLE_RUNTIME_CXX_FLAG_SEP)

IF(NOT CMAKE_EXECUTABLE_RPATH_LINK_CXX_FLAG)
  SET(CMAKE_EXECUTABLE_RPATH_LINK_CXX_FLAG ${CMAKE_SHARED_LIBRARY_RPATH_LINK_CXX_FLAG})
ENDIF(NOT CMAKE_EXECUTABLE_RPATH_LINK_CXX_FLAG)

IF(NOT DEFINED CMAKE_SHARED_LIBRARY_LINK_CXX_WITH_RUNTIME_PATH)
  SET(CMAKE_SHARED_LIBRARY_LINK_CXX_WITH_RUNTIME_PATH ${CMAKE_SHARED_LIBRARY_LINK_C_WITH_RUNTIME_PATH})
ENDIF(NOT DEFINED CMAKE_SHARED_LIBRARY_LINK_CXX_WITH_RUNTIME_PATH)

IF(NOT CMAKE_INCLUDE_FLAG_CXX)
  SET(CMAKE_INCLUDE_FLAG_CXX ${CMAKE_INCLUDE_FLAG_C})
ENDIF(NOT CMAKE_INCLUDE_FLAG_CXX)

IF(NOT CMAKE_INCLUDE_FLAG_SEP_CXX)
  SET(CMAKE_INCLUDE_FLAG_SEP_CXX ${CMAKE_INCLUDE_FLAG_SEP_C})
ENDIF(NOT CMAKE_INCLUDE_FLAG_SEP_CXX)

# repeat for modules
IF(NOT CMAKE_SHARED_MODULE_CREATE_CXX_FLAGS)
  SET(CMAKE_SHARED_MODULE_CREATE_CXX_FLAGS ${CMAKE_SHARED_MODULE_CREATE_C_FLAGS})
ENDIF(NOT CMAKE_SHARED_MODULE_CREATE_CXX_FLAGS)

IF(NOT CMAKE_SHARED_MODULE_CXX_FLAGS)
  SET(CMAKE_SHARED_MODULE_CXX_FLAGS ${CMAKE_SHARED_MODULE_C_FLAGS})
ENDIF(NOT CMAKE_SHARED_MODULE_CXX_FLAGS)

# Initialize CXX link type selection flags from C versions.
FOREACH(type SHARED_LIBRARY SHARED_MODULE EXE)
  IF(NOT CMAKE_${type}_LINK_STATIC_CXX_FLAGS)
    SET(CMAKE_${type}_LINK_STATIC_CXX_FLAGS
      ${CMAKE_${type}_LINK_STATIC_C_FLAGS})
  ENDIF(NOT CMAKE_${type}_LINK_STATIC_CXX_FLAGS)
  IF(NOT CMAKE_${type}_LINK_DYNAMIC_CXX_FLAGS)
    SET(CMAKE_${type}_LINK_DYNAMIC_CXX_FLAGS
      ${CMAKE_${type}_LINK_DYNAMIC_C_FLAGS})
  ENDIF(NOT CMAKE_${type}_LINK_DYNAMIC_CXX_FLAGS)
ENDFOREACH(type)

# add the flags to the cache based
# on the initial values computed in the platform/*.cmake files
# use _INIT variables so that this only happens the first time
# and you can set these flags in the cmake cache
SET(CMAKE_CXX_FLAGS_INIT "$ENV{CXXFLAGS} ${CMAKE_CXX_FLAGS_INIT}")
# avoid just having a space as the initial value for the cache 
IF(CMAKE_CXX_FLAGS_INIT STREQUAL " ")
  SET(CMAKE_CXX_FLAGS_INIT)
ENDIF(CMAKE_CXX_FLAGS_INIT STREQUAL " ")
SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS_INIT}" CACHE STRING
     "Flags used by the compiler during all build types.")

IF(NOT CMAKE_NOT_USING_CONFIG_FLAGS)
  SET (CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG_INIT}" CACHE STRING
     "Flags used by the compiler during debug builds.")
  SET (CMAKE_CXX_FLAGS_MINSIZEREL "${CMAKE_CXX_FLAGS_MINSIZEREL_INIT}" CACHE STRING
      "Flags used by the compiler during release minsize builds.")
  SET (CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE_INIT}" CACHE STRING
     "Flags used by the compiler during release builds (/MD /Ob1 /Oi /Ot /Oy /Gs will produce slightly less optimized but smaller files).")
  SET (CMAKE_CXX_FLAGS_RELWITHDEBINFO "${CMAKE_CXX_FLAGS_RELWITHDEBINFO_INIT}" CACHE STRING
     "Flags used by the compiler during Release with Debug Info builds.")

ENDIF(NOT CMAKE_NOT_USING_CONFIG_FLAGS)

IF(CMAKE_CXX_STANDARD_LIBRARIES_INIT)
  SET(CMAKE_CXX_STANDARD_LIBRARIES "${CMAKE_CXX_STANDARD_LIBRARIES_INIT}"
    CACHE STRING "Libraries linked by defalut with all C++ applications.")
  MARK_AS_ADVANCED(CMAKE_CXX_STANDARD_LIBRARIES)
ENDIF(CMAKE_CXX_STANDARD_LIBRARIES_INIT)

INCLUDE(CMakeCommonLanguageInclude)

# now define the following rules:
# CMAKE_CXX_CREATE_SHARED_LIBRARY
# CMAKE_CXX_CREATE_SHARED_MODULE
# CMAKE_CXX_COMPILE_OBJECT
# CMAKE_CXX_LINK_EXECUTABLE

# variables supplied by the generator at use time
# <TARGET>
# <TARGET_BASE> the target without the suffix
# <OBJECTS>
# <OBJECT>
# <LINK_LIBRARIES>
# <FLAGS>
# <LINK_FLAGS>

# CXX compiler information
# <CMAKE_CXX_COMPILER>  
# <CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS>
# <CMAKE_CXX_SHARED_MODULE_CREATE_FLAGS>
# <CMAKE_CXX_LINK_FLAGS>

# Static library tools
# <CMAKE_AR> 
# <CMAKE_RANLIB>


# create a shared C++ library
IF(NOT CMAKE_CXX_CREATE_SHARED_LIBRARY)
  SET(CMAKE_CXX_CREATE_SHARED_LIBRARY
      "<CMAKE_CXX_COMPILER> <CMAKE_SHARED_LIBRARY_CXX_FLAGS> <LANGUAGE_COMPILE_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS> <CMAKE_SHARED_LIBRARY_SONAME_CXX_FLAG><TARGET_SONAME> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")
ENDIF(NOT CMAKE_CXX_CREATE_SHARED_LIBRARY)

# create a c++ shared module copy the shared library rule by default
IF(NOT CMAKE_CXX_CREATE_SHARED_MODULE)
  SET(CMAKE_CXX_CREATE_SHARED_MODULE ${CMAKE_CXX_CREATE_SHARED_LIBRARY})
ENDIF(NOT CMAKE_CXX_CREATE_SHARED_MODULE)


# Create a static archive incrementally for large object file counts.
# If CMAKE_CXX_CREATE_STATIC_LIBRARY is set it will override these.
IF(NOT DEFINED CMAKE_CXX_ARCHIVE_CREATE)
  SET(CMAKE_CXX_ARCHIVE_CREATE "<CMAKE_AR> cr <TARGET> <LINK_FLAGS> <OBJECTS>")
ENDIF()
IF(NOT DEFINED CMAKE_CXX_ARCHIVE_APPEND)
  SET(CMAKE_CXX_ARCHIVE_APPEND "<CMAKE_AR> r  <TARGET> <LINK_FLAGS> <OBJECTS>")
ENDIF()
IF(NOT DEFINED CMAKE_CXX_ARCHIVE_FINISH)
  SET(CMAKE_CXX_ARCHIVE_FINISH "<CMAKE_RANLIB> <TARGET>")
ENDIF()

# compile a C++ file into an object file
IF(NOT CMAKE_CXX_COMPILE_OBJECT)
  SET(CMAKE_CXX_COMPILE_OBJECT
    "<CMAKE_CXX_COMPILER>  <DEFINES> <FLAGS> -o <OBJECT> -c <SOURCE>")
ENDIF(NOT CMAKE_CXX_COMPILE_OBJECT)

IF(NOT CMAKE_CXX_LINK_EXECUTABLE)
  SET(CMAKE_CXX_LINK_EXECUTABLE
    "<CMAKE_CXX_COMPILER>  <FLAGS> <CMAKE_CXX_LINK_FLAGS> <LINK_FLAGS> <OBJECTS>  -o <TARGET> <LINK_LIBRARIES>")
ENDIF(NOT CMAKE_CXX_LINK_EXECUTABLE)

MARK_AS_ADVANCED(
CMAKE_BUILD_TOOL
CMAKE_VERBOSE_MAKEFILE 
CMAKE_CXX_FLAGS
CMAKE_CXX_FLAGS_RELEASE
CMAKE_CXX_FLAGS_RELWITHDEBINFO
CMAKE_CXX_FLAGS_MINSIZEREL
CMAKE_CXX_FLAGS_DEBUG)

SET(CMAKE_CXX_INFORMATION_LOADED 1)

