      SUBROUTINE SETUP
      INCLUDE 'O8BLOC.INC'
      INTEGER I
        DO I=1,16
          GCONST(I)=.TRUE.
        ENDDO
      RETURN
      END
C   HIMMELBLAU 6 WITH CORRECTIONS BY MURTAGH AND SARGENT
      SUBROUTINE SETUP0
      INCLUDE 'O8BLOC.INC'
      INTEGER I,J
      DOUBLE PRECISION XST(NX)
      DATA (XST(I),I=1,45)/45*0.1D0/
      DO I=1,45
        X(I)=XST(I)
      ENDDO
      NAME='HIMMELBLAU6'
      N=45
      NH=16
      NG=45
      DEL0=1.D-5
      TAU0=1.D4
      TAU=0.1
      PROU=10
      MEU=20
      DO J=0,16
        GUNIT(1,J)=-1
        GUNIT(2,J)=0
        GUNIT(3,J)=0
      ENDDO
      DO J=17,61
        GUNIT(1,J)=1
        GUNIT(3,J)=1
        GUNIT(2,J)=J-16
      ENDDO
      RETURN
      END
      SUBROUTINE EF(X,FX)
      INCLUDE 'O8FUCO.INC'
      INTEGER I,N1,N2,K,J
      DOUBLE PRECISION FX,S1,S2
      DOUBLE PRECISION X(NX),XA(NX),C(45),NK(7)
      SAVE C,NK
c      DATA NK/4,17,35,38,41,43,45/
      DATA NK/4d0,17d0,35d0,38d0,41d0,43d0,45d0/
      DATA C/0.D0,-7.69D0,-11.52D0,-36.6D0,-10.94D0,6*0.D0,2.5966D0,
     1       -39.39D0,-21.35D0,-32.84D0,6.26D0,0.D0,10.45D0,0.D0,-0.5D0,
     2    3*0.D0,2.2435D0,0.D0,-39.39D0,-21.49D0,-32.84D0,6.12D0,2*0.D0,
     3       -1.9028D0,-2.8889D0,-3.3622D0,-7.4854D0,-15.639D0,0.D0,
     4      21.81D0,-16.79D0,0.D0,18.9779D0,0.D0,11.959D0,0.D0,12.899D0/
      ICF=ICF+1
      FX=0.D0
      DO      5       I=1,N
      XA(I)=SQRT(X(I)**2+1.D-20)
   5  CONTINUE
      DO      100      I=1,7
      N1=1
      N2=NK(I)
      IF(I .GT. 1)      N1=NK(I-1)+1
      S1=0.D0
      DO      10      K=N1,N2
      S1=S1+XA(K)
   10 CONTINUE
      S2=0.D0
      DO      50      J=N1,N2
      S2=S2+XA(J)*(C(J)+DLOG(XA(J)/S1))
   50 CONTINUE
      FX=FX+S2
  100 CONTINUE
      RETURN
      END
      SUBROUTINE EGRADF(X,GRADF)
      INCLUDE 'O8FUCO.INC'
      INTEGER I,N1,N2,K,L,J
      DOUBLE PRECISION X(NX),XA(NX),GRADF(NX),C(45),NK(7),
     F        S1
      SAVE C,NK
      INTRINSIC MAX,ABS,LOG
c      DATA NK/4,17,35,38,41,43,45/
      DATA NK/4d0,17d0,35d0,38d0,41d0,43d0,45d0/
      DATA C/0.D0,-7.69D0,-11.52D0,-36.6D0,-10.94D0,6*0.D0,2.5966D0,
     1       -39.39D0,-21.35D0,-32.84D0,6.26D0,0.D0,10.45D0,0.D0,-0.5D0,
     2    3*0.D0,2.2435D0,0.D0,-39.39D0,-21.49D0,-32.84D0,6.12D0,2*0.D0,
     3       -1.9028D0,-2.8889D0,-3.3622D0,-7.4854D0,-15.639D0,0.D0,
     4      21.81D0,-16.79D0,0.D0,18.9779D0,0.D0,11.959D0,0.D0,12.899D0/
      ICGF=ICGF+1
      DO      5       I=1,N
      XA(I)=SQRT(X(I)**2+1.D-20)
   5  CONTINUE
      DO      100      K=1,7
      N1=1
      N2=NK(K)
      IF( K .GT. 1)      N1=NK(K-1)+1
      S1=0.D0
      DO      10      L=N1,N2
      S1=S1+XA(L)
   10 CONTINUE
      DO      50      J=N1,N2
      GRADF(J)= ( C(J)+LOG(XA(J)/S1))*X(J)/XA(J)
   50 CONTINUE
  100 CONTINUE
      RETURN
      END
      SUBROUTINE EH(I,X,HXI)
      INCLUDE 'O8FUCO.INC'
      INTEGER I
      DOUBLE PRECISION X(NX),HXI
      CRES(I)=CRES(I)+1
      GOTO(100,200,300,400,500,600,700,800,900,1000,1100,1200,1300,
     1     1400,1500,1600),I
  100 CONTINUE
      HXI=X( 1)+X( 5)+X(18)+X(32)+2.D0*X(33)+3.D0*X(34)+4.D0*X(35)
     1    -0.6529581D0
      GOTO 2000
  200 CONTINUE
      HXI=X( 2)+X( 6)+X(14)+X(15)+X(16)+X(19)+X(27)+X(28)+X(29)+X(43)
     1     +X(45)-  0.281941D0
      GOTO 2000
  300 CONTINUE
      HXI=X( 3)+X( 7)+X(20)-3.705233D0
      GOTO 2000
  400 CONTINUE
      HXI=X( 4)+X( 8)+X(13)+X(15)-X(16)+X(21)+X(26)+X(28)-X(29)+X(36)
     1     -X(38)+X(39)-X(41)-X(43)-X(45) - 47.00022D0
      GOTO 2000
  500 CONTINUE
      HXI=X( 4)+X( 9)+X(13)+X(14)+X(15)+X(16)+X(22)+X(26)+X(27)+X(28)
     1     +X(29)-47.02972D0
      GOTO 2000
  600 CONTINUE
      HXI=X(10)+X(23)-0.08005D0
      GOTO 2000
  700 CONTINUE
      HXI=X(11)+X(24)-0.08813D0
      GOTO 2000
  800 CONTINUE
      HXI=X(12)+X(25)-0.04829D0
      GOTO 2000
  900 CONTINUE
      HXI=X(17)-0.0155D0
      GOTO 2000
 1000 CONTINUE
      HXI=X(30)-0.0211275D0
      GOTO 2000
 1100 CONTINUE
      HXI=X(31)+X(32)+X(33)+X(34)+X(35)- 0.0022725D0
      GOTO 2000
 1200 CONTINUE
      HXI=X( 8)-X( 9)-X(10)+X(11)+X(12)-X(14)- 2.D0*X(16)-X(17)
      GOTO 2000
 1300 CONTINUE
      HXI=+X(36)+X(37)+X(38)
     1     -4.D0*X(31)-3.D0*X(32)-2.D0*X(33) -X(34)
      GOTO 2000
 1400 CONTINUE
      HXI=-X(32)-2.D0*X(33)-3.D0*X(34)-4.D0*X(35)
     1    + X(39)+X(40)+X(41)
      GOTO 2000
 1500 CONTINUE
      HXI=-4.D0*X(38)+X(42)+X(43)
      GOTO 2000
 1600 CONTINUE
      HXI=-4.D0*X(41)+X(44)+X(45)
      GOTO 2000
2000  CONTINUE
      RETURN
      END
      SUBROUTINE EGRADH(I,X,GRADHI)
      INCLUDE 'O8FUCO.INC'
      INTEGER I,J
      DOUBLE PRECISION X(NX),GRADHI(NX)
      CGRES(I)=CGRES(I)+1
      DO      10      J=1,45
      GRADHI(J)=0.D0
  10  CONTINUE
      GOTO(100,200,300,400,500,600,700,800,900,1000,1100,1200,
     1     1300,1400,1500,1600),I
  100 CONTINUE
      GRADHI( 1)= 1.D0
      GRADHI( 5)= 1.D0
      GRADHI(18)= 1.D0
      GRADHI(32)= 1.D0
      GRADHI(33)= 2.D0
      GRADHI(34)= 3.D0
      GRADHI(35)= 4.D0
      GOTO 2000
  200 CONTINUE
      GRADHI( 2)= 1.D0
      GRADHI( 6)= 1.D0
      GRADHI(14)= 1.D0
      GRADHI(15)= 1.D0
      GRADHI(16)= 1.D0
      GRADHI(19)= 1.D0
      GRADHI(27)= 1.D0
      GRADHI(28)= 1.D0
      GRADHI(29)= 1.D0
      GRADHI(43)= 1.D0
      GRADHI(45)= 1.D0
      GOTO 2000
  300 CONTINUE
      GRADHI( 3)= 1.D0
      GRADHI( 7)= 1.D0
      GRADHI(20)= 1.D0
      GOTO 2000
  400 CONTINUE
      GRADHI( 4)= 1.D0
      GRADHI( 8)= 1.D0
      GRADHI(13)= 1.D0
      GRADHI(15)= 1.D0
      GRADHI(16)=-1.D0
      GRADHI(21)= 1.D0
      GRADHI(26)= 1.D0
      GRADHI(28)= 1.D0
      GRADHI(29)=-1.D0
      GRADHI(36)= 1.D0
      GRADHI(38)=-1.D0
      GRADHI(39)= 1.D0
      GRADHI(41)=-1.D0
      GRADHI(43)=-1.D0
      GRADHI(45)=-1.D0
      GOTO 2000
  500 CONTINUE
      GRADHI( 4)= 1.D0
      GRADHI( 9)= 1.D0
      GRADHI(13)= 1.D0
      GRADHI(14)= 1.D0
      GRADHI(15)= 1.D0
      GRADHI(16)= 1.D0
      GRADHI(22)= 1.D0
      GRADHI(26)= 1.D0
      GRADHI(27)= 1.D0
      GRADHI(28)= 1.D0
      GRADHI(29)= 1.D0
      GOTO 2000
  600 CONTINUE
      GRADHI(10)= 1.D0
      GRADHI(23)= 1.D0
      GOTO 2000
  700 CONTINUE
      GRADHI(11)= 1.D0
      GRADHI(24)= 1.D0
      GOTO 2000
  800 CONTINUE
      GRADHI(12)= 1.D0
      GRADHI(25)= 1.D0
      GOTO 2000
  900 CONTINUE
      GRADHI(17)= 1.D0
      GOTO 2000
 1000 CONTINUE
      GRADHI(30)= 1.D0
      GOTO 2000
 1100 CONTINUE
      GRADHI(31)= 1.D0
      GRADHI(32)= 1.D0
      GRADHI(33)= 1.D0
      GRADHI(34)= 1.D0
      GRADHI(35)= 1.D0
      GOTO 2000
 1200 CONTINUE
      GRADHI( 8)= 1.D0
      GRADHI( 9)=-1.D0
      GRADHI(10)=-1.D0
      GRADHI(11)= 1.D0
      GRADHI(12)= 1.D0
      GRADHI(14)=-1.D0
      GRADHI(16)=-2.D0
      GRADHI(17)=-1.D0
      GOTO 2000
 1300 CONTINUE
      GRADHI(31)=-4.D0
      GRADHI(32)=-3.D0
      GRADHI(33)=-2.D0
      GRADHI(34)=-1.D0
      GRADHI(36)= 1.D0
      GRADHI(37)= 1.D0
      GRADHI(38)= 1.D0
      GOTO 2000
 1400 CONTINUE
      GRADHI(32)=-1.D0
      GRADHI(33)=-2.D0
      GRADHI(34)=-3.D0
      GRADHI(35)=-4.D0
      GRADHI(39)= 1.D0
      GRADHI(40)= 1.D0
      GRADHI(41)= 1.D0
      GOTO 2000
 1500 CONTINUE
      GRADHI(38)=-4.D0
      GRADHI(42)= 1.D0
      GRADHI(43)= 1.D0
      GOTO 2000
 1600 CONTINUE
      GRADHI(41)=-4.D0
      GRADHI(44)= 1.D0
      GRADHI(45)= 1.D0
      GOTO 2000
 2000 CONTINUE
      END
      SUBROUTINE EG(I,X,GXI)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(NX),GXI
      INTEGER I
      IF ( GUNIT(1,I+NH) .EQ. -1 ) CRES(I+NH)=CRES(I+NH)+1
      GXI=X(I)-1.D-6
      END
      SUBROUTINE EGRADG(I,X,GRADGI)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(NX) ,GRADGI(NX)
      INTEGER I,J
      DO      100      J=1,45
      GRADGI(J)=0.D0
  100 CONTINUE
      GRADGI(I)= 1.D0
      RETURN
      END
