#include "cp_types.h"
#include "cp_proto.h"

/* dodec_coloring.c 
Bill Floyd will generate a file of data for the dodecahedral
subdivision tiling, level 3 (??), which gives for the barycenter
vertex of each tile an integer whose digits encode the parentage
of the face -- digits tell successively whether the parent tile
is pentagon, rectangle, or triangle.

Compile with: 
   cc -o tile_coloring tile_coloring.c -L. -L/usr/X11R6/lib -lCP_libs -lX11 -lm

Run with:
   tile_coloring -color rgb -quanta 30 <filename.p>

Idea is to color code using increments of red green blue, repectively,
putting out a postscript file showing the tiles in colors reflecting
their lineage.*/

/* main is derived from "shell_main.c" TEMPLATE.*/

char *emsgbuf,*msgbuf;
int repack_activity_msg(),refresh_canvas();

int main(int argc,char *argv[])
{
  int wad=30; /* increment in color intensity for each hit */
  int Red,Green,Blue;
  double Rcolor,Gcolor,Bcolor;
  int i,j,v,save_spot,depth,count=0;
  complex b;
  char line[BUFSIZE],filename[BUFSIZE],cbuf[BUFSIZE],code[64],
    rgb[16],colr[]="123";
  FILE *fp=NULL,*fpps=NULL;
  struct p_data *p;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  set_cp_globals();

  /* ----------- user code starts here */

  if (argc<1)
    {
      printf("tile_coloring: usage: -color <rgb> -quanta <n> filename.p\n");
      exit(1);
    }

  sc_print_size=9;

  /* ------ read the packing */
  
  if (!strcpy(filename,argv[argc-1])
      || !(p=init_packing())
      || !(fp=fopen(filename,"r"))
      || !readpack(fp,p))
    {
      if (fp) fclose(fp);
      printf("  Failed to get the packing.\n");
      exit(1);
    }
  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  sprintf(cbuf,"-a"); 
  set_screen(p,cbuf); /* fit screen to packing */
  
  printf("Enter the PostScript output file name.\n");
  fgets(line,sizeof(line),stdin);
  sscanf(line,"%s",filename);

  /* ------ get color options from arguments */
  for (i=1;i<=(argc-1);i++)
    {
      if (!strncmp(argv[i],"-c",2) && ++i<=argc-1)
	sscanf(argv[i],"%s",rgb);
      else if (!strncmp(argv[i],"-q",2) && ++i<=argc-1)
	sscanf(argv[i],"%d",&wad);
    }

  for (i=0;i<3 && rgb[i]!='\0';i++) /* set entries of colr */
    {
      if (rgb[i]=='r') sprintf(colr,"%d",i+1);
      else if (rgb[i]=='g') sprintf(colr+1,"%d",i+1);
      else if (rgb[i]=='b') sprintf(colr+2,"%d",i+1);
    }

  /* find the lineage data */
  while (!fscanf(fp,"%s",line) || strcmp(line,"HISTORIES:"));
  if (strcmp(line,"HISTORIES:"))
    {
      printf("Didn't find 'HISTORIES' keyword.\n");
      exit(2);
    }

  sprintf(cbuf,"-o");
  print_call(&fpps,p,filename,cbuf,
	     "Floyd-Stephenson","Aug 2001","lpr");
  fprintf(fpps,"\n .05 ourlinewidth\n");
  
  /* read first to see how many generations we face */
  save_spot=ftell(fp);
  fscanf(fp,"%d %s",&v,code);
  depth=strlen(code);
  fseek(fp,save_spot,SEEK_SET);

  /* ------ read, decode lineage data, add to postscript file */

  while (fscanf(fp,"%d %s",&v,code)==2 && v>0 && v<=p->nodecount)
    {
      Red=Green=Blue=0;

  /* =========================== here's one place to set strategy */
  

      for (i=0;i<depth;i++) /* can adjust: eg, more guanta for 
			       deeper level? */
	{
	  /* weight depending on generation? */
/* 	  if (code[i]==colr[0]) Red += 1+i;
	  else if (code[i]==colr[1]) Green += 1+i;
	  else if (code[i]==colr[2]) Blue += 1+i;
*/
	  /* equal weight (could change weight depending on color) */
	  if (code[i]==colr[0]) Red++;
	  else if (code[i]==colr[1]) Green++;
	  else if (code[i]==colr[2]) Blue++;
	}

/* =========================== here's another strategy spot: 
   low indices? 256-indices? base?..... */
/*      Rcolor=((256-Red*wad)%256)/255.0;
      Gcolor=((256-Green*wad)%256)/255.0;
      Bcolor=((256-Blue*wad)%256)/255.0;
*/

      Rcolor=((Red*wad)%256)/255.0;
      Gcolor=((Green*wad)%256)/255.0;
      Bcolor=((Blue*wad)%256)/255.0;

/*      
        Rcolor=((100+Red*wad)%256)/255.0;
      Gcolor=((100+Green*wad)%256)/255.0;
      Bcolor=((100+Blue*wad)%256)/255.0;
*/

     /* put flower in postscript */
      b=pR_ptr[pK_ptr[v].flower[0]].center;
      fprintf(fpps,"n\n %f %f m\n",b.re,b.im);

      for (j=1;j<=pK_ptr[v].num;j++)
	{
	  b=pR_ptr[pK_ptr[v].flower[j]].center;
	  fprintf(fpps,"%f %f l\n",b.re,b.im);
	}
      /* need to close up? */
      if (pK_ptr[v].flower[0]!=pK_ptr[v].flower[pK_ptr[v].num])
	{
	  b=pR_ptr[v].center;
	  fprintf(fpps,"%f %f l\n",b.re,b.im);
	  b=pR_ptr[pK_ptr[v].flower[0]].center;
	  fprintf(fpps,"%f %f l\n",b.re,b.im);
	}
      fprintf(fpps,"cp\n");
      /* ===== draw edge in color? (may want to drop this) */
/*   fprintf(fpps,"%lf %lf %lf srgb ",Rcolor,Gcolor,Bcolor); 
*/

      /* fill in colored face */
      fprintf(fpps,"gs %lf %lf %lf srgb fill gr\ns\n",Rcolor,Gcolor,Bcolor);
    }
  fclose(fp);
  printf("Printed %d polygonal faces. \n",count);

  sprintf(cbuf,"-xg");
  print_call(&fpps,p,filename,cbuf,"","","lpr");

  printf("Output should now be in %s.\nBye.\n",filename);

  /* ----------- user code ends here */
  exit(0);
} /* main */


/* ====== communication routines; user may want to modify ====== */


int emsg()
{
  printf(emsgbuf);return 1;
} /* emsg */

int msg()
{
  printf(msgbuf);return 1;
} /* msg */

int repack_activity_msg(char *datastr)
     /* report progress of repacking */
{
  strcpy(msgbuf,datastr);
  msg();
  return 1;
} /* repack_activity_msg */

int refresh_canvas(struct s_data *q)
     /* some drawing routines want to refresh */
{return 1;} /* refresh_canvas */

/* ================================================================= */
