#include "cp_types.h"
#include "cp_proto.h"
#include <ctype.h>

/* Read 'light' circle packing data from open fp. If flag set,
read in 'raw' form, no keywords. plight is created; if it had 
data already, it will be tossed out. Return 0 (and empty plight)
on error, else return vertcount. Parallel to write_light. */

int read_light(FILE *fp,struct p_light **plight,int flag)
{
  int vertcount=0,dum,n;
  double radius;
  char command[128],buf[64];
  struct p_light *pl;

  pl=*plight;
  if (pl) free_p_light(&pl);
  pl=*(plight)=(struct p_light *)
    calloc((size_t)1,sizeof(struct p_light));
  pl->counts=(int *)calloc((size_t)12,sizeof(int));
  /* note: only first 6 spots currently in use. */

  if (flag) /* read in raw form */
    {
      for (n=0;n<12;n++) 
	if (!fscanf(fp,"%d",&(pl->counts[n])) 
	    || !(vertcount=pl->counts[0]) )
	  goto BOMB;

      pl->var_indices=(int *)
	calloc((size_t)(pl->counts[3]+1),sizeof(int));
      for (n=1;n<=pl->counts[3];n++) 
	if (!fscanf(fp,"%d",&(pl->var_indices[n]))) goto BOMB;

      pl->orig_indices=(int *)
	calloc((size_t)(vertcount+1),sizeof(int));
      for (n=1;n<=vertcount;n++) 
	if (!fscanf(fp,"%d",&(pl->orig_indices[n]))) 
	  goto BOMB;

      pl->radii=(double *)
	calloc((size_t)(vertcount+1),sizeof(double));
      if (pl->counts[1]<0) /* hyperbolic */
	for (n=1;n<=vertcount;n++) 
	  {
	    if (!fscanf(fp,"%lf",&radius)) goto BOMB;
	    if (radius>0.0) pl->radii[n]=exp(-radius);
	    else pl->radii[n]=radius;
	  }
      else /* euclidean or spherical */
	for (n=1;n<=vertcount;n++) 
	  if (!fscanf(fp,"%lf",&(pl->radii[n]))) goto BOMB;

      pl->fixed_radii=pl->radii+pl->counts[2]+1;

      if (pl->counts[5]) /* aims to read */
	{
	  pl->aim_indices=(int *)
	    calloc((size_t)(pl->counts[5]+1),sizeof(int));
	  pl->aims=(double *)
	    calloc((size_t)(pl->counts[5]+1),sizeof(double));
	  for (n=1;n<=pl->counts[5];n++)
	    if (!fscanf(fp,"%d",pl->aim_indices+n)) goto BOMB;
	  for (n=1;n<=pl->counts[5];n++)
	    if (!fscanf(fp,"%lf",pl->aims+n)) goto BOMB;
	}
    }
  else
    {

      /* must read 'vertcount' info first */
      while ( (fscanf(fp,"%63s",command)!=EOF) 
	      && (strcmp(command,"END")!=0)
	      && (strcmp(command,"VERTCOUNT:")!=0) );
      if (strcmp(command,"VERTCOUNT:")!=0) goto BOMB;
      if (!fscanf(fp,"%d",&vertcount) || !vertcount) goto BOMB;
      pl->counts[0]=vertcount;

      /* now read rest of data */
      while ( (fscanf(fp,"%63s",command)!=EOF) 
	      && (strcmp(command,"END")!=0) )
	{
	  if (strcmp(command,"GEOMETRY:")==0)
	    {
	      if (!fscanf(fp,"%63s",buf)) goto BOMB;
	      if (toupper(buf[0])=='H') pl->counts[1]=-1;
	      else if (toupper(buf[0])=='E') pl->counts[1]=0;
	      else if (toupper(buf[0])=='S') pl->counts[1]=1;
	      else /* if recorded as integer */
		{
		  dum=atoi(buf);
		  if (dum>0) pl->counts[1]=1;
		  else if (dum<0) pl->counts[1]=-1;
		  else pl->counts[1]=0;
		}
	    }
	  else if (strcmp(command,"VARIABLE_COUNT:")==0)
	    {if (!fscanf(fp,"%d",pl->counts+2)) goto BOMB;}
	  else if (strcmp(command,"CHECK_COUNT:")==0)
	    {if (!fscanf(fp,"%d",pl->counts+4)) goto BOMB;}
	  else if (strcmp(command,"AIM_COUNT:")==0)
	    {if (!fscanf(fp,"%d",pl->counts+5)) goto BOMB;}
	} /* end of while for 'counts' */
      
      /* must have some basic info now */
      if (!vertcount || !pl->counts[2]) goto BOMB;
      
      while ( (fscanf(fp,"%63s",command)!=EOF) 
	      && (strcmp(command,"END")!=0) )
	{
	  if ((strcmp(command,"FLOWERS_OF_VARIABLE_VERTS:")==0)
	      && pl->counts[2] && !pl->var_indices)
	    {
	      pl->var_indices=(int *)
		calloc((pl->counts[2]+1),sizeof(int));
	      for (n=1;n<=pl->counts[2];n++) 
		if (!fscanf(fp,"%d",pl->var_indices+n)) goto BOMB;
	    }
	  if ((strcmp(command,"ORIG_INDICES:")==0) && !pl->orig_indices)
	    {
	      pl->orig_indices=(int *)
		calloc((vertcount+1),sizeof(int));
	      for (n=1;n<=vertcount;n++) 
		if (!fscanf(fp,"%d",pl->orig_indices+n)) goto BOMB;
	    }
	  if ((strcmp(command,"RADII:")==0) && !pl->radii)
	    {
	      pl->radii=(double *)
		calloc((vertcount+1),sizeof(double));
	      if (pl->counts[1]<0) /* hyperbolic */
		for (n=1;n<=vertcount;n++) 
		  {
		    if (!fscanf(fp,"%lf",&radius)) goto BOMB;
		    if (radius>0.0) pl->radii[n]=exp(-radius);
		    else pl->radii[n]=radius;
		  }
	      else /* euclidean or spherical */
		for (n=1;n<=vertcount;n++) 
		  if (!fscanf(fp,"%lf",&(pl->radii[n]))) goto BOMB;
	      pl->fixed_radii=pl->radii+pl->counts[2]+1;
	    }
	  if ((strcmp(command,"AIM_INDICES:")==0) && !pl->counts[5])
	    {
	      pl->aim_indices=(int *)
		calloc((pl->counts[5]+1),sizeof(int));
	      pl->aims=(double *)
		calloc((pl->counts[5]+1),sizeof(double));
	      for (n=1;n<=pl->counts[5];n++) 
		if (!fscanf(fp,"%d",pl->aim_indices+n)) goto BOMB;
	    }
	  if ((strcmp(command,"AIMS:")==0) 
	      && !pl->counts[5] && pl->aims)
	    {
	      for (n=1;n<=pl->counts[5];n++) 
		if (!fscanf(fp,"%lf",pl->aims+n)) goto BOMB;
	    }
	} /* end of while */
    }

  return vertcount;

 BOMB:
  if (pl) free_p_light(&pl);
  pl=NULL;
  return 0;
} /* read_light */
