#include "cp_types.h"
#include "cp_proto.h"

/*  Needs updated anglesums, and does update them before returning. 
Also changes radius. */

int normalize_star(struct p_data *p,int v,double radius)
{
  int i,j;
  struct R_data *pR_ptr,*lowR,*highR;
  struct K_data *pK_ptr;
  double target,area,max_r,lowarea,higharea,error,factor=0.15;
  double norm_err=.0001;

  pR_ptr=p->packR_ptr;
  pK_ptr=p->packK_ptr;
  fill_star_curves(p,v);
  target=s_star_area(p,v);
  pR_ptr[v].rad=radius;
	
  /* set up dup data */
  highR=(struct R_data*)malloc((p->nodecount+2)*sizeof(struct R_data));
  lowR=(struct R_data *)malloc((p->nodecount+2)*sizeof(struct R_data));
  for (i=1;i<=p->nodecount;i++) highR[i]=lowR[i]=pR_ptr[i];

  fill_star_curves(p,v);
  area=s_star_area(p,v);
  lowarea=area;
  higharea=area;
  error=area - target;
  if (fabs(error)> norm_err)
    {
      while (lowarea>(target))
	{
	  lowR[v].rad-=lowR[v].rad*factor;
	  for (i=0;i<=pK_ptr[v].num;i++)
	    {
	      j=pK_ptr[v].flower[i];
	      if (lowR[j].rad>highR[j].rad)
		{
		  sprintf(msgbuf,"low>high for vert %d.",
			  j);
		  emsg();
		}
	      if (pR_ptr[pK_ptr[v].flower[i]].aim>0) 
		lowR[j].rad-=lowR[j].rad * factor;
	    }
	  p->packR_ptr=lowR;
	  fill_star_curves(p,v);
	  lowarea=s_star_area(p,v);
	}

      while (higharea<(target))
	{
	  highR[v].rad+=highR[v].rad*factor;
	  for (i=0;i<=pK_ptr[v].num;i++)
	    {
	      j=pK_ptr[v].flower[i];	
	      if (pR_ptr[j].aim>0 
		  && (max_r=max_r_adjustment(p,j))>0.0) 
		{
		  max_r= highR[j].rad+max_r;
		  highR[j].rad
		    =((1+factor)*highR[j].rad<=max_r)
		    ? (1+factor)*highR[j].rad : max_r;
		}
	    } 
	  p->packR_ptr=highR;
	  fill_star_curves(p,v);
	  higharea=s_star_area(p,v);		     
	}
    }	
  p->packR_ptr=pR_ptr; /* CAUTION: note, pointer has been fooled with! */

  while (fabs(error)>norm_err)
    {
      pR_ptr[v].rad=(higharea*lowR[v].rad + lowarea*highR[v].rad)
	/(higharea + lowarea);
      for (i=0;i<=pK_ptr[v].num;i++)
	{
	  j=pK_ptr[v].flower[i];
	  if (pR_ptr[j].aim>=0)
	    pR_ptr[j].rad=(higharea*lowR[j].rad+lowarea*highR[j].rad)
	      /(higharea + lowarea);
	}
      fill_star_curves(p,v);
      area=s_star_area(p,v);
      error= area-target;
		
      if (error>norm_err)
	{
	  highR[v]=pR_ptr[v];
	  for (i=0;i<=pK_ptr[v].num;i++)
	    highR[pK_ptr[v].flower[i]]
	      =pR_ptr[pK_ptr[v].flower[i]];
	  higharea=area;
	}		
      else if (error<(-norm_err))
	{
	  lowR[v]=pR_ptr[v];
	  for (i=0;i<=pK_ptr[v].num;i++) 
	    lowR[pK_ptr[v].flower[i]]
	      =pR_ptr[pK_ptr[v].flower[i]];
	  lowarea=area;
	}
    }
  free(highR);
  free(lowR);
  return 1;
} /* normalize_star */


