#include "cp_types.h"
#include "cp_proto.h"

/* simple binary search method; cmd bits tell which verts to work on:
  0001 = adjust compat verts
  0010 = incompat, too small
  0100 = incompat, too large
  1000 = incompat, mixed */

double h_radcalc_binary(struct p_data *p,int i,double s,double aim,
			int *chgflag,int cmd)
{
  int j,flag,ic_flag_start;
  double startcurv,lower,upper,upcurv,lowcurv,ic_err;
  double factor=0.9;

  *chgflag=0;
  if (aim<0.0) return s;
  /* find situation at start */
  h_as_overlap(p,i,s,&startcurv,&ic_flag_start,&ic_err);

  /* fix if compat, don't make incompat */
  if (ic_flag_start==0 && (cmd & 0001))
    {
      if (startcurv<(aim-okerr)) /* s small; need upper bd on adj */
	{
	  upper=1-factor+s*factor;
	  h_as_overlap(p,i,upper,&upcurv,&flag,&ic_err);
	  if (flag==0 && upcurv<aim) 
	    {(*chgflag)++;return upper;}
	  /* this is max change allowed (as precaution) */
	  j=1;
	  while (j<30)
	    {
	      j++;
	      upper=(s+upper)/2;
	      h_as_overlap(p,i,upper,&upcurv,&flag,&ic_err);
	      if (flag==0 && upcurv<aim)
		{(*chgflag)++;return upper;}
	    }
	  if (j>=30) return s; /* failed to find compatib upper */
	}
      if (startcurv>(aim+okerr)) /* s large; need lower bd on adj */
	{ 
	  lower=s*factor;
	  h_as_overlap(p,i,lower,&lowcurv,&flag,&ic_err);
	  if (flag==0 && lowcurv>aim) 
	    {(*chgflag)++;return lower;}
	  /* this is max change allowed (as safty measure) */
	  j=1;
	  while (j<30)
	    {
	      j++;
	      lower=(s+lower)/2;
	      h_as_overlap(p,i,lower,&lowcurv,&flag,&ic_err);
	      if (flag==0 && lowcurv>aim)
		{(*chgflag)++;return lower;}
	    }
	  if (j>=30) return s; /* failed to find compatib lower */
	}
    }

  /* fix if incompat flag = 1 (too small) */
  else if (ic_flag_start==1 && (cmd & 0010))
    {
      lower=s*factor;
      h_as_overlap(p,i,lower,&lowcurv,&flag,&ic_err);
      if ( (flag==0 && lowcurv>aim) || flag==1 ) 
	{(*chgflag)++;return lower;}
      /* this is max change allowed (as safty measure) */
      j=1;
      while (j<30)
	{
	  j++;
	  lower=(s+lower)/2;
	  h_as_overlap(p,i,lower,&lowcurv,&flag,&ic_err);
	  if ( (flag==0 && lowcurv>aim) || flag==1)
	    {(*chgflag)++;return lower;}
	}
      if (j>=30) return s; /* failed to improve */
    }

  /* fix if incompat flag = 2 (too large) */
  else if (ic_flag_start==2 && (cmd & 0100))
    {
      upper=1-factor+s*factor;
      h_as_overlap(p,i,upper,&upcurv,&flag,&ic_err);
      if ( (flag==0 && upcurv<aim) || flag==2 ) 
	{(*chgflag)++;return upper;}
      /* this is max change allowed (as precaution) */
      j=1;
      while (j<30)
	{
	  j++;
	  upper=(s+upper)/2;
	  h_as_overlap(p,i,upper,&upcurv,&flag,&ic_err);
	  if ( (flag==0 && upcurv<aim) || flag==2)
	    {(*chgflag)++;return upper;}
	}	
      if (j>=30) return s; /* failed to improve */
    }
  return s;
} /* h_radcalc_binary */
