#include "cp_types.h"
#include "cp_proto.h"

int vert_free(struct Vertlist **vertlist)
{
  struct Vertlist *trace,*clobber;

  if (*vertlist==NULL) return 1;
  trace=*vertlist;
  while (trace!=NULL)
    {
      clobber=trace;
      trace=trace->next;
      free(clobber);
    }
  *vertlist=NULL;
  return 1;
} /* vert_free */

int edge_free(struct Edgelist **edgelist)
{
  struct Edgelist *trace,*clobber;

  if (*edgelist==NULL) return 1;
  trace=*edgelist;
  while (trace!=NULL)
    {
      clobber=trace;
      trace=trace->next;
      free(clobber);
    }
  *edgelist=NULL;
  return 1;
} /* edge_free */

int cent_free(struct Centlist **centlist)
{
  struct Centlist *trace,*clobber;

  if (*centlist==NULL) return 1;
  trace=*centlist;
  while (trace!=NULL)
    {
      clobber=trace;
      trace=trace->next;
      free(clobber);
    }
  *centlist=NULL;
  return 1;
} /* cent_free */

int path_free(struct Pathlist **pathlist)
{
  struct Pathlist *trace,*clobber;

  if (*pathlist==NULL) return 1;
  trace=*pathlist;
  while (trace!=NULL)
    {
      clobber=trace;
      trace=trace->next;
      free(clobber);
    }
  *pathlist=NULL;
  return 1;
} /* path_free */

int free_redfaces(struct RedList **redlist)
{
  struct RedList *kil;

  if ((*redlist)==NULL) return 0;
  while (*redlist && (*redlist)->next!=*redlist) /* collapse list by one */
    {
      (*redlist)->prev->next=(*redlist)->next;
      (*redlist)->next->prev=(*redlist)->prev;
      kil=*redlist;
      *redlist=(*redlist)->prev;
      free(kil);
      kil=NULL;
    }
  free(*redlist); 
  *redlist=NULL;
  return 1;
} /* free_redfaces */

int free_bdrydata(struct BdryData **bdrydata)
{
  struct BdryData *kil;

  if ((*bdrydata)==NULL) return 0;
  while (*bdrydata && (*bdrydata)->next!=*bdrydata) /* collapse list by one */
    {
      (*bdrydata)->prev->next=(*bdrydata)->next;
      (*bdrydata)->next->prev=(*bdrydata)->prev;
      kil=*bdrydata;
      *bdrydata=(*bdrydata)->prev;
      free(kil);
      kil=NULL;
    }
  free(*bdrydata); 
  *bdrydata=NULL;
  return 1;
} /* free_bdrydata */

int free_overlaps(struct p_data *p)
     /* free pointers to overlaps */
{
  int v;

  for (v=1;v<=p->nodecount;v++)
    if (p->packK_ptr[v].overlaps) 
      {
	free(p->packK_ptr[v].overlaps);
	p->packK_ptr[v].overlaps=NULL;
      }
  p->overlap_status=0;
  return 1;
} /* free_overlaps */

int free_p_data(struct p_data **pack)
     /* get rid of a packing and free its space */
{
  int i;
  struct p_data *p;

  p=*pack;
  if (!p) return 1;
  free_overlaps(p);
  free_redfaces(&(p->redfaces));
  if (p->rwb_flags) free(p->rwb_flags);
  if (p->f_util) free(p->f_util);
  vert_free(&(p->vlist));
  vert_free(&(p->flist));
  edge_free(&(p->elist));
  edge_free(&(p->vertex_map));
  if (p->faces) free(p->faces);
  if (p->packR_ptr) free(p->packR_ptr);
  if (p->packK_ptr)
    {
      for (i=1;i<=p->nodecount;i++)
	if (p->packK_ptr[i].flower) free(p->packK_ptr[i].flower);
      free(p->packK_ptr);
    }
  if (p->edge_pair) free(p->edge_pair);
  free(p);
  *pack=NULL;
  return 1;
} /* free_p_data */
  
int free_p_light(struct p_light **plight)
{
  struct p_light *pl;
  
  pl=*plight;
  if (!pl) return 1;
  if (pl->counts) free(pl->counts);
  if (pl->var_indices) free(pl->var_indices);
  if (pl->orig_indices) free(pl->orig_indices);
  if (pl->radii) free(pl->radii);
  if (pl->aim_indices) free(pl->aim_indices);
  if (pl->aims) free(pl->aims);
  free(pl);
  *plight=NULL;
  return 1;
} /* free_p_light */
