#include "cp_types.h"
#include "cp_proto.h"

/* read face numbers for p, put in linked list. endptr=NULL or pts 
to inappropriate char, if such is encountered. hits=0 ==> no 
expressions parsed.*/ 

struct Vertlist *Face_link_parse(struct p_data *p,char *dpoint,
				 char **endptr,int *hits,
				 struct Vertlist **Vlist,
				 struct Edgelist **Elist,
				 struct Vertlist **Flist,
				 Region *region,struct Pathlist *pathlist,
				 int pathlength)
{
  int count,v1,v2,n,m,flag,i,cflg,localcount,
    q,qcount=0,q_flag,cf_flag=0,wflag,face;
  char next[256],*nextptr,*lastptr,phold[1];
  struct Vertlist *facelist=NULL,*trace,*clobber,*tmp_ptr;
  struct Vertlist *vlptr=NULL,*cfptr=NULL;
  struct RedList *ftrace;
  f_data *qfaces=NULL;

  nextptr=lastptr=dpoint;
  *endptr=NULL;
  *hits=count=0;
  if (*nextptr == '\0' || !grab_next(&nextptr,next)) return NULL;
  facelist=(struct Vertlist *)calloc((size_t)1,sizeof(struct Vertlist));
  trace=facelist;
  clobber=trace;
  do
    {
      lastptr += notspace(lastptr);
      if (*next=='a') /* all */
	{
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole complex */
	    {v1=1;v2=p->facecount;}
	  else if (!paren_parse(&lastptr,&v1,&v2) || v2<v1)
	    /* malformed expression */
	    goto F_GETOUT;
	  if (v1<1) v1=1;
	  if (v2>p->facecount) v2=p->facecount;
	  if (lastptr>nextptr) nextptr=lastptr;
	  /* now should have valid v1 and v2 */
	  for (n=v1;n<=v2;n++)
	    {
	      trace->v=n;
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      count++;
	    }
	} /* finished with 'all' */
      else if (*next=='b') /* boundary */
	{
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole complex */
	    {v1=1;v2=p->facecount;}
	  else if (!paren_parse(&lastptr,&v1,&v2) || v1>v2)
	    /* malformed expression */
	    goto F_GETOUT;
	  if (v1<1) v1=1;
	  if (v2>p->facecount) v2=p->facecount;
	  for (n=v1;n<=v2;n++)	
	    {
	      flag=0;
	      for (i=0;i<3;i++) 
		if (p->packK_ptr[p->faces[n].vert[i]].bdry_flag)
		  flag++;
	      if (flag)
		{
		  trace->v=n;
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}
	    }
	} /* finished with bdry */
      else if (*next=='r' && p->redfaces)    
	/* red faces using double linked list */
	{
	  localcount=0;
	  lastptr++;
	  wflag=0;
	  ftrace=p->redfaces;
	  while ((ftrace!=p->redfaces || !(wflag++)) 
		 && localcount < 3*p->facecount)
	    {
	      trace->v=ftrace->face;
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      localcount++;
	      ftrace=ftrace->next;
	    }
	  count += localcount;
	}
      else if (*next=='r' && (face=p->first_red_face))
	/* red faces using f_data list (e.g., simply connected case) */
	{
	  localcount=0;
	  lastptr++;
	  wflag=0;
	  while (((face!=p->first_red_face) || !(wflag++)) 
		 && localcount < 3*p->facecount)
	    {
	      trace->v=face;
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      localcount++;
	      face=p->faces[face].next_red;
	    }
	  count += localcount;
	}	  
      else if (*next=='w' && p->rwb_flags) /* white faces in draw order, 
					      as possible.*/
	{
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole complex */
	    {v1=1;v2=p->facecount;}
	  else if (!paren_parse(&lastptr,&v1,&v2) || v1>v2)
	    /* malformed expression */
	    goto F_GETOUT;
	  if (v1<1) v1=1;
	  if (v2>p->facecount) v2=p->facecount;
	  n=m=p->first_face;
	  do
	    {
	      if (n>=v1 && n<=v2 && p->rwb_flags[n]<0)
		{
		  trace->v=n;
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}
	      n=p->faces[n].next_face;
	    }
	  while (n!=m);
	}  
      else if (strncmp(next+1,"list",4)==0) /* use flist */
	{
	  if (((*next=='f' && (cfptr=(*Flist) )) 
	       || (*next=='f' && (cfptr=p->flist)))
	      && *(next+5)=='[')
	    {
	      if (*(next+6)=='r') /* rotate list */
		{
		  vlptr=cfptr;
		  while (vlptr && vlptr->next) vlptr=vlptr->next;
		  vlptr->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  vlptr->next->v=cfptr->v;
		}
	      if (*(next+6)=='n' || *(next+6)=='r')
		{
		  v1=consume_one_index(&cfptr);
		  if (*next=='F') (*Flist)=cfptr;
		  else p->flist=cfptr;
		}
	      else if (sscanf(next+5,"[%d]",&n) && n>=0)
		{
		  vlptr=cfptr;
		  while (n-- > 1 && vlptr->next)
		    vlptr=vlptr->next;
		  if (n==0 && vlptr) v1=vlptr->v;
		  else v1=0;
		}
	      else v1=0;
	      if (v1>0 && v1<=p->facecount ) 
		{
		  trace->v=v1;
		  trace->next=(struct Vertlist *)
		    calloc((size_t)1,sizeof(struct Vertlist));
		  clobber=trace;
		  trace=trace->next;
		  count++;
		}	
	      vlptr=(struct Vertlist *)NULL;
	    }
	  else if (*next=='F') vlptr=(*Flist); /* adjoint Flist */
	  else if (*next=='f') vlptr=p->flist; /* adjoint pack flist */
	  while (vlptr && (n=vlptr->v)>0 && n<=p->facecount)
	    {
	      trace->v=n;
	      trace->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      clobber=trace;
	      trace=trace->next;
	      vlptr=vlptr->next;
	      count++;
	    }
	}
      else if (*next=='m') /* marked */
	{
	  if ((cflg=(next[1]=='c'))) lastptr++; 
				/* 1==>complement of marked */
	  if (next[1]=='p' || (cflg && next[2]=='p') )
				/* take marking from pack q */
	    {
	      lastptr++;
	      if (next[1]=='p') phold[0]=next[2];
	      else phold[0]=next[3];
	      q=atoi(phold);
	      if (q>=0 && packdata[q].status)
		{
		  lastptr++;
		  q_flag=1;
		  qfaces=packdata[q].faces;
		  qcount=packdata[q].facecount;
		}
	      else q_flag=0;
	    }				
	  else q_flag=0;				
	  lastptr++;
	  lastptr=lastptr+notspace(lastptr);
	  if (*lastptr!='(') /* run thru whole complex */
	    {v1=1;v2=p->facecount;}
	  else if (!paren_parse(&lastptr,&v1,&v2) || v1>v2)
	    /* malformed expression */
	    goto F_GETOUT;
	  if (v1<1) v1=1;
	  if (v2>p->facecount) v2=p->facecount;
	  if (lastptr>nextptr) nextptr=lastptr;
	  /* now should have valid v1 and v2 */
	  for (n=v1;n<=v2;n++)
	    if ( (!cflg && !q_flag && p->faces[n].mark) 
		 || (cflg && !q_flag && !p->faces[n].mark) 
		 || (!cflg && q_flag && n<=qcount
		     && qfaces[n].mark)
		 || (cflg && q_flag && n<=qcount
		     && !qfaces[n].mark) )
	      {
		trace->v=n;
		trace->next=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		clobber=trace;
		trace=trace->next;
		count++;
	      }
	} 
      else if (*next=='{')
	{
	  tmp_ptr=brace_parse(p,lastptr,&cf_flag,&lastptr,packdata);
	  if (tmp_ptr!=NULL) /* fit into growing list */
	    {
	      if (facelist==trace) facelist=tmp_ptr;
	      free(trace);
	      clobber=tmp_ptr;
	      count++;
	      while (clobber->next!=NULL)
		{
		  count++;
		  clobber=clobber->next;
		}
	      clobber->next=(struct Vertlist *)
		calloc((size_t)1,sizeof(struct Vertlist));
	      trace=clobber->next;
	    }
	}
      else if (sscanf(next,"%d",&v1) && v1>0 && v1<=p->facecount) 
	{
	  trace->v=v1;
	  trace->next=(struct Vertlist *)
	    calloc((size_t)1,sizeof(struct Vertlist));
	  clobber=trace;
	  trace=trace->next;
	  count++;
	}
      else if (*next=='x') /* plot_flag not set? */
	{
	  for (n=1;n<=p->facecount;n++)
	    if (!p->faces[n].plot_flag)
	      {
		trace->v=n;
		trace->next=(struct Vertlist *)
		  calloc((size_t)1,sizeof(struct Vertlist));
		clobber=trace;
		trace=trace->next;
		count++;
	      }
	}
      else goto F_GETOUT;   /* inappropriate entry */

      stripsp(nextptr);
      lastptr=nextptr;
    }
  while (*nextptr!='-' && grab_next(&nextptr,next));
  *endptr=nextptr;
 F_GETOUT: /* clean up and leave */
  *hits=count;
  if (trace!=clobber) 
    {
      clobber->next=NULL; /* clobber should be last valid data */
      free(trace);trace=NULL;
    }
  if (!count) /* no data; should have trace=clobber=vertlist */
    {
      free(trace);
      return NULL;
    }
  return facelist;
} /* Face_link_parse */
