use Test::More;

use CipUX::RBAC;
use File::Spec;

if ( not $ENV{TEST_CGI} ) {
    my $msg = 'CGI test.  Set $ENV{TEST_CGI} to a true value to run.';
    plan( skip_all => $msg );
} else {
    plan( tests => 5 );
}

#my $rbac_cat_xml = 'cipux-cat-rbac.xml';
my $rbac_cat_xml = File::Spec->catfile( 't', 'cipux-cat-rbac.xml' );
my $rbac_conf    = File::Spec->catfile( 't', 'cipux-rbac.conf' );

my $rbac = CipUX::RBAC->new( { debug => 0, cfg => $rbac_conf } );
is( ref $rbac, 'CipUX::RBAC' );

my $graph = $rbac->read_xml_file( { file => $rbac_cat_xml } );
ok( $graph->directed() );

my @m1 = $rbac->cat_modules_by_user( { graph => $graph, user => 'frodo' } );
is( "@m1", "student.cgi" );

my @m2 = $rbac->cat_modules_by_user( { graph => $graph, user => 'bilbo' } );
is( "@m2", "teacher.cgi student.cgi" );

my @m3 = $rbac->cat_modules_by_user( { graph => $graph, user => 'gandalf' } );
is( "@m3",
"tutor.cgi module.cgi professor.cgi userlist.cgi assignment.cgi skel.cgi lecturer.cgi teacher client.cgi admin.cgi lecture.cgi rbacview.cgi team.cgi reading.cgi access.cgi netgroup.cgi import.cgi tutorial.cgi workshop.cgi assistant.cgi studygroup.cgi index.cgi teacher.cgi course.cgi student.cgi room.cgi seminar.cgi class.cgi pupil.cgi role.cgi"
);

#my @m2 = $rbac->cat_modules_by_user({graph=>$graph,user=>'bilbo'});
#is("@m2",".cgi module.cgi access.cgi studygroup.cgi lecture.cgi tutor.cgi index.cgi rbacview.cgi userlist.cgi client.cgi role.cgi import.cgi seminar.cgi course.cgi student.cgi room.cgi teacher.cgi lecturer.cgi netgroup.cgi professor.cgi workshop.cgi skel.cgi assistant.cgi admin.cgi pupil.cgi tutorial.cgi team.cgi reading.cgi assignment.cgi");

