/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2008-06-03 04:56
   Version 3.2.0 - linux-unix-gnu-x86	[ manyargs dload ptables applyhook hostpcre ]
   SVN rev. 10674	compiled 2008-04-30 on debian (Linux)
   command line: posixunix.scm -quiet -no-trace -optimize-level 2 -include-path . -explicit-use -unsafe -no-lambda-info -output-file uposixunix.c
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>
#include <math.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#if defined(__sun__) && defined(__svr4__)
# include <sys/tty.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)          C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)           (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)          C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)        (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)
#define C_isdir             ((C_statbuf.st_mode & S_IFMT) == S_IFDIR)
#define C_ischr             ((C_statbuf.st_mode & S_IFMT) == S_IFCHR)
#define C_isblk             ((C_statbuf.st_mode & S_IFMT) == S_IFBLK)
#define C_isfifo            ((C_statbuf.st_mode & S_IFMT) == S_IFIFO)
#ifdef S_IFSOCK
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == S_IFSOCK)
#else
#define C_issock            ((C_statbuf.st_mode & S_IFMT) == 0140000)
#endif

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

static void C_set_timeval(C_word num, struct timeval *tm)
{
  if((num & C_FIXNUM_BIT) != 0) {
    tm->tv_sec = C_unfix(num);
    tm->tv_usec = 0;
  }
  else {
    double i;
    tm->tv_usec = (int)(modf(C_flonum_magnitude(num), &i) * 1000000);
    tm->tv_sec = (int)i;
  }
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_set_timeval(t, &C_timeval), \
			       C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#endif

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set_9(v) \
        (C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)))

#define C_tm_get_08(v) \
        (C_set_block_item(v, 0, C_fix(C_tm.tm_sec)), \
        C_set_block_item(v, 1, C_fix(C_tm.tm_min)), \
        C_set_block_item(v, 2, C_fix(C_tm.tm_hour)), \
        C_set_block_item(v, 3, C_fix(C_tm.tm_mday)), \
        C_set_block_item(v, 4, C_fix(C_tm.tm_mon)), \
        C_set_block_item(v, 5, C_fix(C_tm.tm_year)), \
        C_set_block_item(v, 6, C_fix(C_tm.tm_wday)), \
        C_set_block_item(v, 7, C_fix(C_tm.tm_yday)), \
        C_set_block_item(v, 8, (C_tm.tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define C_tm_get_9(v) \
        (C_set_block_item(v, 9, C_fix(C_tm.tm_gmtoff)))

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)

static struct tm *
C_tm_set (C_word v)
{
  C_tm_set_08 (v);
  return &C_tm;
}

static C_word
C_tm_get (C_word v)
{
  C_tm_get_08 (v);
  return v;
}

#else

static struct tm *
C_tm_set (C_word v)
{
  C_tm_set_08 (v);
  C_tm_set_9 (v);
  return &C_tm;
}

static C_word
C_tm_get (C_word v)
{
  C_tm_get_08 (v);
  C_tm_get_9 (v);
  return v;
}

#endif

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)
#define C_timegm(v)     ((C_temporary_flonum = timegm(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

#define C_strptime(s, f, v) \
        (strptime(C_c_string(s), C_c_string(f), &C_tm) ? C_tm_get(v) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#ifdef TIOCGWINSZ
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[473];
static double C_possibly_force_alignment;


/* from k7235 in set-root-directory! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub1393(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1393(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from sleep in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub1166(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1166(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub1163(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1163(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub1161(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1161(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub1092(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1092(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k6190 */
static C_word C_fcall stub1085(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1085(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub1080(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1080(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k6182 */
static C_word C_fcall stub1073(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1073(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from f_6167 in k6161 in process-fork in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub1061(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1061(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub1056(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1056(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1016(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1016(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);else return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k5979 */
static C_word C_fcall stub1002(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1002(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from ttyname */
static C_word C_fcall stub992(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub992(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from set-alarm! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub972(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub972(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from ex0 */
static C_word C_fcall stub967(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub967(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub962(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub962(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_ret:
#undef return

return C_r;}

/* from strptime */
static C_word C_fcall stub943(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub943(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=((C_word)C_strptime(t0,t1,t2));
return C_r;}

/* from strftime */
static C_word C_fcall stub922(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub922(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub916(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub916(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub907(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub907(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k5549 */
static C_word C_fcall stub888(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub888(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k5491 */
static C_word C_fcall stub863(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub863(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from get */
static C_word C_fcall stub845(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub845(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k4192 in k4188 in file-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub569(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub569(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k3912 in initialize-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub509(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub509(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from _ensure-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub482(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub482(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_ret:
#undef return

return C_r;}

/* from _get-groups */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub478(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub478(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

/* from group-member */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub461(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub461(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a7281 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub448(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub448(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a7299 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub446(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub446(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a7302 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub440(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub440(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a7320 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub438(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub438(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from fd_test in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from fd_set in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from fd_zero in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall stub81(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub81(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from fcntl */
static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from ##sys#file-select-one in k1665 in k1662 in k1659 in k1656 in k1653 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub17(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub17(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_ret:
#undef return

return C_r;}

/* from ##sys#file-nonblocking! in k1665 in k1662 in k1659 in k1656 in k1653 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
static C_word C_fcall stub13(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub13(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from strerror */
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1655)
static void C_ccall f_1655(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1658)
static void C_ccall f_1658(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1661)
static void C_ccall f_1661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1664)
static void C_ccall f_1664(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1667)
static void C_ccall f_1667(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7330)
static void C_ccall f_7330(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7346)
static void C_ccall f_7346(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7334)
static void C_ccall f_7334(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7337)
static void C_ccall f_7337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2378)
static void C_ccall f_2378(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3396)
static void C_ccall f_3396(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7324)
static void C_ccall f_7324(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3531)
static void C_ccall f_3531(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7321)
static void C_ccall f_7321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3588)
static void C_ccall f_3588(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7306)
static void C_ccall f_7306(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7316)
static void C_ccall f_7316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7303)
static void C_ccall f_7303(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3592)
static void C_ccall f_3592(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7300)
static void C_ccall f_7300(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3611)
static void C_ccall f_3611(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7285)
static void C_ccall f_7285(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7295)
static void C_ccall f_7295(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7282)
static void C_ccall f_7282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3615)
static void C_ccall f_3615(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7264)
static void C_ccall f_7264(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7277)
static void C_ccall f_7277(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7271)
static void C_ccall f_7271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4119)
static void C_ccall f_4119(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4158)
static void C_ccall f_4158(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7241)
static void C_ccall f_7241(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7237)
static void C_ccall f_7237(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6983)
static void C_ccall f_6983(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_6983)
static void C_ccall f_6983r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_7166)
static void C_fcall f_7166(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7172)
static void C_ccall f_7172(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7161)
static void C_fcall f_7161(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7156)
static void C_fcall f_7156(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6985)
static void C_fcall f_6985(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7143)
static void C_ccall f_7143(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_7151)
static void C_ccall f_7151(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6992)
static void C_fcall f_6992(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7131)
static void C_ccall f_7131(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7125)
static void C_ccall f_7125(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7002)
static void C_ccall f_7002(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7004)
static void C_fcall f_7004(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7023)
static void C_ccall f_7023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7111)
static void C_ccall f_7111(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7118)
static void C_ccall f_7118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7105)
static void C_ccall f_7105(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7038)
static void C_ccall f_7038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7098)
static void C_ccall f_7098(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7095)
static void C_ccall f_7095(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7082)
static void C_ccall f_7082(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7058)
static void C_ccall f_7058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7080)
static void C_ccall f_7080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7066)
static void C_ccall f_7066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7073)
static void C_ccall f_7073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7070)
static void C_ccall f_7070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7050)
static void C_ccall f_7050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7048)
static void C_ccall f_7048(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_7132)
static void C_ccall f_7132(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6926)
static void C_ccall f_6926(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6926)
static void C_ccall f_6926r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6938)
static void C_fcall f_6938(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6933)
static void C_fcall f_6933(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6928)
static void C_fcall f_6928(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6869)
static void C_ccall f_6869(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6869)
static void C_ccall f_6869r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6881)
static void C_fcall f_6881(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6876)
static void C_fcall f_6876(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6871)
static void C_fcall f_6871(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6808)
static void C_fcall f_6808(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6863)
static void C_ccall f_6863(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6867)
static void C_ccall f_6867(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6829)
static void C_ccall f_6829(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6832)
static void C_ccall f_6832(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6843)
static void C_ccall f_6843(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6837)
static void C_ccall f_6837(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6810)
static void C_fcall f_6810(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6819)
static void C_ccall f_6819(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6744)
static void C_ccall f_6744(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_6756)
static void C_ccall f_6756(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_6787)
static void C_ccall f_6787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6767)
static void C_ccall f_6767(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6783)
static void C_ccall f_6783(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6771)
static void C_ccall f_6771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6779)
static void C_ccall f_6779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6775)
static void C_ccall f_6775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6750)
static void C_ccall f_6750(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6733)
static void C_fcall f_6733(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_6737)
static void C_ccall f_6737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6722)
static void C_fcall f_6722(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_6726)
static void C_ccall f_6726(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6677)
static void C_fcall f_6677(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6681)
static void C_ccall f_6681(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6684)
static void C_ccall f_6684(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6687)
static void C_ccall f_6687(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6700)
static void C_ccall f_6700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6704)
static void C_ccall f_6704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6707)
static void C_ccall f_6707(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6710)
static void C_ccall f_6710(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6698)
static void C_ccall f_6698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6661)
static C_word C_fcall f_6661(C_word *a,C_word t0);
C_noret_decl(f_6644)
static void C_fcall f_6644(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6657)
static void C_ccall f_6657(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6569)
static void C_ccall f_6569(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6630)
static void C_fcall f_6630(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6643)
static void C_ccall f_6643(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6610)
static void C_fcall f_6610(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6625)
static void C_ccall f_6625(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6619)
static void C_ccall f_6619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6573)
static void C_fcall f_6573(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6575)
static void C_ccall f_6575(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6596)
static void C_ccall f_6596(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6590)
static void C_ccall f_6590(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6517)
static void C_ccall f_6517(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6517)
static void C_ccall f_6517r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6524)
static void C_ccall f_6524(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6543)
static void C_ccall f_6543(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6547)
static void C_ccall f_6547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6511)
static void C_ccall f_6511(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6502)
static void C_ccall f_6502(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6506)
static void C_ccall f_6506(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6475)
static void C_ccall f_6475(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6475)
static void C_ccall f_6475r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6472)
static void C_ccall f_6472(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6469)
static void C_ccall f_6469(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6466)
static void C_ccall f_6466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6391)
static void C_ccall f_6391(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6391)
static void C_ccall f_6391r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6424)
static void C_ccall f_6424(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6418)
static void C_ccall f_6418(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6374)
static void C_ccall f_6374(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6195)
static void C_ccall f_6195(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_6195)
static void C_ccall f_6195r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_6329)
static void C_fcall f_6329(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6324)
static void C_fcall f_6324(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6197)
static void C_fcall f_6197(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6207)
static void C_ccall f_6207(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6215)
static void C_fcall f_6215(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6261)
static C_word C_fcall f_6261(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6228)
static void C_fcall f_6228(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6253)
static void C_ccall f_6253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6231)
static void C_ccall f_6231(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6187)
static C_word C_fcall f_6187(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6179)
static C_word C_fcall f_6179(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_6141)
static void C_ccall f_6141(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6141)
static void C_ccall f_6141r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6163)
static void C_ccall f_6163(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6167)
static void C_ccall f_6167(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6029)
static void C_ccall f_6029(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6029)
static void C_ccall f_6029r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_6035)
static void C_fcall f_6035(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6056)
static void C_ccall f_6056(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6133)
static void C_ccall f_6133(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6060)
static void C_ccall f_6060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6063)
static void C_ccall f_6063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6066)
static void C_ccall f_6066(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6073)
static void C_ccall f_6073(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6075)
static void C_fcall f_6075(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6092)
static void C_ccall f_6092(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6102)
static void C_ccall f_6102(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6106)
static void C_ccall f_6106(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6050)
static void C_ccall f_6050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6017)
static void C_ccall f_6017(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6021)
static void C_ccall f_6021(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6024)
static void C_ccall f_6024(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5982)
static void C_ccall f_5982(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5986)
static void C_ccall f_5986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6006)
static void C_ccall f_6006(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6010)
static void C_ccall f_6010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5963)
static void C_ccall f_5963(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5967)
static void C_ccall f_5967(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5936)
static void C_fcall f_5936(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5940)
static void C_ccall f_5940(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5917)
static void C_ccall f_5917(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5921)
static void C_ccall f_5921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5924)
static void C_ccall f_5924(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5858)
static void C_ccall f_5858(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5858)
static void C_ccall f_5858r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5862)
static void C_ccall f_5862(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5868)
static void C_ccall f_5868(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5855)
static void C_ccall f_5855(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5839)
static void C_ccall f_5839(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5839)
static void C_ccall f_5839r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5831)
static void C_ccall f_5831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5803)
static void C_ccall f_5803(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5810)
static void C_ccall f_5810(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5775)
static void C_ccall f_5775(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5782)
static void C_ccall f_5782(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5736)
static void C_ccall f_5736(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5736)
static void C_ccall f_5736r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5753)
static void C_ccall f_5753(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5757)
static void C_ccall f_5757(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5661)
static void C_ccall f_5661(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5661)
static void C_ccall f_5661r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5671)
static void C_ccall f_5671(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5693)
static void C_ccall f_5693(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5690)
static void C_ccall f_5690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5680)
static void C_ccall f_5680(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5628)
static void C_ccall f_5628(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5632)
static void C_ccall f_5632(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5614)
static void C_ccall f_5614(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5605)
static void C_ccall f_5605(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5599)
static void C_ccall f_5599(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5590)
static void C_ccall f_5590(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5555)
static void C_ccall f_5555(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5555)
static void C_ccall f_5555r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5497)
static void C_ccall f_5497(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_5497)
static void C_ccall f_5497r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_5501)
static void C_ccall f_5501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5507)
static void C_ccall f_5507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5526)
static void C_ccall f_5526(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5513)
static void C_ccall f_5513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5414)
static void C_ccall f_5414(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5420)
static void C_fcall f_5420(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5424)
static void C_ccall f_5424(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5432)
static void C_fcall f_5432(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5458)
static void C_ccall f_5458(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5462)
static void C_ccall f_5462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5450)
static void C_ccall f_5450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5399)
static void C_ccall f_5399(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5407)
static void C_ccall f_5407(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5382)
static void C_ccall f_5382(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5393)
static void C_ccall f_5393(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5397)
static void C_ccall f_5397(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5356)
static void C_ccall f_5356(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5380)
static void C_ccall f_5380(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5363)
static void C_ccall f_5363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5313)
static void C_ccall f_5313(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5313)
static void C_ccall f_5313r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5320)
static void C_fcall f_5320(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5341)
static void C_ccall f_5341(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5337)
static void C_ccall f_5337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5285)
static void C_ccall f_5285(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5263)
static void C_ccall f_5263(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5263)
static void C_ccall f_5263r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5267)
static void C_ccall f_5267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5248)
static void C_ccall f_5248(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5248)
static void C_ccall f_5248r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5252)
static void C_ccall f_5252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5233)
static void C_ccall f_5233(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5233)
static void C_ccall f_5233r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5237)
static void C_ccall f_5237(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5215)
static void C_fcall f_5215(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5144)
static void C_fcall f_5144(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5163)
static void C_ccall f_5163(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5169)
static void C_fcall f_5169(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5105)
static void C_ccall f_5105(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5133)
static void C_ccall f_5133(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5129)
static void C_ccall f_5129(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5122)
static void C_ccall f_5122(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4849)
static void C_ccall f_4849(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_4849)
static void C_ccall f_4849r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_5045)
static void C_fcall f_5045(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5040)
static void C_fcall f_5040(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5035)
static void C_fcall f_5035(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4851)
static void C_fcall f_4851(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4855)
static void C_ccall f_4855(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4961)
static void C_ccall f_4961(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4962)
static void C_ccall f_4962(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4979)
static void C_fcall f_4979(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4989)
static void C_ccall f_4989(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4947)
static void C_ccall f_4947(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4903)
static void C_fcall f_4903(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4939)
static void C_ccall f_4939(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4918)
static void C_ccall f_4918(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4928)
static void C_ccall f_4928(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4912)
static void C_ccall f_4912(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4907)
static void C_ccall f_4907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4910)
static void C_ccall f_4910(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4857)
static void C_fcall f_4857(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4892)
static void C_ccall f_4892(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4873)
static void C_ccall f_4873(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4378)
static void C_ccall f_4378(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_4378)
static void C_ccall f_4378r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_4774)
static void C_fcall f_4774(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4769)
static void C_fcall f_4769(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4764)
static void C_fcall f_4764(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4759)
static void C_fcall f_4759(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4380)
static void C_fcall f_4380(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4384)
static void C_ccall f_4384(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4390)
static void C_ccall f_4390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4632)
static void C_ccall f_4632(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4638)
static void C_fcall f_4638(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4734)
static void C_ccall f_4734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4724)
static void C_ccall f_4724(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4718)
static void C_ccall f_4718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4640)
static void C_ccall f_4640(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4690)
static void C_ccall f_4690(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4647)
static void C_ccall f_4647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4657)
static void C_ccall f_4657(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4556)
static void C_ccall f_4556(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_4564)
static void C_fcall f_4564(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4566)
static void C_fcall f_4566(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4614)
static void C_ccall f_4614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4547)
static void C_ccall f_4547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4551)
static void C_ccall f_4551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4526)
static void C_ccall f_4526(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4536)
static void C_ccall f_4536(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4514)
static void C_ccall f_4514(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4501)
static void C_ccall f_4501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4505)
static void C_ccall f_4505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4496)
static void C_ccall f_4496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4499)
static void C_ccall f_4499(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4414)
static void C_fcall f_4414(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4426)
static void C_fcall f_4426(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4463)
static void C_ccall f_4463(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4472)
static void C_ccall f_4472(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4466)
static void C_ccall f_4466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4442)
static void C_ccall f_4442(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4445)
static void C_ccall f_4445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4406)
static C_word C_fcall f_4406(C_word t0);
C_noret_decl(f_4391)
static void C_fcall f_4391(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4405)
static void C_ccall f_4405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4351)
static void C_ccall f_4351(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4351)
static void C_ccall f_4351r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4358)
static void C_fcall f_4358(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4361)
static void C_ccall f_4361(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4306)
static void C_ccall f_4306(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4310)
static void C_ccall f_4310(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4345)
static void C_ccall f_4345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4328)
static void C_ccall f_4328(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4292)
static void C_ccall f_4292(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4292)
static void C_ccall f_4292r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4304)
static void C_ccall f_4304(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4278)
static void C_ccall f_4278(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4278)
static void C_ccall f_4278r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4290)
static void C_ccall f_4290(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4263)
static void C_fcall f_4263(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4276)
static void C_ccall f_4276(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4226)
static void C_fcall f_4226(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4234)
static void C_ccall f_4234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4201)
static void C_ccall f_4201(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4190)
static void C_ccall f_4190(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4194)
static void C_ccall f_4194(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4159)
static void C_ccall f_4159(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4183)
static void C_ccall f_4183(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4167)
static void C_ccall f_4167(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4170)
static void C_ccall f_4170(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4121)
static void C_ccall f_4121(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4154)
static void C_ccall f_4154(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4142)
static void C_ccall f_4142(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4150)
static void C_ccall f_4150(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4146)
static void C_ccall f_4146(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4096)
static void C_ccall f_4096(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4112)
static void C_ccall f_4112(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4081)
static void C_ccall f_4081(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4091)
static void C_ccall f_4091(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4085)
static void C_ccall f_4085(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4075)
static void C_ccall f_4075(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4069)
static void C_ccall f_4069(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4063)
static void C_ccall f_4063(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4039)
static void C_fcall f_4039(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4061)
static void C_ccall f_4061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4057)
static void C_ccall f_4057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4049)
static void C_ccall f_4049(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4009)
static void C_ccall f_4009(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4037)
static void C_ccall f_4037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4033)
static void C_ccall f_4033(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3982)
static void C_ccall f_3982(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4007)
static void C_ccall f_4007(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4003)
static void C_ccall f_4003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3918)
static void C_ccall f_3918(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3914)
static void C_ccall f_3914(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3934)
static void C_ccall f_3934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3852)
static void C_ccall f_3852(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3856)
static void C_ccall f_3856(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3861)
static void C_fcall f_3861(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3877)
static void C_ccall f_3877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3789)
static void C_ccall f_3789(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3847)
static void C_ccall f_3847(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3793)
static void C_ccall f_3793(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3796)
static void C_ccall f_3796(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3828)
static void C_ccall f_3828(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3799)
static void C_ccall f_3799(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3804)
static void C_fcall f_3804(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3818)
static void C_ccall f_3818(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3786)
static C_word C_fcall f_3786(C_word t0);
C_noret_decl(f_3711)
static void C_ccall f_3711(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3711)
static void C_ccall f_3711r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3769)
static void C_ccall f_3769(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3718)
static void C_fcall f_3718(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3728)
static void C_ccall f_3728(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3732)
static void C_ccall f_3732(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3741)
static void C_fcall f_3741(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3745)
static void C_ccall f_3745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3755)
static void C_ccall f_3755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3736)
static void C_ccall f_3736(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3691)
static void C_ccall f_3691(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3703)
static void C_ccall f_3703(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3699)
static void C_ccall f_3699(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3677)
static void C_ccall f_3677(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3689)
static void C_ccall f_3689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3685)
static void C_ccall f_3685(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3617)
static void C_ccall f_3617(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3617)
static void C_ccall f_3617r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3663)
static void C_ccall f_3663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3624)
static void C_fcall f_3624(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3634)
static void C_ccall f_3634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3638)
static void C_ccall f_3638(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3642)
static void C_ccall f_3642(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3646)
static void C_ccall f_3646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3650)
static void C_ccall f_3650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3594)
static void C_ccall f_3594(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3604)
static void C_ccall f_3604(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3571)
static void C_ccall f_3571(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3581)
static void C_ccall f_3581(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3533)
static void C_ccall f_3533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3566)
static void C_ccall f_3566(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3537)
static void C_ccall f_3537(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3544)
static void C_ccall f_3544(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3548)
static void C_ccall f_3548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3552)
static void C_ccall f_3552(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3556)
static void C_ccall f_3556(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3560)
static void C_ccall f_3560(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3515)
static void C_ccall f_3515(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3500)
static void C_ccall f_3500(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3494)
static void C_ccall f_3494(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3462)
static void C_ccall f_3462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3468)
static void C_fcall f_3468(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3438)
static void C_ccall f_3438(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3456)
static void C_ccall f_3456(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3445)
static void C_ccall f_3445(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3420)
static void C_ccall f_3420(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3430)
static void C_ccall f_3430(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3407)
static void C_ccall f_3407(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3398)
static void C_ccall f_3398(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3351)
static void C_ccall f_3351(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3355)
static void C_ccall f_3355(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3335)
static void C_ccall f_3335(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3341)
static void C_ccall f_3341(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3341)
static void C_ccall f_3341r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3345)
static void C_ccall f_3345(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3311)
static void C_ccall f_3311(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3311)
static void C_ccall f_3311r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3321)
static void C_ccall f_3321(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3321)
static void C_ccall f_3321r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3325)
static void C_ccall f_3325(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3287)
static void C_ccall f_3287(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3287)
static void C_ccall f_3287r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3302)
static void C_ccall f_3302(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3302)
static void C_ccall f_3302r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3306)
static void C_ccall f_3306(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3296)
static void C_ccall f_3296(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3263)
static void C_ccall f_3263(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3263)
static void C_ccall f_3263r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3267)
static void C_ccall f_3267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3278)
static void C_ccall f_3278(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3278)
static void C_ccall f_3278r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3282)
static void C_ccall f_3282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3272)
static void C_ccall f_3272(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3247)
static void C_ccall f_3247(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3251)
static void C_ccall f_3251(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3254)
static void C_ccall f_3254(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3211)
static void C_ccall f_3211(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3211)
static void C_ccall f_3211r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3242)
static void C_ccall f_3242(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3232)
static void C_ccall f_3232(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3225)
static void C_ccall f_3225(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3175)
static void C_ccall f_3175(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3175)
static void C_ccall f_3175r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3206)
static void C_ccall f_3206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3196)
static void C_ccall f_3196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3189)
static void C_ccall f_3189(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3160)
static void C_fcall f_3160(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3173)
static void C_ccall f_3173(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3154)
static void C_fcall f_3154(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3142)
static C_word C_fcall f_3142(C_word t0);
C_noret_decl(f_2825)
static void C_ccall f_2825(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3132)
static void C_ccall f_3132(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2952)
static void C_fcall f_2952(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3118)
static void C_ccall f_3118(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3107)
static void C_ccall f_3107(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3114)
static void C_ccall f_3114(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2971)
static void C_fcall f_2971(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3100)
static void C_ccall f_3100(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3079)
static void C_ccall f_3079(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3096)
static void C_ccall f_3096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3085)
static void C_ccall f_3085(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3092)
static void C_ccall f_3092(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3015)
static void C_fcall f_3015(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3076)
static void C_ccall f_3076(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3055)
static void C_ccall f_3055(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3072)
static void C_ccall f_3072(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3061)
static void C_ccall f_3061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3068)
static void C_ccall f_3068(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3028)
static void C_ccall f_3028(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3052)
static void C_ccall f_3052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3048)
static void C_ccall f_3048(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3009)
static void C_ccall f_3009(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2978)
static void C_ccall f_2978(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2996)
static void C_ccall f_2996(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2981)
static void C_ccall f_2981(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2985)
static void C_ccall f_2985(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2965)
static void C_ccall f_2965(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2946)
static void C_ccall f_2946(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2832)
static void C_ccall f_2832(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2839)
static void C_ccall f_2839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2841)
static void C_fcall f_2841(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2848)
static void C_ccall f_2848(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2912)
static void C_ccall f_2912(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2921)
static void C_ccall f_2921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2909)
static void C_fcall f_2909(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2854)
static void C_ccall f_2854(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2890)
static void C_ccall f_2890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2886)
static void C_ccall f_2886(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2882)
static void C_ccall f_2882(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2871)
static void C_ccall f_2871(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2867)
static void C_ccall f_2867(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2769)
static void C_fcall f_2769(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2778)
static void C_ccall f_2778(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2802)
static void C_ccall f_2802(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2814)
static void C_ccall f_2814(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2814)
static void C_ccall f_2814r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2820)
static void C_ccall f_2820(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2808)
static void C_ccall f_2808(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2784)
static void C_ccall f_2784(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2790)
static void C_ccall f_2790(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2776)
static void C_ccall f_2776(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2758)
static C_word C_fcall f_2758(C_word t0);
C_noret_decl(f_2753)
static void C_fcall f_2753(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2712)
static void C_ccall f_2712(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2712)
static void C_ccall f_2712r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2725)
static void C_ccall f_2725(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2689)
static void C_ccall f_2689(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2710)
static void C_ccall f_2710(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2696)
static void C_ccall f_2696(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2535)
static void C_ccall f_2535(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2535)
static void C_ccall f_2535r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2640)
static void C_fcall f_2640(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2648)
static void C_ccall f_2648(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2635)
static void C_fcall f_2635(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2537)
static void C_fcall f_2537(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2544)
static void C_ccall f_2544(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2547)
static void C_ccall f_2547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2550)
static void C_ccall f_2550(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2634)
static void C_ccall f_2634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2554)
static void C_ccall f_2554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2568)
static void C_fcall f_2568(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2578)
static void C_ccall f_2578(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2581)
static void C_ccall f_2581(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2584)
static void C_ccall f_2584(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2590)
static void C_fcall f_2590(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2600)
static void C_ccall f_2600(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2511)
static void C_ccall f_2511(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2533)
static void C_ccall f_2533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2529)
static void C_ccall f_2529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2487)
static void C_ccall f_2487(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2509)
static void C_ccall f_2509(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2505)
static void C_ccall f_2505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2386)
static void C_ccall f_2386(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2386)
static void C_ccall f_2386r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2459)
static void C_ccall f_2459(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2473)
static void C_ccall f_2473(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2399)
static void C_ccall f_2399(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2456)
static void C_ccall f_2456(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2404)
static void C_ccall f_2404(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2409)
static void C_ccall f_2409(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2432)
static void C_ccall f_2432(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2452)
static void C_ccall f_2452(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2415)
static void C_ccall f_2415(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2429)
static void C_ccall f_2429(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2318)
static void C_ccall f_2318(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2318)
static void C_ccall f_2318r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2331)
static void C_ccall f_2331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2343)
static void C_ccall f_2343(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2337)
static void C_ccall f_2337(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2309)
static void C_ccall f_2309(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2316)
static void C_ccall f_2316(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2300)
static void C_ccall f_2300(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2307)
static void C_ccall f_2307(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2291)
static void C_ccall f_2291(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2298)
static void C_ccall f_2298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2282)
static void C_ccall f_2282(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2289)
static void C_ccall f_2289(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2273)
static void C_ccall f_2273(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2280)
static void C_ccall f_2280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2264)
static void C_ccall f_2264(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2271)
static void C_ccall f_2271(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2255)
static void C_ccall f_2255(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2262)
static void C_ccall f_2262(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2246)
static void C_ccall f_2246(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2253)
static void C_ccall f_2253(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2237)
static void C_ccall f_2237(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2244)
static void C_ccall f_2244(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2231)
static void C_ccall f_2231(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2235)
static void C_ccall f_2235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2225)
static void C_ccall f_2225(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2229)
static void C_ccall f_2229(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2219)
static void C_ccall f_2219(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2223)
static void C_ccall f_2223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2213)
static void C_ccall f_2213(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2217)
static void C_ccall f_2217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2207)
static void C_ccall f_2207(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2211)
static void C_ccall f_2211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2201)
static void C_ccall f_2201(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2205)
static void C_ccall f_2205(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2176)
static void C_ccall f_2176(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2176)
static void C_ccall f_2176r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2180)
static void C_ccall f_2180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2139)
static void C_fcall f_2139(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2171)
static void C_ccall f_2171(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2164)
static void C_ccall f_2164(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2143)
static void C_ccall f_2143(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1947)
static void C_ccall f_1947(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1947)
static void C_ccall f_1947r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2120)
static void C_ccall f_2120(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1963)
static void C_ccall f_1963(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2094)
static void C_ccall f_2094(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1969)
static void C_ccall f_1969(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1972)
static void C_fcall f_1972(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2054)
static void C_ccall f_2054(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2052)
static void C_ccall f_2052(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2011)
static void C_fcall f_2011(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2029)
static void C_ccall f_2029(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2027)
static void C_ccall f_2027(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2015)
static void C_fcall f_2015(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1945)
static C_word C_fcall f_1945(C_word t0,C_word t1);
C_noret_decl(f_1943)
static C_word C_fcall f_1943(C_word t0,C_word t1);
C_noret_decl(f_1941)
static C_word C_fcall f_1941(C_word t0);
C_noret_decl(f_1909)
static void C_ccall f_1909(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1916)
static void C_ccall f_1916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1922)
static void C_ccall f_1922(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1929)
static void C_ccall f_1929(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1870)
static void C_ccall f_1870(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1870)
static void C_ccall f_1870r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1877)
static void C_ccall f_1877(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1886)
static void C_ccall f_1886(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1828)
static void C_ccall f_1828r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1838)
static void C_ccall f_1838(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1841)
static void C_ccall f_1841(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1844)
static void C_ccall f_1844(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1813)
static void C_ccall f_1813(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1775)
static void C_ccall f_1775(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1775)
static void C_ccall f_1775r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1805)
static void C_ccall f_1805(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1792)
static void C_ccall f_1792(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1795)
static void C_ccall f_1795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1736)
static void C_ccall f_1736(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1736)
static void C_ccall f_1736r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1695)
static void C_ccall f_1695(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1692)
static void C_ccall f_1692(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1674)
static void C_ccall f_1674(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1674)
static void C_ccall f_1674r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1678)
static void C_ccall f_1678(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1689)
static void C_ccall f_1689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1685)
static void C_ccall f_1685(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_7166)
static void C_fcall trf_7166(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7166(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_7166(t0,t1);}

C_noret_decl(trf_7161)
static void C_fcall trf_7161(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7161(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_7161(t0,t1,t2);}

C_noret_decl(trf_7156)
static void C_fcall trf_7156(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7156(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7156(t0,t1,t2,t3);}

C_noret_decl(trf_6985)
static void C_fcall trf_6985(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6985(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6985(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6992)
static void C_fcall trf_6992(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6992(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6992(t0,t1);}

C_noret_decl(trf_7004)
static void C_fcall trf_7004(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_7004(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_7004(t0,t1,t2,t3);}

C_noret_decl(trf_6938)
static void C_fcall trf_6938(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6938(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6938(t0,t1);}

C_noret_decl(trf_6933)
static void C_fcall trf_6933(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6933(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6933(t0,t1,t2);}

C_noret_decl(trf_6928)
static void C_fcall trf_6928(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6928(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6928(t0,t1,t2,t3);}

C_noret_decl(trf_6881)
static void C_fcall trf_6881(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6881(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6881(t0,t1);}

C_noret_decl(trf_6876)
static void C_fcall trf_6876(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6876(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6876(t0,t1,t2);}

C_noret_decl(trf_6871)
static void C_fcall trf_6871(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6871(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6871(t0,t1,t2,t3);}

C_noret_decl(trf_6808)
static void C_fcall trf_6808(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6808(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_6808(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_6810)
static void C_fcall trf_6810(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6810(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6810(t0,t1,t2);}

C_noret_decl(trf_6733)
static void C_fcall trf_6733(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6733(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_6733(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_6722)
static void C_fcall trf_6722(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6722(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_6722(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_6677)
static void C_fcall trf_6677(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6677(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_6677(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_6644)
static void C_fcall trf_6644(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6644(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_6644(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6630)
static void C_fcall trf_6630(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6630(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6630(t0,t1,t2,t3);}

C_noret_decl(trf_6610)
static void C_fcall trf_6610(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6610(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6610(t0,t1,t2);}

C_noret_decl(trf_6573)
static void C_fcall trf_6573(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6573(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_6573(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_6329)
static void C_fcall trf_6329(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6329(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6329(t0,t1);}

C_noret_decl(trf_6324)
static void C_fcall trf_6324(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6324(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6324(t0,t1,t2);}

C_noret_decl(trf_6197)
static void C_fcall trf_6197(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6197(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6197(t0,t1,t2,t3);}

C_noret_decl(trf_6215)
static void C_fcall trf_6215(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6215(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6215(t0,t1,t2,t3);}

C_noret_decl(trf_6228)
static void C_fcall trf_6228(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6228(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6228(t0,t1);}

C_noret_decl(trf_6035)
static void C_fcall trf_6035(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6035(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6035(t0,t1,t2);}

C_noret_decl(trf_6075)
static void C_fcall trf_6075(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6075(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6075(t0,t1,t2);}

C_noret_decl(trf_5936)
static void C_fcall trf_5936(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5936(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5936(t0,t1,t2);}

C_noret_decl(trf_5420)
static void C_fcall trf_5420(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5420(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5420(t0,t1,t2);}

C_noret_decl(trf_5432)
static void C_fcall trf_5432(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5432(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5432(t0,t1,t2);}

C_noret_decl(trf_5320)
static void C_fcall trf_5320(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5320(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5320(t0,t1);}

C_noret_decl(trf_5215)
static void C_fcall trf_5215(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5215(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5215(t0,t1,t2,t3);}

C_noret_decl(trf_5144)
static void C_fcall trf_5144(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5144(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5144(t0,t1,t2,t3);}

C_noret_decl(trf_5169)
static void C_fcall trf_5169(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5169(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5169(t0,t1);}

C_noret_decl(trf_5045)
static void C_fcall trf_5045(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5045(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5045(t0,t1);}

C_noret_decl(trf_5040)
static void C_fcall trf_5040(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5040(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5040(t0,t1,t2);}

C_noret_decl(trf_5035)
static void C_fcall trf_5035(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5035(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5035(t0,t1,t2,t3);}

C_noret_decl(trf_4851)
static void C_fcall trf_4851(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4851(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4851(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4979)
static void C_fcall trf_4979(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4979(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4979(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4903)
static void C_fcall trf_4903(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4903(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4903(t0,t1);}

C_noret_decl(trf_4857)
static void C_fcall trf_4857(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4857(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4857(t0,t1,t2,t3);}

C_noret_decl(trf_4774)
static void C_fcall trf_4774(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4774(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4774(t0,t1);}

C_noret_decl(trf_4769)
static void C_fcall trf_4769(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4769(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4769(t0,t1,t2);}

C_noret_decl(trf_4764)
static void C_fcall trf_4764(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4764(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4764(t0,t1,t2,t3);}

C_noret_decl(trf_4759)
static void C_fcall trf_4759(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4759(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4759(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4380)
static void C_fcall trf_4380(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4380(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_4380(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_4638)
static void C_fcall trf_4638(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4638(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4638(t0,t1,t2);}

C_noret_decl(trf_4564)
static void C_fcall trf_4564(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4564(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4564(t0,t1);}

C_noret_decl(trf_4566)
static void C_fcall trf_4566(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4566(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4566(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4414)
static void C_fcall trf_4414(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4414(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4414(t0,t1);}

C_noret_decl(trf_4426)
static void C_fcall trf_4426(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4426(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4426(t0,t1);}

C_noret_decl(trf_4391)
static void C_fcall trf_4391(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4391(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4391(t0,t1);}

C_noret_decl(trf_4358)
static void C_fcall trf_4358(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4358(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4358(t0,t1);}

C_noret_decl(trf_4263)
static void C_fcall trf_4263(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4263(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4263(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4226)
static void C_fcall trf_4226(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4226(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4226(t0,t1,t2);}

C_noret_decl(trf_4039)
static void C_fcall trf_4039(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4039(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4039(t0,t1,t2,t3);}

C_noret_decl(trf_3861)
static void C_fcall trf_3861(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3861(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3861(t0,t1,t2,t3);}

C_noret_decl(trf_3804)
static void C_fcall trf_3804(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3804(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3804(t0,t1,t2);}

C_noret_decl(trf_3718)
static void C_fcall trf_3718(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3718(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3718(t0,t1);}

C_noret_decl(trf_3741)
static void C_fcall trf_3741(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3741(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3741(t0,t1,t2);}

C_noret_decl(trf_3624)
static void C_fcall trf_3624(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3624(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3624(t0,t1);}

C_noret_decl(trf_3468)
static void C_fcall trf_3468(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3468(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3468(t0,t1,t2,t3);}

C_noret_decl(trf_3160)
static void C_fcall trf_3160(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3160(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3160(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3154)
static void C_fcall trf_3154(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3154(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3154(t0,t1);}

C_noret_decl(trf_2952)
static void C_fcall trf_2952(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2952(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2952(t0,t1);}

C_noret_decl(trf_2971)
static void C_fcall trf_2971(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2971(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2971(t0,t1);}

C_noret_decl(trf_3015)
static void C_fcall trf_3015(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3015(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3015(t0,t1);}

C_noret_decl(trf_2841)
static void C_fcall trf_2841(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2841(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2841(t0,t1,t2,t3);}

C_noret_decl(trf_2909)
static void C_fcall trf_2909(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2909(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2909(t0,t1);}

C_noret_decl(trf_2769)
static void C_fcall trf_2769(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2769(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2769(t0,t1);}

C_noret_decl(trf_2753)
static void C_fcall trf_2753(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2753(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2753(t0,t1);}

C_noret_decl(trf_2640)
static void C_fcall trf_2640(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2640(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2640(t0,t1);}

C_noret_decl(trf_2635)
static void C_fcall trf_2635(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2635(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2635(t0,t1,t2);}

C_noret_decl(trf_2537)
static void C_fcall trf_2537(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2537(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2537(t0,t1,t2,t3);}

C_noret_decl(trf_2568)
static void C_fcall trf_2568(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2568(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2568(t0,t1);}

C_noret_decl(trf_2590)
static void C_fcall trf_2590(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2590(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2590(t0,t1);}

C_noret_decl(trf_2139)
static void C_fcall trf_2139(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2139(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2139(t0,t1,t2,t3);}

C_noret_decl(trf_1972)
static void C_fcall trf_1972(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1972(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1972(t0,t1);}

C_noret_decl(trf_2011)
static void C_fcall trf_2011(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2011(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2011(t0,t1);}

C_noret_decl(trf_2015)
static void C_fcall trf_2015(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2015(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2015(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3410)){
C_save(t1);
C_rereclaim2(3410*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,473);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000\033too many optional arguments");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[9]=C_h_intern(&lf[9],21,"\003sysfile-nonblocking!");
lf[10]=C_h_intern(&lf[10],19,"\003sysfile-select-one");
lf[11]=C_h_intern(&lf[11],8,"pipe/buf");
lf[12]=C_h_intern(&lf[12],11,"fcntl/dupfd");
lf[13]=C_h_intern(&lf[13],11,"fcntl/getfd");
lf[14]=C_h_intern(&lf[14],11,"fcntl/setfd");
lf[15]=C_h_intern(&lf[15],11,"fcntl/getfl");
lf[16]=C_h_intern(&lf[16],11,"fcntl/setfl");
lf[17]=C_h_intern(&lf[17],11,"open/rdonly");
lf[18]=C_h_intern(&lf[18],11,"open/wronly");
lf[19]=C_h_intern(&lf[19],9,"open/rdwr");
lf[20]=C_h_intern(&lf[20],9,"open/read");
lf[21]=C_h_intern(&lf[21],10,"open/write");
lf[22]=C_h_intern(&lf[22],10,"open/creat");
lf[23]=C_h_intern(&lf[23],11,"open/append");
lf[24]=C_h_intern(&lf[24],9,"open/excl");
lf[25]=C_h_intern(&lf[25],11,"open/noctty");
lf[26]=C_h_intern(&lf[26],13,"open/nonblock");
lf[27]=C_h_intern(&lf[27],10,"open/trunc");
lf[28]=C_h_intern(&lf[28],9,"open/sync");
lf[29]=C_h_intern(&lf[29],10,"open/fsync");
lf[30]=C_h_intern(&lf[30],11,"open/binary");
lf[31]=C_h_intern(&lf[31],9,"open/text");
lf[32]=C_h_intern(&lf[32],10,"perm/irusr");
lf[33]=C_h_intern(&lf[33],10,"perm/iwusr");
lf[34]=C_h_intern(&lf[34],10,"perm/ixusr");
lf[35]=C_h_intern(&lf[35],10,"perm/irgrp");
lf[36]=C_h_intern(&lf[36],10,"perm/iwgrp");
lf[37]=C_h_intern(&lf[37],10,"perm/ixgrp");
lf[38]=C_h_intern(&lf[38],10,"perm/iroth");
lf[39]=C_h_intern(&lf[39],10,"perm/iwoth");
lf[40]=C_h_intern(&lf[40],10,"perm/ixoth");
lf[41]=C_h_intern(&lf[41],10,"perm/irwxu");
lf[42]=C_h_intern(&lf[42],10,"perm/irwxg");
lf[43]=C_h_intern(&lf[43],10,"perm/irwxo");
lf[44]=C_h_intern(&lf[44],10,"perm/isvtx");
lf[45]=C_h_intern(&lf[45],10,"perm/isuid");
lf[46]=C_h_intern(&lf[46],10,"perm/isgid");
lf[47]=C_h_intern(&lf[47],12,"file-control");
lf[48]=C_h_intern(&lf[48],11,"\000file-error");
lf[49]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[50]=C_h_intern(&lf[50],9,"file-open");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[52]=C_h_intern(&lf[52],17,"\003sysmake-c-string");
lf[53]=C_h_intern(&lf[53],20,"\003sysexpand-home-path");
lf[54]=C_h_intern(&lf[54],10,"file-close");
lf[55]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[56]=C_h_intern(&lf[56],11,"make-string");
lf[57]=C_h_intern(&lf[57],9,"file-read");
lf[58]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[59]=C_h_intern(&lf[59],11,"\000type-error");
lf[60]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[61]=C_h_intern(&lf[61],10,"file-write");
lf[62]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[64]=C_h_intern(&lf[64],12,"file-mkstemp");
lf[65]=C_h_intern(&lf[65],13,"\003syssubstring");
lf[66]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[67]=C_h_intern(&lf[67],11,"file-select");
lf[68]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[69]=C_h_intern(&lf[69],12,"\003sysfor-each");
lf[70]=C_h_intern(&lf[70],8,"seek/set");
lf[71]=C_h_intern(&lf[71],8,"seek/end");
lf[72]=C_h_intern(&lf[72],8,"seek/cur");
lf[74]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[75]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[76]=C_h_intern(&lf[76],9,"file-stat");
lf[77]=C_h_intern(&lf[77],9,"file-size");
lf[78]=C_h_intern(&lf[78],22,"file-modification-time");
lf[79]=C_h_intern(&lf[79],16,"file-access-time");
lf[80]=C_h_intern(&lf[80],16,"file-change-time");
lf[81]=C_h_intern(&lf[81],10,"file-owner");
lf[82]=C_h_intern(&lf[82],16,"file-permissions");
lf[83]=C_h_intern(&lf[83],13,"regular-file\077");
lf[84]=C_h_intern(&lf[84],14,"symbolic-link\077");
lf[85]=C_h_intern(&lf[85],13,"stat-regular\077");
lf[86]=C_h_intern(&lf[86],15,"stat-directory\077");
lf[87]=C_h_intern(&lf[87],17,"stat-char-device\077");
lf[88]=C_h_intern(&lf[88],18,"stat-block-device\077");
lf[89]=C_h_intern(&lf[89],10,"stat-fifo\077");
lf[90]=C_h_intern(&lf[90],13,"stat-symlink\077");
lf[91]=C_h_intern(&lf[91],12,"stat-socket\077");
lf[92]=C_h_intern(&lf[92],18,"set-file-position!");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[94]=C_h_intern(&lf[94],6,"stream");
lf[95]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[96]=C_h_intern(&lf[96],5,"port\077");
lf[97]=C_h_intern(&lf[97],13,"\000bounds-error");
lf[98]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[99]=C_h_intern(&lf[99],13,"file-position");
lf[100]=C_h_intern(&lf[100],20,"g196-1212508536.0236");
lf[101]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[102]=C_h_intern(&lf[102],20,"g202-1212508536.0182");
lf[103]=C_decode_literal(C_heaptop,"\376B\000\000\026path segment is a file");
lf[104]=C_h_intern(&lf[104],20,"g201-1212508536.0794");
lf[105]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot stat file");
lf[106]=C_h_intern(&lf[106],20,"g218-1212508536.0664");
lf[107]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[108]=C_h_intern(&lf[108],20,"g217-1212508536.0232");
lf[109]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[110]=C_h_intern(&lf[110],20,"g216-1212508536.0597");
lf[111]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[112]=C_h_intern(&lf[112],16,"create-directory");
lf[113]=C_h_intern(&lf[113],12,"file-exists\077");
lf[114]=C_h_intern(&lf[114],12,"string-split");
lf[115]=C_h_intern(&lf[115],14,"canonical-path");
lf[116]=C_h_intern(&lf[116],16,"change-directory");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[118]=C_h_intern(&lf[118],16,"delete-directory");
lf[119]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[120]=C_h_intern(&lf[120],10,"string-ref");
lf[121]=C_h_intern(&lf[121],6,"string");
lf[122]=C_h_intern(&lf[122],9,"directory");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[124]=C_h_intern(&lf[124],16,"\003sysmake-pointer");
lf[125]=C_h_intern(&lf[125],17,"current-directory");
lf[126]=C_h_intern(&lf[126],10,"directory\077");
lf[127]=C_h_intern(&lf[127],13,"\003sysfile-info");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[129]=C_h_intern(&lf[129],5,"null\077");
lf[130]=C_h_intern(&lf[130],6,"char=\077");
lf[131]=C_h_intern(&lf[131],8,"string=\077");
lf[132]=C_h_intern(&lf[132],16,"char-alphabetic\077");
lf[133]=C_h_intern(&lf[133],18,"string-intersperse");
lf[134]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[135]=C_h_intern(&lf[135],6,"getenv");
lf[136]=C_h_intern(&lf[136],17,"current-user-name");
lf[137]=C_h_intern(&lf[137],9,"condition");
lf[138]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[139]=C_h_intern(&lf[139],22,"with-exception-handler");
lf[140]=C_h_intern(&lf[140],30,"call-with-current-continuation");
lf[141]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[142]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[143]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[144]=C_h_intern(&lf[144],7,"reverse");
lf[145]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[146]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[147]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[148]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[149]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[150]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[151]=C_decode_literal(C_heaptop,"\376B\000\000\006/home/");
lf[152]=C_decode_literal(C_heaptop,"\376B\000\000\004HOME");
lf[153]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[154]=C_decode_literal(C_heaptop,"\376B\000\000\001/");
lf[155]=C_h_intern(&lf[155],5,"\000text");
lf[156]=C_h_intern(&lf[156],9,"\003syserror");
lf[157]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[158]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[159]=C_h_intern(&lf[159],13,"\003sysmake-port");
lf[160]=C_h_intern(&lf[160],21,"\003sysstream-port-class");
lf[161]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[162]=C_h_intern(&lf[162],15,"open-input-pipe");
lf[163]=C_h_intern(&lf[163],7,"\000binary");
lf[164]=C_h_intern(&lf[164],16,"open-output-pipe");
lf[165]=C_h_intern(&lf[165],16,"close-input-pipe");
lf[166]=C_h_intern(&lf[166],23,"close-input/output-pipe");
lf[167]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[168]=C_h_intern(&lf[168],14,"\003syscheck-port");
lf[169]=C_h_intern(&lf[169],17,"close-output-pipe");
lf[170]=C_h_intern(&lf[170],20,"call-with-input-pipe");
lf[171]=C_h_intern(&lf[171],21,"call-with-output-pipe");
lf[172]=C_h_intern(&lf[172],20,"with-input-from-pipe");
lf[173]=C_h_intern(&lf[173],18,"\003sysstandard-input");
lf[174]=C_h_intern(&lf[174],19,"with-output-to-pipe");
lf[175]=C_h_intern(&lf[175],19,"\003sysstandard-output");
lf[176]=C_h_intern(&lf[176],11,"create-pipe");
lf[177]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[178]=C_h_intern(&lf[178],11,"signal/term");
lf[179]=C_h_intern(&lf[179],11,"signal/kill");
lf[180]=C_h_intern(&lf[180],10,"signal/int");
lf[181]=C_h_intern(&lf[181],10,"signal/hup");
lf[182]=C_h_intern(&lf[182],10,"signal/fpe");
lf[183]=C_h_intern(&lf[183],10,"signal/ill");
lf[184]=C_h_intern(&lf[184],11,"signal/segv");
lf[185]=C_h_intern(&lf[185],11,"signal/abrt");
lf[186]=C_h_intern(&lf[186],11,"signal/trap");
lf[187]=C_h_intern(&lf[187],11,"signal/quit");
lf[188]=C_h_intern(&lf[188],11,"signal/alrm");
lf[189]=C_h_intern(&lf[189],13,"signal/vtalrm");
lf[190]=C_h_intern(&lf[190],11,"signal/prof");
lf[191]=C_h_intern(&lf[191],9,"signal/io");
lf[192]=C_h_intern(&lf[192],10,"signal/urg");
lf[193]=C_h_intern(&lf[193],11,"signal/chld");
lf[194]=C_h_intern(&lf[194],11,"signal/cont");
lf[195]=C_h_intern(&lf[195],11,"signal/stop");
lf[196]=C_h_intern(&lf[196],11,"signal/tstp");
lf[197]=C_h_intern(&lf[197],11,"signal/pipe");
lf[198]=C_h_intern(&lf[198],11,"signal/xcpu");
lf[199]=C_h_intern(&lf[199],11,"signal/xfsz");
lf[200]=C_h_intern(&lf[200],11,"signal/usr1");
lf[201]=C_h_intern(&lf[201],11,"signal/usr2");
lf[202]=C_h_intern(&lf[202],12,"signal/winch");
lf[203]=C_h_intern(&lf[203],12,"signals-list");
lf[204]=C_h_intern(&lf[204],18,"\003sysinterrupt-hook");
lf[205]=C_h_intern(&lf[205],14,"signal-handler");
lf[206]=C_h_intern(&lf[206],19,"set-signal-handler!");
lf[207]=C_h_intern(&lf[207],16,"set-signal-mask!");
lf[208]=C_h_intern(&lf[208],14,"\000process-error");
lf[209]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[210]=C_h_intern(&lf[210],11,"signal-mask");
lf[211]=C_h_intern(&lf[211],14,"signal-masked\077");
lf[212]=C_h_intern(&lf[212],12,"signal-mask!");
lf[213]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[214]=C_h_intern(&lf[214],14,"signal-unmask!");
lf[215]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[216]=C_h_intern(&lf[216],18,"system-information");
lf[217]=C_h_intern(&lf[217],25,"\003syspeek-nonnull-c-string");
lf[218]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[219]=C_h_intern(&lf[219],12,"set-user-id!");
lf[220]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[221]=C_h_intern(&lf[221],15,"current-user-id");
lf[222]=C_h_intern(&lf[222],25,"current-effective-user-id");
lf[223]=C_h_intern(&lf[223],13,"set-group-id!");
lf[224]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[225]=C_h_intern(&lf[225],16,"current-group-id");
lf[226]=C_h_intern(&lf[226],26,"current-effective-group-id");
lf[227]=C_h_intern(&lf[227],16,"user-information");
lf[228]=C_h_intern(&lf[228],6,"vector");
lf[229]=C_h_intern(&lf[229],4,"list");
lf[230]=C_h_intern(&lf[230],27,"current-effective-user-name");
lf[231]=C_h_intern(&lf[231],17,"group-information");
lf[233]=C_h_intern(&lf[233],10,"get-groups");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[237]=C_h_intern(&lf[237],11,"set-groups!");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[239]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[240]=C_h_intern(&lf[240],17,"initialize-groups");
lf[241]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[242]=C_h_intern(&lf[242],10,"errno/perm");
lf[243]=C_h_intern(&lf[243],11,"errno/noent");
lf[244]=C_h_intern(&lf[244],10,"errno/srch");
lf[245]=C_h_intern(&lf[245],10,"errno/intr");
lf[246]=C_h_intern(&lf[246],8,"errno/io");
lf[247]=C_h_intern(&lf[247],12,"errno/noexec");
lf[248]=C_h_intern(&lf[248],10,"errno/badf");
lf[249]=C_h_intern(&lf[249],11,"errno/child");
lf[250]=C_h_intern(&lf[250],11,"errno/nomem");
lf[251]=C_h_intern(&lf[251],11,"errno/acces");
lf[252]=C_h_intern(&lf[252],11,"errno/fault");
lf[253]=C_h_intern(&lf[253],10,"errno/busy");
lf[254]=C_h_intern(&lf[254],12,"errno/notdir");
lf[255]=C_h_intern(&lf[255],11,"errno/isdir");
lf[256]=C_h_intern(&lf[256],11,"errno/inval");
lf[257]=C_h_intern(&lf[257],11,"errno/mfile");
lf[258]=C_h_intern(&lf[258],11,"errno/nospc");
lf[259]=C_h_intern(&lf[259],11,"errno/spipe");
lf[260]=C_h_intern(&lf[260],10,"errno/pipe");
lf[261]=C_h_intern(&lf[261],11,"errno/again");
lf[262]=C_h_intern(&lf[262],10,"errno/rofs");
lf[263]=C_h_intern(&lf[263],11,"errno/exist");
lf[264]=C_h_intern(&lf[264],16,"errno/wouldblock");
lf[265]=C_h_intern(&lf[265],10,"errno/2big");
lf[266]=C_h_intern(&lf[266],12,"errno/deadlk");
lf[267]=C_h_intern(&lf[267],9,"errno/dom");
lf[268]=C_h_intern(&lf[268],10,"errno/fbig");
lf[269]=C_h_intern(&lf[269],11,"errno/ilseq");
lf[270]=C_h_intern(&lf[270],11,"errno/mlink");
lf[271]=C_h_intern(&lf[271],17,"errno/nametoolong");
lf[272]=C_h_intern(&lf[272],11,"errno/nfile");
lf[273]=C_h_intern(&lf[273],11,"errno/nodev");
lf[274]=C_h_intern(&lf[274],11,"errno/nolck");
lf[275]=C_h_intern(&lf[275],11,"errno/nosys");
lf[276]=C_h_intern(&lf[276],14,"errno/notempty");
lf[277]=C_h_intern(&lf[277],11,"errno/notty");
lf[278]=C_h_intern(&lf[278],10,"errno/nxio");
lf[279]=C_h_intern(&lf[279],11,"errno/range");
lf[280]=C_h_intern(&lf[280],10,"errno/xdev");
lf[281]=C_h_intern(&lf[281],16,"change-file-mode");
lf[282]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[283]=C_h_intern(&lf[283],17,"change-file-owner");
lf[284]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[285]=C_h_intern(&lf[285],17,"file-read-access\077");
lf[286]=C_h_intern(&lf[286],18,"file-write-access\077");
lf[287]=C_h_intern(&lf[287],20,"file-execute-access\077");
lf[288]=C_h_intern(&lf[288],14,"create-session");
lf[289]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[290]=C_h_intern(&lf[290],21,"set-process-group-id!");
lf[291]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[292]=C_h_intern(&lf[292],16,"process-group-id");
lf[293]=C_h_intern(&lf[293],20,"create-symbolic-link");
lf[294]=C_h_intern(&lf[294],18,"create-symbol-link");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[296]=C_h_intern(&lf[296],9,"substring");
lf[297]=C_h_intern(&lf[297],18,"read-symbolic-link");
lf[298]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[299]=C_h_intern(&lf[299],9,"file-link");
lf[300]=C_h_intern(&lf[300],9,"hard-link");
lf[301]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[302]=C_h_intern(&lf[302],12,"fileno/stdin");
lf[303]=C_h_intern(&lf[303],13,"fileno/stdout");
lf[304]=C_h_intern(&lf[304],13,"fileno/stderr");
lf[305]=C_h_intern(&lf[305],7,"\000append");
lf[306]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[307]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[308]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[310]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[311]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[312]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[313]=C_h_intern(&lf[313],16,"open-input-file*");
lf[314]=C_h_intern(&lf[314],17,"open-output-file*");
lf[315]=C_h_intern(&lf[315],12,"port->fileno");
lf[316]=C_h_intern(&lf[316],6,"socket");
lf[317]=C_h_intern(&lf[317],20,"\003systcp-port->fileno");
lf[318]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[320]=C_h_intern(&lf[320],25,"\003syspeek-unsigned-integer");
lf[321]=C_h_intern(&lf[321],16,"duplicate-fileno");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[323]=C_h_intern(&lf[323],15,"make-input-port");
lf[324]=C_h_intern(&lf[324],14,"set-port-name!");
lf[325]=C_h_intern(&lf[325],21,"\003syscustom-input-port");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[327]=C_h_intern(&lf[327],17,"\003systhread-yield!");
lf[328]=C_h_intern(&lf[328],25,"\003systhread-block-for-i/o!");
lf[329]=C_h_intern(&lf[329],18,"\003syscurrent-thread");
lf[330]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[331]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[332]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[333]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[334]=C_h_intern(&lf[334],17,"\003sysstring-append");
lf[335]=C_h_intern(&lf[335],15,"\003sysmake-string");
lf[336]=C_h_intern(&lf[336],20,"\003sysscan-buffer-line");
lf[337]=C_h_intern(&lf[337],4,"noop");
lf[338]=C_h_intern(&lf[338],16,"make-output-port");
lf[339]=C_h_intern(&lf[339],22,"\003syscustom-output-port");
lf[340]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[342]=C_h_intern(&lf[342],13,"file-truncate");
lf[343]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[344]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[345]=C_h_intern(&lf[345],4,"lock");
lf[346]=C_h_intern(&lf[346],9,"file-lock");
lf[347]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[348]=C_h_intern(&lf[348],18,"file-lock/blocking");
lf[349]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[350]=C_h_intern(&lf[350],14,"file-test-lock");
lf[351]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[352]=C_h_intern(&lf[352],11,"file-unlock");
lf[353]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[354]=C_h_intern(&lf[354],11,"create-fifo");
lf[355]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[356]=C_h_intern(&lf[356],5,"fifo\077");
lf[357]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[358]=C_h_intern(&lf[358],6,"setenv");
lf[359]=C_h_intern(&lf[359],8,"unsetenv");
lf[360]=C_h_intern(&lf[360],19,"current-environment");
lf[361]=C_h_intern(&lf[361],9,"prot/read");
lf[362]=C_h_intern(&lf[362],10,"prot/write");
lf[363]=C_h_intern(&lf[363],9,"prot/exec");
lf[364]=C_h_intern(&lf[364],9,"prot/none");
lf[365]=C_h_intern(&lf[365],9,"map/fixed");
lf[366]=C_h_intern(&lf[366],10,"map/shared");
lf[367]=C_h_intern(&lf[367],11,"map/private");
lf[368]=C_h_intern(&lf[368],13,"map/anonymous");
lf[369]=C_h_intern(&lf[369],8,"map/file");
lf[370]=C_h_intern(&lf[370],18,"map-file-to-memory");
lf[371]=C_h_intern(&lf[371],4,"mmap");
lf[372]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[373]=C_h_intern(&lf[373],20,"\003syspointer->address");
lf[374]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[375]=C_h_intern(&lf[375],16,"\003sysnull-pointer");
lf[376]=C_h_intern(&lf[376],22,"unmap-file-from-memory");
lf[377]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[378]=C_h_intern(&lf[378],26,"memory-mapped-file-pointer");
lf[379]=C_h_intern(&lf[379],19,"memory-mapped-file\077");
lf[380]=C_h_intern(&lf[380],19,"seconds->local-time");
lf[381]=C_h_intern(&lf[381],18,"\003sysdecode-seconds");
lf[382]=C_h_intern(&lf[382],17,"seconds->utc-time");
lf[383]=C_h_intern(&lf[383],15,"seconds->string");
lf[384]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[385]=C_h_intern(&lf[385],12,"time->string");
lf[386]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[388]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[389]=C_h_intern(&lf[389],12,"string->time");
lf[390]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[391]=C_h_intern(&lf[391],19,"local-time->seconds");
lf[392]=C_h_intern(&lf[392],15,"\003syscons-flonum");
lf[393]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[394]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[395]=C_h_intern(&lf[395],17,"utc-time->seconds");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[397]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[398]=C_h_intern(&lf[398],27,"local-timezone-abbreviation");
lf[399]=C_h_intern(&lf[399],5,"_exit");
lf[400]=C_h_intern(&lf[400],10,"set-alarm!");
lf[401]=C_h_intern(&lf[401],19,"set-buffering-mode!");
lf[402]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[403]=C_h_intern(&lf[403],5,"\000full");
lf[404]=C_h_intern(&lf[404],5,"\000line");
lf[405]=C_h_intern(&lf[405],5,"\000none");
lf[406]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[407]=C_h_intern(&lf[407],14,"terminal-port\077");
lf[409]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[410]=C_h_intern(&lf[410],13,"terminal-name");
lf[411]=C_h_intern(&lf[411],13,"terminal-size");
lf[412]=C_h_intern(&lf[412],6,"\000error");
lf[413]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[414]=C_h_intern(&lf[414],17,"\003sysmake-locative");
lf[415]=C_h_intern(&lf[415],8,"location");
lf[416]=C_h_intern(&lf[416],13,"get-host-name");
lf[417]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[418]=C_h_intern(&lf[418],6,"regexp");
lf[419]=C_h_intern(&lf[419],21,"make-anchored-pattern");
lf[420]=C_h_intern(&lf[420],12,"string-match");
lf[421]=C_h_intern(&lf[421],12,"glob->regexp");
lf[422]=C_h_intern(&lf[422],13,"make-pathname");
lf[423]=C_h_intern(&lf[423],18,"decompose-pathname");
lf[424]=C_h_intern(&lf[424],4,"glob");
lf[425]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[426]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[427]=C_h_intern(&lf[427],12,"process-fork");
lf[428]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[429]=C_h_intern(&lf[429],24,"pathname-strip-directory");
lf[430]=C_h_intern(&lf[430],15,"process-execute");
lf[431]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[432]=C_h_intern(&lf[432],16,"\003sysprocess-wait");
lf[433]=C_h_intern(&lf[433],12,"process-wait");
lf[434]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[435]=C_h_intern(&lf[435],18,"current-process-id");
lf[436]=C_h_intern(&lf[436],17,"parent-process-id");
lf[437]=C_h_intern(&lf[437],5,"sleep");
lf[438]=C_h_intern(&lf[438],14,"process-signal");
lf[439]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[440]=C_h_intern(&lf[440],17,"\003sysshell-command");
lf[441]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[442]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[443]=C_h_intern(&lf[443],27,"\003sysshell-command-arguments");
lf[444]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[445]=C_h_intern(&lf[445],11,"process-run");
lf[446]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[447]=C_h_intern(&lf[447],11,"\003sysprocess");
lf[448]=C_h_intern(&lf[448],19,"\003sysundefined-value");
lf[449]=C_h_intern(&lf[449],7,"process");
lf[450]=C_h_intern(&lf[450],8,"process*");
lf[451]=C_h_intern(&lf[451],10,"find-files");
lf[452]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[454]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[455]=C_h_intern(&lf[455],16,"\003sysdynamic-wind");
lf[456]=C_h_intern(&lf[456],13,"pathname-file");
lf[457]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[458]=C_h_intern(&lf[458],7,"regexp\077");
lf[459]=C_h_intern(&lf[459],19,"set-root-directory!");
lf[460]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[461]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[462]=C_h_intern(&lf[462],18,"getter-with-setter");
lf[463]=C_h_intern(&lf[463],26,"effective-group-id!-setter");
lf[464]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[465]=C_h_intern(&lf[465],25,"effective-user-id!-setter");
lf[466]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[467]=C_h_intern(&lf[467],23,"\003sysuser-interrupt-hook");
lf[468]=C_h_intern(&lf[468],11,"make-vector");
lf[469]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[470]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[471]=C_h_intern(&lf[471],17,"register-feature!");
lf[472]=C_h_intern(&lf[472],5,"posix");
C_register_lf2(lf,473,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1655,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1653 */
static void C_ccall f_1655(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1655,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1658,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1656 in k1653 */
static void C_ccall f_1658(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1658,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1661,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1659 in k1656 in k1653 */
static void C_ccall f_1661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1661,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1664,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1664(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1664,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1667,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 508  register-feature! */
t3=*((C_word*)lf[471]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[472]);}

/* k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1667(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word ab[81],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1667,2,t0,t1);}
t2=*((C_word*)lf[2]+1);
t3=C_mutate(&lf[3],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1674,a[2]=t2,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[8]+1,lf[3]);
t5=C_mutate((C_word*)lf[9]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1692,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[10]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1695,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[11]+1,C_fix((C_word)PIPE_BUF));
t8=C_mutate((C_word*)lf[12]+1,C_fix((C_word)F_DUPFD));
t9=C_mutate((C_word*)lf[13]+1,C_fix((C_word)F_GETFD));
t10=C_mutate((C_word*)lf[14]+1,C_fix((C_word)F_SETFD));
t11=C_mutate((C_word*)lf[15]+1,C_fix((C_word)F_GETFL));
t12=C_mutate((C_word*)lf[16]+1,C_fix((C_word)F_SETFL));
t13=C_mutate((C_word*)lf[17]+1,C_fix((C_word)O_RDONLY));
t14=C_mutate((C_word*)lf[18]+1,C_fix((C_word)O_WRONLY));
t15=C_mutate((C_word*)lf[19]+1,C_fix((C_word)O_RDWR));
t16=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_RDONLY));
t17=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_WRONLY));
t18=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_CREAT));
t19=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_APPEND));
t20=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_EXCL));
t21=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_NOCTTY));
t22=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_NONBLOCK));
t23=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_TRUNC));
t24=C_mutate((C_word*)lf[28]+1,C_fix((C_word)O_FSYNC));
t25=C_mutate((C_word*)lf[29]+1,C_fix((C_word)O_FSYNC));
t26=C_mutate((C_word*)lf[30]+1,C_fix((C_word)O_BINARY));
t27=C_mutate((C_word*)lf[31]+1,C_fix((C_word)O_TEXT));
t28=C_mutate((C_word*)lf[32]+1,C_fix((C_word)S_IRUSR));
t29=C_mutate((C_word*)lf[33]+1,C_fix((C_word)S_IWUSR));
t30=C_mutate((C_word*)lf[34]+1,C_fix((C_word)S_IXUSR));
t31=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IRGRP));
t32=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IWGRP));
t33=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IXGRP));
t34=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IROTH));
t35=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IWOTH));
t36=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_IXOTH));
t37=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_IRWXU));
t38=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_IRWXG));
t39=C_mutate((C_word*)lf[43]+1,C_fix((C_word)S_IRWXO));
t40=C_mutate((C_word*)lf[44]+1,C_fix((C_word)S_ISVTX));
t41=C_mutate((C_word*)lf[45]+1,C_fix((C_word)S_ISUID));
t42=C_mutate((C_word*)lf[46]+1,C_fix((C_word)S_ISGID));
t43=C_mutate((C_word*)lf[47]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1736,tmp=(C_word)a,a+=2,tmp));
t44=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=C_mutate((C_word*)lf[50]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1775,a[2]=t45,tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[54]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1813,tmp=(C_word)a,a+=2,tmp));
t48=*((C_word*)lf[56]+1);
t49=C_mutate((C_word*)lf[57]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1828,a[2]=t48,tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[61]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1870,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[64]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1909,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1941,tmp=(C_word)a,a+=2,tmp);
t53=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1943,tmp=(C_word)a,a+=2,tmp);
t54=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_1945,tmp=(C_word)a,a+=2,tmp);
t55=C_mutate((C_word*)lf[67]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1947,a[2]=t53,a[3]=t54,a[4]=t52,tmp=(C_word)a,a+=5,tmp));
t56=C_mutate((C_word*)lf[70]+1,C_fix((C_word)SEEK_SET));
t57=C_mutate((C_word*)lf[71]+1,C_fix((C_word)SEEK_END));
t58=C_mutate((C_word*)lf[72]+1,C_fix((C_word)SEEK_CUR));
t59=C_mutate(&lf[73],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2139,tmp=(C_word)a,a+=2,tmp));
t60=C_mutate((C_word*)lf[76]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2176,tmp=(C_word)a,a+=2,tmp));
t61=C_mutate((C_word*)lf[77]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2201,tmp=(C_word)a,a+=2,tmp));
t62=C_mutate((C_word*)lf[78]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2207,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[79]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2213,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[80]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2219,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[81]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2225,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[82]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2231,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[83]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2237,tmp=(C_word)a,a+=2,tmp));
t68=C_mutate((C_word*)lf[84]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2246,tmp=(C_word)a,a+=2,tmp));
t69=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2255,tmp=(C_word)a,a+=2,tmp));
t70=C_mutate((C_word*)lf[86]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2264,tmp=(C_word)a,a+=2,tmp));
t71=C_mutate((C_word*)lf[87]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2273,tmp=(C_word)a,a+=2,tmp));
t72=C_mutate((C_word*)lf[88]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2282,tmp=(C_word)a,a+=2,tmp));
t73=C_mutate((C_word*)lf[89]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2291,tmp=(C_word)a,a+=2,tmp));
t74=C_mutate((C_word*)lf[90]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2300,tmp=(C_word)a,a+=2,tmp));
t75=C_mutate((C_word*)lf[91]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2309,tmp=(C_word)a,a+=2,tmp));
t76=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2318,tmp=(C_word)a,a+=2,tmp));
t77=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2378,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t78=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7330,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 848  getter-with-setter */
t79=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t79+1)))(4,t79,t77,t78,*((C_word*)lf[92]+1));}

/* a7329 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7330(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7330,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7334,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7346,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 850  port? */
t5=*((C_word*)lf[96]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k7344 in a7329 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7346(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[94]);
t4=((C_word*)t0)[2];
f_7334(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_7334(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 855  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[59],lf[99],lf[470],((C_word*)t0)[3]);}}}

/* k7332 in a7329 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7334,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7337,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 857  posix-error */
t3=lf[3];
f_1674(6,t3,t2,lf[48],lf[99],lf[469],((C_word*)t0)[2]);}
else{
t3=t2;
f_7337(2,t3,C_SCHEME_UNDEFINED);}}

/* k7335 in k7332 in a7329 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2378(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word ab[150],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2378,2,t0,t1);}
t2=C_mutate((C_word*)lf[99]+1,t1);
t3=C_mutate((C_word*)lf[100]+1,lf[101]);
t4=C_mutate((C_word*)lf[102]+1,lf[103]);
t5=C_mutate((C_word*)lf[104]+1,lf[105]);
t6=C_mutate((C_word*)lf[106]+1,lf[107]);
t7=C_mutate((C_word*)lf[108]+1,lf[109]);
t8=C_mutate((C_word*)lf[110]+1,lf[111]);
t9=C_mutate((C_word*)lf[112]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2386,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[116]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2487,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[118]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2511,tmp=(C_word)a,a+=2,tmp));
t12=*((C_word*)lf[120]+1);
t13=*((C_word*)lf[56]+1);
t14=*((C_word*)lf[121]+1);
t15=C_mutate((C_word*)lf[122]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2535,a[2]=t13,a[3]=t12,tmp=(C_word)a,a+=4,tmp));
t16=C_mutate((C_word*)lf[126]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2689,tmp=(C_word)a,a+=2,tmp));
t17=*((C_word*)lf[56]+1);
t18=C_mutate((C_word*)lf[125]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2712,a[2]=t17,tmp=(C_word)a,a+=3,tmp));
t19=*((C_word*)lf[129]+1);
t20=*((C_word*)lf[130]+1);
t21=*((C_word*)lf[131]+1);
t22=*((C_word*)lf[132]+1);
t23=*((C_word*)lf[120]+1);
t24=*((C_word*)lf[2]+1);
t25=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2753,tmp=(C_word)a,a+=2,tmp);
t26=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2758,tmp=(C_word)a,a+=2,tmp);
t27=*((C_word*)lf[135]+1);
t28=*((C_word*)lf[136]+1);
t29=*((C_word*)lf[125]+1);
t30=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2769,a[2]=t29,tmp=(C_word)a,a+=3,tmp);
t31=C_mutate((C_word*)lf[115]+1,(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2825,a[2]=t22,a[3]=t20,a[4]=t27,a[5]=t28,a[6]=t30,a[7]=t21,a[8]=t19,a[9]=t23,a[10]=t25,a[11]=t24,a[12]=t26,tmp=(C_word)a,a+=13,tmp));
t32=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3142,tmp=(C_word)a,a+=2,tmp);
t33=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3154,tmp=(C_word)a,a+=2,tmp);
t34=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3160,tmp=(C_word)a,a+=2,tmp);
t35=C_mutate((C_word*)lf[162]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3175,a[2]=t33,a[3]=t34,a[4]=t32,tmp=(C_word)a,a+=5,tmp));
t36=C_mutate((C_word*)lf[164]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3211,a[2]=t33,a[3]=t34,a[4]=t32,tmp=(C_word)a,a+=5,tmp));
t37=C_mutate((C_word*)lf[165]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3247,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[169]+1,*((C_word*)lf[165]+1));
t39=*((C_word*)lf[162]+1);
t40=*((C_word*)lf[164]+1);
t41=*((C_word*)lf[165]+1);
t42=*((C_word*)lf[169]+1);
t43=C_mutate((C_word*)lf[170]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3263,a[2]=t39,a[3]=t41,tmp=(C_word)a,a+=4,tmp));
t44=C_mutate((C_word*)lf[171]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3287,a[2]=t40,a[3]=t42,tmp=(C_word)a,a+=4,tmp));
t45=C_mutate((C_word*)lf[172]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3311,a[2]=t39,a[3]=t41,tmp=(C_word)a,a+=4,tmp));
t46=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3331,a[2]=t40,a[3]=t42,tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[176]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3351,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[178]+1,C_fix((C_word)SIGTERM));
t49=C_mutate((C_word*)lf[179]+1,C_fix((C_word)SIGKILL));
t50=C_mutate((C_word*)lf[180]+1,C_fix((C_word)SIGINT));
t51=C_mutate((C_word*)lf[181]+1,C_fix((C_word)SIGHUP));
t52=C_mutate((C_word*)lf[182]+1,C_fix((C_word)SIGFPE));
t53=C_mutate((C_word*)lf[183]+1,C_fix((C_word)SIGILL));
t54=C_mutate((C_word*)lf[184]+1,C_fix((C_word)SIGSEGV));
t55=C_mutate((C_word*)lf[185]+1,C_fix((C_word)SIGABRT));
t56=C_mutate((C_word*)lf[186]+1,C_fix((C_word)SIGTRAP));
t57=C_mutate((C_word*)lf[187]+1,C_fix((C_word)SIGQUIT));
t58=C_mutate((C_word*)lf[188]+1,C_fix((C_word)SIGALRM));
t59=C_mutate((C_word*)lf[189]+1,C_fix((C_word)SIGVTALRM));
t60=C_mutate((C_word*)lf[190]+1,C_fix((C_word)SIGPROF));
t61=C_mutate((C_word*)lf[191]+1,C_fix((C_word)SIGIO));
t62=C_mutate((C_word*)lf[192]+1,C_fix((C_word)SIGURG));
t63=C_mutate((C_word*)lf[193]+1,C_fix((C_word)SIGCHLD));
t64=C_mutate((C_word*)lf[194]+1,C_fix((C_word)SIGCONT));
t65=C_mutate((C_word*)lf[195]+1,C_fix((C_word)SIGSTOP));
t66=C_mutate((C_word*)lf[196]+1,C_fix((C_word)SIGTSTP));
t67=C_mutate((C_word*)lf[197]+1,C_fix((C_word)SIGPIPE));
t68=C_mutate((C_word*)lf[198]+1,C_fix((C_word)SIGXCPU));
t69=C_mutate((C_word*)lf[199]+1,C_fix((C_word)SIGXFSZ));
t70=C_mutate((C_word*)lf[200]+1,C_fix((C_word)SIGUSR1));
t71=C_mutate((C_word*)lf[201]+1,C_fix((C_word)SIGUSR2));
t72=C_mutate((C_word*)lf[202]+1,C_fix((C_word)SIGWINCH));
t73=(C_word)C_a_i_list(&a,25,*((C_word*)lf[178]+1),*((C_word*)lf[179]+1),*((C_word*)lf[180]+1),*((C_word*)lf[181]+1),*((C_word*)lf[182]+1),*((C_word*)lf[183]+1),*((C_word*)lf[184]+1),*((C_word*)lf[185]+1),*((C_word*)lf[186]+1),*((C_word*)lf[187]+1),*((C_word*)lf[188]+1),*((C_word*)lf[189]+1),*((C_word*)lf[190]+1),*((C_word*)lf[191]+1),*((C_word*)lf[192]+1),*((C_word*)lf[193]+1),*((C_word*)lf[194]+1),*((C_word*)lf[195]+1),*((C_word*)lf[196]+1),*((C_word*)lf[197]+1),*((C_word*)lf[198]+1),*((C_word*)lf[199]+1),*((C_word*)lf[200]+1),*((C_word*)lf[201]+1),*((C_word*)lf[202]+1));
t74=C_mutate((C_word*)lf[203]+1,t73);
t75=*((C_word*)lf[204]+1);
t76=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3396,a[2]=((C_word*)t0)[2],a[3]=t75,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1181 make-vector */
t77=*((C_word*)lf[468]+1);
((C_proc4)(void*)(*((C_word*)t77+1)))(4,t77,t76,C_fix(256),C_SCHEME_FALSE);}

/* k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3396(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3396,2,t0,t1);}
t2=C_mutate((C_word*)lf[205]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3398,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[206]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3407,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[204]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3420,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[207]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3438,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3462,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[211]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3494,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3500,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3515,tmp=(C_word)a,a+=2,tmp));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3531,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7324,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1237 set-signal-handler! */
t12=*((C_word*)lf[206]+1);
((C_proc4)(void*)(*((C_word*)t12+1)))(4,t12,t10,*((C_word*)lf[180]+1),t11);}

/* a7323 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7324(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7324,3,t0,t1,t2);}
/* posixunix.scm: 1239 ##sys#user-interrupt-hook */
t3=*((C_word*)lf[467]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3531(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3531,2,t0,t1);}
t2=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3533,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[219]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3571,tmp=(C_word)a,a+=2,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3588,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7321,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1269 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,*((C_word*)lf[219]+1));}

/* a7320 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7321,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub438(C_SCHEME_UNDEFINED));}

/* k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3588,2,t0,t1);}
t2=C_mutate((C_word*)lf[221]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3592,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7303,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7306,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1274 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a7305 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7306(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7306,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_seteuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7316,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1278 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k7314 in a7305 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1279 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[465],lf[466],((C_word*)t0)[2]);}

/* a7302 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7303(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7303,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub440(C_SCHEME_UNDEFINED));}

/* k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3592(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3592,2,t0,t1);}
t2=C_mutate((C_word*)lf[222]+1,t1);
t3=C_mutate((C_word*)lf[223]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3594,tmp=(C_word)a,a+=2,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3611,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7300,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1289 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,*((C_word*)lf[223]+1));}

/* a7299 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7300(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7300,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub446(C_SCHEME_UNDEFINED));}

/* k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3611,2,t0,t1);}
t2=C_mutate((C_word*)lf[225]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3615,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7282,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7285,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1294 getter-with-setter */
t6=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t4,t5);}

/* a7284 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7285(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7285,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setegid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7295,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1298 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k7293 in a7284 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7295(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1299 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[463],lf[464],((C_word*)t0)[2]);}

/* a7281 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7282,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub448(C_SCHEME_UNDEFINED));}

/* k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3615(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word ab[40],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3615,2,t0,t1);}
t2=C_mutate((C_word*)lf[226]+1,t1);
t3=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3617,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[136]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3677,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate((C_word*)lf[230]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3691,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate((C_word*)lf[231]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3711,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate(&lf[232],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3786,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[233]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3789,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3852,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[240]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3918,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[242]+1,C_fix((C_word)EPERM));
t12=C_mutate((C_word*)lf[243]+1,C_fix((C_word)ENOENT));
t13=C_mutate((C_word*)lf[244]+1,C_fix((C_word)ESRCH));
t14=C_mutate((C_word*)lf[245]+1,C_fix((C_word)EINTR));
t15=C_mutate((C_word*)lf[246]+1,C_fix((C_word)EIO));
t16=C_mutate((C_word*)lf[247]+1,C_fix((C_word)ENOEXEC));
t17=C_mutate((C_word*)lf[248]+1,C_fix((C_word)EBADF));
t18=C_mutate((C_word*)lf[249]+1,C_fix((C_word)ECHILD));
t19=C_mutate((C_word*)lf[250]+1,C_fix((C_word)ENOMEM));
t20=C_mutate((C_word*)lf[251]+1,C_fix((C_word)EACCES));
t21=C_mutate((C_word*)lf[252]+1,C_fix((C_word)EFAULT));
t22=C_mutate((C_word*)lf[253]+1,C_fix((C_word)EBUSY));
t23=C_mutate((C_word*)lf[254]+1,C_fix((C_word)ENOTDIR));
t24=C_mutate((C_word*)lf[255]+1,C_fix((C_word)EISDIR));
t25=C_mutate((C_word*)lf[256]+1,C_fix((C_word)EINVAL));
t26=C_mutate((C_word*)lf[257]+1,C_fix((C_word)EMFILE));
t27=C_mutate((C_word*)lf[258]+1,C_fix((C_word)ENOSPC));
t28=C_mutate((C_word*)lf[259]+1,C_fix((C_word)ESPIPE));
t29=C_mutate((C_word*)lf[260]+1,C_fix((C_word)EPIPE));
t30=C_mutate((C_word*)lf[261]+1,C_fix((C_word)EAGAIN));
t31=C_mutate((C_word*)lf[262]+1,C_fix((C_word)EROFS));
t32=C_mutate((C_word*)lf[263]+1,C_fix((C_word)EEXIST));
t33=C_mutate((C_word*)lf[264]+1,C_fix((C_word)EWOULDBLOCK));
t34=C_set_block_item(lf[265],0,C_fix(0));
t35=C_set_block_item(lf[266],0,C_fix(0));
t36=C_set_block_item(lf[267],0,C_fix(0));
t37=C_set_block_item(lf[268],0,C_fix(0));
t38=C_set_block_item(lf[269],0,C_fix(0));
t39=C_set_block_item(lf[270],0,C_fix(0));
t40=C_set_block_item(lf[271],0,C_fix(0));
t41=C_set_block_item(lf[272],0,C_fix(0));
t42=C_set_block_item(lf[273],0,C_fix(0));
t43=C_set_block_item(lf[274],0,C_fix(0));
t44=C_set_block_item(lf[275],0,C_fix(0));
t45=C_set_block_item(lf[276],0,C_fix(0));
t46=C_set_block_item(lf[277],0,C_fix(0));
t47=C_set_block_item(lf[278],0,C_fix(0));
t48=C_set_block_item(lf[279],0,C_fix(0));
t49=C_set_block_item(lf[280],0,C_fix(0));
t50=C_mutate((C_word*)lf[281]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3982,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[283]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4009,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4039,tmp=(C_word)a,a+=2,tmp);
t53=C_mutate((C_word*)lf[285]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4063,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[286]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4069,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[287]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4075,a[2]=t52,tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4081,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[290]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4096,tmp=(C_word)a,a+=2,tmp));
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4119,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t59=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7264,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 1521 getter-with-setter */
t60=*((C_word*)lf[462]+1);
((C_proc4)(void*)(*((C_word*)t60+1)))(4,t60,t58,t59,*((C_word*)lf[290]+1));}

/* a7263 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7264(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7264,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[292]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7271,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7277,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1526 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_7271(2,t6,C_SCHEME_UNDEFINED);}}

/* k7275 in a7263 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1527 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[292],lf[461],((C_word*)t0)[2]);}

/* k7269 in a7263 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4119(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4119,2,t0,t1);}
t2=C_mutate((C_word*)lf[292]+1,t1);
t3=C_mutate((C_word*)lf[293]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4121,tmp=(C_word)a,a+=2,tmp));
t4=*((C_word*)lf[296]+1);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4158,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_u_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1548 make-string */
t7=*((C_word*)lf[56]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}

/* k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4158(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word ab[189],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4158,2,t0,t1);}
t2=C_mutate((C_word*)lf[297]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4159,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[299]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4201,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[302]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[303]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[304]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4226,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4263,tmp=(C_word)a,a+=2,tmp);
t9=C_mutate((C_word*)lf[313]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4278,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[314]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4292,a[2]=t7,a[3]=t8,tmp=(C_word)a,a+=4,tmp));
t11=C_mutate((C_word*)lf[315]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4306,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[321]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4351,tmp=(C_word)a,a+=2,tmp));
t13=*((C_word*)lf[323]+1);
t14=*((C_word*)lf[324]+1);
t15=C_mutate((C_word*)lf[325]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4378,a[2]=t13,a[3]=t14,tmp=(C_word)a,a+=4,tmp));
t16=*((C_word*)lf[338]+1);
t17=*((C_word*)lf[324]+1);
t18=C_mutate((C_word*)lf[339]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4849,a[2]=t16,a[3]=t17,tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[342]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5105,tmp=(C_word)a,a+=2,tmp));
t20=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5144,tmp=(C_word)a,a+=2,tmp);
t21=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5215,tmp=(C_word)a,a+=2,tmp);
t22=C_mutate((C_word*)lf[346]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5233,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t23=C_mutate((C_word*)lf[348]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5248,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t24=C_mutate((C_word*)lf[350]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5263,a[2]=t20,a[3]=t21,tmp=(C_word)a,a+=4,tmp));
t25=C_mutate((C_word*)lf[352]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5285,tmp=(C_word)a,a+=2,tmp));
t26=C_mutate((C_word*)lf[354]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5313,tmp=(C_word)a,a+=2,tmp));
t27=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5356,tmp=(C_word)a,a+=2,tmp));
t28=C_mutate((C_word*)lf[358]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5382,tmp=(C_word)a,a+=2,tmp));
t29=C_mutate((C_word*)lf[359]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5399,tmp=(C_word)a,a+=2,tmp));
t30=C_mutate((C_word*)lf[360]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5414,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[361]+1,C_fix((C_word)PROT_READ));
t32=C_mutate((C_word*)lf[362]+1,C_fix((C_word)PROT_WRITE));
t33=C_mutate((C_word*)lf[363]+1,C_fix((C_word)PROT_EXEC));
t34=C_mutate((C_word*)lf[364]+1,C_fix((C_word)PROT_NONE));
t35=C_mutate((C_word*)lf[365]+1,C_fix((C_word)MAP_FIXED));
t36=C_mutate((C_word*)lf[366]+1,C_fix((C_word)MAP_SHARED));
t37=C_mutate((C_word*)lf[367]+1,C_fix((C_word)MAP_PRIVATE));
t38=C_mutate((C_word*)lf[368]+1,C_fix((C_word)MAP_ANON));
t39=C_mutate((C_word*)lf[369]+1,C_fix((C_word)MAP_FILE));
t40=C_mutate((C_word*)lf[370]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5497,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[376]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5555,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[378]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5590,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[379]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5599,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[380]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5605,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[382]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5614,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[383]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5628,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[385]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5661,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[389]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5736,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[391]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5775,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[395]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5803,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[398]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5831,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[399]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5839,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[400]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5855,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[401]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5858,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[407]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5917,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate(&lf[408],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5936,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[410]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5963,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[411]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5982,tmp=(C_word)a,a+=2,tmp));
t59=C_mutate((C_word*)lf[416]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6017,tmp=(C_word)a,a+=2,tmp));
t60=*((C_word*)lf[418]+1);
t61=*((C_word*)lf[419]+1);
t62=*((C_word*)lf[420]+1);
t63=*((C_word*)lf[421]+1);
t64=*((C_word*)lf[122]+1);
t65=*((C_word*)lf[422]+1);
t66=*((C_word*)lf[423]+1);
t67=C_mutate((C_word*)lf[424]+1,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6029,a[2]=t63,a[3]=t61,a[4]=t60,a[5]=t64,a[6]=t62,a[7]=t65,a[8]=t66,tmp=(C_word)a,a+=9,tmp));
t68=C_mutate((C_word*)lf[427]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6141,tmp=(C_word)a,a+=2,tmp));
t69=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6179,tmp=(C_word)a,a+=2,tmp);
t70=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6187,tmp=(C_word)a,a+=2,tmp);
t71=*((C_word*)lf[429]+1);
t72=C_mutate((C_word*)lf[430]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6195,a[2]=t71,a[3]=t70,a[4]=t69,tmp=(C_word)a,a+=5,tmp));
t73=C_mutate((C_word*)lf[432]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6374,tmp=(C_word)a,a+=2,tmp));
t74=C_mutate((C_word*)lf[433]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6391,tmp=(C_word)a,a+=2,tmp));
t75=C_mutate((C_word*)lf[435]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6466,tmp=(C_word)a,a+=2,tmp));
t76=C_mutate((C_word*)lf[436]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6469,tmp=(C_word)a,a+=2,tmp));
t77=C_mutate((C_word*)lf[437]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6472,tmp=(C_word)a,a+=2,tmp));
t78=C_mutate((C_word*)lf[438]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6475,tmp=(C_word)a,a+=2,tmp));
t79=C_mutate((C_word*)lf[440]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6502,tmp=(C_word)a,a+=2,tmp));
t80=C_mutate((C_word*)lf[443]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6511,tmp=(C_word)a,a+=2,tmp));
t81=*((C_word*)lf[427]+1);
t82=*((C_word*)lf[430]+1);
t83=*((C_word*)lf[135]+1);
t84=C_mutate((C_word*)lf[445]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6517,a[2]=t81,a[3]=t82,tmp=(C_word)a,a+=4,tmp));
t85=*((C_word*)lf[176]+1);
t86=*((C_word*)lf[433]+1);
t87=*((C_word*)lf[427]+1);
t88=*((C_word*)lf[430]+1);
t89=*((C_word*)lf[321]+1);
t90=*((C_word*)lf[54]+1);
t91=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6573,a[2]=t86,tmp=(C_word)a,a+=3,tmp);
t92=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6610,a[2]=t85,tmp=(C_word)a,a+=3,tmp);
t93=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6630,a[2]=t90,tmp=(C_word)a,a+=3,tmp);
t94=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6644,a[2]=t90,tmp=(C_word)a,a+=3,tmp);
t95=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6661,tmp=(C_word)a,a+=2,tmp);
t96=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6677,a[2]=t92,a[3]=t87,a[4]=t94,a[5]=t88,a[6]=t95,tmp=(C_word)a,a+=7,tmp);
t97=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6722,a[2]=t93,tmp=(C_word)a,a+=3,tmp);
t98=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6733,a[2]=t93,tmp=(C_word)a,a+=3,tmp);
t99=C_mutate((C_word*)lf[447]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6744,a[2]=t98,a[3]=t91,a[4]=t97,a[5]=t96,tmp=(C_word)a,a+=6,tmp));
t100=*((C_word*)lf[448]+1);
t101=C_mutate((C_word*)lf[449]+1,t100);
t102=*((C_word*)lf[448]+1);
t103=C_mutate((C_word*)lf[450]+1,t102);
t104=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6808,tmp=(C_word)a,a+=2,tmp);
t105=C_mutate((C_word*)lf[449]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6869,a[2]=t104,tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[450]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6926,a[2]=t104,tmp=(C_word)a,a+=3,tmp));
t107=*((C_word*)lf[424]+1);
t108=*((C_word*)lf[420]+1);
t109=*((C_word*)lf[422]+1);
t110=*((C_word*)lf[126]+1);
t111=C_mutate((C_word*)lf[451]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6983,a[2]=t110,a[3]=t109,a[4]=t107,a[5]=t108,tmp=(C_word)a,a+=6,tmp));
t112=C_mutate((C_word*)lf[459]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7241,tmp=(C_word)a,a+=2,tmp));
t113=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t113+1)))(2,t113,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7241(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7241,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[459]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7237,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
/* ##sys#make-c-string */
t6=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t4);}
else{
t6=t5;
f_7237(2,t6,C_SCHEME_FALSE);}}

/* k7235 in set-root-directory! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7237(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub1393(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 2401 posix-error */
t3=lf[3];
f_1674(6,t3,((C_word*)t0)[3],lf[48],lf[459],lf[460],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6983(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_6983r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_6983r(t0,t1,t2,t3,t4);}}

static void C_ccall f_6983r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6985,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7156,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7161,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7166,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action13461382 */
t9=t8;
f_7166(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id13471380 */
t11=t7;
f_7161(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit13481377 */
t13=t6;
f_7156(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body13441350 */
t15=t5;
f_6985(t15,t1,t9,t11,t13);}}}}

/* def-action1346 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_7166(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7166,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7172,tmp=(C_word)a,a+=2,tmp);
/* def-id13471380 */
t3=((C_word*)t0)[2];
f_7161(t3,t1,t2);}

/* a7171 in def-action1346 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7172(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_7172,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id1347 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_7161(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7161,NULL,3,t0,t1,t2);}
/* def-limit13481377 */
t3=((C_word*)t0)[2];
f_7156(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit1348 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_7156(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7156,NULL,4,t0,t1,t2,t3);}
/* body13441350 */
t4=((C_word*)t0)[2];
f_6985(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6985(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6985,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[451]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6992,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=t2,a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_6992(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7151,a[2]=t4,a[3]=t7,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t10=t8;
f_6992(t10,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_7143,tmp=(C_word)a,a+=2,tmp));}}

/* f_7143 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7143(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7143,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_7151 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7151(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7151,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6992(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6992,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7131,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[10],tmp=(C_word)a,a+=13,tmp);
if(C_truep(t2)){
t4=t3;
f_7131(2,t4,t2);}
else{
/* posixunix.scm: 2373 regexp? */
t4=*((C_word*)lf[458]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[11]);}}

/* k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7131(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7131,2,t0,t1);}
t2=(C_truep(t1)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7132,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[12],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7002,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t2,a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7125,a[2]=t3,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2376 make-pathname */
t5=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[2],lf[457]);}

/* k7123 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7125(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2376 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7002(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7002,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_7004,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_7004(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_7004(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_7004,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7023,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2382 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7023,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7105,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2383 pathname-file */
t3=*((C_word*)lf[456]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7111,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2390 pproc */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}}

/* k7109 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7111(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7111,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7118,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2390 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2391 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_7004(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k7116 in k7109 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2390 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7004(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7105(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7105,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[452]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[453]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 2383 loop */
t2=((C_word*)((C_word*)t0)[12])[1];
f_7004(t2,((C_word*)t0)[11],((C_word*)t0)[10],((C_word*)t0)[9]);}
else{
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7038,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=((C_word*)t0)[8],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm: 2384 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[6]);}}

/* k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[39],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7038,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[11])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7048,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7050,a[2]=t4,a[3]=((C_word*)t0)[11],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7058,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[10],tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7082,a[2]=t6,a[3]=((C_word*)t0)[11],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2386 ##sys#dynamic-wind */
t11=*((C_word*)lf[455]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7095,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7098,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2389 pproc */
t4=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[6]);}}

/* k7096 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7098(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2389 action */
t2=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_7095(2,t2,((C_word*)t0)[2]);}}

/* k7093 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7095(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2389 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7004(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a7081 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7082(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7082,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[448]+1));}

/* a7057 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7058,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7066,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7080,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2387 make-pathname */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[6],lf[454]);}

/* k7078 in a7057 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k7064 in a7057 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7066,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7070,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7073,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2388 pproc */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k7071 in k7064 in a7057 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2388 action */
t2=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
f_7070(2,t2,((C_word*)t0)[2]);}}

/* k7068 in k7064 in a7057 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2387 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7004(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a7049 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_7050,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[448]+1));}

/* k7046 in k7036 in k7103 in k7021 in loop in k7000 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7048(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2385 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_7004(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_7132 in k7129 in k6990 in body1344 in find-files in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_7132(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_7132,3,t0,t1,t2);}
/* posixunix.scm: 2374 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6926(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_6926r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6926r(t0,t1,t2,t3);}}

static void C_ccall f_6926r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6928,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6933,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6938,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args13201328 */
t7=t6;
f_6938(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env13211326 */
t9=t5;
f_6933(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body13181323 */
t11=t4;
f_6928(t11,t1,t7,t9);}}}

/* def-args1320 in process* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6938(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6938,NULL,2,t0,t1);}
/* def-env13211326 */
t2=((C_word*)t0)[2];
f_6933(t2,t1,C_SCHEME_FALSE);}

/* def-env1321 in process* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6933(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6933,NULL,3,t0,t1,t2);}
/* body13181323 */
t3=((C_word*)t0)[2];
f_6928(t3,t1,t2,C_SCHEME_FALSE);}

/* body1318 in process* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6928(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6928,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2351 %process */
f_6808(t1,lf[450],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3);}

/* process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6869(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr3r,(void*)f_6869r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6869r(t0,t1,t2,t3);}}

static void C_ccall f_6869r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6871,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6876,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6881,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args13001308 */
t7=t6;
f_6881(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env13011306 */
t9=t5;
f_6876(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body12981303 */
t11=t4;
f_6871(t11,t1,t7,t9);}}}

/* def-args1300 in process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6881(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6881,NULL,2,t0,t1);}
/* def-env13011306 */
t2=((C_word*)t0)[2];
f_6876(t2,t1,C_SCHEME_FALSE);}

/* def-env1301 in process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6876(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6876,NULL,3,t0,t1,t2);}
/* body12981303 */
t3=((C_word*)t0)[2];
f_6871(t3,t1,t2,C_SCHEME_FALSE);}

/* body1298 in process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6871(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6871,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2348 %process */
f_6808(t1,lf[449],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3);}

/* %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6808(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6808,NULL,6,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6810,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t10=(C_word)C_i_check_string_2(((C_word*)t7)[1],t2);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6829,a[2]=t9,a[3]=t1,a[4]=t3,a[5]=t6,a[6]=t8,a[7]=t7,a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
/* posixunix.scm: 2337 chkstrlst */
t12=t9;
f_6810(t12,t11,((C_word*)t8)[1]);}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6863,a[2]=t11,a[3]=t7,a[4]=t8,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2339 ##sys#shell-command-arguments */
t13=*((C_word*)lf[443]+1);
((C_proc3)(void*)(*((C_word*)t13+1)))(3,t13,t12,((C_word*)t7)[1]);}}

/* k6861 in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6863(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6863,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6867,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2340 ##sys#shell-command */
t4=*((C_word*)lf[440]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k6865 in k6861 in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6867(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_6829(2,t3,t2);}

/* k6827 in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6829,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6832,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2341 chkstrlst */
t3=((C_word*)t0)[2];
f_6810(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;
f_6832(2,t3,C_SCHEME_UNDEFINED);}}

/* k6830 in k6827 in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6832,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6837,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6843,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2342 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a6842 in k6830 in k6827 in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6843(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6843,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 2344 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixunix.scm: 2345 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a6836 in k6830 in k6827 in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6837(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6837,2,t0,t1);}
/* posixunix.scm: 2342 ##sys#process */
t2=*((C_word*)lf[447]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[3],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[2]);}

/* chkstrlst in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6810(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6810,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6819,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t5=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a6818 in chkstrlst in %process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6819(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6819,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6744(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_6744,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6750,a[2]=t8,a[3]=t7,a[4]=t6,a[5]=t5,a[6]=t4,a[7]=t3,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6756,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=t6,a[9]=t7,tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t9,t10);}

/* a6755 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6756(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_6756,6,t0,t1,t2,t3,t4,t5);}
t6=(C_word)C_i_not(((C_word*)t0)[9]);
t7=(C_word)C_i_not(((C_word*)t0)[8]);
t8=(C_word)C_i_not(((C_word*)t0)[7]);
t9=(C_word)C_a_i_vector(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_6767,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t9,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=t5,a[13]=t1,tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6787,a[2]=((C_word*)t0)[9],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t10,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2318 make-on-close */
t12=((C_word*)t0)[3];
f_6573(t12,t11,((C_word*)t0)[5],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k6785 in a6755 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2317 input-port */
t2=((C_word*)t0)[7];
f_6722(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6765 in a6755 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6767(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6767,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6771,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[12],a[10]=t1,a[11]=((C_word*)t0)[13],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6783,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],a[6]=t2,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2320 make-on-close */
t4=((C_word*)t0)[6];
f_6573(t4,t3,((C_word*)t0)[10],((C_word*)t0)[12],((C_word*)t0)[5],C_fix(1),C_fix(0),C_fix(2));}

/* k6781 in k6765 in a6755 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2319 output-port */
t2=((C_word*)t0)[7];
f_6733(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6769 in k6765 in a6755 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6771,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6775,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6779,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2323 make-on-close */
t4=((C_word*)t0)[3];
f_6573(t4,t3,((C_word*)t0)[7],((C_word*)t0)[9],((C_word*)t0)[2],C_fix(2),C_fix(0),C_fix(1));}

/* k6777 in k6769 in k6765 in a6755 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2322 input-port */
t2=((C_word*)t0)[7];
f_6722(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6773 in k6769 in k6765 in a6755 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2316 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a6749 in ##sys#process in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6750(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6750,2,t0,t1);}
/* posixunix.scm: 2311 spawn */
t2=((C_word*)t0)[8];
f_6677(t2,t1,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6733(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6733,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6737,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2307 connect-parent */
t8=((C_word*)t0)[2];
f_6630(t8,t7,t4,t5);}

/* k6735 in output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2308 ##sys#custom-output-port */
t2=*((C_word*)lf[339]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(0),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6722(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6722,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6726,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2303 connect-parent */
t8=((C_word*)t0)[2];
f_6630(t8,t7,t4,t5);}

/* k6724 in input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6726(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2304 ##sys#custom-input-port */
t2=*((C_word*)lf[325]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_SCHEME_TRUE,C_fix(256),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6677(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6677,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_6681,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t6,a[5]=t5,a[6]=t7,a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=t3,a[10]=t2,a[11]=((C_word*)t0)[5],a[12]=t1,a[13]=((C_word*)t0)[6],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2290 needed-pipe */
t9=((C_word*)t0)[2];
f_6610(t9,t8,t6);}

/* k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6681,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_6684,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t1,a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2291 needed-pipe */
t3=((C_word*)t0)[2];
f_6610(t3,t2,((C_word*)t0)[5]);}

/* k6682 in k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6684(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6684,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_6687,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,a[14]=((C_word*)t0)[14],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2292 needed-pipe */
t3=((C_word*)t0)[2];
f_6610(t3,t2,((C_word*)t0)[6]);}

/* k6685 in k6682 in k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6687,2,t0,t1);}
t2=f_6661(C_a_i(&a,3),((C_word*)t0)[13]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6698,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[12],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_6700,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[13],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,a[9]=((C_word*)t0)[14],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2295 process-fork */
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* a6699 in k6685 in k6682 in k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6700,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_6704,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=t1,a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2297 connect-child */
t3=((C_word*)t0)[7];
f_6644(t3,t2,((C_word*)t0)[3],((C_word*)t0)[2],*((C_word*)lf[302]+1));}

/* k6702 in a6699 in k6685 in k6682 in k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6704,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6707,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=f_6661(C_a_i(&a,3),((C_word*)t0)[3]);
/* posixunix.scm: 2298 connect-child */
t4=((C_word*)t0)[5];
f_6644(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[303]+1));}

/* k6705 in k6702 in a6699 in k6685 in k6682 in k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6707(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6707,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6710,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],tmp=(C_word)a,a+=7,tmp);
t3=f_6661(C_a_i(&a,3),((C_word*)t0)[4]);
/* posixunix.scm: 2299 connect-child */
t4=((C_word*)t0)[3];
f_6644(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[304]+1));}

/* k6708 in k6705 in k6702 in a6699 in k6685 in k6682 in k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2300 process-execute */
t2=((C_word*)t0)[6];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k6696 in k6685 in k6682 in k6679 in spawn in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2293 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* swapped-ends in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_6661(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(1));
t3=(C_word)C_u_i_car(t1);
return((C_word)C_a_i_cons(&a,2,t2,t3));}
else{
return(C_SCHEME_FALSE);}}

/* connect-child in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6644(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6644,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=(C_word)C_u_i_car(t2);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6657,a[2]=t5,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2281 file-close */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* k6655 in connect-child in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6657(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6657,2,t0,t1);}
t2=((C_word*)t0)[4];
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6569,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2255 duplicate-fileno */
t6=*((C_word*)lf[321]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t3);}}

/* k6567 in k6655 in connect-child in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2256 file-close */
t2=*((C_word*)lf[54]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* connect-parent in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6630(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6630,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6643,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2275 file-close */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k6641 in connect-parent in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6643(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* needed-pipe in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6610(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6610,NULL,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6619,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6625,tmp=(C_word)a,a+=2,tmp);
/* posixunix.scm: 2270 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* a6624 in needed-pipe in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6625(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6625,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* a6618 in needed-pipe in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6619,2,t0,t1);}
/* posixunix.scm: 2270 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* make-on-close in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6573(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6573,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6575,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t6,a[7]=t5,a[8]=t4,tmp=(C_word)a,a+=9,tmp));}

/* f_6575 in make-on-close in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6575,2,t0,t1);}
t2=(C_word)C_i_set_i_slot(((C_word*)t0)[8],((C_word*)t0)[7],C_SCHEME_TRUE);
t3=(C_word)C_slot(((C_word*)t0)[8],((C_word*)t0)[6]);
t4=(C_truep(t3)?(C_word)C_slot(((C_word*)t0)[8],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6590,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6596,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2263 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t5,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* a6595 */
static void C_ccall f_6596(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6596,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2265 ##sys#signal-hook */
t5=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[208],((C_word*)t0)[3],lf[446],((C_word*)t0)[2],t4);}}

/* a6589 */
static void C_ccall f_6590(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6590,2,t0,t1);}
/* posixunix.scm: 2263 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6517(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6517r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6517r(t0,t1,t2,t3);}}

static void C_ccall f_6517r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6524,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2219 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k6522 in process-run in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6524(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6524,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 2221 process-execute */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6543,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2223 ##sys#shell-command */
t4=*((C_word*)lf[440]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k6541 in k6522 in process-run in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6543(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6543,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6547,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2223 ##sys#shell-command-arguments */
t3=*((C_word*)lf[443]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k6545 in k6541 in k6522 in process-run in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2223 process-execute */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6511(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6511,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[444],t2));}

/* ##sys#shell-command in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6502(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6502,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6506,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2208 getenv */
t3=*((C_word*)lf[135]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[442]);}

/* k6504 in ##sys#shell-command in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6506(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_truep(t1)?t1:lf[441]));}

/* process-signal in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6475(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_6475r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_6475r(t0,t1,t2,t3);}}

static void C_ccall f_6475r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[438]);
t7=(C_word)C_i_check_exact_2(t5,lf[438]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm: 2205 posix-error */
t10=lf[3];
f_1674(7,t10,t1,lf[208],lf[438],lf[439],t2,t5);}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6472(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6472,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub1166(C_SCHEME_UNDEFINED,t2));}

/* parent-process-id in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6469(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6469,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1163(C_SCHEME_UNDEFINED));}

/* current-process-id in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6466,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1161(C_SCHEME_UNDEFINED));}

/* process-wait in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6391(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr2r,(void*)f_6391r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6391r(t0,t1,t2);}}

static void C_ccall f_6391r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(7);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_u_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t2,C_fix(1)));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_u_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t6,C_fix(1)));
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_word)C_i_check_exact_2(t11,lf[433]);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6418,a[2]=t8,a[3]=t11,tmp=(C_word)a,a+=4,tmp);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6424,a[2]=t11,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2189 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t13,t14);}

/* a6423 in process-wait in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6424(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6424,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm: 2191 posix-error */
t6=lf[3];
f_1674(6,t6,t1,lf[208],lf[433],lf[434],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2192 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a6417 in process-wait in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6418(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6418,2,t0,t1);}
/* posixunix.scm: 2189 ##sys#process-wait */
t2=*((C_word*)lf[432]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6374(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6374,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=(C_word)C_waitpid(t2,t4);
t6=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=(C_truep(t6)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 2176 values */
C_values(5,0,t1,t5,t6,t7);}

/* process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6195(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_6195r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_6195r(t0,t1,t2,t3);}}

static void C_ccall f_6195r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6197,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6324,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6329,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist11011136 */
t7=t6;
f_6329(t7,t1);}
else{
t7=(C_word)C_u_i_car(t3);
t8=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist11021134 */
t9=t5;
f_6324(t9,t1,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
/* body10991104 */
t11=t4;
f_6197(t11,t1,t7,t9);}}}

/* def-arglist1101 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6329(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6329,NULL,2,t0,t1);}
/* def-envlist11021134 */
t2=((C_word*)t0)[2];
f_6324(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist1102 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6324(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6324,NULL,3,t0,t1,t2);}
/* body10991104 */
t3=((C_word*)t0)[2];
f_6197(t3,t1,t2,C_SCHEME_FALSE);}

/* body1099 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6197(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6197,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[430]);
t5=(C_word)C_i_check_list_2(t2,lf[430]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6207,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2144 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[5]);}

/* k6205 in body1099 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6207(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6207,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_6179(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6215,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_6215(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do1108 in k6205 in body1099 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6215(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_6215,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_6179(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6228,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(C_word)C_i_check_list_2(((C_word*)t0)[5],lf[430]);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6261,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t8=t5;
f_6228(t8,f_6261(t7,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_6228(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[430]);
t6=(C_word)C_block_size(t4);
t7=f_6179(t3,t4,t6);
t8=(C_word)C_slot(t2,C_fix(1));
t9=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t15=t1;
t16=t8;
t17=t9;
t1=t15;
t2=t16;
t3=t17;
goto loop;}}

/* do1112 in do1108 in k6205 in body1099 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_6261(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
if(C_truep((C_word)C_i_nullp(t1))){
return(f_6187(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_u_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[430]);
t5=(C_word)C_block_size(t3);
t6=f_6187(t2,t3,t5);
t7=(C_word)C_slot(t1,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k6226 in do1108 in k6205 in body1099 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6228(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6228,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6231,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6253,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 2158 ##sys#expand-home-path */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k6251 in k6226 in do1108 in k6205 in body1099 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2158 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k6229 in k6226 in do1108 in k6205 in body1099 in process-execute in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6231(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub1080(C_SCHEME_UNDEFINED);
t5=(C_word)stub1092(C_SCHEME_UNDEFINED);
/* posixunix.scm: 2165 posix-error */
t6=lf[3];
f_1674(6,t6,((C_word*)t0)[3],lf[208],lf[430],lf[431],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_6187(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub1085(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* setarg in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_6179(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub1073(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* process-fork in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6141(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_6141r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_6141r(t0,t1,t2);}}

static void C_ccall f_6141r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub1056(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 2129 posix-error */
t5=lf[3];
f_1674(5,t5,t1,lf[208],lf[427],lf[428]);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6163,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_slot(t2,C_fix(0));
t9=t8;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k6161 in process-fork in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6163,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6167,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_6167 in k6161 in process-fork in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6167(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6167,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub1061(C_SCHEME_UNDEFINED,t2));}

/* glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6029(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_6029r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_6029r(t0,t1,t2);}}

static void C_ccall f_6029r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(12);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6035,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp));
t6=((C_word*)t4)[1];
f_6035(t6,t1,t2);}

/* conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6035(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6035,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6050,a[2]=t3,a[3]=((C_word*)t0)[9],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6056,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,tmp=(C_word)a,a+=10,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6056(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_6056,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6060,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6133,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[426]);
/* posixunix.scm: 2113 make-pathname */
t8=((C_word*)t0)[7];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k6131 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6133(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2113 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6060,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6063,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 2114 make-anchored-pattern */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k6061 in k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6063,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6066,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 2115 regexp */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k6064 in k6061 in k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6066(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6066,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6073,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[425]);
/* posixunix.scm: 2116 directory */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k6071 in k6064 in k6061 in k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6073,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6075,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_6075(t5,((C_word*)t0)[2],t1);}

/* loop in k6071 in k6064 in k6061 in k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_6075(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6075,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[8],C_fix(1));
/* posixunix.scm: 2117 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_6035(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6092,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posixunix.scm: 2118 string-match */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k6090 in loop in k6071 in k6064 in k6061 in k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6092,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6102,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posixunix.scm: 2119 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posixunix.scm: 2120 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_6075(t3,((C_word*)t0)[6],t2);}}

/* k6100 in k6090 in loop in k6071 in k6064 in k6061 in k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6102(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6102,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6106,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 2119 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_6075(t4,t2,t3);}

/* k6104 in k6100 in k6090 in loop in k6071 in k6064 in k6061 in k6058 in a6055 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6106(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6106,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a6049 in conc-loop in glob in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6050,2,t0,t1);}
/* posixunix.scm: 2112 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6017(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6017,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6021,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub1016(t3),C_fix(0));}

/* k6019 in get-host-name in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6021(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6021,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6024,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_6024(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2093 posix-error */
t3=lf[3];
f_1674(5,t3,t2,lf[412],lf[416],lf[417]);}}

/* k6022 in k6019 in get-host-name in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6024(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-size in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5982(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5982,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5986,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2074 ##sys#terminal-check */
f_5936(t3,lf[411],t2);}

/* k5984 in terminal-size in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5986,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6006,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#make-locative */
t5=*((C_word*)lf[414]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t4,t2,C_fix(0),C_SCHEME_FALSE,lf[415]);}

/* k6004 in k5984 in terminal-size in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6006(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6006,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6010,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[414]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],C_fix(0),C_SCHEME_FALSE,lf[415]);}

/* k6008 in k6004 in k5984 in terminal-size in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_6010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
t2=(C_word)C_C_fileno(((C_word*)t0)[6]);
t3=((C_word*)t0)[5];
t4=(C_word)C_i_foreign_pointer_argumentp(t3);
t5=(C_word)C_i_foreign_pointer_argumentp(t1);
t6=(C_word)stub1002(C_SCHEME_UNDEFINED,t2,t4,t5);
t7=(C_word)C_eqp(C_fix(0),t6);
if(C_truep(t7)){
/* posixunix.scm: 2081 values */
C_values(4,0,((C_word*)t0)[4],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[3]))),C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
/* posixunix.scm: 2082 posix-error */
t8=lf[3];
f_1674(6,t8,((C_word*)t0)[4],lf[412],lf[411],lf[413],((C_word*)t0)[6]);}}

/* terminal-name in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5963(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5963,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5967,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2066 ##sys#terminal-check */
f_5936(t3,lf[410],t2);}

/* k5965 in terminal-name in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5967(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5967,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub992(t4,t3),C_fix(0));}

/* ##sys#terminal-check in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5936(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5936,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5940,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2058 ##sys#check-port */
t5=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,t3,t2);}

/* k5938 in ##sys#terminal-check in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5940(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(7));
t3=(C_word)C_eqp(lf[94],t2);
t4=(C_truep(t3)?(C_word)C_tty_portp(((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 2061 ##sys#error */
t5=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[3],((C_word*)t0)[2],lf[409],((C_word*)t0)[4]);}}

/* terminal-port? in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5917(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5917,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5921,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2053 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[407]);}

/* k5919 in terminal-port? in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5921,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5924,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2054 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[320]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k5922 in k5919 in terminal-port? in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5924(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),t1);
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5858(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_5858r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_5858r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5858r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5862,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2038 ##sys#check-port */
t6=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[401]);}

/* k5860 in set-buffering-mode! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5862(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5862,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5868,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[403]);
if(C_truep(t6)){
t7=t5;
f_5868(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[404]);
if(C_truep(t7)){
t8=t5;
f_5868(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[405]);
if(C_truep(t8)){
t9=t5;
f_5868(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 2044 ##sys#error */
t9=*((C_word*)lf[156]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[401],lf[406],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k5866 in k5860 in set-buffering-mode! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5868(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[401]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[94],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm: 2050 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[401],lf[402],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5855(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5855,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub972(C_SCHEME_UNDEFINED,t2));}

/* _exit in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5839(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_5839r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_5839r(t0,t1,t2);}}

static void C_ccall f_5839r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_slot(t2,C_fix(0)):C_fix(0));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub967(C_SCHEME_UNDEFINED,t4));}

/* local-timezone-abbreviation in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5831,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub962(t2),C_fix(0));}

/* utc-time->seconds in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5803(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5803,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[395]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5810,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 2006 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[395],lf[397],t2);}
else{
t6=t4;
f_5810(2,t6,C_SCHEME_UNDEFINED);}}

/* k5808 in utc-time->seconds in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5810(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 2008 ##sys#cons-flonum */
t2=*((C_word*)lf[392]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2009 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[395],lf[396],((C_word*)t0)[3]);}}

/* local-time->seconds in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5775(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5775,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[391]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5782,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1999 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[391],lf[394],t2);}
else{
t6=t4;
f_5782(2,t6,C_SCHEME_UNDEFINED);}}

/* k5780 in local-time->seconds in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5782(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 2001 ##sys#cons-flonum */
t2=*((C_word*)lf[392]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2002 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[391],lf[393],((C_word*)t0)[3]);}}

/* string->time in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5736(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5736r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5736r(t0,t1,t2,t3);}}

static void C_ccall f_5736r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(4);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?lf[390]:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[389]);
t7=(C_word)C_i_check_string_2(t5,lf[389]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5753,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1995 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}

/* k5751 in string->time in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5753(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5753,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5757,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1995 ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k5755 in k5751 in string->time in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5757(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5757,2,t0,t1);}
t2=(C_word)C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[2];
t5=t3;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub943(C_SCHEME_UNDEFINED,t4,t1,t2));}

/* time->string in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5661(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5661r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5661r(t0,t1,t2,t3);}}

static void C_ccall f_5661r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(5);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_vector_2(t2,lf[385]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5671,a[2]=t2,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(10)))){
/* posixunix.scm: 1979 ##sys#error */
t9=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t7,lf[385],lf[388],t2);}
else{
t9=t7;
f_5671(2,t9,C_SCHEME_UNDEFINED);}}

/* k5669 in time->string in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5671(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5671,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[385]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5680,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5690,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1983 ##sys#make-c-string */
t5=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5693,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub916(t4,t3),C_fix(0));}}

/* k5691 in k5669 in time->string in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5693(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1987 ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1988 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[385],lf[387],((C_word*)t0)[2]);}}

/* k5688 in k5669 in time->string in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5690,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub922(t3,t2,t1),C_fix(0));}

/* k5678 in k5669 in time->string in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5680(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixunix.scm: 1984 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[385],lf[386],((C_word*)t0)[2]);}}

/* seconds->string in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5628(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5628,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5632,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub907(t5,t4),C_fix(0));}

/* k5630 in seconds->string in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5632(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixunix.scm: 1971 ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixunix.scm: 1972 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[383],lf[384],((C_word*)t0)[2]);}}

/* seconds->utc-time in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5614(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5614,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[382]);
/* posixunix.scm: 1964 ##sys#decode-seconds */
t4=*((C_word*)lf[381]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5605(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5605,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[380]);
/* posixunix.scm: 1960 ##sys#decode-seconds */
t4=*((C_word*)lf[381]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5599(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5599,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[371]));}

/* memory-mapped-file-pointer in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5590(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5590,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[371],lf[378]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5555(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5555r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5555r(t0,t1,t2,t3);}}

static void C_ccall f_5555r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=(C_word)C_i_check_structure_2(t2,lf[371],lf[376]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_slot(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)stub888(C_SCHEME_UNDEFINED,t8,t6);
t10=(C_word)C_eqp(C_fix(0),t9);
if(C_truep(t10)){
t11=t1;
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1947 posix-error */
t11=lf[3];
f_1674(7,t11,t1,lf[48],lf[376],lf[377],t2,t6);}}

/* map-file-to-memory in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5497(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_5497r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_5497r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_5497r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5501,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_5501(2,t10,t2);}
else{
/* posixunix.scm: 1932 ##sys#null-pointer */
t10=*((C_word*)lf[375]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k5499 in map-file-to-memory in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5501,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5507,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_5507(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1935 ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[59],lf[370],lf[374],t1);}}

/* k5505 in k5499 in map-file-to-memory in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5507,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)stub863(t7,t8,t3,t4,t5,t6,((C_word*)t0)[3]);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5513,a[2]=((C_word*)t0)[7],a[3]=t9,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5526,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t10,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1937 ##sys#pointer->address */
t12=*((C_word*)lf[373]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t9);}

/* k5524 in k5505 in k5499 in map-file-to-memory in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1938 posix-error */
t3=lf[3];
f_1674(11,t3,((C_word*)t0)[8],lf[48],lf[370],lf[372],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[8];
f_5513(2,t3,C_SCHEME_UNDEFINED);}}

/* k5511 in k5505 in k5499 in map-file-to-memory in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5513,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[371],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5414(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5414,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5420,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_5420(t5,t1,C_fix(0));}

/* loop in current-environment in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5420(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5420,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5424,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub845(t5,t4),C_fix(0));}

/* k5422 in loop in current-environment in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5424(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5424,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5432,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_5432(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k5422 in loop in current-environment in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5432(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5432,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5458,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1899 ##sys#substring */
t5=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1902 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k5456 in scan in k5422 in loop in current-environment in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5458(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5458,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5462,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1900 ##sys#substring */
t5=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k5460 in k5456 in scan in k5422 in loop in current-environment in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5462,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5450,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1901 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_5420(t5,t3,t4);}

/* k5448 in k5460 in k5456 in scan in k5422 in loop in current-environment in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5450,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5399(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5399,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[359]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5407,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1888 ##sys#make-c-string */
t5=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k5405 in unsetenv in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5407(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5382(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5382,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[358]);
t5=(C_word)C_i_check_string_2(t3,lf[358]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5393,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t7=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k5391 in setenv in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5393,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5397,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1883 ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k5395 in k5391 in setenv in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5356(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5356,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[356]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5363,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5380,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1872 ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k5378 in fifo? in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5380(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1872 ##sys#file-info */
t2=*((C_word*)lf[127]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5361 in fifo? in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1875 posix-error */
t2=lf[3];
f_1674(6,t2,((C_word*)t0)[3],lf[48],lf[356],lf[357],((C_word*)t0)[2]);}}

/* create-fifo in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5313(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5313r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5313r(t0,t1,t2,t3);}}

static void C_ccall f_5313r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[354]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5320,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_5320(t6,(C_word)C_slot(t3,C_fix(0)));}
else{
t6=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_5320(t7,(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k5318 in create-fifo in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5320(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5320,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[354]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5337,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5341,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1866 ##sys#expand-home-path */
t5=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}

/* k5339 in k5318 in create-fifo in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1866 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5335 in k5318 in create-fifo in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1867 posix-error */
t3=lf[3];
f_1674(7,t3,((C_word*)t0)[3],lf[48],lf[354],lf[355],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5285(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5285,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[345],lf[352]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm: 1856 posix-error */
t9=lf[3];
f_1674(6,t9,t1,lf[48],lf[352],lf[353],t2);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5263(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5263r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5263r(t0,t1,t2,t3);}}

static void C_ccall f_5263r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5267,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1847 setup */
f_5144(t4,t2,t3,lf[350]);}

/* k5265 in file-test-lock in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1849 err */
f_5215(((C_word*)t0)[3],lf[351],t1,lf[350]);}}

/* file-lock/blocking in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5248(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5248r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5248r(t0,t1,t2,t3);}}

static void C_ccall f_5248r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5252,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1841 setup */
f_5144(t4,t2,t3,lf[348]);}

/* k5250 in file-lock/blocking in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1843 err */
f_5215(((C_word*)t0)[2],lf[349],t1,lf[348]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5233(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_5233r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5233r(t0,t1,t2,t3);}}

static void C_ccall f_5233r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5237,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1835 setup */
f_5144(t4,t2,t3,lf[346]);}

/* k5235 in file-lock in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5237(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1837 err */
f_5215(((C_word*)t0)[2],lf[347],t1,lf[346]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5215(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5215,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1832 posix-error */
t8=lf[3];
f_1674(8,t8,t1,lf[48],t4,t2,t5,t6,t7);}

/* setup in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5144(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5144,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_u_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_u_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t8,C_fix(1)));
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5163,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1824 ##sys#check-port */
t16=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}

/* k5161 in setup in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5163(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5163,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5169,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_5169(t6,t5);}
else{
t5=t3;
f_5169(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k5167 in k5161 in setup in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5169(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5169,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[345],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5105(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5105,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[342]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5122,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5129,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5133,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1807 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_5122(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1809 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[342],lf[344],t2);}}}

/* k5131 in file-truncate in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5133(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1807 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5127 in file-truncate in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_5122(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k5120 in file-truncate in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_5122(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1811 posix-error */
t2=lf[3];
f_1674(7,t2,((C_word*)t0)[4],lf[48],lf[342],lf[343],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4849(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr5r,(void*)f_4849r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_4849r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_4849r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4851,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5035,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5040,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5045,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?737778 */
t10=t9;
f_5045(t10,t1);}
else{
t10=(C_word)C_u_i_car(t5);
t11=(C_word)C_slot(t5,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-bufi738776 */
t12=t8;
f_5040(t12,t1,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
if(C_truep((C_word)C_i_nullp(t13))){
/* def-on-close739773 */
t14=t7;
f_5035(t14,t1,t10,t12);}
else{
t14=(C_word)C_u_i_car(t13);
t15=(C_word)C_slot(t13,C_fix(1));
/* body735741 */
t16=t6;
f_4851(t16,t1,t10,t12,t14);}}}}

/* def-nonblocking?737 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5045(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5045,NULL,2,t0,t1);}
/* def-bufi738776 */
t2=((C_word*)t0)[2];
f_5040(t2,t1,C_SCHEME_FALSE);}

/* def-bufi738 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5040(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5040,NULL,3,t0,t1,t2);}
/* def-on-close739773 */
t3=((C_word*)t0)[2];
f_5035(t3,t1,t2,C_fix(0));}

/* def-on-close739 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_5035(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5035,NULL,4,t0,t1,t2,t3);}
/* body735741 */
t4=((C_word*)t0)[2];
f_4851(t4,t1,t2,t3,*((C_word*)lf[337]+1));}

/* body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4851(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4851,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4855,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t3,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1749 ##sys#file-nonblocking! */
t6=*((C_word*)lf[9]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[6]);}
else{
t6=t5;
f_4855(2,t6,C_SCHEME_UNDEFINED);}}

/* k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4855(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[28],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4855,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4857,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=t3,a[5]=((C_word*)t0)[9],tmp=(C_word)a,a+=6,tmp));
t7=(C_word)C_fixnump(((C_word*)t0)[6]);
t8=(C_truep(t7)?((C_word*)t0)[6]:(C_word)C_block_size(((C_word*)t0)[6]));
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4903,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t10=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t10)){
t11=t9;
f_4903(t11,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4947,a[2]=t3,tmp=(C_word)a,a+=3,tmp));}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4961,a[2]=t3,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[6]))){
/* posixunix.scm: 1768 ##sys#make-string */
t12=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,((C_word*)t0)[6]);}
else{
t12=t11;
f_4961(2,t12,((C_word*)t0)[6]);}}}

/* k4959 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4961,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[4];
f_4903(t4,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4962,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp));}

/* f_4962 in k4959 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4962(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4962,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1]);
t4=(C_word)C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4979,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t6,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp));
t8=((C_word*)t6)[1];
f_4979(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep((C_word)C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm: 1784 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4857(t3,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* loop */
static void C_fcall f_4979(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4979,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4989,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1774 poke */
t7=((C_word*)((C_word*)t0)[4])[1];
f_4857(t7,t6,((C_word*)t0)[3],((C_word*)t0)[5]);}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,t4))){
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t2,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_u_fixnum_difference(t4,t2);
/* posixunix.scm: 1779 loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t4,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[7])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k4987 in loop */
static void C_ccall f_4989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_fix(0));
/* posixunix.scm: 1776 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_4979(t3,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* f_4947 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4947(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4947,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_block_size(t2);
/* posixunix.scm: 1767 poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4857(t4,t1,t2,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k4901 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4903(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4903,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[9])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4907,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4912,a[2]=((C_word*)t0)[9],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4918,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4939,a[2]=((C_word*)t0)[9],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1787 make-output-port */
t9=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t9+1)))(5,t9,t5,t6,t7,t8);}

/* a4938 in k4901 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4939(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4939,2,t0,t1);}
/* posixunix.scm: 1797 store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,C_SCHEME_FALSE);}

/* a4917 in k4901 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4918(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4918,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4928,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1794 posix-error */
t3=lf[3];
f_1674(7,t3,t2,lf[48],((C_word*)t0)[3],lf[341],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_4928(2,t3,C_SCHEME_UNDEFINED);}}}

/* k4926 in a4917 in k4901 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4928(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1795 on-close */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* a4911 in k4901 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4912(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4912,3,t0,t1,t2);}
/* posixunix.scm: 1789 store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t1,t2);}

/* k4905 in k4901 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4907,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4910,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1798 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k4908 in k4905 in k4901 in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4910(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* poke in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4857(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4857,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_write(((C_word*)t0)[5],t2,t3);
t5=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4873,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1757 ##sys#thread-yield! */
t8=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixunix.scm: 1759 posix-error */
t7=lf[3];
f_1674(7,t7,t1,((C_word*)t0)[3],lf[48],lf[340],((C_word*)t0)[5],((C_word*)t0)[2]);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t4,t3))){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4892,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1761 ##sys#substring */
t7=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,t2,t4,t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}}

/* k4890 in poke in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4892(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_u_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[4]);
/* posixunix.scm: 1761 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_4857(t3,((C_word*)t0)[2],t1,t2);}

/* k4871 in poke in k4853 in body735 in ##sys#custom-output-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1758 poke */
t2=((C_word*)((C_word*)t0)[5])[1];
f_4857(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4378(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+19)){
C_save_and_reclaim((void*)tr5r,(void*)f_4378r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_4378r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_4378r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a=C_alloc(19);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4380,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t4,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4759,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4764,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4769,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4774,a[2]=t9,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-nonblocking?627716 */
t11=t10;
f_4774(t11,t1);}
else{
t11=(C_word)C_u_i_car(t5);
t12=(C_word)C_slot(t5,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-bufi628714 */
t13=t9;
f_4769(t13,t1,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
if(C_truep((C_word)C_i_nullp(t14))){
/* def-on-close629711 */
t15=t8;
f_4764(t15,t1,t11,t13);}
else{
t15=(C_word)C_u_i_car(t14);
t16=(C_word)C_slot(t14,C_fix(1));
if(C_truep((C_word)C_i_nullp(t16))){
/* def-more?630707 */
t17=t7;
f_4759(t17,t1,t11,t13,t15);}
else{
t17=(C_word)C_u_i_car(t16);
t18=(C_word)C_slot(t16,C_fix(1));
/* body625632 */
t19=t6;
f_4380(t19,t1,t11,t13,t15,t17);}}}}}

/* def-nonblocking?627 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4774(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4774,NULL,2,t0,t1);}
/* def-bufi628714 */
t2=((C_word*)t0)[2];
f_4769(t2,t1,C_SCHEME_FALSE);}

/* def-bufi628 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4769(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4769,NULL,3,t0,t1,t2);}
/* def-on-close629711 */
t3=((C_word*)t0)[2];
f_4764(t3,t1,t2,C_fix(1));}

/* def-on-close629 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4764(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4764,NULL,4,t0,t1,t2,t3);}
/* def-more?630707 */
t4=((C_word*)t0)[2];
f_4759(t4,t1,t2,t3,*((C_word*)lf[337]+1));}

/* def-more?630 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4759(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4759,NULL,5,t0,t1,t2,t3,t4);}
/* body625632 */
t5=((C_word*)t0)[2];
f_4380(t5,t1,t2,t3,t4,C_SCHEME_FALSE);}

/* body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4380(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4380,NULL,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4384,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=t3,tmp=(C_word)a,a+=11,tmp);
if(C_truep(t2)){
/* posixunix.scm: 1627 ##sys#file-nonblocking! */
t7=*((C_word*)lf[9]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[5]);}
else{
t7=t6;
f_4384(2,t7,C_SCHEME_UNDEFINED);}}

/* k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4384(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4384,2,t0,t1);}
t2=(C_word)C_fixnump(((C_word*)t0)[10]);
t3=(C_truep(t2)?((C_word*)t0)[10]:(C_word)C_block_size(((C_word*)t0)[10]));
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4390,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t3,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
if(C_truep((C_word)C_fixnump(((C_word*)t0)[10]))){
/* posixunix.scm: 1629 ##sys#make-string */
t5=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[10]);}
else{
t5=t4;
f_4390(2,t5,((C_word*)t0)[10]);}}

/* k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word ab[65],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4390,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4391,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4406,a[2]=t1,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4414,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[9],a[8]=t3,a[9]=t5,tmp=(C_word)a,a+=10,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4496,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t10,tmp=(C_word)a,a+=6,tmp);
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4501,a[2]=t8,a[3]=t5,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4514,a[2]=t6,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4526,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=t10,tmp=(C_word)a,a+=7,tmp);
t15=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4547,a[2]=t8,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4556,a[2]=t8,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t17=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4632,a[2]=t1,a[3]=t8,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1673 make-input-port */
t18=((C_word*)t0)[2];
((C_proc8)(void*)(*((C_word*)t18+1)))(8,t18,t11,t12,t13,t14,t15,t16,t17);}

/* a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4632(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4632,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4638,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_4638(t7,t1,C_SCHEME_FALSE);}

/* loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4638(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4638,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4640,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4718,a[2]=t3,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4724,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1732 ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4734,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1738 fetch */
t5=((C_word*)t0)[5];
f_4414(t5,t4);}}

/* k4732 in loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
/* posixunix.scm: 1740 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_4638(t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_FILE);}}

/* a4723 in loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4724(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4724,4,t0,t1,t2,t3);}
if(C_truep(t3)){
/* posixunix.scm: 1735 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4638(t4,t1,t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* a4717 in loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4718,2,t0,t1);}
/* posixunix.scm: 1733 ##sys#scan-buffer-line */
t2=*((C_word*)lf[336]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,t1,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]);}

/* bumper in loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4640(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4640,4,t0,t1,t2,t3);}
t4=(C_word)C_u_fixnum_difference(t2,((C_word*)((C_word*)t0)[7])[1]);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4647,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t6=(C_word)C_eqp(C_fix(0),t4);
if(C_truep(t6)){
t7=((C_word*)t0)[3];
t8=t5;
f_4647(2,t8,(C_truep(t7)?t7:lf[333]));}
else{
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4690,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1715 ##sys#make-string */
t8=*((C_word*)lf[335]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t4);}}

/* k4688 in bumper in loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_substring_copy(((C_word*)t0)[8],t1,((C_word*)((C_word*)t0)[7])[1],((C_word*)t0)[6],C_fix(0));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(5));
t4=(C_word)C_u_fixnum_plus(t3,((C_word*)t0)[4]);
t5=(C_word)C_i_set_i_slot(((C_word*)t0)[5],C_fix(5),t4);
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm: 1721 ##sys#string-append */
t6=*((C_word*)lf[334]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[2],((C_word*)t0)[3],t1);}
else{
t6=((C_word*)t0)[2];
f_4647(2,t6,t1);}}

/* k4645 in bumper in loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4647,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[8])+1,((C_word*)t0)[7]);
t3=(C_word)C_eqp(((C_word*)t0)[6],((C_word*)t0)[7]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4657,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1725 fetch */
t5=((C_word*)t0)[3];
f_4414(t5,t4);}
else{
t4=(C_word)C_slot(((C_word*)t0)[2],C_fix(4));
t5=(C_word)C_u_fixnum_plus(t4,C_fix(1));
t6=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t5);
t7=(C_word)C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
/* posixunix.scm: 1730 values */
C_values(4,0,((C_word*)t0)[4],t1,C_SCHEME_FALSE);}}

/* k4655 in k4645 in bumper in loop in a4631 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4657(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
/* posixunix.scm: 1726 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* a4555 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4556(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_4556,6,t0,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4564,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_4564(t7,t3);}
else{
t7=(C_word)C_block_size(t4);
t8=t6;
f_4564(t8,(C_word)C_u_fixnum_difference(t7,t5));}}

/* k4562 in a4555 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4564(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4564,NULL,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4566,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_4566(t5,((C_word*)t0)[3],t1,C_fix(0),((C_word*)t0)[2]);}

/* loop in k4562 in a4555 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4566(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4566,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t3);}
else{
if(C_truep((C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[6])[1]))){
t6=(C_word)C_u_fixnum_difference(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t10=(C_word)C_substring_copy(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[7])[1],t9,t4);
t11=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t8);
t12=C_mutate(((C_word *)((C_word*)t0)[7])+1,t11);
t13=(C_word)C_u_fixnum_difference(t2,t8);
t14=(C_word)C_u_fixnum_plus(t3,t8);
t15=(C_word)C_u_fixnum_plus(t4,t8);
/* posixunix.scm: 1701 loop */
t18=t1;
t19=t13;
t20=t14;
t21=t15;
t1=t18;
t2=t19;
t3=t20;
t4=t21;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4614,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=t1,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1703 fetch */
t7=((C_word*)t0)[2];
f_4414(t7,t6);}}}

/* k4612 in loop in k4562 in a4555 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(0),((C_word*)((C_word*)t0)[7])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,((C_word*)t0)[5]);}
else{
/* posixunix.scm: 1706 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4566(t3,((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* a4546 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4547,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4551,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1691 fetch */
t3=((C_word*)t0)[2];
f_4414(t3,t2);}

/* k4549 in a4546 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1692 peek */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,f_4406(((C_word*)t0)[2]));}

/* a4525 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4526(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4526,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4536,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1688 posix-error */
t3=lf[3];
f_1674(7,t3,t2,lf[48],((C_word*)t0)[3],lf[332],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_4536(2,t3,C_SCHEME_UNDEFINED);}}}

/* k4534 in a4525 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4536(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1689 on-close */
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* a4513 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4514(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4514,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm: 1683 ready? */
t3=((C_word*)t0)[2];
f_4391(t3,t1);}}

/* a4500 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4501,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4505,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1675 fetch */
t3=((C_word*)t0)[2];
f_4414(t3,t2);}

/* k4503 in a4500 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_4406(((C_word*)t0)[4]);
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[3])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

/* k4494 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4496,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4499,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1742 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k4497 in k4494 in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4499(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* fetch in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4414(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4414,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[9])[1],((C_word*)((C_word*)t0)[8])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4426,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_4426(t5,t1);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4426(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4426,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4442,a[2]=t1,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1650 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[328]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,*((C_word*)lf[329]+1),((C_word*)t0)[10],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1653 posix-error */
t5=lf[3];
f_1674(7,t5,t1,lf[48],((C_word*)t0)[6],lf[330],((C_word*)t0)[10],((C_word*)t0)[5]);}}
else{
t4=(C_truep(((C_word*)t0)[4])?(C_word)C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4463,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1657 more? */
t6=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t6=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k4461 in loop in fetch in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4463(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4463,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4466,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1659 ##sys#thread-yield! */
t3=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_read(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4472,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=C_set_block_item(t3,0,C_fix(0));
t8=t4;
f_4472(2,t8,t7);}
else{
/* posixunix.scm: 1665 posix-error */
t7=lf[3];
f_1674(7,t7,t4,lf[48],((C_word*)t0)[3],lf[331],((C_word*)t0)[8],((C_word*)t0)[2]);}}
else{
t6=t4;
f_4472(2,t6,C_SCHEME_UNDEFINED);}}}

/* k4470 in k4461 in loop in fetch in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4472(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)((C_word*)t0)[4])[1]);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4464 in k4461 in loop in fetch in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1660 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4426(t2,((C_word*)t0)[2]);}

/* k4440 in loop in fetch in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4442(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4442,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4445,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1651 ##sys#thread-yield! */
t3=*((C_word*)lf[327]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k4443 in k4440 in loop in fetch in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1652 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_4426(t2,((C_word*)t0)[2]);}

/* peek in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_4406(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
t1=(C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
return((C_truep(t1)?C_SCHEME_END_OF_FILE:(C_word)C_subchar(((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1])));}

/* ready? in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4391(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4391,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4405,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1635 ##sys#file-select-one */
t3=*((C_word*)lf[10]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}

/* k4403 in ready? in k4388 in k4382 in body625 in ##sys#custom-input-port in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1636 posix-error */
t3=lf[3];
f_1674(7,t3,((C_word*)t0)[5],lf[48],((C_word*)t0)[4],lf[326],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4351(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4351r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4351r(t0,t1,t2,t3);}}

static void C_ccall f_4351r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[321]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4358,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_4358(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_slot(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[321]);
t8=t5;
f_4358(t8,(C_word)C_dup2(t2,t6));}}

/* k4356 in duplicate-fileno in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4358(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4358,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4361,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1620 posix-error */
t3=lf[3];
f_1674(6,t3,t2,lf[48],lf[321],lf[322],((C_word*)t0)[2]);}
else{
t3=t2;
f_4361(2,t3,C_SCHEME_UNDEFINED);}}

/* k4359 in k4356 in duplicate-fileno in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4361(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4306(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4306,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4310,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1602 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[315]);}

/* k4308 in port->fileno in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4310(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4310,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[316],t2);
if(C_truep(t3)){
/* posixunix.scm: 1603 ##sys#tcp-port->fileno */
t4=*((C_word*)lf[317]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4345,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1604 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[320]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k4343 in k4308 in port->fileno in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4345,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1609 posix-error */
t2=lf[3];
f_1674(6,t2,((C_word*)t0)[3],lf[59],lf[315],lf[318],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4328,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1607 posix-error */
t4=lf[3];
f_1674(6,t4,t3,lf[48],lf[315],lf[319],((C_word*)t0)[2]);}
else{
t4=t3;
f_4328(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4326 in k4343 in k4308 in port->fileno in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4328(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4292(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4292r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4292r(t0,t1,t2,t3);}}

static void C_ccall f_4292r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[314]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4304,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1598 mode */
f_4226(t5,C_SCHEME_FALSE,t3);}

/* k4302 in open-output-file* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4304(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4304,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1598 check */
f_4263(((C_word*)t0)[2],lf[314],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4278(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4278r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4278r(t0,t1,t2,t3);}}

static void C_ccall f_4278r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[313]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4290,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1594 mode */
f_4226(t5,C_SCHEME_TRUE,t3);}

/* k4288 in open-input-file* in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4290,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1594 check */
f_4263(((C_word*)t0)[2],lf[313],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4263(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4263,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1587 posix-error */
t6=lf[3];
f_1674(6,t6,t1,lf[48],t2,lf[311],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4276,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1588 ##sys#make-port */
t7=*((C_word*)lf[159]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[160]+1),lf[312],lf[94]);}}

/* k4274 in check in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4276(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4226(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4226,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4234,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[305]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1581 ##sys#error */
t8=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[306],t5);}
else{
t8=t4;
f_4234(2,t8,lf[307]);}}
else{
/* posixunix.scm: 1582 ##sys#error */
t7=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[308],t5);}}
else{
t5=t4;
f_4234(2,t5,(C_truep(t2)?lf[309]:lf[310]));}}

/* k4232 in mode in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1577 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4201(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4201,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[299]);
t5=(C_word)C_i_check_string_2(t3,lf[299]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4190,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t6);}
else{
t9=t8;
f_4190(2,t9,C_SCHEME_FALSE);}}

/* k4188 in file-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4190(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4190,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4194,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f_4194(2,t3,C_SCHEME_FALSE);}}

/* k4192 in k4188 in file-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4194(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub569(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1562 posix-error */
t3=lf[3];
f_1674(7,t3,((C_word*)t0)[4],lf[48],lf[300],lf[301],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4159(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4159,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[297]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4167,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4183,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1551 ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4181 in read-symbolic-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4183(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1551 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4165 in read-symbolic-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4167,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4170,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1553 posix-error */
t4=lf[3];
f_1674(6,t4,t3,lf[48],lf[297],lf[298],((C_word*)t0)[2]);}
else{
t4=t3;
f_4170(2,t4,C_SCHEME_UNDEFINED);}}

/* k4168 in k4165 in read-symbolic-link in k4156 in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4170(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1554 substring */
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4121(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4121,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[293]);
t5=(C_word)C_i_check_string_2(t3,lf[293]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4142,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4154,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1539 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4152 in create-symbolic-link in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4154(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1539 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4140 in create-symbolic-link in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4142(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4142,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4146,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4150,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1540 ##sys#expand-home-path */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4148 in k4140 in create-symbolic-link in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4150(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1540 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4144 in k4140 in create-symbolic-link in k4117 in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4146(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1542 posix-error */
t3=lf[3];
f_1674(7,t3,((C_word*)t0)[4],lf[48],lf[294],lf[295],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4096(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4096,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[290]);
t5=(C_word)C_i_check_exact_2(t3,lf[290]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4112,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1517 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k4110 in set-process-group-id! in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4112(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1518 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[290],lf[291],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* create-session in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4081(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4081,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4085,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4091,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1509 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_4085(2,t4,C_SCHEME_UNDEFINED);}}

/* k4089 in create-session in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4091(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1510 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[288],lf[289]);}

/* k4083 in create-session in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4085(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4075(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4075,3,t0,t1,t2);}
/* posixunix.scm: 1504 check */
f_4039(t1,t2,C_fix((C_word)X_OK),lf[287]);}

/* file-write-access? in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4069(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4069,3,t0,t1,t2);}
/* posixunix.scm: 1503 check */
f_4039(t1,t2,C_fix((C_word)W_OK),lf[286]);}

/* file-read-access? in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4063(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4063,3,t0,t1,t2);}
/* posixunix.scm: 1502 check */
f_4039(t1,t2,C_fix((C_word)R_OK),lf[285]);}

/* check in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_4039(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4039,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4057,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4061,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1499 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4059 in check in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1499 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4055 in check in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4057,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4049,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_4049(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1500 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k4047 in k4055 in check in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4049(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-owner in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4009(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4009,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[283]);
t6=(C_word)C_i_check_exact_2(t3,lf[283]);
t7=(C_word)C_i_check_exact_2(t4,lf[283]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4033,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4037,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1489 ##sys#expand-home-path */
t10=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}

/* k4035 in change-file-owner in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1489 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4031 in change-file-owner in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4033(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1490 posix-error */
t3=lf[3];
f_1674(8,t3,((C_word*)t0)[3],lf[48],lf[283],lf[284],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3982(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3982,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[281]);
t5=(C_word)C_i_check_exact_2(t3,lf[281]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4003,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4007,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1481 ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4005 in change-file-mode in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4007(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1481 ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4001 in change-file-mode in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_4003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1482 posix-error */
t3=lf[3];
f_1674(7,t3,((C_word*)t0)[3],lf[48],lf[281],lf[282],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3918(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3918,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[240]);
t5=(C_word)C_i_check_exact_2(t3,lf[240]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3914,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t6);}
else{
t9=t8;
f_3914(2,t9,C_SCHEME_FALSE);}}

/* k3912 in initialize-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3914(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3914,2,t0,t1);}
t2=(C_word)stub509(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[5]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3934,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1402 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3932 in k3912 in initialize-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1403 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[240],lf[241],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3852(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3852,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3856,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_3786(t4);
if(C_truep(t5)){
t6=t3;
f_3856(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1385 ##sys#error */
t6=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[237],lf[239]);}}

/* k3854 in set-groups! in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3856(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3856,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3861,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3861(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do496 in k3854 in set-groups! in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3861(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3861,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3877,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1390 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[237]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k3875 in do496 in k3854 in set-groups! in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1391 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[237],lf[238],((C_word*)t0)[2]);}

/* get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3789(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3789,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3793,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3847,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1371 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_3793(2,t4,C_SCHEME_UNDEFINED);}}

/* k3845 in get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3847(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1372 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[233],lf[236]);}

/* k3791 in get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3793,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3796,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_3786(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_3796(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1374 ##sys#error */
t4=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[233],lf[235]);}}

/* k3794 in k3791 in get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3796(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3796,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3799,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)stub478(C_SCHEME_UNDEFINED,((C_word*)t0)[3]);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3828,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1376 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_3799(2,t4,C_SCHEME_UNDEFINED);}}

/* k3826 in k3794 in k3791 in get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3828(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1377 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[233],lf[234]);}

/* k3797 in k3794 in k3791 in get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3799(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3799,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3804,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3804(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k3797 in k3794 in k3791 in get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3804(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3804,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3818,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1381 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k3816 in loop in k3797 in k3794 in k3791 in get-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3818(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3818,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_3786(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub482(C_SCHEME_UNDEFINED,t1));}

/* group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3711(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3711r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3711r(t0,t1,t2,t3);}}

static void C_ccall f_3711r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3718,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t7=t6;
f_3718(t7,(C_word)C_getgrgid(t2));}
else{
t7=(C_word)C_i_check_string_2(t2,lf[231]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3769,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1345 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}}

/* k3767 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3769(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_3718(t2,(C_word)C_getgrnam(t1));}

/* k3716 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3718(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3718,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3728,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3726 in k3716 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3728(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3728,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3732,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k3730 in k3726 in k3716 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3732,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3736,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3741,a[2]=t4,tmp=(C_word)a,a+=3,tmp));
t6=((C_word*)t4)[1];
f_3741(t6,t2,C_fix(0));}

/* loop in k3730 in k3726 in k3716 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3741(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3741,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3745,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub461(t5,t4),C_fix(0));}

/* k3743 in loop in k3730 in k3726 in k3716 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3745,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3755,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1354 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3741(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k3753 in k3743 in loop in k3730 in k3726 in k3716 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3755,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k3734 in k3730 in k3726 in k3716 in group-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?*((C_word*)lf[228]+1):*((C_word*)lf[229]+1));
t3=t2;
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1);}

/* current-effective-user-name in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3691(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3691,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3699,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3703,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1330 current-effective-user-id */
t4=*((C_word*)lf[222]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3701 in current-effective-user-name in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3703(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1330 user-information */
t2=*((C_word*)lf[227]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3697 in current-effective-user-name in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3699(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_u_i_list_ref(t1,C_fix(0)));}

/* current-user-name in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3677,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3685,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3689,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1327 current-user-id */
t4=*((C_word*)lf[221]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3687 in current-user-name in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1327 user-information */
t2=*((C_word*)lf[227]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3683 in current-user-name in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3685(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_u_i_list_ref(t1,C_fix(0)));}

/* user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3617(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3617r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3617r(t0,t1,t2,t3);}}

static void C_ccall f_3617r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(7);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3624,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t7=t6;
f_3624(t7,(C_word)C_getpwuid(t2));}
else{
t7=(C_word)C_i_check_string_2(t2,lf[227]);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3663,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1315 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}}

/* k3661 in user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_3624(t2,(C_word)C_getpwnam(t1));}

/* k3622 in user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3624(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3624,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3634,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k3632 in k3622 in user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3634,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3638,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k3636 in k3632 in k3622 in user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3638,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3642,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k3640 in k3636 in k3632 in k3622 in user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3642(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3642,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3646,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k3644 in k3640 in k3636 in k3632 in k3622 in user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3646,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3650,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k3648 in k3644 in k3640 in k3636 in k3632 in k3622 in user-information in k3613 in k3609 in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[7])?*((C_word*)lf[228]+1):*((C_word*)lf[229]+1));
t3=t2;
((C_proc9)(void*)(*((C_word*)t3+1)))(9,t3,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* set-group-id! in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3594(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3594,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3604,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1285 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3602 in set-group-id! in k3590 in k3586 in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1286 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[219],lf[224],((C_word*)t0)[2]);}

/* set-user-id! in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3571(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3571,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3581,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1265 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3579 in set-user-id! in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3581(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1266 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[219],lf[220],((C_word*)t0)[2]);}

/* system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3533,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3537,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3566,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1254 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_3537(2,t3,C_SCHEME_UNDEFINED);}}

/* k3564 in system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3566(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1255 ##sys#error */
t2=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[216],lf[218]);}

/* k3535 in system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3537(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3537,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3544,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k3542 in k3535 in system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3544(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3544,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3548,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k3546 in k3542 in k3535 in system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3548,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3552,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k3550 in k3546 in k3542 in k3535 in system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3552,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3556,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k3554 in k3550 in k3546 in k3542 in k3535 in system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3556,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3560,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[217]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k3558 in k3554 in k3550 in k3546 in k3542 in k3535 in system-information in k3529 in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3560(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3560,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* signal-unmask! in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3515(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3515,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[214]);
t4=(C_word)C_sigdelset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1233 posix-error */
t5=lf[3];
f_1674(5,t5,t1,lf[208],lf[214],lf[215]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-mask! in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3500(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3500,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[212]);
t4=(C_word)C_sigaddset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1227 posix-error */
t5=lf[3];
f_1674(5,t5,t1,lf[208],lf[212],lf[213]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-masked? in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3494(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3494,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[211]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigismember(t2));}

/* signal-mask in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3462,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3468,a[2]=t3,tmp=(C_word)a,a+=3,tmp));
t5=((C_word*)t3)[1];
f_3468(t5,t1,*((C_word*)lf[203]+1),C_SCHEME_END_OF_LIST);}

/* loop in signal-mask in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3468(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3468,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(C_truep((C_word)C_sigismember(t4))?(C_word)C_a_i_cons(&a,2,t4,t3):t3);
/* posixunix.scm: 1217 loop */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* set-signal-mask! in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3438(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3438,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[207]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3445,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3456,tmp=(C_word)a,a+=2,tmp);
/* for-each */
t7=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a3455 in set-signal-mask! in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3456(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3456,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[207]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k3443 in set-signal-mask! in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3445(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1210 posix-error */
t2=lf[3];
f_1674(5,t2,((C_word*)t0)[2],lf[208],lf[207],lf[209]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3420(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3420,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3430,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1196 h */
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixunix.scm: 1198 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k3428 in ##sys#interrupt-hook in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1197 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3407(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3407,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[206]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k3394 in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3398(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3398,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[205]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3351,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3355,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 1113 posix-error */
t3=lf[3];
f_1674(5,t3,t2,lf[48],lf[176],lf[177]);}
else{
t3=t2;
f_3355(2,t3,C_SCHEME_UNDEFINED);}}

/* k3353 in create-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1114 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3331(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3331r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3331r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3331r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[175]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3335,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3333 in with-output-to-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3335,2,t0,t1);}
t2=C_mutate((C_word*)lf[175]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3341,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1101 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3340 in k3333 in with-output-to-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3341(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3341r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3341r(t0,t1,t2);}}

static void C_ccall f_3341r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3345,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1103 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3343 in a3340 in k3333 in with-output-to-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3345(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[175]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3311(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_3311r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3311r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3311r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[173]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3315,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k3313 in with-input-from-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3315(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3315,2,t0,t1);}
t2=C_mutate((C_word*)lf[173]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3321,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1091 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a3320 in k3313 in with-input-from-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3321(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_3321r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3321r(t0,t1,t2);}}

static void C_ccall f_3321r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3325,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1093 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3323 in a3320 in k3313 in with-input-from-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3325(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[173]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3287(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3287r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3287r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3287r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3291,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3289 in call-with-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3291(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3291,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3296,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3302,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1081 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3301 in k3289 in call-with-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3302(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3302r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3302r(t0,t1,t2);}}

static void C_ccall f_3302r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3306,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1084 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3304 in a3301 in k3289 in call-with-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3306(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3295 in k3289 in call-with-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3296(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3296,2,t0,t1);}
/* posixunix.scm: 1082 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3263(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_3263r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_3263r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3263r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3267,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k3265 in call-with-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3267,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3272,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3278,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1073 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a3277 in k3265 in call-with-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3278(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_3278r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3278r(t0,t1,t2);}}

static void C_ccall f_3278r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3282,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1076 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3280 in a3277 in k3265 in call-with-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a3271 in k3265 in call-with-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3272(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3272,2,t0,t1);}
/* posixunix.scm: 1074 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3247(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3247,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3251,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1060 ##sys#check-port */
t4=*((C_word*)lf[168]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[165]);}

/* k3249 in close-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3251(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3251,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3254,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 1062 posix-error */
t5=lf[3];
f_1674(6,t5,t3,lf[48],lf[166],lf[167],((C_word*)t0)[3]);}
else{
t5=t3;
f_3254(2,t5,C_SCHEME_UNDEFINED);}}

/* k3252 in k3249 in close-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3254(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3211(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_3211r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3211r(t0,t1,t2,t3);}}

static void C_ccall f_3211r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[164]);
t5=f_3142(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3225,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[155]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3232,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1055 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[163]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3242,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1056 ##sys#make-c-string */
t10=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1057 badmode */
f_3154(t6,t5);}}}

/* k3240 in open-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3242(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3242,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3225(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k3230 in open-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3232(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3232,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3225(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k3223 in open-output-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3225(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1051 check */
f_3160(((C_word*)t0)[3],lf[164],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3175(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_3175r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3175r(t0,t1,t2,t3);}}

static void C_ccall f_3175r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[162]);
t5=f_3142(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3189,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[155]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3196,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1044 ##sys#make-c-string */
t9=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[163]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3206,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1045 ##sys#make-c-string */
t10=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 1046 badmode */
f_3154(t6,t5);}}}

/* k3204 in open-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3206,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3189(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k3194 in open-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3196,2,t0,t1);}
t2=((C_word*)t0)[2];
f_3189(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k3187 in open-input-pipe in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3189(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1040 check */
f_3160(((C_word*)t0)[3],lf[162],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3160(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3160,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1032 posix-error */
t6=lf[3];
f_1674(6,t6,t1,lf[48],t2,lf[158],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3173,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1033 ##sys#make-port */
t7=*((C_word*)lf[159]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[160]+1),lf[161],lf[94]);}}

/* k3171 in check in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3173(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3154(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3154,NULL,2,t1,t2);}
/* posixunix.scm: 1029 ##sys#error */
t3=*((C_word*)lf[156]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[157],t2);}

/* mode in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_3142(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[155]));}

/* canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2825(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2825,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[115]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2832,a[2]=t1,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2946,a[2]=t4,a[3]=((C_word*)t0)[11],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 977  cwd */
t8=((C_word*)t0)[6];
f_2769(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2952,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[12],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[11],a[10]=t2,a[11]=t4,tmp=(C_word)a,a+=12,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3132,a[2]=((C_word*)t0)[12],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 979  sref */
t10=((C_word*)t0)[9];
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_2952(t9,C_SCHEME_FALSE);}}}

/* k3130 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3132(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 979  sep? */
t2=((C_word*)t0)[3];
f_2952(t2,f_2758(t1));}

/* k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2952(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[27],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2952,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[11];
f_2832(2,t2,((C_word*)t0)[10]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[10]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2965,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[11],a[4]=((C_word*)t0)[9],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 982  cwd */
t5=((C_word*)t0)[8];
f_2769(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_2971,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[9],tmp=(C_word)a,a+=12,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3107,a[2]=((C_word*)t0)[10],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3118,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 983  sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[10],C_fix(0));}}}

/* k3116 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3118(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 983  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k3105 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3107(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3107,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3114,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 984  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_2971(t2,C_SCHEME_FALSE);}}

/* k3112 in k3105 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3114(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 984  sep? */
t2=((C_word*)t0)[3];
f_2971(t2,f_2758(t1));}

/* k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2971(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[32],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2971,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2978,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 986  getenv */
t3=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[152]);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[9]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3009,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 991  cwd */
t5=((C_word*)t0)[6];
f_2769(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3015,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3079,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3100,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 992  sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[9],C_fix(0));}}}

/* k3098 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3100(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 992  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3077 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3079(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3079,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3085,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3096,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 993  sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_3015(t2,C_SCHEME_FALSE);}}

/* k3094 in k3077 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 993  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3083 in k3077 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3085(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3085,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3092,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 994  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_3015(t2,C_SCHEME_FALSE);}}

/* k3090 in k3083 in k3077 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3092(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 994  sep? */
t2=((C_word*)t0)[3];
f_3015(t2,f_2758(t1));}

/* k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_3015(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3015,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[9]);
/* posixunix.scm: 995  ##sys#substring */
t3=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[8],((C_word*)t0)[9],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3028,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3055,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3076,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 996  sref */
t5=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[9],C_fix(0));}}

/* k3074 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3076(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 996  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k3053 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3055,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3061,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3072,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 997  sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3028(2,t2,C_SCHEME_FALSE);}}

/* k3070 in k3053 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3072(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 997  alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3059 in k3053 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3061,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3068,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 998  sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_3028(2,t2,C_SCHEME_FALSE);}}

/* k3066 in k3059 in k3053 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3068(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 998  char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3026 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3028,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_block_size(((C_word*)t0)[7]);
/* posixunix.scm: 999  ##sys#substring */
t3=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[6],((C_word*)t0)[7],C_fix(3),t2);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3052,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1000 sref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[7],C_fix(0));}}

/* k3050 in k3026 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3052,2,t0,t1);}
t2=f_2758(t1);
if(C_truep(t2)){
t3=((C_word*)t0)[5];
f_2832(2,t3,((C_word*)t0)[4]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3048,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1003 cwd */
t4=((C_word*)t0)[2];
f_2769(t4,t3);}}

/* k3046 in k3050 in k3026 in k3013 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3048(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1003 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[154],((C_word*)t0)[2]);}

/* k3007 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_3009(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 991  sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[153],((C_word*)t0)[2]);}

/* k2976 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2978(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2978,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2981,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=t2;
f_2981(2,t3,t1);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2996,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 987  user */
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k2994 in k2976 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2996(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 987  sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[151],t1);}

/* k2979 in k2976 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2981,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2985,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 988  ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k2983 in k2979 in k2976 in k2969 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2985(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 985  sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2963 in k2950 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2965(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 982  sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[150],((C_word*)t0)[2]);}

/* k2944 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2946(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 977  sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],t1,lf[149]);}

/* k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2832,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2839,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t3=t1;
/* string-split */
t4=*((C_word*)lf[114]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,lf[148]);}

/* k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2839,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2841,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_2841(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2841(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2841,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_2848,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t3,a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 1006 null? */
t5=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2848(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2848,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2854,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1007 null? */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[8]);}
else{
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2909,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2912,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[8],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_u_i_car(((C_word*)t0)[4]);
/* posixunix.scm: 1018 string=? */
t6=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[147],t5);}}

/* k2910 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2912(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2912,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_2909(t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2921,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(((C_word*)t0)[3]);
/* posixunix.scm: 1020 string=? */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[146],t3);}}

/* k2919 in k2910 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2921,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_2909(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_u_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_2909(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k2907 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2909(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1016 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2841(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k2852 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2854(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2854,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[8];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,lf[141]);}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2890,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[3]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixunix.scm: 1009 sref */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,((C_word*)t0)[3],t4);}}

/* k2888 in k2852 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2890,2,t0,t1);}
t2=f_2758(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2867,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2871,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_a_i_cons(&a,2,lf[143],((C_word*)t0)[2]);
/* posixunix.scm: 1012 reverse */
t6=*((C_word*)lf[144]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2882,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2886,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1015 reverse */
t5=*((C_word*)lf[144]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}}

/* k2884 in k2888 in k2852 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1015 isperse */
f_2753(((C_word*)t0)[2],t1);}

/* k2880 in k2888 in k2852 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1013 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[145],t1);}

/* k2869 in k2888 in k2852 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1012 isperse */
f_2753(((C_word*)t0)[2],t1);}

/* k2865 in k2888 in k2852 in k2846 in loop in k2837 in k2830 in canonical-path in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2867(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1010 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[142],t1);}

/* cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2769(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2769,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2776,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2778,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[140]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a2777 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2778(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2778,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2784,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2802,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* with-exception-handler */
t5=*((C_word*)lf[139]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t3,t4);}

/* a2801 in a2777 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2802,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2808,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2814,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t2,t3);}

/* a2813 in a2801 in a2777 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2814(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_2814r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2814r(t0,t1,t2);}}

static void C_ccall f_2814r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2820,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* g313315 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a2819 in a2813 in a2801 in a2777 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2820(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2820,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a2807 in a2801 in a2777 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2808(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2808,2,t0,t1);}
/* posixunix.scm: 972  cw */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a2783 in a2777 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2784(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2784,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2790,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* g313315 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a2789 in a2783 in a2777 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2790(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2790,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[137]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[138]);}

/* k2774 in cwd in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2776(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* sep? in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_2758(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2753(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2753,NULL,2,t1,t2);}
/* string-intersperse */
t3=*((C_word*)lf[133]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,lf[134]);}

/* current-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2712(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_2712r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_2712r(t0,t1,t2);}}

static void C_ccall f_2712r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(C_word)C_vemptyp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_slot(t2,C_fix(0)));
if(C_truep(t4)){
/* posixunix.scm: 950  change-directory */
t5=*((C_word*)lf[116]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2725,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 951  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}}

/* k2723 in current-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2725(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 954  ##sys#substring */
t3=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 955  posix-error */
t3=lf[3];
f_1674(5,t3,((C_word*)t0)[2],lf[48],lf[125],lf[128]);}}

/* directory? in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2689(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2689,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[126]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2696,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2710,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 943  ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2708 in directory? in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 943  ##sys#file-info */
t2=*((C_word*)lf[127]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2694 in directory? in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2696(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2535(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr2r,(void*)f_2535r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2535r(t0,t1,t2);}}

static void C_ccall f_2535r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2537,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2635,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2640,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec250275 */
t6=t5;
f_2640(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?251273 */
t8=t4;
f_2635(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body248253 */
t10=t3;
f_2537(t10,t1,t6,t8);}}}

/* def-spec250 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2640(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2640,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2648,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 916  current-directory */
t3=*((C_word*)lf[125]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2646 in def-spec250 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2648(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?251273 */
t2=((C_word*)t0)[3];
f_2635(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?251 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2635(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2635,NULL,3,t0,t1,t2);}
/* body248253 */
t3=((C_word*)t0)[2];
f_2537(t3,t1,t2,C_SCHEME_FALSE);}

/* body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2537(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2537,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[122]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2544,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 918  make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}

/* k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2544(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2544,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2547,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 919  ##sys#make-pointer */
t3=*((C_word*)lf[124]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2547,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2550,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 920  ##sys#make-pointer */
t3=*((C_word*)lf[124]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2550(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2550,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2554,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2634,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 921  ##sys#expand-home-path */
t4=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[5]);}

/* k2632 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 921  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2552 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2554,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[8]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[8]))){
/* posixunix.scm: 923  posix-error */
t3=lf[3];
f_1674(6,t3,((C_word*)t0)[7],lf[48],lf[122],lf[123],((C_word*)t0)[6]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2568,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2568(t6,((C_word*)t0)[7]);}}

/* loop in k2552 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2568(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2568,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[7],((C_word*)t0)[6]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[6]))){
t3=(C_word)C_closedir(((C_word*)t0)[7]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[6],((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2578,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t1,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 931  ##sys#substring */
t5=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t3);}}

/* k2576 in loop in k2552 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2578(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2578,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2581,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 932  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,t1,C_fix(0));}

/* k2579 in k2576 in loop in k2552 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2581(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2581,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2584,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep((C_word)C_fixnum_greaterp(((C_word*)t0)[4],C_fix(1)))){
/* posixunix.scm: 933  string-ref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[5],C_fix(1));}
else{
t3=t2;
f_2584(2,t3,C_SCHEME_FALSE);}}

/* k2582 in k2579 in k2576 in loop in k2552 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2584(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2584,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2590,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(C_make_character(46),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(C_word)C_i_not(t1);
if(C_truep(t4)){
t5=t2;
f_2590(t5,t4);}
else{
t5=(C_word)C_eqp(C_make_character(46),t1);
t6=(C_truep(t5)?(C_word)C_eqp(C_fix(2),((C_word*)t0)[3]):C_SCHEME_FALSE);
t7=t2;
f_2590(t7,(C_truep(t6)?t6:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t4=t2;
f_2590(t4,C_SCHEME_FALSE);}}

/* k2588 in k2582 in k2579 in k2576 in loop in k2552 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2590(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2590,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 938  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2568(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2600,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 939  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2568(t3,t2);}}

/* k2598 in k2588 in k2582 in k2579 in k2576 in loop in k2552 in k2548 in k2545 in k2542 in body248 in directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2600(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2600,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2511(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2511,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[118]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2529,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2533,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 909  ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2531 in delete-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 909  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2527 in delete-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 910  posix-error */
t3=lf[3];
f_1674(6,t3,((C_word*)t0)[3],lf[48],lf[118],lf[119],((C_word*)t0)[2]);}}

/* change-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2487(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2487,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[116]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2505,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2509,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 903  ##sys#expand-home-path */
t6=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2507 in change-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 903  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2503 in change-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 904  posix-error */
t3=lf[3];
f_1674(6,t3,((C_word*)t0)[3],lf[48],lf[116],lf[117],((C_word*)t0)[2]);}}

/* create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2386(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2386r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2386r(t0,t1,t2,t3);}}

static void C_ccall f_2386r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(6);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[112]);
if(C_truep(t5)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2399,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 895  canonical-path */
t8=*((C_word*)lf[115]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2459,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 896  canonical-path */
t8=*((C_word*)lf[115]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}}

/* k2457 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2459(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2459,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2473,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k2471 in k2457 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2473(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix-error */
t3=lf[3];
f_1674(6,t3,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[100]+1),((C_word*)t0)[2]);}}

/* k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2399(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2399,2,t0,t1);}
t2=*((C_word*)lf[110]+1);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2404,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2456,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-split */
t6=*((C_word*)lf[114]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t1,*((C_word*)lf[106]+1));}

/* k2454 in k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2456(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* for-each */
t2=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a2403 in k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2404(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2404,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2409,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* string-append */
t4=*((C_word*)lf[2]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],*((C_word*)lf[108]+1),t2);}

/* k2407 in a2403 in k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2409(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2409,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2415,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2432,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* file-exists? */
t6=*((C_word*)lf[113]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}

/* k2430 in k2407 in a2403 in k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2432,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2452,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_2415(2,t2,C_SCHEME_FALSE);}}

/* k2450 in k2430 in k2407 in a2403 in k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2452(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_stat(t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posix-error */
t3=lf[3];
f_1674(6,t3,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[104]+1),((C_word*)t0)[2]);}
else{
t3=C_mk_bool(C_isdir);
if(C_truep(t3)){
t4=((C_word*)t0)[3];
f_2415(2,t4,t3);}
else{
/* posix-error */
t4=lf[3];
f_1674(6,t4,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[102]+1),((C_word*)t0)[2]);}}}

/* k2413 in k2407 in a2403 in k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2415(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2415,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2429,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#make-c-string */
t3=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k2427 in k2413 in k2407 in a2403 in k2397 in create-directory in k2376 in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2429(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posix-error */
t3=lf[3];
f_1674(6,t3,((C_word*)t0)[3],lf[48],lf[112],*((C_word*)lf[100]+1),((C_word*)t0)[2]);}}

/* set-file-position! in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2318(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2318r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2318r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2318r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[92]);
t8=(C_word)C_i_check_exact_2(t6,lf[92]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2331,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 839  ##sys#signal-hook */
t10=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[97],lf[92],lf[98],t3,t2);}
else{
t10=t9;
f_2331(2,t10,C_SCHEME_UNDEFINED);}}

/* k2329 in set-file-position! in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2331,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2337,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2343,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 840  port? */
t4=*((C_word*)lf[96]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k2341 in k2329 in set-file-position! in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2343(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[94]);
t4=((C_word*)t0)[4];
f_2337(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_2337(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 844  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[59],lf[92],lf[95],((C_word*)t0)[5]);}}}

/* k2335 in k2329 in set-file-position! in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 845  posix-error */
t2=lf[3];
f_1674(7,t2,((C_word*)t0)[4],lf[48],lf[92],lf[93],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* stat-socket? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2309(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2309,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[91]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2316,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 831  ##sys#stat */
f_2139(t4,t2,C_SCHEME_FALSE,lf[91]);}

/* k2314 in stat-socket? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2316(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_issock));}

/* stat-symlink? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2300(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2300,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[90]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2307,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 826  ##sys#stat */
f_2139(t4,t2,C_SCHEME_TRUE,lf[90]);}

/* k2305 in stat-symlink? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2307(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* stat-fifo? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2291(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2291,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[89]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2298,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 821  ##sys#stat */
f_2139(t4,t2,C_SCHEME_FALSE,lf[89]);}

/* k2296 in stat-fifo? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isfifo));}

/* stat-block-device? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2282(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2282,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[88]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2289,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 816  ##sys#stat */
f_2139(t4,t2,C_SCHEME_FALSE,lf[88]);}

/* k2287 in stat-block-device? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2289(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isblk));}

/* stat-char-device? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2273(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2273,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[87]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2280,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 811  ##sys#stat */
f_2139(t4,t2,C_SCHEME_FALSE,lf[87]);}

/* k2278 in stat-char-device? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_ischr));}

/* stat-directory? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2264(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2264,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[86]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2271,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 806  ##sys#stat */
f_2139(t4,t2,C_SCHEME_FALSE,lf[86]);}

/* k2269 in stat-directory? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isdir));}

/* stat-regular? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2255(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2255,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[85]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2262,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 801  ##sys#stat */
f_2139(t4,t2,C_SCHEME_FALSE,lf[85]);}

/* k2260 in stat-regular? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2262(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* symbolic-link? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2246(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2246,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[84]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2253,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 796  ##sys#stat */
f_2139(t4,t2,C_SCHEME_TRUE,lf[84]);}

/* k2251 in symbolic-link? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2253(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2237(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2237,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[83]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2244,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 791  ##sys#stat */
f_2139(t4,t2,C_SCHEME_TRUE,lf[83]);}

/* k2242 in regular-file? in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2244(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2231(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2231,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2235,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 787  ##sys#stat */
f_2139(t3,t2,C_SCHEME_FALSE,lf[82]);}

/* k2233 in file-permissions in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2225(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2225,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2229,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 786  ##sys#stat */
f_2139(t3,t2,C_SCHEME_FALSE,lf[81]);}

/* k2227 in file-owner in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2229(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2219(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2219,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2223,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 785  ##sys#stat */
f_2139(t3,t2,C_SCHEME_FALSE,lf[80]);}

/* k2221 in file-change-time in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2223,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2213(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2213,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2217,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 784  ##sys#stat */
f_2139(t3,t2,C_SCHEME_FALSE,lf[79]);}

/* k2215 in file-access-time in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2217,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2207(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2207,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2211,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 783  ##sys#stat */
f_2139(t3,t2,C_SCHEME_FALSE,lf[78]);}

/* k2209 in file-modification-time in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2211,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2201(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2201,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2205,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 782  ##sys#stat */
f_2139(t3,t2,C_SCHEME_FALSE,lf[77]);}

/* k2203 in file-size in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2205(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2205,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_a_double_to_num(&a,C_statbuf.st_size));}

/* file-stat in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2176(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2176r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2176r(t0,t1,t2,t3);}}

static void C_ccall f_2176r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2180,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_vemptyp(t3);
t6=(C_truep(t5)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
/* posixunix.scm: 775  ##sys#stat */
f_2139(t4,t2,t6,lf[76]);}

/* k2178 in file-stat in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2180,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks)));}

/* ##sys#stat in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2139(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2139,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2143,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_2143(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2164,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2171,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 766  ##sys#expand-home-path */
t8=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 770  ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[59],lf[75],t2);}}}

/* k2169 in ##sys#stat in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 766  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2162 in ##sys#stat in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2164(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2143(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k2141 in ##sys#stat in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2143(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 772  posix-error */
t2=lf[3];
f_1674(6,t2,((C_word*)t0)[4],lf[48],((C_word*)t0)[3],lf[74],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1947(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1947r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1947r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1947r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(15);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1941(C_fix(0));
t10=f_1941(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1963,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1963(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 695  fd_set */
t14=t12;
f_1963(2,t14,f_1943(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[67]);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2120,a[2]=((C_word*)t0)[2],a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* for-each */
t15=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a2119 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2120(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2120,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[67]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 702  fd_set */
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f_1943(C_fix(0),t2));}

/* k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1963(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1963,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1969,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1969(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 707  fd_set */
t5=t3;
f_1969(2,t5,f_1943(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[67]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2094,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t6=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a2093 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2094(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2094,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[67]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 714  fd_set */
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,f_1943(C_fix(1),t2));}

/* k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1969(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1969,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1972,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_number_2(((C_word*)t0)[3],lf[67]);
t4=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_1972(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1972(t4,(C_word)C_C_select(t3));}}

/* k1970 in k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_1972(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1972,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 721  posix-error */
t2=lf[3];
f_1674(7,t2,((C_word*)t0)[5],lf[48],lf[67],lf[68],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 722  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2011,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 727  fd_test */
t4=t3;
f_2011(t4,f_1945(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2052,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2054,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t8=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_2011(t4,C_SCHEME_FALSE);}}}}

/* a2053 in k1970 in k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2054(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2054,3,t0,t1,t2);}
t3=f_1945(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2050 in k1970 in k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2052(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2011(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k2009 in k1970 in k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2011(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2011,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2015,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 733  fd_test */
t3=t2;
f_2015(t3,f_1945(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2027,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2029,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t7=*((C_word*)lf[69]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_2015(t3,C_SCHEME_FALSE);}}

/* a2028 in k2009 in k1970 in k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2029(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2029,3,t0,t1,t2);}
t3=f_1945(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2025 in k2009 in k1970 in k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_2027(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_2015(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k2013 in k2009 in k1970 in k1967 in k1961 in file-select in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_fcall f_2015(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 724  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_1945(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub92(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_set in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_1943(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub86(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_zero in k1665 in k1662 in k1659 in k1656 in k1653 */
static C_word C_fcall f_1941(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub81(C_SCHEME_UNDEFINED,t1));}

/* file-mkstemp in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1909(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1909,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[64]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1916,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 673  ##sys#make-c-string */
t5=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1914 in file-mkstemp in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1916,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1922,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 677  posix-error */
t6=lf[3];
f_1674(6,t6,t4,lf[48],lf[64],lf[66],((C_word*)t0)[2]);}
else{
t6=t4;
f_1922(2,t6,C_SCHEME_UNDEFINED);}}

/* k1920 in k1914 in file-mkstemp in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1922(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1922,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1929,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 678  ##sys#substring */
t4=*((C_word*)lf[65]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1927 in k1920 in k1914 in file-mkstemp in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 678  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1870(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1870r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1870r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1870r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[61]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1877,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1877(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 662  ##sys#signal-hook */
t8=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[59],lf[61],lf[63],t3);}}

/* k1875 in file-write in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1877(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1877,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[61]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1886,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm: 667  posix-error */
t8=lf[3];
f_1674(7,t8,t6,lf[48],lf[61],lf[62],((C_word*)t0)[3],t3);}
else{
t8=t6;
f_1886(2,t8,C_SCHEME_UNDEFINED);}}

/* k1884 in k1875 in file-write in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1886(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1828(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1828r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1828r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1828r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[57]);
t6=(C_word)C_i_check_exact_2(t3,lf[57]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1838,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1838(2,t8,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posixunix.scm: 650  make-string */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t3);}}

/* k1836 in file-read in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1838(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1838,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1841,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1841(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 652  ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[59],lf[57],lf[60],t1);}}

/* k1839 in k1836 in file-read in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1841,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1844,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 655  posix-error */
t5=lf[3];
f_1674(7,t5,t3,lf[48],lf[57],lf[58],((C_word*)t0)[5],((C_word*)t0)[3]);}
else{
t5=t3;
f_1844(2,t5,C_SCHEME_UNDEFINED);}}

/* k1842 in k1839 in k1836 in file-read in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1844(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1844,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1813(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1813,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[54]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 643  posix-error */
t4=lf[3];
f_1674(6,t4,t1,lf[48],lf[54],lf[55],t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1775(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1775r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1775r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1775r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[50]);
t8=(C_word)C_i_check_exact_2(t3,lf[50]);
t9=(C_word)C_i_check_exact_2(t6,lf[50]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1792,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1805,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 634  ##sys#expand-home-path */
t12=*((C_word*)lf[53]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k1803 in file-open in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1805(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 634  ##sys#make-c-string */
t2=*((C_word*)lf[52]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1790 in file-open in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1792,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1795,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 636  posix-error */
t5=lf[3];
f_1674(8,t5,t3,lf[48],lf[50],lf[51],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t5=t3;
f_1795(2,t5,C_SCHEME_UNDEFINED);}}

/* k1793 in k1790 in file-open in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-control in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1736(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1736r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1736r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1736r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t5=(C_word)C_vemptyp(t4);
t6=(C_truep(t5)?C_fix(0):(C_word)C_slot(t4,C_fix(0)));
t7=(C_word)C_i_check_exact_2(t2,lf[47]);
t8=(C_word)C_i_check_exact_2(t3,lf[47]);
t9=t2;
t10=t3;
t11=(C_word)stub24(C_SCHEME_UNDEFINED,t9,t10,t6);
t12=(C_word)C_eqp(t11,C_fix(-1));
if(C_truep(t12)){
/* posixunix.scm: 624  posix-error */
t13=lf[3];
f_1674(7,t13,t1,lf[48],lf[47],lf[49],t2,t3);}
else{
t13=t1;
((C_proc2)(void*)(*((C_word*)t13+1)))(2,t13,t11);}}

/* ##sys#file-select-one in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1695(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1695,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub17(C_SCHEME_UNDEFINED,t2));}

/* ##sys#file-nonblocking! in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1692(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1692,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub13(C_SCHEME_UNDEFINED,t2));}

/* posix-error in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1674(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1674r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1674r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1674r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1678,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 514  ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1676 in posix-error in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1678(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1678,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1685,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1689,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,(C_word)stub3(t4,t1),C_fix(0));}

/* k1687 in k1676 in posix-error in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 515  string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[5],t1);}

/* k1683 in k1676 in posix-error in k1665 in k1662 in k1659 in k1656 in k1653 */
static void C_ccall f_1685(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[4]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[608] = {
{"toplevelposixunix.scm",(void*)C_posix_toplevel},
{"f_1655posixunix.scm",(void*)f_1655},
{"f_1658posixunix.scm",(void*)f_1658},
{"f_1661posixunix.scm",(void*)f_1661},
{"f_1664posixunix.scm",(void*)f_1664},
{"f_1667posixunix.scm",(void*)f_1667},
{"f_7330posixunix.scm",(void*)f_7330},
{"f_7346posixunix.scm",(void*)f_7346},
{"f_7334posixunix.scm",(void*)f_7334},
{"f_7337posixunix.scm",(void*)f_7337},
{"f_2378posixunix.scm",(void*)f_2378},
{"f_3396posixunix.scm",(void*)f_3396},
{"f_7324posixunix.scm",(void*)f_7324},
{"f_3531posixunix.scm",(void*)f_3531},
{"f_7321posixunix.scm",(void*)f_7321},
{"f_3588posixunix.scm",(void*)f_3588},
{"f_7306posixunix.scm",(void*)f_7306},
{"f_7316posixunix.scm",(void*)f_7316},
{"f_7303posixunix.scm",(void*)f_7303},
{"f_3592posixunix.scm",(void*)f_3592},
{"f_7300posixunix.scm",(void*)f_7300},
{"f_3611posixunix.scm",(void*)f_3611},
{"f_7285posixunix.scm",(void*)f_7285},
{"f_7295posixunix.scm",(void*)f_7295},
{"f_7282posixunix.scm",(void*)f_7282},
{"f_3615posixunix.scm",(void*)f_3615},
{"f_7264posixunix.scm",(void*)f_7264},
{"f_7277posixunix.scm",(void*)f_7277},
{"f_7271posixunix.scm",(void*)f_7271},
{"f_4119posixunix.scm",(void*)f_4119},
{"f_4158posixunix.scm",(void*)f_4158},
{"f_7241posixunix.scm",(void*)f_7241},
{"f_7237posixunix.scm",(void*)f_7237},
{"f_6983posixunix.scm",(void*)f_6983},
{"f_7166posixunix.scm",(void*)f_7166},
{"f_7172posixunix.scm",(void*)f_7172},
{"f_7161posixunix.scm",(void*)f_7161},
{"f_7156posixunix.scm",(void*)f_7156},
{"f_6985posixunix.scm",(void*)f_6985},
{"f_7143posixunix.scm",(void*)f_7143},
{"f_7151posixunix.scm",(void*)f_7151},
{"f_6992posixunix.scm",(void*)f_6992},
{"f_7131posixunix.scm",(void*)f_7131},
{"f_7125posixunix.scm",(void*)f_7125},
{"f_7002posixunix.scm",(void*)f_7002},
{"f_7004posixunix.scm",(void*)f_7004},
{"f_7023posixunix.scm",(void*)f_7023},
{"f_7111posixunix.scm",(void*)f_7111},
{"f_7118posixunix.scm",(void*)f_7118},
{"f_7105posixunix.scm",(void*)f_7105},
{"f_7038posixunix.scm",(void*)f_7038},
{"f_7098posixunix.scm",(void*)f_7098},
{"f_7095posixunix.scm",(void*)f_7095},
{"f_7082posixunix.scm",(void*)f_7082},
{"f_7058posixunix.scm",(void*)f_7058},
{"f_7080posixunix.scm",(void*)f_7080},
{"f_7066posixunix.scm",(void*)f_7066},
{"f_7073posixunix.scm",(void*)f_7073},
{"f_7070posixunix.scm",(void*)f_7070},
{"f_7050posixunix.scm",(void*)f_7050},
{"f_7048posixunix.scm",(void*)f_7048},
{"f_7132posixunix.scm",(void*)f_7132},
{"f_6926posixunix.scm",(void*)f_6926},
{"f_6938posixunix.scm",(void*)f_6938},
{"f_6933posixunix.scm",(void*)f_6933},
{"f_6928posixunix.scm",(void*)f_6928},
{"f_6869posixunix.scm",(void*)f_6869},
{"f_6881posixunix.scm",(void*)f_6881},
{"f_6876posixunix.scm",(void*)f_6876},
{"f_6871posixunix.scm",(void*)f_6871},
{"f_6808posixunix.scm",(void*)f_6808},
{"f_6863posixunix.scm",(void*)f_6863},
{"f_6867posixunix.scm",(void*)f_6867},
{"f_6829posixunix.scm",(void*)f_6829},
{"f_6832posixunix.scm",(void*)f_6832},
{"f_6843posixunix.scm",(void*)f_6843},
{"f_6837posixunix.scm",(void*)f_6837},
{"f_6810posixunix.scm",(void*)f_6810},
{"f_6819posixunix.scm",(void*)f_6819},
{"f_6744posixunix.scm",(void*)f_6744},
{"f_6756posixunix.scm",(void*)f_6756},
{"f_6787posixunix.scm",(void*)f_6787},
{"f_6767posixunix.scm",(void*)f_6767},
{"f_6783posixunix.scm",(void*)f_6783},
{"f_6771posixunix.scm",(void*)f_6771},
{"f_6779posixunix.scm",(void*)f_6779},
{"f_6775posixunix.scm",(void*)f_6775},
{"f_6750posixunix.scm",(void*)f_6750},
{"f_6733posixunix.scm",(void*)f_6733},
{"f_6737posixunix.scm",(void*)f_6737},
{"f_6722posixunix.scm",(void*)f_6722},
{"f_6726posixunix.scm",(void*)f_6726},
{"f_6677posixunix.scm",(void*)f_6677},
{"f_6681posixunix.scm",(void*)f_6681},
{"f_6684posixunix.scm",(void*)f_6684},
{"f_6687posixunix.scm",(void*)f_6687},
{"f_6700posixunix.scm",(void*)f_6700},
{"f_6704posixunix.scm",(void*)f_6704},
{"f_6707posixunix.scm",(void*)f_6707},
{"f_6710posixunix.scm",(void*)f_6710},
{"f_6698posixunix.scm",(void*)f_6698},
{"f_6661posixunix.scm",(void*)f_6661},
{"f_6644posixunix.scm",(void*)f_6644},
{"f_6657posixunix.scm",(void*)f_6657},
{"f_6569posixunix.scm",(void*)f_6569},
{"f_6630posixunix.scm",(void*)f_6630},
{"f_6643posixunix.scm",(void*)f_6643},
{"f_6610posixunix.scm",(void*)f_6610},
{"f_6625posixunix.scm",(void*)f_6625},
{"f_6619posixunix.scm",(void*)f_6619},
{"f_6573posixunix.scm",(void*)f_6573},
{"f_6575posixunix.scm",(void*)f_6575},
{"f_6596posixunix.scm",(void*)f_6596},
{"f_6590posixunix.scm",(void*)f_6590},
{"f_6517posixunix.scm",(void*)f_6517},
{"f_6524posixunix.scm",(void*)f_6524},
{"f_6543posixunix.scm",(void*)f_6543},
{"f_6547posixunix.scm",(void*)f_6547},
{"f_6511posixunix.scm",(void*)f_6511},
{"f_6502posixunix.scm",(void*)f_6502},
{"f_6506posixunix.scm",(void*)f_6506},
{"f_6475posixunix.scm",(void*)f_6475},
{"f_6472posixunix.scm",(void*)f_6472},
{"f_6469posixunix.scm",(void*)f_6469},
{"f_6466posixunix.scm",(void*)f_6466},
{"f_6391posixunix.scm",(void*)f_6391},
{"f_6424posixunix.scm",(void*)f_6424},
{"f_6418posixunix.scm",(void*)f_6418},
{"f_6374posixunix.scm",(void*)f_6374},
{"f_6195posixunix.scm",(void*)f_6195},
{"f_6329posixunix.scm",(void*)f_6329},
{"f_6324posixunix.scm",(void*)f_6324},
{"f_6197posixunix.scm",(void*)f_6197},
{"f_6207posixunix.scm",(void*)f_6207},
{"f_6215posixunix.scm",(void*)f_6215},
{"f_6261posixunix.scm",(void*)f_6261},
{"f_6228posixunix.scm",(void*)f_6228},
{"f_6253posixunix.scm",(void*)f_6253},
{"f_6231posixunix.scm",(void*)f_6231},
{"f_6187posixunix.scm",(void*)f_6187},
{"f_6179posixunix.scm",(void*)f_6179},
{"f_6141posixunix.scm",(void*)f_6141},
{"f_6163posixunix.scm",(void*)f_6163},
{"f_6167posixunix.scm",(void*)f_6167},
{"f_6029posixunix.scm",(void*)f_6029},
{"f_6035posixunix.scm",(void*)f_6035},
{"f_6056posixunix.scm",(void*)f_6056},
{"f_6133posixunix.scm",(void*)f_6133},
{"f_6060posixunix.scm",(void*)f_6060},
{"f_6063posixunix.scm",(void*)f_6063},
{"f_6066posixunix.scm",(void*)f_6066},
{"f_6073posixunix.scm",(void*)f_6073},
{"f_6075posixunix.scm",(void*)f_6075},
{"f_6092posixunix.scm",(void*)f_6092},
{"f_6102posixunix.scm",(void*)f_6102},
{"f_6106posixunix.scm",(void*)f_6106},
{"f_6050posixunix.scm",(void*)f_6050},
{"f_6017posixunix.scm",(void*)f_6017},
{"f_6021posixunix.scm",(void*)f_6021},
{"f_6024posixunix.scm",(void*)f_6024},
{"f_5982posixunix.scm",(void*)f_5982},
{"f_5986posixunix.scm",(void*)f_5986},
{"f_6006posixunix.scm",(void*)f_6006},
{"f_6010posixunix.scm",(void*)f_6010},
{"f_5963posixunix.scm",(void*)f_5963},
{"f_5967posixunix.scm",(void*)f_5967},
{"f_5936posixunix.scm",(void*)f_5936},
{"f_5940posixunix.scm",(void*)f_5940},
{"f_5917posixunix.scm",(void*)f_5917},
{"f_5921posixunix.scm",(void*)f_5921},
{"f_5924posixunix.scm",(void*)f_5924},
{"f_5858posixunix.scm",(void*)f_5858},
{"f_5862posixunix.scm",(void*)f_5862},
{"f_5868posixunix.scm",(void*)f_5868},
{"f_5855posixunix.scm",(void*)f_5855},
{"f_5839posixunix.scm",(void*)f_5839},
{"f_5831posixunix.scm",(void*)f_5831},
{"f_5803posixunix.scm",(void*)f_5803},
{"f_5810posixunix.scm",(void*)f_5810},
{"f_5775posixunix.scm",(void*)f_5775},
{"f_5782posixunix.scm",(void*)f_5782},
{"f_5736posixunix.scm",(void*)f_5736},
{"f_5753posixunix.scm",(void*)f_5753},
{"f_5757posixunix.scm",(void*)f_5757},
{"f_5661posixunix.scm",(void*)f_5661},
{"f_5671posixunix.scm",(void*)f_5671},
{"f_5693posixunix.scm",(void*)f_5693},
{"f_5690posixunix.scm",(void*)f_5690},
{"f_5680posixunix.scm",(void*)f_5680},
{"f_5628posixunix.scm",(void*)f_5628},
{"f_5632posixunix.scm",(void*)f_5632},
{"f_5614posixunix.scm",(void*)f_5614},
{"f_5605posixunix.scm",(void*)f_5605},
{"f_5599posixunix.scm",(void*)f_5599},
{"f_5590posixunix.scm",(void*)f_5590},
{"f_5555posixunix.scm",(void*)f_5555},
{"f_5497posixunix.scm",(void*)f_5497},
{"f_5501posixunix.scm",(void*)f_5501},
{"f_5507posixunix.scm",(void*)f_5507},
{"f_5526posixunix.scm",(void*)f_5526},
{"f_5513posixunix.scm",(void*)f_5513},
{"f_5414posixunix.scm",(void*)f_5414},
{"f_5420posixunix.scm",(void*)f_5420},
{"f_5424posixunix.scm",(void*)f_5424},
{"f_5432posixunix.scm",(void*)f_5432},
{"f_5458posixunix.scm",(void*)f_5458},
{"f_5462posixunix.scm",(void*)f_5462},
{"f_5450posixunix.scm",(void*)f_5450},
{"f_5399posixunix.scm",(void*)f_5399},
{"f_5407posixunix.scm",(void*)f_5407},
{"f_5382posixunix.scm",(void*)f_5382},
{"f_5393posixunix.scm",(void*)f_5393},
{"f_5397posixunix.scm",(void*)f_5397},
{"f_5356posixunix.scm",(void*)f_5356},
{"f_5380posixunix.scm",(void*)f_5380},
{"f_5363posixunix.scm",(void*)f_5363},
{"f_5313posixunix.scm",(void*)f_5313},
{"f_5320posixunix.scm",(void*)f_5320},
{"f_5341posixunix.scm",(void*)f_5341},
{"f_5337posixunix.scm",(void*)f_5337},
{"f_5285posixunix.scm",(void*)f_5285},
{"f_5263posixunix.scm",(void*)f_5263},
{"f_5267posixunix.scm",(void*)f_5267},
{"f_5248posixunix.scm",(void*)f_5248},
{"f_5252posixunix.scm",(void*)f_5252},
{"f_5233posixunix.scm",(void*)f_5233},
{"f_5237posixunix.scm",(void*)f_5237},
{"f_5215posixunix.scm",(void*)f_5215},
{"f_5144posixunix.scm",(void*)f_5144},
{"f_5163posixunix.scm",(void*)f_5163},
{"f_5169posixunix.scm",(void*)f_5169},
{"f_5105posixunix.scm",(void*)f_5105},
{"f_5133posixunix.scm",(void*)f_5133},
{"f_5129posixunix.scm",(void*)f_5129},
{"f_5122posixunix.scm",(void*)f_5122},
{"f_4849posixunix.scm",(void*)f_4849},
{"f_5045posixunix.scm",(void*)f_5045},
{"f_5040posixunix.scm",(void*)f_5040},
{"f_5035posixunix.scm",(void*)f_5035},
{"f_4851posixunix.scm",(void*)f_4851},
{"f_4855posixunix.scm",(void*)f_4855},
{"f_4961posixunix.scm",(void*)f_4961},
{"f_4962posixunix.scm",(void*)f_4962},
{"f_4979posixunix.scm",(void*)f_4979},
{"f_4989posixunix.scm",(void*)f_4989},
{"f_4947posixunix.scm",(void*)f_4947},
{"f_4903posixunix.scm",(void*)f_4903},
{"f_4939posixunix.scm",(void*)f_4939},
{"f_4918posixunix.scm",(void*)f_4918},
{"f_4928posixunix.scm",(void*)f_4928},
{"f_4912posixunix.scm",(void*)f_4912},
{"f_4907posixunix.scm",(void*)f_4907},
{"f_4910posixunix.scm",(void*)f_4910},
{"f_4857posixunix.scm",(void*)f_4857},
{"f_4892posixunix.scm",(void*)f_4892},
{"f_4873posixunix.scm",(void*)f_4873},
{"f_4378posixunix.scm",(void*)f_4378},
{"f_4774posixunix.scm",(void*)f_4774},
{"f_4769posixunix.scm",(void*)f_4769},
{"f_4764posixunix.scm",(void*)f_4764},
{"f_4759posixunix.scm",(void*)f_4759},
{"f_4380posixunix.scm",(void*)f_4380},
{"f_4384posixunix.scm",(void*)f_4384},
{"f_4390posixunix.scm",(void*)f_4390},
{"f_4632posixunix.scm",(void*)f_4632},
{"f_4638posixunix.scm",(void*)f_4638},
{"f_4734posixunix.scm",(void*)f_4734},
{"f_4724posixunix.scm",(void*)f_4724},
{"f_4718posixunix.scm",(void*)f_4718},
{"f_4640posixunix.scm",(void*)f_4640},
{"f_4690posixunix.scm",(void*)f_4690},
{"f_4647posixunix.scm",(void*)f_4647},
{"f_4657posixunix.scm",(void*)f_4657},
{"f_4556posixunix.scm",(void*)f_4556},
{"f_4564posixunix.scm",(void*)f_4564},
{"f_4566posixunix.scm",(void*)f_4566},
{"f_4614posixunix.scm",(void*)f_4614},
{"f_4547posixunix.scm",(void*)f_4547},
{"f_4551posixunix.scm",(void*)f_4551},
{"f_4526posixunix.scm",(void*)f_4526},
{"f_4536posixunix.scm",(void*)f_4536},
{"f_4514posixunix.scm",(void*)f_4514},
{"f_4501posixunix.scm",(void*)f_4501},
{"f_4505posixunix.scm",(void*)f_4505},
{"f_4496posixunix.scm",(void*)f_4496},
{"f_4499posixunix.scm",(void*)f_4499},
{"f_4414posixunix.scm",(void*)f_4414},
{"f_4426posixunix.scm",(void*)f_4426},
{"f_4463posixunix.scm",(void*)f_4463},
{"f_4472posixunix.scm",(void*)f_4472},
{"f_4466posixunix.scm",(void*)f_4466},
{"f_4442posixunix.scm",(void*)f_4442},
{"f_4445posixunix.scm",(void*)f_4445},
{"f_4406posixunix.scm",(void*)f_4406},
{"f_4391posixunix.scm",(void*)f_4391},
{"f_4405posixunix.scm",(void*)f_4405},
{"f_4351posixunix.scm",(void*)f_4351},
{"f_4358posixunix.scm",(void*)f_4358},
{"f_4361posixunix.scm",(void*)f_4361},
{"f_4306posixunix.scm",(void*)f_4306},
{"f_4310posixunix.scm",(void*)f_4310},
{"f_4345posixunix.scm",(void*)f_4345},
{"f_4328posixunix.scm",(void*)f_4328},
{"f_4292posixunix.scm",(void*)f_4292},
{"f_4304posixunix.scm",(void*)f_4304},
{"f_4278posixunix.scm",(void*)f_4278},
{"f_4290posixunix.scm",(void*)f_4290},
{"f_4263posixunix.scm",(void*)f_4263},
{"f_4276posixunix.scm",(void*)f_4276},
{"f_4226posixunix.scm",(void*)f_4226},
{"f_4234posixunix.scm",(void*)f_4234},
{"f_4201posixunix.scm",(void*)f_4201},
{"f_4190posixunix.scm",(void*)f_4190},
{"f_4194posixunix.scm",(void*)f_4194},
{"f_4159posixunix.scm",(void*)f_4159},
{"f_4183posixunix.scm",(void*)f_4183},
{"f_4167posixunix.scm",(void*)f_4167},
{"f_4170posixunix.scm",(void*)f_4170},
{"f_4121posixunix.scm",(void*)f_4121},
{"f_4154posixunix.scm",(void*)f_4154},
{"f_4142posixunix.scm",(void*)f_4142},
{"f_4150posixunix.scm",(void*)f_4150},
{"f_4146posixunix.scm",(void*)f_4146},
{"f_4096posixunix.scm",(void*)f_4096},
{"f_4112posixunix.scm",(void*)f_4112},
{"f_4081posixunix.scm",(void*)f_4081},
{"f_4091posixunix.scm",(void*)f_4091},
{"f_4085posixunix.scm",(void*)f_4085},
{"f_4075posixunix.scm",(void*)f_4075},
{"f_4069posixunix.scm",(void*)f_4069},
{"f_4063posixunix.scm",(void*)f_4063},
{"f_4039posixunix.scm",(void*)f_4039},
{"f_4061posixunix.scm",(void*)f_4061},
{"f_4057posixunix.scm",(void*)f_4057},
{"f_4049posixunix.scm",(void*)f_4049},
{"f_4009posixunix.scm",(void*)f_4009},
{"f_4037posixunix.scm",(void*)f_4037},
{"f_4033posixunix.scm",(void*)f_4033},
{"f_3982posixunix.scm",(void*)f_3982},
{"f_4007posixunix.scm",(void*)f_4007},
{"f_4003posixunix.scm",(void*)f_4003},
{"f_3918posixunix.scm",(void*)f_3918},
{"f_3914posixunix.scm",(void*)f_3914},
{"f_3934posixunix.scm",(void*)f_3934},
{"f_3852posixunix.scm",(void*)f_3852},
{"f_3856posixunix.scm",(void*)f_3856},
{"f_3861posixunix.scm",(void*)f_3861},
{"f_3877posixunix.scm",(void*)f_3877},
{"f_3789posixunix.scm",(void*)f_3789},
{"f_3847posixunix.scm",(void*)f_3847},
{"f_3793posixunix.scm",(void*)f_3793},
{"f_3796posixunix.scm",(void*)f_3796},
{"f_3828posixunix.scm",(void*)f_3828},
{"f_3799posixunix.scm",(void*)f_3799},
{"f_3804posixunix.scm",(void*)f_3804},
{"f_3818posixunix.scm",(void*)f_3818},
{"f_3786posixunix.scm",(void*)f_3786},
{"f_3711posixunix.scm",(void*)f_3711},
{"f_3769posixunix.scm",(void*)f_3769},
{"f_3718posixunix.scm",(void*)f_3718},
{"f_3728posixunix.scm",(void*)f_3728},
{"f_3732posixunix.scm",(void*)f_3732},
{"f_3741posixunix.scm",(void*)f_3741},
{"f_3745posixunix.scm",(void*)f_3745},
{"f_3755posixunix.scm",(void*)f_3755},
{"f_3736posixunix.scm",(void*)f_3736},
{"f_3691posixunix.scm",(void*)f_3691},
{"f_3703posixunix.scm",(void*)f_3703},
{"f_3699posixunix.scm",(void*)f_3699},
{"f_3677posixunix.scm",(void*)f_3677},
{"f_3689posixunix.scm",(void*)f_3689},
{"f_3685posixunix.scm",(void*)f_3685},
{"f_3617posixunix.scm",(void*)f_3617},
{"f_3663posixunix.scm",(void*)f_3663},
{"f_3624posixunix.scm",(void*)f_3624},
{"f_3634posixunix.scm",(void*)f_3634},
{"f_3638posixunix.scm",(void*)f_3638},
{"f_3642posixunix.scm",(void*)f_3642},
{"f_3646posixunix.scm",(void*)f_3646},
{"f_3650posixunix.scm",(void*)f_3650},
{"f_3594posixunix.scm",(void*)f_3594},
{"f_3604posixunix.scm",(void*)f_3604},
{"f_3571posixunix.scm",(void*)f_3571},
{"f_3581posixunix.scm",(void*)f_3581},
{"f_3533posixunix.scm",(void*)f_3533},
{"f_3566posixunix.scm",(void*)f_3566},
{"f_3537posixunix.scm",(void*)f_3537},
{"f_3544posixunix.scm",(void*)f_3544},
{"f_3548posixunix.scm",(void*)f_3548},
{"f_3552posixunix.scm",(void*)f_3552},
{"f_3556posixunix.scm",(void*)f_3556},
{"f_3560posixunix.scm",(void*)f_3560},
{"f_3515posixunix.scm",(void*)f_3515},
{"f_3500posixunix.scm",(void*)f_3500},
{"f_3494posixunix.scm",(void*)f_3494},
{"f_3462posixunix.scm",(void*)f_3462},
{"f_3468posixunix.scm",(void*)f_3468},
{"f_3438posixunix.scm",(void*)f_3438},
{"f_3456posixunix.scm",(void*)f_3456},
{"f_3445posixunix.scm",(void*)f_3445},
{"f_3420posixunix.scm",(void*)f_3420},
{"f_3430posixunix.scm",(void*)f_3430},
{"f_3407posixunix.scm",(void*)f_3407},
{"f_3398posixunix.scm",(void*)f_3398},
{"f_3351posixunix.scm",(void*)f_3351},
{"f_3355posixunix.scm",(void*)f_3355},
{"f_3331posixunix.scm",(void*)f_3331},
{"f_3335posixunix.scm",(void*)f_3335},
{"f_3341posixunix.scm",(void*)f_3341},
{"f_3345posixunix.scm",(void*)f_3345},
{"f_3311posixunix.scm",(void*)f_3311},
{"f_3315posixunix.scm",(void*)f_3315},
{"f_3321posixunix.scm",(void*)f_3321},
{"f_3325posixunix.scm",(void*)f_3325},
{"f_3287posixunix.scm",(void*)f_3287},
{"f_3291posixunix.scm",(void*)f_3291},
{"f_3302posixunix.scm",(void*)f_3302},
{"f_3306posixunix.scm",(void*)f_3306},
{"f_3296posixunix.scm",(void*)f_3296},
{"f_3263posixunix.scm",(void*)f_3263},
{"f_3267posixunix.scm",(void*)f_3267},
{"f_3278posixunix.scm",(void*)f_3278},
{"f_3282posixunix.scm",(void*)f_3282},
{"f_3272posixunix.scm",(void*)f_3272},
{"f_3247posixunix.scm",(void*)f_3247},
{"f_3251posixunix.scm",(void*)f_3251},
{"f_3254posixunix.scm",(void*)f_3254},
{"f_3211posixunix.scm",(void*)f_3211},
{"f_3242posixunix.scm",(void*)f_3242},
{"f_3232posixunix.scm",(void*)f_3232},
{"f_3225posixunix.scm",(void*)f_3225},
{"f_3175posixunix.scm",(void*)f_3175},
{"f_3206posixunix.scm",(void*)f_3206},
{"f_3196posixunix.scm",(void*)f_3196},
{"f_3189posixunix.scm",(void*)f_3189},
{"f_3160posixunix.scm",(void*)f_3160},
{"f_3173posixunix.scm",(void*)f_3173},
{"f_3154posixunix.scm",(void*)f_3154},
{"f_3142posixunix.scm",(void*)f_3142},
{"f_2825posixunix.scm",(void*)f_2825},
{"f_3132posixunix.scm",(void*)f_3132},
{"f_2952posixunix.scm",(void*)f_2952},
{"f_3118posixunix.scm",(void*)f_3118},
{"f_3107posixunix.scm",(void*)f_3107},
{"f_3114posixunix.scm",(void*)f_3114},
{"f_2971posixunix.scm",(void*)f_2971},
{"f_3100posixunix.scm",(void*)f_3100},
{"f_3079posixunix.scm",(void*)f_3079},
{"f_3096posixunix.scm",(void*)f_3096},
{"f_3085posixunix.scm",(void*)f_3085},
{"f_3092posixunix.scm",(void*)f_3092},
{"f_3015posixunix.scm",(void*)f_3015},
{"f_3076posixunix.scm",(void*)f_3076},
{"f_3055posixunix.scm",(void*)f_3055},
{"f_3072posixunix.scm",(void*)f_3072},
{"f_3061posixunix.scm",(void*)f_3061},
{"f_3068posixunix.scm",(void*)f_3068},
{"f_3028posixunix.scm",(void*)f_3028},
{"f_3052posixunix.scm",(void*)f_3052},
{"f_3048posixunix.scm",(void*)f_3048},
{"f_3009posixunix.scm",(void*)f_3009},
{"f_2978posixunix.scm",(void*)f_2978},
{"f_2996posixunix.scm",(void*)f_2996},
{"f_2981posixunix.scm",(void*)f_2981},
{"f_2985posixunix.scm",(void*)f_2985},
{"f_2965posixunix.scm",(void*)f_2965},
{"f_2946posixunix.scm",(void*)f_2946},
{"f_2832posixunix.scm",(void*)f_2832},
{"f_2839posixunix.scm",(void*)f_2839},
{"f_2841posixunix.scm",(void*)f_2841},
{"f_2848posixunix.scm",(void*)f_2848},
{"f_2912posixunix.scm",(void*)f_2912},
{"f_2921posixunix.scm",(void*)f_2921},
{"f_2909posixunix.scm",(void*)f_2909},
{"f_2854posixunix.scm",(void*)f_2854},
{"f_2890posixunix.scm",(void*)f_2890},
{"f_2886posixunix.scm",(void*)f_2886},
{"f_2882posixunix.scm",(void*)f_2882},
{"f_2871posixunix.scm",(void*)f_2871},
{"f_2867posixunix.scm",(void*)f_2867},
{"f_2769posixunix.scm",(void*)f_2769},
{"f_2778posixunix.scm",(void*)f_2778},
{"f_2802posixunix.scm",(void*)f_2802},
{"f_2814posixunix.scm",(void*)f_2814},
{"f_2820posixunix.scm",(void*)f_2820},
{"f_2808posixunix.scm",(void*)f_2808},
{"f_2784posixunix.scm",(void*)f_2784},
{"f_2790posixunix.scm",(void*)f_2790},
{"f_2776posixunix.scm",(void*)f_2776},
{"f_2758posixunix.scm",(void*)f_2758},
{"f_2753posixunix.scm",(void*)f_2753},
{"f_2712posixunix.scm",(void*)f_2712},
{"f_2725posixunix.scm",(void*)f_2725},
{"f_2689posixunix.scm",(void*)f_2689},
{"f_2710posixunix.scm",(void*)f_2710},
{"f_2696posixunix.scm",(void*)f_2696},
{"f_2535posixunix.scm",(void*)f_2535},
{"f_2640posixunix.scm",(void*)f_2640},
{"f_2648posixunix.scm",(void*)f_2648},
{"f_2635posixunix.scm",(void*)f_2635},
{"f_2537posixunix.scm",(void*)f_2537},
{"f_2544posixunix.scm",(void*)f_2544},
{"f_2547posixunix.scm",(void*)f_2547},
{"f_2550posixunix.scm",(void*)f_2550},
{"f_2634posixunix.scm",(void*)f_2634},
{"f_2554posixunix.scm",(void*)f_2554},
{"f_2568posixunix.scm",(void*)f_2568},
{"f_2578posixunix.scm",(void*)f_2578},
{"f_2581posixunix.scm",(void*)f_2581},
{"f_2584posixunix.scm",(void*)f_2584},
{"f_2590posixunix.scm",(void*)f_2590},
{"f_2600posixunix.scm",(void*)f_2600},
{"f_2511posixunix.scm",(void*)f_2511},
{"f_2533posixunix.scm",(void*)f_2533},
{"f_2529posixunix.scm",(void*)f_2529},
{"f_2487posixunix.scm",(void*)f_2487},
{"f_2509posixunix.scm",(void*)f_2509},
{"f_2505posixunix.scm",(void*)f_2505},
{"f_2386posixunix.scm",(void*)f_2386},
{"f_2459posixunix.scm",(void*)f_2459},
{"f_2473posixunix.scm",(void*)f_2473},
{"f_2399posixunix.scm",(void*)f_2399},
{"f_2456posixunix.scm",(void*)f_2456},
{"f_2404posixunix.scm",(void*)f_2404},
{"f_2409posixunix.scm",(void*)f_2409},
{"f_2432posixunix.scm",(void*)f_2432},
{"f_2452posixunix.scm",(void*)f_2452},
{"f_2415posixunix.scm",(void*)f_2415},
{"f_2429posixunix.scm",(void*)f_2429},
{"f_2318posixunix.scm",(void*)f_2318},
{"f_2331posixunix.scm",(void*)f_2331},
{"f_2343posixunix.scm",(void*)f_2343},
{"f_2337posixunix.scm",(void*)f_2337},
{"f_2309posixunix.scm",(void*)f_2309},
{"f_2316posixunix.scm",(void*)f_2316},
{"f_2300posixunix.scm",(void*)f_2300},
{"f_2307posixunix.scm",(void*)f_2307},
{"f_2291posixunix.scm",(void*)f_2291},
{"f_2298posixunix.scm",(void*)f_2298},
{"f_2282posixunix.scm",(void*)f_2282},
{"f_2289posixunix.scm",(void*)f_2289},
{"f_2273posixunix.scm",(void*)f_2273},
{"f_2280posixunix.scm",(void*)f_2280},
{"f_2264posixunix.scm",(void*)f_2264},
{"f_2271posixunix.scm",(void*)f_2271},
{"f_2255posixunix.scm",(void*)f_2255},
{"f_2262posixunix.scm",(void*)f_2262},
{"f_2246posixunix.scm",(void*)f_2246},
{"f_2253posixunix.scm",(void*)f_2253},
{"f_2237posixunix.scm",(void*)f_2237},
{"f_2244posixunix.scm",(void*)f_2244},
{"f_2231posixunix.scm",(void*)f_2231},
{"f_2235posixunix.scm",(void*)f_2235},
{"f_2225posixunix.scm",(void*)f_2225},
{"f_2229posixunix.scm",(void*)f_2229},
{"f_2219posixunix.scm",(void*)f_2219},
{"f_2223posixunix.scm",(void*)f_2223},
{"f_2213posixunix.scm",(void*)f_2213},
{"f_2217posixunix.scm",(void*)f_2217},
{"f_2207posixunix.scm",(void*)f_2207},
{"f_2211posixunix.scm",(void*)f_2211},
{"f_2201posixunix.scm",(void*)f_2201},
{"f_2205posixunix.scm",(void*)f_2205},
{"f_2176posixunix.scm",(void*)f_2176},
{"f_2180posixunix.scm",(void*)f_2180},
{"f_2139posixunix.scm",(void*)f_2139},
{"f_2171posixunix.scm",(void*)f_2171},
{"f_2164posixunix.scm",(void*)f_2164},
{"f_2143posixunix.scm",(void*)f_2143},
{"f_1947posixunix.scm",(void*)f_1947},
{"f_2120posixunix.scm",(void*)f_2120},
{"f_1963posixunix.scm",(void*)f_1963},
{"f_2094posixunix.scm",(void*)f_2094},
{"f_1969posixunix.scm",(void*)f_1969},
{"f_1972posixunix.scm",(void*)f_1972},
{"f_2054posixunix.scm",(void*)f_2054},
{"f_2052posixunix.scm",(void*)f_2052},
{"f_2011posixunix.scm",(void*)f_2011},
{"f_2029posixunix.scm",(void*)f_2029},
{"f_2027posixunix.scm",(void*)f_2027},
{"f_2015posixunix.scm",(void*)f_2015},
{"f_1945posixunix.scm",(void*)f_1945},
{"f_1943posixunix.scm",(void*)f_1943},
{"f_1941posixunix.scm",(void*)f_1941},
{"f_1909posixunix.scm",(void*)f_1909},
{"f_1916posixunix.scm",(void*)f_1916},
{"f_1922posixunix.scm",(void*)f_1922},
{"f_1929posixunix.scm",(void*)f_1929},
{"f_1870posixunix.scm",(void*)f_1870},
{"f_1877posixunix.scm",(void*)f_1877},
{"f_1886posixunix.scm",(void*)f_1886},
{"f_1828posixunix.scm",(void*)f_1828},
{"f_1838posixunix.scm",(void*)f_1838},
{"f_1841posixunix.scm",(void*)f_1841},
{"f_1844posixunix.scm",(void*)f_1844},
{"f_1813posixunix.scm",(void*)f_1813},
{"f_1775posixunix.scm",(void*)f_1775},
{"f_1805posixunix.scm",(void*)f_1805},
{"f_1792posixunix.scm",(void*)f_1792},
{"f_1795posixunix.scm",(void*)f_1795},
{"f_1736posixunix.scm",(void*)f_1736},
{"f_1695posixunix.scm",(void*)f_1695},
{"f_1692posixunix.scm",(void*)f_1692},
{"f_1674posixunix.scm",(void*)f_1674},
{"f_1678posixunix.scm",(void*)f_1678},
{"f_1689posixunix.scm",(void*)f_1689},
{"f_1685posixunix.scm",(void*)f_1685},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
