class CannotSaveError: pass

class BaseAccountManager:
	def get_accounts_dicts(self): 
		"""
		must return a list of accounts dictionaries
		"""
		raise NotImplementedError()
	def remove_account(self, id): raise NotImplementedError()
	
	
	def update_account(self, id, dic):
		"""
		Update account id with the new dic
		"""
		self.remove_account(id)
		self.add_account(dic, force_id = id)

	def add_account(self, dic): 
		"""
		return the account id
		"""
		raise NotImplementedError()

	def store_accounts_dicts(self, dicts): 
		"""
		Set the accounts dicts to dicts
		"""
		for account in dicts:
			self.add_account(account)

	def reset(self): 
		"""
		This method must reset the account manager.
		After this method account manager store support
		(xml file, gnome keyring) must be empty
		"""
		raise NotImplementedError()
