import gtk
import gconf

from XMLAccounts import XMLAccounts
from keyringaccounts import KeyringAccounts
from gconfhelper import GconfHelper
from baseaccountmanager import CannotSaveError


class CannotSetDefault(Exception): pass

class AccountManager:
	def __init__(self):
		gconf_helper = GconfHelper()
		self.use_gnome_keyring = gconf_helper.get_key("use_gnome_keyring")

	def get_manager(self):
		if self.use_gnome_keyring:
			return KeyringAccounts()
		else:
			return XMLAccounts()
	
	def set_keyring_default(self):
		print "Setting keyring as default account manager ..."
		xml = XMLAccounts()
		keyring = KeyringAccounts()
		keyring.reset()
		dicts = xml.get_accounts_dicts()
		try:
			keyring.store_accounts_dicts(dicts)
			xml.reset()
		except CannotSaveError:
			raise CannotSetDefault()
		print "...done"
	
	def set_xml_default(self):
		print "Setting xml file as default account manager..."
		xml = XMLAccounts()
		xml.reset()
		keyring = KeyringAccounts()
		dicts = keyring.get_accounts_dicts()
		try:
			xml.store_accounts_dicts(dicts)
			keyring.reset()
		except CannotSaveError:
			raise CannotSetDefault()
		print "...done"

if __name__ == "__main__":
	AccountManager()
