#ifndef H_CDW_NCURSES
#define H_CDW_NCURSES

#include <stddef.h>
#include <ncursesw/ncurses.h>
#include <ncursesw/form.h>
#include <ncursesw/menu.h>

#include "main.h"
#include "cdw_colors.h"


/* type of data that can be put in input field, and if it should be invisible */
enum {
	CDW_NCURSES_INPUT_NONE = 0,
	CDW_NCURSES_INPUT_HIDDEN = 1,
	CDW_NCURSES_INPUT_INTEGER = 2,
	CDW_NCURSES_INPUT_NUMERIC = 4
};



cdw_rv_t cdw_ncurses_init(void);
void cdw_ncurses_clean(void);

cdw_rv_t cdw_ncurses_get_field_buffer(FIELD *field, char **buffer, size_t limit);
const char *cdw_ncurses_error_string(int ret_val);
FORM *cdw_ncurses_new_form(WINDOW *window, WINDOW *subwindow, FIELD *field[]);
FIELD *cdw_ncurses_new_input_field(size_t n_lines, size_t n_cols, size_t begin_y, size_t begin_x, const char *initial_string, size_t len_max, int input_type, cdw_colors_t colors);
cdw_rv_t cdw_ncurses_nice_box(WINDOW *window, const char *top_string, const char *bottom_string);
void cdw_ncurses_delete_menu_and_items(MENU **menu);
const char *cdw_ncurses_key_label(int c);
WINDOW *cdw_ncurses_window_new(WINDOW *window, int n_lines, int n_cols, int begin_y, int begin_x, chtype cdw_colors, const char *top_string, const char *bottom_string);

#endif /* H_CDW_NCURSES */


