# This is the main tcl library for all of the help related functions

proc help {} {
catch {destroy .help}
toplevel .help
wm title .help {Help!}

button .help.ok -text {This Rules!} -command {destroy .help}
text .help.t -width 60 -height 18 -yscrollcommand {.help.sb set} -wrap word
scrollbar .help.sb -orient v -command {.help.t yview}

pack .help.ok -side bottom
pack .help.t -side left
pack .help.sb -side left -fill y

.help.t insert 1.0 "About CDRBQ version [version]"
.help.t insert end {

This is a graphical front-end for the excellent programs 'mkisofs', 'cdrecord', 'cdrdao' and 'cdparanoia'.

It's good for:
	o Avoiding coasters due to command-line mistakes
	o Eliminating the tedium of consulting documentation
	o Feeling more secure in a correct set of options
	o Being lazy

As you can guess, I wrote it for what it's good for.

CDRBQ is copyright 1999 Ian Kjos <brooke@jump.net>
CDRBQ is maintained by Brad Hudson <domito@rogers.com>

CDRBQ contains some code contributed by:
  Brad Hudson <domito@rogers.com>
  Daniel Caujolle-Bert <lobadia@club-internet.fr>
  Andrew Williams <woodchuk@bellatlantic.net>
  Claus Brunzema <chb@ossi.fho-emden.de>
  Aaron Sherman <ajs@ajs.com>
  Fred D. Feirtag <fdfeirt@valinor.sandia.gov>
  And a cast of thousands!

  If you don't see your name here and you should,
  please send me some e-mail about it. Preferably
  with a diff.

CDR-Toaster is availible under the GNU General
Public License version 2.0 or later (at your option).
This license can be found at
http://www.gnu.org/copyleft/gpl.html

}

.help.t config -state disabled

}

proc help_clarify {} {
catch {destroy .help}
toplevel .help
wm title .help {Help!}

set helpstuff {
	{Pre-made data track}
{  Select this option to burn a disk image from your
  hard drive to CDR/RW.  Supported formats are
  ISO-9660 (.iso), XCDRoast (.raw) and CUE/BIN (.cue).
  Quick and dirty: select your image, device and speed,
  then hit F1 to burn.
}
	{Make data track on the fly}
{  Use this option to burn the contents of a directory
  to a CD.
  Quick and dirty: select the directory, device and
  speed, then hit F1 to burn.
}
	{Audio only disk}
{
  Burn your audio or mp3 files to CDR.
  Quick and dirty: add your audio tracks, select your
  device and speed, then hit F1 to burn.
}
	{Read CD-ROM to create ISO image}
{  Selecting this will allow you to create an image
  of the CD-ROM on your hard drive in ISO9660 format.
}
	{Read CD-ROM to create CUE/BIN image}
{  Selecting this will allow you to create an image
  of the CD-ROM on your hard drive in CDRWin's (tm)
  CUE/BIN format.  This uses cdrdao to rip the bin
  image, and then uses CDRBQs own toc2cue process.
  Note:  The conversion from toc to cue is a bit
  complex and I know I have not covered all types
  of CDs.  If you have a type of CD that I cannot
  convert to a good cue file, please email me with
  toc file from your disk and a good cue file from
  CDRWin if possible.
}
	{Read Audio Tracks from CD-ROM}
{  Use this to "rip" audio tracks from your
  favorite CD to .wav files on your hard drive.
}
	{Blank a CDR/W media}
{  Need to re-use that CDRW disk?  You can erase
  all the files here.
}
	{Fixate a multisession CD}
{  If you have created a multisession CD by
  unselecting "fixate CD", you can use this to
  finalize the CD after the fact.
}
	{All Files}
{  Ordinarily files with names containing '#' or '~'
  are backup files on Linux. CDRBQ will instruct
  mkisofs to skip these files in the creation of a
  CD. If you DON'T want to skip them, click this box.
}
	{Joliet support}
{  This stores long filenames on a CD so Windows 9x/NT
  machines can read them. Unlike the Joliet CDs produced
  on MS-Windows, you can still see the 8.3 filenames on
  MS-Dos and other systems that don't support Joliet.
  Linux kernels 2.2 and up can also read Joliet names.
}
	{Rock Ridge}
{  This is another way to store long filenames on a CD.
  It works with all Un*x-like systems that also support
  CDs. It allows file permissions, ownership info, and
  symbolic links to be stored and appear as such on the
  CD. If you choose "Literal", the final CD will look in
  all respects identical to the directory hierarchy it
  was created from, except for some reason you can't
  write to it. This could be good for system backups.
  If you choose "Rationalized", you get a more generally
  useful CD. It sets the user and group of all files to
  root, removes SUID and SGID bits, makes all files and
  folders readable globally, sets all execute bits for
  anything that has any execute bits, and clears all
  write bits.
}
	{Follow SymLinks}
{  Normally symbolic links are ignored, unless you use
  Rock Ridge, when they are copied literally. If you
  want the actual files and folders pointed to by the
  symbolic links to show up on the CD, check this box.
}
	{Translation Tables}
{   Puts a file called "TRANS.TBL" in every directory on
  the CD which maps 8.3 files to their long equivalents.
  Very simple, very old.
}
	{DAO support}
{  Disk at Once mode is a special writing mode wherein
  the burner will write the CD in one continuous track,
  instead of the default 'Track at Once' mode.  This is
  useful for making audio CDs with no space between
  tracks.
}
	{Buffer Protection}
{  Modern CDR/RW drives have what is known as "Buffer
  Underrun Protection".  This is sometimes called Burn-
  Proof, or ExactLink or something similar.  Use this
  option if your drive supports it.
}
	{Fixate CD}
{  If you are creating a multisession CD then you can use
  this leave the disk open for additional sessions.  This
  option must be selected for all tracks excluding the
  final track.  If this is selected the disk will be
  finalized and no sessions can be added.  If you Have
  created a multisession CD and you need to fixate it,
  check out the "Do Tricks" menu.
}
	{Allow Overburn}
{  Overburning allows you to write more than 650Mb or 74
  minutes of music on a CD.  Not all drives support this
  option, and you need to use a CD capable of handling
  the extra data; typically these disks are 800Mb or 80
  minutes.
}
	{CD-ROM Mode 1}
{  If  this  flag  is present, all subsequent tracks are
  written in CD-ROM mode 1 (Yellow Book) format.
  The data is a  multiple  of 2048 bytes.  The file with
  track data should contain an ISO-9660 or Rock Ridge
  filesystem image (see mkisofs for  more details).  If
  the  track  data  is  an ufs filesystem image, fragment
  size should be set to 2 KB or more to allow CR-drives
  with 2 KB sector size to to be used for reading.
}
	{CD-ROM Mode 2}
{
  If  this  flag  is present, all subsequent tracks are
  written in CD-ROM mode 2 format. The data is a
  multiple of 2048 bytes.
}
	{CD-ROM XA Mode 1 and 2}
{
  If this flag is present, all subsequent tracks  are
  written  in CD-ROM XA mode 1 format. The data
  is a multiple of 2048 bytes.

  CD-ROM XA (for eXtended Architecture) discs
  contain Mode 2 sectors and were designed to
  allow audio and other data to be interleaved and
  read simultaneously. This avoids the need to
  load images first and then play CD audio tracks.
}
	{CDI Audio}
{
  If this  flag is present, all subsequent tracks
  are  written  in CDI format. The data is a
  multiple of 2048 bytes.

  CD-I Bridge is a Philips/Sony
  specification, for discs intended to play on
  CD-i players and other platforms such as
  the PC.
}
	{CDRDAO (cue/bin) special driver options}
{
  Some drives are not autodetected in cdrdao, or you
  may need a special driver for other reasons.  My 
  new LG 52x drive requires that I set it to 
  generic-mmc to work.  If your burner works without 
  this, then you should not use it.  If it does not 
  work, cdrdao should suggest which driver to use when 
  it fails.

  For more information on these drivers, see the docs
  for cdrdao.
}
	{MPEG Compressed Audio}
{  CDRBQ will extract MPEG Compressed audio (mp3)
  if you have mpg123 and sox installed. This way you
  can burn an audio CD from mp3 files. The sound will
  not be as good quality as the original uncompressed
  audio, but that's the trade off that a lossy compression
  like MPEG makes to attain the high ratios that it does.
  For more information, point your web browser at these:
  http://www.mpeg.org/MPEG/
  http://drogo.cselt.stet.it/mpeg/
}
	{PCM vs. WAV}
{  WAV is a format composed of 44 bytes of header data,
  then raw PCM data. PCM means only pulse code modulation,
  which is to say a digitial audio format made of numbers
  to signify each sample. There is no attempt made to
  compress the signals beyond the decisions of sample rate
  and dynamic range.

  For CDRBQ to burn audio, you can feed it either a
  raw PCM file or a WAV file. WAV files are better because
  they contain enough information in the header to ensure
  that the audio format is correct. To get an audio track
  to burn properly, the PCM data needs to be composed of
  exactly the same structure as on a CD - that is 41.1 khz
  16 bit stereo. Anything else and you get an unusable
  audio track.

  When using WAV files ripped from a CD, (as CDPARANOIA
  does) you will get files that are already correct. If
  you want to use a WAV file you recorded yourself, it is
  wise to ensure you recorded cd-quality (16 bit stereo
  44.1khz) uncompressed audio. If you did otherwise, there
  are many format converters available which can convert to
  this format without any signal loss. The other issue with
  audio files you record yourself is that they must be a
  precise multiple of 1/75th of a second. This is where
  audio padding comes into play. If you do not have the
  right number of samples, the Pad Audio option can round
  up using absolute silence.
}
	{Burning Bootable CDs}
{  When your computer boots from a CD, it treats part of
  the CD as a floppy drive. The emulation is at the BIOS
  level, so programs like the Linux Kernel operate
  normally but programs like LILO or SYSLINUX are fooled.
  All attempts to access the (primary) floppy drive are
  mapped to the "BOOT" extent on the CD.

  Step by step, the easiest way to make a bootable CD
  is as follows:

  1. Make a real live floppy disk that boots your computer
     ok. There are many rescue disk packages which are
     good for this purpose, or you can use your operating
     system install disk. Make sure the floppy actually
     boots properly.

  2. Copy this floppy disk to an image file. Under Linux
     you can type:
		dd if=/dev/fd0 of=bootimage.bin bs=18k

  3. Put this file in the directory you are going to make
     your CD from:
		mv bootimage.bin /tmp/my_cdrom/

  4. Bring up CDRBQ. Put a check in the "El Torito
     Bootable CD" box, and click the "Boot Setup" button.

  5. For "Boot Image Path" type "bootimage.bin"

  6. For "Boot Catalog Path" type "bootcat.bin"

  7. Click OK, and set the "Root of Tree" appropriately.
      From the example above, it would be "/tmp/my_cdrom"

  8. Finish burning your CD as you would normally.

  9. Set your bios to boot from CD, and things should
      be happy.

  The Boot Catalog is a place for information about the
  Boot Image. It is generated automatically. It need not
  exist beforehand. In fact, if it does exist, it will
  be overwritten.

  Both paths are interpretted relative to the root
  of the CD.

  For more information, see "man mkisofs". It should be on
  your system for CDRBQ to operate properly.
}
	{Using ATAPI CDR(W) Devices}
{  ATAPI CDR(W)s are special. The Linux kernel needs to be 
  compiled specially for them to work properly.

  If you have never compiled a kernel before, you are wise 
  to read the Kernel Howto.

  I tend to use "make menuconfig" to configure the kernel, 
  and these are the things I did:

  Under "Block devices", I set "Include IDE/ATAPI CDROM 
  support" to "n" and I set "SCSI emulation support" to 
  "Y" (or "M" if you prefer to compile as a module).

  Under "SCSI support", I make sure there is "SCSI CD-ROM 
  support" and "SCSI generic support" turned on. Since I
  have no true SCSI cards, I need nothing from the "SCSI 
  low-level drivers" section.

  Once the kernel has been compiled and installed you will
  need to append the directive "hdx=ide-scsi" to your boot
  command.  This can be done automatically by editing the
  /etc/lilo.conf and adding the following under your kernel
  image section:

	append="hdc=ide-scsi"

  Be sure to replace "hdc" with your proper device.  
  Similar things can be done with other boot loaders, 
  but I will not get into those.

  I built and installed this kernel. As a result, my 
  CD-ROM detected as a scsi device (/dev/scd0 in my case) 
  during bootup and I have been able to burn to /dev/sg0 
  as is the default in CDRBQ.

  For more information on the special needs of your 
  CDR(W), see the documentation for "cdrecord" which is 
  the burn program that CDRBQ calls out to.
}
}

frame .help.b

set m .help.b.topic.m
menubutton .help.b.topic -menu $m -text Topic -relief raised
menu $m

button .help.b.ok -text {This Rules!} -command {destroy .help}
text .help.t -width 60 -height 18 -yscrollcommand {.help.sb set} -wrap word
scrollbar .help.sb -orient v -command {.help.t yview}

pack .help.b -side bottom -fill x
pack .help.b.topic -side left
pack .help.b.ok -side bottom
pack .help.t -side left
pack .help.sb -side left -fill y

.help.t insert 1.0 {Clarifications:

}

foreach {topic body} $helpstuff {
	set end [.help.t index end]
	set line [expr $end - 1]
	$m add command -label $topic -command ".help.t yview $line"
	.help.t insert end " o $topic\n"
	.help.t insert end "$body\n"
	.help.t tag add head $line $end
}

.help.t tag configure head -foreground white -background blue -font 8x16

.help.t tag add top 1.0 2.0
.help.t tag config top -foreground white -background blue -font 10x20

.help.t config -state disabled

}
