#ifndef __ILLUM_H__
#define __ILLUM_H__

#include "vector.h"
#include "keyvalue.h"

#define RXR	0
#define IXR	1
#define RYR	2
#define IYR	3
#define RZR	4
#define IZR	5
#define RXL	6
#define IXL	7
#define RYL	8
#define IYL	9
#define RZL	10
#define IZL	11

typedef struct
{
	/* This first set of parameters is generated by telescope 
	 * specific code
	 */
	Matrix *E;
	Matrix A, P;			/* amp / phase */
	Matrix B;			/* blockage matrix */
	double dA;			/* area of each pixel (m^2) */
	double prispilleff, subspilleff;
	double spilleff, surfeff, diffeff, misceff;
	double a0;			/* area of primary (m^2) */
	double lambda;			/* wavelength (m) */
	double groundfrac;		/* fraction of power hitting ground */
	double Tsky, Tground, Trec;
	double Xangle;
	int gridsize;
	int pixelsperbeam;
	char *prefix;
	
	/* This second set of parameters are derived by calcIllumparams()
	 * based on the above values
	 */
	double pTground, pTsky, pTrec;	/* partial temperatures */
	double Tsys;
	double gain;
	double blockeff, illumeff, ampeff, phaseeff;
	double efficiency;
	double aeff;
	double pointx, pointy;	/* pointing offsets in radians */
	double fwhm_x, fwhm_y;
	double peaksidelobe;

	/* A third set of parameters could be added that are derived from
	 * calcIllumpolparams()
	 */

	double beampixelscale;

	/* these are control parameters */
	int savejonesmatrices;
	int savestokesimages;
	int saveapertureimages;
	int saveparams;
} Illum;

Illum *newIllum(int N);
void setIllumfromKeyValue(Illum *I, const struct KeyValue *kv);
void deleteIllum(Illum *I);
void printIllum(const Illum *I);
void dephaseIllum(Illum *I);
void calcIllumparams(Illum *I);
void calcIllumpolparams(Illum *I);
void KeyValueupdateIllum(struct KeyValue *kv, const Illum *I);

#endif
