#ifndef VIDEO_DEVICE_LINUX_HPP
#define VIDEO_DEVICE_LINUX_HPP

#include <qglobal.h>

#include <qsocketnotifier.h>
#include <qtimer.h>

#include "videodev.h"
#include <sys/ioctl.h>

#include "VideoDevice.h"
#include "VideoDeviceOptions.h"
#include "VideoSettingsDlg.h"

class CVideoDeviceInput;
class CVideoAudioInput;

class CVideoDeviceLinux: public CVideoDevice
{
friend class CVideoDeviceInput;
friend class CVideoAudioInput;
   Q_OBJECT
private:
   int m_CamFD;
   bool m_HasFramerate;
   int m_Framerate;
   bool m_StopCapture;
   QWaitCondition m_CaptureFinished;

   QSize m_MaxSize, m_MinSize;
   QSize m_RequestedSize;

   uchar *vid_io_buffer;                // The buffer used for I/O; this can be mmap()ed or malloc()ed
   QArray<int> vid_io_offsets;          //, rgb_vid_offsets, yuv_vid_offsets;
   int vid_io_buffer_size, vid_io_image_size;
   int m_Palette;

   QVector<CVideoDeviceInput> m_VideoInputs;
   int m_CurrentVideoInput;
   QVector<CVideoDeviceTuner> m_Tuners;
   int m_CurrentTuner;
   QVector<CVideoAudioInput> m_AudioInputs;
   int m_CurrentAudioInput;

   CVideoDeviceOptions *m_pSettings;
   CVideoSettingsDlg *pSettingsDlg;

   struct video_picture m_VPic;
   struct video_mbuf m_VMBuf;
   struct video_mmap m_VMMap;

   bool TryPalette(int palette, int depth);
   void SetPalette();

   virtual void CreateImagesRGB();
   virtual void DeleteImagesRGB();
   virtual void CreateImagesYUV();
   virtual void DeleteImagesYUV();

private slots:
   void VideoInputSwitched(int);
   void NewFrequency(float);

protected:
   virtual bool Init();
   virtual void Exit();

   virtual bool StartCapture();
   virtual void StopCapture();

   virtual void run();

public:
   CVideoDeviceLinux(const QString &node_name);
   ~CVideoDeviceLinux();

   void SetConfiguration(const QDomNode &);
   void GetConfiguration(QDomNode &) const;

   virtual long GetDescriptor() const;

   virtual void Mute(bool on) const;

   /* These are for Linux only */
   QSize GetMinSize() const;
   QSize GetMaxSize() const;
   void SetSize(const QSize &new_size);
   bool HasFramerate() const;
   int GetFramerate() const;
   void SetFramerate(int fps);

   int GetBrightness() const;
   bool SetBrightness(int val);
   int GetContrast() const;
   bool SetContrast(int val);
   int GetHue() const;
   bool SetHue(int val);
   int GetColour() const;
   bool SetColour(int val);
   int GetWhiteness() const;
   bool SetWhiteness(int val);

   virtual int GetNumberOfInputs() const;
   virtual void SetInput(int);
   virtual int GetInput() const;
   virtual int GetNumberOfTuners() const;
   virtual void SetTuner(int);
   virtual int GetTuner() const;

   CVideoDeviceInput *GetVideoInput(int number = -1) const;
   CVideoDeviceTuner *GetVideoTuner(int number = -1) const;

public: /* overloaded slots */
   virtual void ShowDisplayDialog();
   virtual void ShowFormatDialog();
   virtual void ShowSourceDialog();
};

#endif
