#ifndef WEBCAMCODEC_SUBBAND_HPP
#define WEBCAMCODEC_SUBBAND_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qtimer.h>

#include "VideoDevice.h"

#include "CamWindow.h"
#include "CodecImage.h"
#include "CodecImageSubband.h"
#include "CodecImageViewer.h"
#include "BasicPanel.h"
#include "ImagePanelRGB.h"
#include "ImagePanelYUV.h"

class CWebCamCodecSubband: public CCamWindow
{
   Q_OBJECT
private:
   CVideoDevice *m_pVideo;

   YUVTriplet<CCodecImage> m_SourceFrame[2]; // original images from webcam
   int m_PreviousFrame, m_CurrentFrame, m_MaxFrames;
   CCamPanel *m_pSourceViewer;

   YUVTriplet<CCodecImage> m_Diff;
   CCodecImageViewer *m_pDiffViewer;

   YUVTriplet<CCodecImageSubband> m_CodecSubband;
   CCodecImageViewer *m_pSubbandViewer;

   YUVTriplet<CCodecImageSubband> m_InverseSubband;
   CCodecImageViewer *m_pInverseViewer;

   YUVTriplet <CCodecImage> m_Reconstructed;
   CCodecImageViewer *m_pReconstructedViewer;

   QTimer *m_pSizeTimer;        ///< Helper timer for adjustSize()
   int m_Rows, m_Cols;
   int m_CellWidth, m_CellHeight;

   void PutAtGrid(int row, int column, QWidget *w);

protected:
   void RecalcTotalViewSize();

protected slots:
   void DeviceChangedSize(const QSize &size);
   void DeviceError(int err_no);

   void CallAdjustSize();
   void VideoFrameReady();

public:
   CWebCamCodecSubband(CVideoDevice *video, QWidget *parent = 0, const char *name = 0);
   virtual ~CWebCamCodecSubband();
};


#endif
