/* 
 *
 *   Kodak ESP Cxxx (OPL?) Control Language filters for the  Common UNIX
 *   Printing System (CUPS).
 *  common functions for c2esp, c2espC filters
 *
 *  copyright Paul Newall May 2010 - Oct 2011. VERSION 1 (first used in c2esp21~rc3) 
 *
 */


#include <stdio.h>
#include <string.h>
#include <cups/sidechannel.h> //FlushBackChannel, and the side channel functions and constants
#include <fcntl.h> //files
#include <sys/stat.h> //for chmod
#include <cups/driver.h> //has the dither functions probably not needed for Cxxx
#include <time.h> //time functions used for debugging
#include "c2espcommon.h" //the common library



/*
 * Constants...
 */
unsigned char NL = 10;

/*
 * Globals...
 */
char		CallerName[50];  	/* String that identifies the calling program */
int		DoBack;			/* Enables the back channel comms */ 
char 		BackBuf[32000]; //for the back channel replies from the printer
int 		BackBufLen=sizeof(BackBuf)-1;
FILE 		*LogFile = NULL; //file descriptor for log file
time_t		StartTime;

void SetupLogging(char *ExtCallerName, int ExtDoBack, char *ExtLogFileName)
{
	strcpy(CallerName,ExtCallerName);
	DoBack=ExtDoBack;
	if(strlen(ExtLogFileName)>0)
	{
		remove(ExtLogFileName); //to be sure I only see the latest
		LogFile = fopen(ExtLogFileName, "w"); //open the log file
		sleep(3); //does this help chmod to work?
		chmod(ExtLogFileName, S_IRUSR | S_IWUSR | S_IROTH ); //let anyone read it
  		setbuf(LogFile, NULL);
		fprintf(LogFile, "KodakPrintLog %s\n",ExtCallerName);
	}
	StartTime = time(NULL);
}

void CloseLogging()
{
	if(LogFile) 
	{
		DoLog("Closing log\n",0,0);
		fclose(LogFile);
	}
}
/*
void OldDoLog(char *PrintFormat, int I1, int I2)
{
	//prints a line with 2 integers to the log file and the cups error log
	char LogFormat[200];
	char CupsFormat[200]; 
	strcpy(LogFormat, "%d : ");
	strncat(LogFormat,PrintFormat,150); //crop PrintFormat to avoid FAILING WITH BUFFER OVERFLOW
	//now DoLog also sends to cups error log
	strcpy(CupsFormat, "DEBUG: ");
	strcat(CupsFormat,CallerName);
	strcat(CupsFormat,":");
	strcat(CupsFormat,LogFormat);
// add \n if not \n at the end of cupsformat
	if(CupsFormat[strlen(CupsFormat)-1] != NL) strcat(CupsFormat,"\n");
	fprintf(stderr, CupsFormat, time(NULL)-StartTime, I1, I2);

	if (LogFile != NULL) fprintf(LogFile, LogFormat, time(NULL)-StartTime, I1, I2);
}
*/

void DoLog(char *PrintFormat, int I1, int I2)
{
	//prints a line with 2 integers to the log file and the cups error log
	char CupsFormat[200]; 
	strcpy(CupsFormat, "DEBUG: ");
	strcat(CupsFormat,CallerName);
	strcat(CupsFormat,":%d : ");
	strncat(CupsFormat,PrintFormat,150); //crop PrintFormat to avoid FAILING WITH BUFFER OVERFLOW
	// add \n if not \n at the end of cupsformat
	if(CupsFormat[strlen(CupsFormat)-1] != NL) strcat(CupsFormat,"\n");
	fprintf(stderr, CupsFormat, time(NULL)-StartTime, I1, I2);
	if (LogFile != NULL) fprintf(LogFile, CupsFormat, time(NULL)-StartTime, I1, I2);
}
/*
void OldDoLogString(char *PrintFormat, char *String)
{
	//prints a line with a string to the log file and the cups error log
	char LogFormat[200];
	char CupsFormat[200]; 
	strcpy(LogFormat, "%d : ");
	strncat(LogFormat,PrintFormat,150); //crop PrintFormat to avoid FAILING WITH BUFFER OVERFLOW
	strcat(LogFormat,"\n");
	//now DoLog also sends to cups error log
	strcpy(CupsFormat, "DEBUG: ");
	strcat(CupsFormat,CallerName);
	strcat(CupsFormat,":");
	strcat(CupsFormat,LogFormat);
	fprintf(stderr, CupsFormat, time(NULL)-StartTime, String);

	if (LogFile != NULL) fprintf(LogFile, LogFormat, time(NULL)-StartTime, String);
}
*/

void DoLogString(char *PrintFormat, char *String)
{
	//prints a line with a string to the log file and the cups error log
	char CupsFormat[200]; 
	strcpy(CupsFormat, "DEBUG: ");
	strcat(CupsFormat,CallerName);
	strcat(CupsFormat,":%d : ");
	strncat(CupsFormat,PrintFormat,150); //crop PrintFormat to avoid FAILING WITH BUFFER OVERFLOW
	fprintf(stderr, CupsFormat, time(NULL)-StartTime, String);
	if (LogFile != NULL) fprintf(LogFile, CupsFormat, time(NULL)-StartTime, String);
}

/* DoOutJob used to enable one call to send to the specified job file and to stdout (if not testing)
And log the result */
void DoOutJob(FILE *OutFile, char *PrintFormat, int I1, int I2)
{
	int BytesRead = 0; //int because cupsBackChannel can return -1
	char Display[80];
	char LogFormat[200];
	int i;

	if (OutFile) fprintf(OutFile, PrintFormat, I1, I2); //to the specified file
	strcpy(LogFormat, "-> ");
	strcat(LogFormat,PrintFormat);
	DoLog(LogFormat, I1, I2); //and the log
#if TESTING == 0
	fprintf(stdout, PrintFormat, I1, I2); //and to the output
	fflush(stdout);

	if(DoBack)
	{
		BytesRead = cupsBackChannelRead(BackBuf, BackBufLen, 0.5); //read the reply from printer
		if(BytesRead >= 1) 
		{
			if(BytesRead<BackBufLen) BackBuf[BytesRead]=0; //add null terminator NB BytesRead==-1 if nothing read
			for(i=0;i<79;++i) Display[i] = BackBuf[i]; //copy the first 79 chars to Display
			Display[79] = 0; //add null terminator
			DoLogString("Reply = %s\n", Display);
		}
		else DoLog("No reply\n", 0,0);
	}

#endif
//	KeepAwakeStart = time(NULL); // reset timer
}


/* FlushBackChannel gets rid of any previous reply that could cause confusion */
int FlushBackChannel(char *IdString, float DrainTime)
{
//returns 1 if sucessful
	cups_sc_status_t status;
	char BackBuf[2]; //useless buffer to satisfy cupsSideChannelDoRequest
	int BackBufLen=sizeof(BackBuf)-1;
	if(DoBack)
	{
		status = cupsSideChannelDoRequest(CUPS_SC_CMD_DRAIN_OUTPUT, BackBuf, &BackBufLen, DrainTime);
		if(status == CUPS_SC_STATUS_OK) 
		{
//			fprintf(stderr, "DEBUG: c2espC:<did DRAIN_OUTPUT %s>\n", IdString);
			DoLogString("<did DRAIN_OUTPUT %s>\n", IdString);
			return(1);
		}
		else
		{
			if(status == CUPS_SC_STATUS_TIMEOUT) DoLogString("<Failed DRAIN_OUTPUT %s = Timeout>\n", IdString);
			else if(status == CUPS_SC_STATUS_IO_ERROR)  DoLogString("<Failed DRAIN_OUTPUT %s = IO error>\n", IdString);
			else if(status == CUPS_SC_STATUS_NOT_IMPLEMENTED) DoLogString("<Failed DRAIN_OUTPUT %s = not implemented>\n", IdString);
			else  DoLogString("<Failed DRAIN_OUTPUT %s = unknown reason>\n", IdString);
			return(0);
		}
	}
	else return(0);
}

/* GoodExchange sends a command gets reply from the printer on the back channel and compares it with the expected reply
	It returns the number of bytes read if the reply was the one expected, 
	otherwise -(the number of bytes read) if the reply did not match Expect, or 0 if there was no reply */
int GoodExchange(FILE *PrintFile, char *Command, char *Expect, int DoBack,  unsigned int SleepTime, float ReplyTime)
{
	int BytesRead = 0; //int because cupsBackChannel can return -1
	char Display[80];
	int i;

	DoLogString("-> %s\n", Command); //now also sends to stderr
	if(PrintFile) fprintf(PrintFile, "%s", Command); //to the global print file
#if TESTING == 0
	fprintf(stdout, "%s", Command); //printer command
	fflush(stdout); //force a packet to the printer so it can reply
	sleep(SleepTime); //give it a chance to reply before trying to read the reply (may not be needed)
#endif

	if(DoBack)
	{
		BytesRead = cupsBackChannelRead(BackBuf, BackBufLen, ReplyTime); //read the reply from printer
		if(BytesRead < 1) 
		{
			DoLog("No reply\n",0,0);
			return 0;
		}
		else
		{
			BackBuf[BytesRead]=0; //add null terminator NB BytesRead==-1 if nothing read
			for(i=0;i<79;++i) Display[i] = BackBuf[i]; //copy the first 79 chars to Display
			Display[79] = 0; //add null terminator
			//DoLog("Got %d byte reply\n", BytesRead, 0);
			if(strncmp(BackBuf, Expect, strlen(Expect)) != 0) 
			{
				DoLogString("Unexpected reply = %s\n", Display);
				return(-1*BytesRead);
			}
			else 
			{
				DoLogString("Expected reply = %s\n", Display);
				return(BytesRead);
			}
		}
	}
	else return 0;
}
int
MarkerPercent(char *Buf, int GetColour) /* GetColour = 1 for "Color" or 0 for "Black" */
{
	/* search for the ink data in the buffer using char *strstr(char *string2, char string*1);*/
	char *MarkerLevelString;
	
		if(GetColour) MarkerLevelString = strstr(Buf, "DeviceStatus.Printer.InkLevelPercent.Color=");
		else MarkerLevelString = strstr(Buf, "DeviceStatus.Printer.InkLevelPercent.Black=");
		if (MarkerLevelString)
		{
			MarkerLevelString = strstr(MarkerLevelString, "=")+1;
			if (MarkerLevelString)
			{
				if(strncmp(MarkerLevelString,"F",1)==0) return (100);
				else return (atoi(MarkerLevelString));
			}
		}
		return 0;
}



void SetPaperSize(char Size[], int PaperPoints)
{
    //converts length of page in cups header (in points) into a string that the printer recognises

	strcpy(Size, "MediaSize=na_letter_8.5x11in;"); //default

    switch (PaperPoints)
    {
      case 432 : // Photo 4x6" 
		strcpy(Size, "MediaSize=na_index4x6_4x6in;");
	  break;
      case 540 : // Monarch Envelope 
	  break;
      case 595 : // A5 
		strcpy(Size, "MediaSize=iso_a5_148x210mm;");
	  break;
      case 624 : // DL Envelope
	  break;
      case 649 : // C5 Envelope
	  break;
      case 684 : // COM-10 Envelope 
	  break;
      case 709 : // B5 Envelope 
	  break;
      case 756 : // Executive
	  break;
      case 792 : // Letter 
		strcpy(Size, "MediaSize=na_letter_8.5x11in;");
 	  break;
      case 842 : // A4 
		strcpy(Size, "MediaSize=iso_a4_210x297mm;");
	  break;
      case 1008 : // Legal
	  break;
      case 1191 : // A3 
	  break;
      case 1224 : // Tabloid 
	  break;
    }
}

void
DisplayHeader1(FILE *OutFile, cups_page_header2_t *header)
{
 /*
  * Show page device dictionary...
  */

  fprintf(OutFile, "DEBUG: StartPage...\n");
  fprintf(OutFile, "DEBUG: MediaClass = \"%s\"\n", header->MediaClass);
  fprintf(OutFile, "DEBUG: MediaColor = \"%s\"\n", header->MediaColor);
  fprintf(OutFile, "DEBUG: MediaType = \"%s\"\n", header->MediaType);
  fprintf(OutFile, "DEBUG: OutputType = \"%s\"\n", header->OutputType);
  fprintf(OutFile, "DEBUG: AdvanceDistance = %d\n", header->AdvanceDistance);
  fprintf(OutFile, "DEBUG: AdvanceMedia = %d\n", header->AdvanceMedia);
  fprintf(OutFile, "DEBUG: Collate = %d\n", header->Collate);
  fprintf(OutFile, "DEBUG: CutMedia = %d\n", header->CutMedia);
  fprintf(OutFile, "DEBUG: Duplex = %d\n", header->Duplex);
  fprintf(OutFile, "DEBUG: HWResolution = [ %d %d ]\n", header->HWResolution[0], header->HWResolution[1]);
  fprintf(OutFile, "DEBUG: ImagingBoundingBox = [ %d %d %d %d ]\n",
          header->ImagingBoundingBox[0], header->ImagingBoundingBox[1],
          header->ImagingBoundingBox[2], header->ImagingBoundingBox[3]);
  fprintf(OutFile, "DEBUG: InsertSheet = %d\n", header->InsertSheet);
  fprintf(OutFile, "DEBUG: Jog = %d\n", header->Jog);
  fprintf(OutFile, "DEBUG: LeadingEdge = %d\n", header->LeadingEdge);
  fprintf(OutFile, "DEBUG: Margins = [ %d %d ]\n", header->Margins[0], header->Margins[1]);
  fprintf(OutFile, "DEBUG: ManualFeed = %d\n", header->ManualFeed);
  fprintf(OutFile, "DEBUG: MediaPosition = %d\n", header->MediaPosition);
  fprintf(OutFile, "DEBUG: MediaWeight = %d\n", header->MediaWeight);
  fprintf(OutFile, "DEBUG: MirrorPrint = %d\n", header->MirrorPrint);
  fprintf(OutFile, "DEBUG: NegativePrint = %d\n", header->NegativePrint);
  fprintf(OutFile, "DEBUG: NumCopies = %d\n", header->NumCopies);
  fprintf(OutFile, "DEBUG: Orientation = %d\n", header->Orientation);
  fprintf(OutFile, "DEBUG: OutputFaceUp = %d\n", header->OutputFaceUp);
  fprintf(OutFile, "DEBUG: PageSize = [ %d %d ]\n", header->PageSize[0], header->PageSize[1]);
  fprintf(OutFile, "DEBUG: Separations = %d\n", header->Separations);
  fprintf(OutFile, "DEBUG: TraySwitch = %d\n", header->TraySwitch);
  fprintf(OutFile, "DEBUG: Tumble = %d\n", header->Tumble);
  fprintf(OutFile, "DEBUG: cupsWidth = %d\n", header->cupsWidth);
  fprintf(OutFile, "DEBUG: cupsHeight = %d\n", header->cupsHeight);
  fprintf(OutFile, "DEBUG: cupsMediaType = %d\n", header->cupsMediaType);
  fprintf(OutFile, "DEBUG: cupsBitsPerColor = %d\n", header->cupsBitsPerColor);
  fprintf(OutFile, "DEBUG: cupsBitsPerPixel = %d\n", header->cupsBitsPerPixel);
  fprintf(OutFile, "DEBUG: cupsBytesPerLine = %d\n", header->cupsBytesPerLine);
  fprintf(OutFile, "DEBUG: cupsColorOrder = %d\n", header->cupsColorOrder);
  fprintf(OutFile, "DEBUG: cupsColorSpace = %d\n", header->cupsColorSpace);
  fprintf(OutFile, "DEBUG: cupsCompression = %d\n", header->cupsCompression);
}

void
DisplayHeader(cups_page_header2_t *header)
{
	DisplayHeader1(stderr, header);
	if(LogFile != NULL) DisplayHeader1(LogFile, header);
}



