/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "ViewTable.h"
#include "ViewTableItem.h"
#include "Shared.h"

/*------- local constants:
-------------------------------------------------------------------*/
const QColor ViewTableItem::BG_NoFocusSelected           = qRgb( 211, 211, 191 );
const QColor ViewTableItem::BG_NoFocusCurrent            = qRgb( 147, 177, 177 );
const QColor ViewTableItem::BG_NoFocusCurrentAndSelected = qRgb( 147, 177, 177 );

const QColor ViewTableItem::FOCUSED_NUMBER_TEXT      = qRgb( 255, 0, 0 );
const QColor ViewTableItem::FOCUSED_NUMBER_SELTEXT   = qRgb( 255, 220, 0 );
const QColor ViewTableItem::NOFOCUSED_NUMBER_TEXT    = qRgb( 235, 150, 122 );

const QColor ViewTableItem::DEFAULT_CURRENT_SELECTED_FG = qRgb( 0, 0, 0 );
const QColor ViewTableItem::DEFAULT_CURRENT_SELECTED_BG = qRgb( 255, 159, 173 );
const QColor ViewTableItem::DEFAULT_CURRENT_FG          = qRgb( 0, 0, 0 );
const QColor ViewTableItem::DEFAULT_CURRENT_BG          = qRgb( 153, 204, 153 );
const QColor ViewTableItem::DEFAULT_SELECTED_FG         = qRgb( 255, 255, 255 );
const QColor ViewTableItem::DEFAULT_SELECTED_BG         = qRgb( 154, 167, 255 );

//*******************************************************************
// paintCell                                       PRIVATE inherited
//*******************************************************************
void ViewTableItem::paintCell( QPainter* p, const QColorGroup& cg, int col, int w, int align )
{
	QColorGroup new_cg = cg;
	
	if(( 3 == col ) && d_is_size_computed ) {
		if( listView()->hasFocus() ) {
			new_cg.setColor( QColorGroup::Text, FOCUSED_NUMBER_TEXT );
			new_cg.setColor( QColorGroup::HighlightedText, FOCUSED_NUMBER_SELTEXT );
		}	
		else {
			new_cg.setColor( QColorGroup::Text, NOFOCUSED_NUMBER_TEXT );
			new_cg.setColor( QColorGroup::HighlightedText, NOFOCUSED_NUMBER_TEXT );
		}
	}
	
	const bool is_current = ( this == listView()->currentItem() );
	const bool is_selected = isSelected();
	
	if( listView()->hasFocus() ) {		
		if( is_current && is_selected ) {
			new_cg.setColor( QColorGroup::HighlightedText, DEFAULT_CURRENT_SELECTED_FG );
			new_cg.setColor( QColorGroup::Highlight, DEFAULT_CURRENT_SELECTED_BG );
		}
		else if( is_current ) {
			new_cg.setColor( QColorGroup::Text, DEFAULT_CURRENT_FG );
			new_cg.setColor( QColorGroup::Base, DEFAULT_CURRENT_BG );
		}
		else if( is_selected ) {
			new_cg.setColor( QColorGroup::HighlightedText, DEFAULT_SELECTED_FG );
			new_cg.setColor( QColorGroup::Highlight, DEFAULT_SELECTED_BG );
		}
	}
	else {
		if( is_selected && is_current ) {
			new_cg.setColor( QColorGroup::Highlight, BG_NoFocusCurrentAndSelected );
		}
		else if( is_selected ) {
			new_cg.setColor( QColorGroup::Highlight, BG_NoFocusSelected );
		}
		else if( is_current  ) {
			new_cg.setColor( QColorGroup::Text, QColor( 255, 255, 255 ) );
			new_cg.setColor( QColorGroup::Base, BG_NoFocusCurrent );
		}
	}
	QListViewItem::paintCell( p, new_cg, col, w, align );
}
// end of paintCell

//*******************************************************************
// compare                                         PRIVATE inherited
//*******************************************************************
int ViewTableItem::compare( QListViewItem* in_item, int in_column, bool in_ascending ) const
{
	int retval = 0;

	if( Shared::ParentDir == text( 0 )) {
		retval = ( in_ascending ) ? -1 : 1;
	}
	else if( Shared::ParentDir == in_item->text( 0 )) {
		retval = (in_ascending ) ? 1 : -1;
	}
	else {
		const bool item_isdir = ( in_item->text( 2 )[0] == 'd' );
		const bool im_isdir   = ( text( 2 )[0] == 'd' );
		if( item_isdir && !im_isdir ) {
			retval = ( in_ascending ) ? 1 : -1;
		}
		else if( im_isdir && !item_isdir ) {
			retval = ( in_ascending ) ? -1 : 1;
		}
		else {
			if( 3 == in_column ) {
				const Q_ULLONG first_value  = in_item->text( in_column ).remove( ',' ).toLong();
				const Q_ULLONG second_value = text( in_column ).remove( ',' ).toLong();
				retval = ( first_value < second_value ) ?  1 : -1;
			}
			else {
				retval = key( in_column, in_ascending ).compare( in_item->key( in_column, in_ascending ));
			}
		}
	}
	
	return retval;
}
