/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project: Beesoft Commander
 * Author : Piotr Pszczolkowski
 * Contact: piotr@beesoft.org
 *******************************************************************/
#ifndef INCLUDED_RIGHTVIEW_H
#define INCLUDED_RIGHTVIEW_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QFRAME_H
#include <qframe.h>
#define INCLUDED_QFRAME_H
#endif // INCLUDED_QFRAME_H

#ifndef INCLUDED_QWIDGETSTACK_H
#include <qwidgetstack.h>
#define INCLUDED_QWIDGETSTACK_H
#endif // INCLUDED_QWIDGETSTACK_H

#ifndef INCLUDED_VIEWGENERIC_H
#include "ViewGeneric.h"
#endif // INCLUDED_VIEWGENERIC_H

/*------- class declaration:
-------------------------------------------------------------------*/
class RightView : public ViewGeneric
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	RightView( QWidget* const in_parent, Workspace* const in_workspace );
	~RightView();
private:
	RightView( const RightView& );
	RightView& operator=( const RightView& );

// ******* CONSTANTS *******
private:
	static const QString ArgPrefix;
	static const QString ConfigGroupName;

// ******* METHODS *******
public:
	void reconnect();
private:
	void add_new_tab    ( const QString&, const QString& = "" );
	void set_dir_combox ( ViewWindow* const );
private slots:
	void slot_set_tab   ( int );
	void slot_new_tab   ( const QString& = "" );
	void slot_remove_tab();
};

#endif // INCLUDED_RIGHTVIEW_H
