/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_CONFIGURATOR_H
#define INCLUDED_CONFIGURATOR_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QTabBar;
class QWidgetStack;
class QPushButton;

/*------- class declaration:
-------------------------------------------------------------------*/
class Configurator : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Configurator( QWidget* in_parent );
private:
	Configurator( const Configurator& );
	Configurator& operator=( const Configurator& );

// ******* CONSTANTS ******
private:
	static const QString Caption;
	static const QString DisplayTabLabel;
	static const QString FnBtnTabLabel;
	static const QString ConsoleTabLabel;
	static const QString ExtTabLabel;

	enum {
		DisplayTabIdx = 0,
		FnBtnTabIdx,
		ConsoleTabIdx,
		ExtTabIdx
	};
// ******* MEMBERS *******
private:
	QTabBar*      const d_tab_bar;
	QWidgetStack* const d_widget_stack;
	QPushButton*  const d_close_btn;
	
// ******* METHODS *******
private slots:
	void slot_close();
	void slot_set_tab( int );
signals:
	void looks_refresh();
};

#endif // INCLUDED_CONFIGURATOR_H
