
/*
 *  Diverse Bristol midi routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2009
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*#define DEBUG */

#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <unistd.h>

#include "bristol.h"
#include "bristolmidi.h"

struct sockaddr address;

extern bristolMidiMain bmidi;
extern int bristolMidiTCPPassive();
extern int bristolMidiTCPActive();
extern int bristolMidiFindDev();
extern int initControlPort();

int
bristolMidiTCPOpen(char *host, int flags, int chan, int msgs,
int (*callback)(), void *param, int dev, int handle)
{
/* printf("bristolMidiTCPOpen(%s, %i, %i)\n", host, chan, dev); */
	/*
	 * See if we are active or passive.
	 */
	if (flags & BRISTOL_CONN_PASSIVE)
	{
		/*
		 * This is the server, or in our case the engine, side of operations.
		 * we need to open a listening socket, and bind it to an address.
		 */
		return(bristolMidiTCPPassive(host, flags, chan, msgs, callback,
			param, dev, handle));
	} else {
		/*
		 * This is the client side, we should have a station address in "dev"
		 * and we connect to this address.
		 */
		return(bristolMidiTCPActive(host, flags, chan, msgs, callback,
			param, dev, handle));
	}
}

int
bristolMidiTCPActive(char *host, int conntype, int chan, int msgs,
int (*callback)(), void *param, int dev, int handle)
{
#ifdef DEBUG
	printf("bristolMidiTCPActive(%i, %i)\n", host, handle);
#endif

	if (conntype & BRISTOL_CONN_UNIX)
		conntype = 0;
	else
		conntype = 1;

	/*
	 * Otherwise try and find a device that is free.
	 */
	if ((dev = bristolMidiFindDev(NULL)) < 0)
		return(dev);

	bmidi.dev[dev].flags |= BRISTOL_CONN_TCP;

	if (chan == -1)
		chan = 5028;

	if (conntype)
	{
		if ((bmidi.dev[dev].fd = initControlPort(host, chan)) < 0)
		{
			printf("connfailed\n");
			return(BRISTOL_MIDI_CHANNEL);
		}
		bmidi.dev[dev].flags = BRISTOL_CONN_TCP;
	} else {
		/*
		 * We need to open a control socket to the bristol engine. For the time
		 * being we will only be concerned with a unix domain socket.
		 */
		if ((bmidi.dev[dev].fd = socket(PF_UNIX, SOCK_STREAM, 0)) < 0)
		{
			printf("Could not get a socket\n");
			exit(-2);
		}

#ifdef DEBUG
		printf("Opened the bristol control socket: %i\n", bmidi.dev[dev].fd);
#endif

		address.sa_family = AF_UNIX;
		sprintf(&address.sa_data[0], BRISTOL_SOCKNAME);

		if (connect(bmidi.dev[dev].fd, &address, sizeof(struct sockaddr)) < 0)
		{
			printf("Could not connect to the bristol control socket\n");
			return(BRISTOL_MIDI_CHANNEL);
		}
	}

	printf("Connected to the bristol control socket: %i\n", bmidi.dev[dev].fd);

	return(handle);
}

