#include "../config.h"
#include "simd.h"     
float a[1024] __attribute__ ((aligned(16)))={1,-2,3,-4} ;
float b[1024] __attribute__ ((aligned(16)))={-5,6,-7,8} ;
float c[2048] __attribute__ ((aligned(16)))={1,1,1,1} ;


int main(void) {
     simd<float,4>::simd_mode_start();
     simd<float,4>::ptr p(a),q(b);
     simd<float,4>::ptr r(c);
     for (unsigned int i=0;i<sizeof(b)/simd<float,4>::size;i++) {
       p[i].prefetch();
       r[i*2]=interleave<0x0202>(p[i],q[i]);
       q[i].prefetch();
       r[i*2+1]=interleave<0x1313>(p[i],q[i]);
       r[i*2].prefetch();
     }
     simd<float,4>::simd_mode_finish();
     printf("%f %f %f %f %f %f %f %f\n",c[0],c[1],c[2],c[3],c[4],c[5],c[6],c[7]);
     return(0);
}

