package aQute.junit.runtime.minifw;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.jar.*;

import org.osgi.framework.*;

public class Context extends URLClassLoader implements Bundle, BundleContext {
    long          id;
    MiniFramework fw;
    String        location;
    int           state = Bundle.INSTALLED;
    JarFile         jar;
    Manifest manifest;
    
    class Dict extends Dictionary {

        public Enumeration elements() {
            return Collections.enumeration(manifest.getMainAttributes().values());
        }

        public Object get(Object key) {
            return manifest.getMainAttributes().getValue((String)key);
        }

        public boolean isEmpty() {
            return manifest.getMainAttributes().isEmpty();
        }

        public Enumeration keys() {
            Vector v = new Vector();
            for ( Iterator i = manifest.getMainAttributes().keySet().iterator(); i.hasNext(); ) {
                Attributes.Name name = (Attributes.Name) i.next();
                v.add(name.toString());
            }
            return v.elements();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return manifest.getMainAttributes().size();
        }
        
    }
    
    Context(MiniFramework fw, ClassLoader parent, int id, String location) throws IOException {
        super( new URL[]{ new File(location).toURL()}, parent);
        this.fw = fw;
        this.id = id;
        this.location = location;
        jar= new JarFile(new File(location));
        manifest = jar.getManifest();
        jar.close();
    }

    public BundleContext getBundleContext() {
        return this;
    }

    public long getBundleId() {
        return id;
    }

    public URL getEntry(String path) {
        throw new UnsupportedOperationException();
    }

    public Enumeration getEntryPaths(String path) {
        throw new UnsupportedOperationException();
    }

    public Dictionary getHeaders() {
        return new Dict();
    }

    public Dictionary getHeaders(String locale) {
        return new Dict();
    }

    public long getLastModified() {
        return 0;
    }

    public String getLocation() {
        return location;
    }

    public Enumeration findEntries(String path, String filePattern,
            boolean recurse) {
        throw new UnsupportedOperationException();
    }

    public ServiceReference[] getRegisteredServices() {
        return null;
    }


    public ServiceReference[] getServicesInUse() {
        return null;
    }

    public Map getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException();
    }

    public int getState() {
        return state;
    }

    public String getSymbolicName() {
        return location;
    }

    public Version getVersion() {
        return new Version("0");
    }

    public boolean hasPermission(Object permission) {
        return true;
    }

    public void start() throws BundleException {
        state = Bundle.ACTIVE;
    }

    public void start(int options) throws BundleException {
        state = Bundle.ACTIVE;
    }

    public void stop() throws BundleException {
        state = Bundle.RESOLVED;
    }

    public void stop(int options) throws BundleException {
        state = Bundle.RESOLVED;
    }

    public void uninstall() throws BundleException {
        state = Bundle.UNINSTALLED;
    }

    public void update() throws BundleException {
        throw new UnsupportedOperationException();
    }

    public void update(InputStream in) throws BundleException {
        throw new UnsupportedOperationException();
    }

    public void addBundleListener(BundleListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addFrameworkListener(FrameworkListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addServiceListener(ServiceListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addServiceListener(ServiceListener listener, String filter) {
        throw new UnsupportedOperationException();
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        throw new UnsupportedOperationException();
    }

    public ServiceReference[] getAllServiceReferences(String clazz,
            String filter) throws InvalidSyntaxException {
        throw new UnsupportedOperationException();
    }

    public Bundle getBundle() {
        return this;
    }

    public Bundle getBundle(long id) {
        return fw.getBundle(id);
    }

    public Bundle[] getBundles() {
        return fw.getBundles();
    }

    public File getDataFile(String filename) {
        return null;
    }

    public String getProperty(String key) {
        return null;
    }

    public Object getService(ServiceReference reference) {
        throw new UnsupportedOperationException();
    }

    public ServiceReference getServiceReference(String clazz) {
        throw new UnsupportedOperationException();
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter)
            throws InvalidSyntaxException {
        throw new UnsupportedOperationException();
    }

    public Bundle installBundle(String location) throws BundleException {
        return fw.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream input)
            throws BundleException {
        return fw.installBundle(location, input);
    }

    public ServiceRegistration registerService(String[] clazzes,
            Object service, Dictionary properties) {
        throw new UnsupportedOperationException();
    }

    public ServiceRegistration registerService(String clazz, Object service,
            Dictionary properties) {
        throw new UnsupportedOperationException();
    }

    public void removeBundleListener(BundleListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeServiceListener(ServiceListener listener) {
        throw new UnsupportedOperationException();
    }

    public boolean ungetService(ServiceReference reference) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return id + " " + location;
    }
}
