/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jul  2 16:15:31 EDT 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2r -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 9 -name hc2r_9 -include hc2r.h */

/*
 * This function contains 32 FP additions, 24 FP multiplications,
 * (or, 8 additions, 0 multiplications, 24 fused multiply/add),
 * 40 stack variables, and 18 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.19 2006-02-12 23:34:12 athena Exp $
 */

#include "hc2r.h"

static void hc2r_9(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP1_326827896, +1.326827896337876792410842639271782594433726619);
     DK(KP1_705737063, +1.705737063904886419256501927880148143872040591);
     DK(KP766044443, +0.766044443118978035202392650555416673935832457);
     DK(KP1_532088886, +1.532088886237956070404785301110833347871664914);
     DK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DK(KP1_969615506, +1.969615506024416118733486049179046027341286503);
     DK(KP839099631, +0.839099631177280011763127298123181364687434283);
     DK(KP176326980, +0.176326980708464973471090386868618986121633062);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP1_732050807, +1.732050807568877293527446341505872366942805254);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E T4, Th, T3, Tb, Tp, Tk, T7, Tf, Ti, Ta, T1, T2;
	  Ta = ii[WS(iis, 3)];
	  T1 = ri[0];
	  T2 = ri[WS(ris, 3)];
	  T4 = ri[WS(ris, 1)];
	  Th = ii[WS(iis, 1)];
	  {
	       E T5, T9, T6, Td, Te;
	       T5 = ri[WS(ris, 4)];
	       T9 = T1 - T2;
	       T3 = FMA(KP2_000000000, T2, T1);
	       T6 = ri[WS(ris, 2)];
	       Td = ii[WS(iis, 4)];
	       Te = ii[WS(iis, 2)];
	       Tb = FNMS(KP1_732050807, Ta, T9);
	       Tp = FMA(KP1_732050807, Ta, T9);
	       Tk = T6 - T5;
	       T7 = T5 + T6;
	       Tf = Td + Te;
	       Ti = Td - Te;
	  }
	  {
	       E Tu, To, Tt, Tn, Tc, T8;
	       Tc = FNMS(KP500000000, T7, T4);
	       T8 = T4 + T7;
	       {
		    E Tw, Tj, Tr, Tg, Tv;
		    Tw = Ti + Th;
		    Tj = FNMS(KP500000000, Ti, Th);
		    Tr = FMA(KP866025403, Tf, Tc);
		    Tg = FNMS(KP866025403, Tf, Tc);
		    Tv = T3 - T8;
		    O[0] = FMA(KP2_000000000, T8, T3);
		    {
			 E Tq, Tl, Ts, Tm;
			 Tq = FMA(KP866025403, Tk, Tj);
			 Tl = FNMS(KP866025403, Tk, Tj);
			 O[WS(os, 6)] = FMA(KP1_732050807, Tw, Tv);
			 O[WS(os, 3)] = FNMS(KP1_732050807, Tw, Tv);
			 Ts = FNMS(KP176326980, Tr, Tq);
			 Tu = FMA(KP176326980, Tq, Tr);
			 Tm = FNMS(KP839099631, Tl, Tg);
			 To = FMA(KP839099631, Tg, Tl);
			 O[WS(os, 2)] = FNMS(KP1_969615506, Ts, Tp);
			 Tt = FMA(KP984807753, Ts, Tp);
			 O[WS(os, 1)] = FMA(KP1_532088886, Tm, Tb);
			 Tn = FNMS(KP766044443, Tm, Tb);
		    }
	       }
	       O[WS(os, 5)] = FNMS(KP1_705737063, Tu, Tt);
	       O[WS(os, 8)] = FMA(KP1_705737063, Tu, Tt);
	       O[WS(os, 4)] = FNMS(KP1_326827896, To, Tn);
	       O[WS(os, 7)] = FMA(KP1_326827896, To, Tn);
	  }
     }
}

static const khc2r_desc desc = { 9, "hc2r_9", {8, 0, 24, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2r_9) (planner *p) {
     X(khc2r_register) (p, hc2r_9, &desc);
}

#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2r -compact -variables 4 -pipeline-latency 4 -sign 1 -n 9 -name hc2r_9 -include hc2r.h */

/*
 * This function contains 32 FP additions, 18 FP multiplications,
 * (or, 22 additions, 8 multiplications, 10 fused multiply/add),
 * 35 stack variables, and 18 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.19 2006-02-12 23:34:12 athena Exp $
 */

#include "hc2r.h"

static void hc2r_9(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, INT v, INT ivs, INT ovs)
{
     DK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DK(KP173648177, +0.173648177666930348851716626769314796000375677);
     DK(KP300767466, +0.300767466360870593278543795225003852144476517);
     DK(KP1_705737063, +1.705737063904886419256501927880148143872040591);
     DK(KP642787609, +0.642787609686539326322643409907263432907559884);
     DK(KP766044443, +0.766044443118978035202392650555416673935832457);
     DK(KP1_326827896, +1.326827896337876792410842639271782594433726619);
     DK(KP1_113340798, +1.113340798452838732905825904094046265936583811);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     DK(KP1_732050807, +1.732050807568877293527446341505872366942805254);
     INT i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs, MAKE_VOLATILE_STRIDE(ris), MAKE_VOLATILE_STRIDE(iis), MAKE_VOLATILE_STRIDE(os)) {
	  E T3, Tq, Tc, Tk, Tj, T8, Tm, Ts, Th, Tr, Tw, Tx;
	  {
	       E Tb, T1, T2, T9, Ta;
	       Ta = ii[WS(iis, 3)];
	       Tb = KP1_732050807 * Ta;
	       T1 = ri[0];
	       T2 = ri[WS(ris, 3)];
	       T9 = T1 - T2;
	       T3 = FMA(KP2_000000000, T2, T1);
	       Tq = T9 + Tb;
	       Tc = T9 - Tb;
	  }
	  {
	       E T4, T7, Ti, Tg, Tl, Td;
	       T4 = ri[WS(ris, 1)];
	       Tk = ii[WS(iis, 1)];
	       {
		    E T5, T6, Te, Tf;
		    T5 = ri[WS(ris, 4)];
		    T6 = ri[WS(ris, 2)];
		    T7 = T5 + T6;
		    Ti = KP866025403 * (T5 - T6);
		    Te = ii[WS(iis, 4)];
		    Tf = ii[WS(iis, 2)];
		    Tg = KP866025403 * (Te + Tf);
		    Tj = Tf - Te;
	       }
	       T8 = T4 + T7;
	       Tl = FMA(KP500000000, Tj, Tk);
	       Tm = Ti + Tl;
	       Ts = Tl - Ti;
	       Td = FNMS(KP500000000, T7, T4);
	       Th = Td - Tg;
	       Tr = Td + Tg;
	  }
	  O[0] = FMA(KP2_000000000, T8, T3);
	  Tw = T3 - T8;
	  Tx = KP1_732050807 * (Tk - Tj);
	  O[WS(os, 3)] = Tw - Tx;
	  O[WS(os, 6)] = Tw + Tx;
	  {
	       E Tp, Tn, To, Tv, Tt, Tu;
	       Tp = FMA(KP1_113340798, Th, KP1_326827896 * Tm);
	       Tn = FNMS(KP642787609, Tm, KP766044443 * Th);
	       To = Tc - Tn;
	       O[WS(os, 1)] = FMA(KP2_000000000, Tn, Tc);
	       O[WS(os, 7)] = To + Tp;
	       O[WS(os, 4)] = To - Tp;
	       Tv = FMA(KP1_705737063, Tr, KP300767466 * Ts);
	       Tt = FNMS(KP984807753, Ts, KP173648177 * Tr);
	       Tu = Tq - Tt;
	       O[WS(os, 2)] = FMA(KP2_000000000, Tt, Tq);
	       O[WS(os, 8)] = Tu + Tv;
	       O[WS(os, 5)] = Tu - Tv;
	  }
     }
}

static const khc2r_desc desc = { 9, "hc2r_9", {22, 8, 10, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2r_9) (planner *p) {
     X(khc2r_register) (p, hc2r_9, &desc);
}

#endif				/* HAVE_FMA */
