/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Help_Dialog.H>
//#include <FL/Fl_PNG_Image.H>



#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>


#include <util.hpp>

#include <finestra_pr.hpp>
#include <editor.hpp>
#include <bond_prop.hpp>
#include <string_prop.hpp>
#include <multiline_label_prop.hpp>
#include <paragraph_text_prop.hpp>
#include <prefs.hpp>

#include <plot_window.hpp>

#include <pivot.xpm>

extern finestra_pr* __la_finestra;

extern Preferences  __pref;

/****************mol_canvas*************************/


mol_canvas::mol_canvas(int X,int Y,int W,int H)
  :Fl_Widget(X,Y,W,H),
   _la_molecola(0),
   _x_pivot(w()/2),
   _y_pivot(h()/2),
   _action(ACT_NOTHING),
   _start_atom(0),
   _end_atom(0),
   _b_arrow_added(false),
   _x_arc_centr(0),
   _y_arc_centr(0),
   _arc_max_ax(0),
   _arc_min_ax(0),
   _b_bond_added(false),
   _x_added_atom(0),
   _y_added_atom(0),
   _b_construct_box(false),
   _pivot_xpm(pivot_xpm),
   _fixed_rotation_degree(0)
{
  box(FL_ENGRAVED_BOX);
  color(FL_WHITE);

}


void mol_canvas::num_atom_chain(unsigned int nw){
  _num_atom_chain=nw;
}


void mol_canvas::orient_chain(float nw){
  _orient_chain=nw;
}


void mol_canvas::fixed_rotation_degree(float nw){
  _fixed_rotation_degree=nw;
}

void mol_canvas::add_immagine(immagine* imm){

#ifdef DEBUG
  std::cerr << "added: " << imm << endl; 
#endif

  _la_molecola=imm;
  _la_molecola->ruota();  
}

mol_canvas::~mol_canvas(){
#ifdef DEBUG
  cerr << "distrutto mol_canvas" << endl;
#endif
}


void mol_canvas::action(int nw){
  _action=nw;
}

int mol_canvas::action(){
  return _action;
}



void mol_canvas::draw(){
  draw_box();
  
  if(__pref.getDrawGrid()){
    fl_color(0xdd,0xdd,0xdd);

    char dash[2]={__pref.get_tratteggio_legame(),0}; //preferenze 
    fl_line_style(FL_SOLID,1,dash);

    int incrx=(w()-1)/__pref.getGridSpacing();
    int incry=(h()-1)/__pref.getGridSpacing();
    int xt=x();
    int yt=y();

    for(int i=0;i<=incrx;i++){
      fl_line(xt, y(), xt,y()+h());
      xt+=__pref.getGridSpacing();
    }
    
    for(int i=0;i<=incry;i++){
      fl_line(x(), yt, x()+w(), yt);
      yt+=__pref.getGridSpacing();
    }
    
  }
  fl_line_style(0);


  /*
  fl_color(FL_RED);
  fl_point(120,120);
  */
  if(_la_molecola){
    _la_molecola->disegna();
  }
  
  switch(_action){

  case ACT_DRAW_ARROW:
    if(_b_arrow_added){
      fl_color(255,0,0);
      fl_line(_x_mouse,_y_mouse,Fl::event_x(),Fl::event_y());
    }
    break;
  case ACT_DRAW_SINGLE_BOND:
    if(!_b_bond_added){
      draw_preview_bond(ACT_DRAW_SINGLE_BOND);
    }
    break;

  case ACT_DRAW_DOUBLE_BOND:
    
    if(!_b_bond_added){
      draw_preview_bond(ACT_DRAW_SINGLE_BOND);
    }
    break;


  case ACT_DRAW_TRIPLE_BOND:
    
    if(!_b_bond_added){
      draw_preview_bond(ACT_DRAW_TRIPLE_BOND);
    }
    break;

  case ACT_DRAW_BEZIER:
    if(_bezier_point.size()<4){
      for(unsigned int i=0;i<_bezier_point.size();i++){
	disegna_pallino(_bezier_point[i].first,_bezier_point[i].second);
      }
    }

    break;


  case ACT_DRAW_ARC:
    if(_arc_max_ax){
      disegna_pallino(_x_arc_centr,_y_arc_centr);
      fl_color(COMP_R_EV,COMP_G_EV,COMP_B_EV);
      /*
       fl_arc(_x_arc_centr, _y_arc_centr, abs(_arc_max_ax), 
	      abs(_arc_min_ax), 0, 360); 
      */
      /*
 proc_arc* agg=new proc_arc(0,
			     xc-dx_scroll, yc+h/2-dy_scroll,
			     xc+w-dx_scroll, yc+h/2-dy_scroll,
			     xc-dx_scroll, yc-dy_scroll,
			     xc+w-dx_scroll,  yc-dy_scroll,
			     xc-dx_scroll, yc+h-dy_scroll,
			     xc+w-dx_scroll, yc+h-dy_scroll,
			     0, 0, 0 ,
			     0, 0, 0,
			     1, 0);
      */

        fl_begin_line();
	fl_curve(_x_arc_centr, _y_arc_centr+_arc_min_ax/2, 
		 _x_arc_centr, _y_arc_centr, 
		 _x_arc_centr+_arc_max_ax,_y_arc_centr,
		 _x_arc_centr+_arc_max_ax, _y_arc_centr+_arc_min_ax/2);
	fl_end_line();
	
	fl_begin_line();
	
	fl_curve(_x_arc_centr, _y_arc_centr+_arc_min_ax/2, 
		 _x_arc_centr, _y_arc_centr+_arc_min_ax, 
		 _x_arc_centr+_arc_max_ax,_y_arc_centr+_arc_min_ax,
		 _x_arc_centr+_arc_max_ax, _y_arc_centr+_arc_min_ax/2);
	
	fl_end_line();


    }
    break;

  case ACT_SEL_ATOM:
  case ACT_SEL_BOX:
    if(_b_construct_box){
      _la_molecola->elimina_elem_selected();
      _la_molecola->elimina_legami_selected();
      fl_color(COMP_R_EV,COMP_G_EV,COMP_B_EV);
      fl_loop(_x_mouse, _y_mouse, 
	      _x_mouse+(Fl::event_x()-_x_mouse), _y_mouse,
	      _x_mouse+(Fl::event_x()-_x_mouse), _y_mouse+(Fl::event_y()-_y_mouse),
	      _x_mouse, _y_mouse+(Fl::event_y()-_y_mouse));
    }
    break;

  case ACT_ROTATE_SELECTED:
    _pivot_xpm.draw(_x_pivot-_pivot_xpm.w()/2, _y_pivot-_pivot_xpm.h()/2);
    break;

  default:
    break;
  }


}

int mol_canvas::handle(int e){
  if(plugin()!=0 && plugin()->time_to_act()){
    plugin()->act(e);
    return 1;
  }

  

  //  editor* ed=dynamic_cast<editor*>(__la_finestra);
  //static float trx=10;
  //  static float trxm=0.5;
  //static float angl=0.1;
  switch(e){
  case FL_PASTE:
    std::cerr << "AHHOO" << std::endl;
    std::cerr << Fl::event_text() << std::endl;
    return 1;

  case FL_LEAVE:
    redraw();
    return 1;

  case FL_FOCUS:
    redraw();
    return 1;

  case FL_UNFOCUS:
    redraw();
    return 1;
      
  case FL_KEYDOWN:
    switch(Fl::event_key()){

    case FL_Up:
      switch(_action){
      case ACT_SCALE_SELECTED:
        {
          if(Fl::event_ctrl()){
            _la_molecola->scale_label_of_atom_selected(1.01);
          }else{
            _la_molecola->scala_selected(1.01);
          }
          redraw();
          break;
        }
      default:
        set_action_translate_selected_push_handle();
        _la_molecola->trasla_selected(0,-1);
        fl_cursor(FL_CURSOR_DEFAULT);
        redraw();
      }
      
      return 1;
    case FL_Down:
      switch(_action){

      case ACT_SCALE_SELECTED:
        {
          if(Fl::event_ctrl()){
            _la_molecola->scale_label_of_atom_selected(0.99);
          }else{
            _la_molecola->scala_selected(0.99);
          }
          redraw();
          break;
        }
      default:
        set_action_translate_selected_push_handle();
        _la_molecola->trasla_selected(0,1);
        fl_cursor(FL_CURSOR_DEFAULT);
        redraw();
        break;
      }
      
      return 1;

    case FL_Left:
      switch(_action){
      default:
        {
          set_action_translate_selected_push_handle();
          _la_molecola->trasla_selected(-1,0);
          fl_cursor(FL_CURSOR_DEFAULT);
          redraw();
          break;
        }

      }
      
      return 1;


    case FL_Right:
      switch(_action){
      default:
        {
          set_action_translate_selected_push_handle();
          _la_molecola->trasla_selected(1,0);
          fl_cursor(FL_CURSOR_DEFAULT);
          redraw();
          break;
        }

      }
      
      return 1;


      //DEBUG
    case '+':
      zoom(0.1,-w()/2,-h()/2);
      return 1;
    case '-':
      zoom(-0.1,-w()/2,-h()/2);
      return 1;

     case 'e':
       
       _la_molecola->PROVA_ISOMORPH();
       //_la_molecola->trasla(trx,0);
       redraw();
       return 1;
       break;	

    case 'l':
      {
        spectra_plot::plot_window p;
        p.add_spike(3000,50);
        p.add_group(_la_molecola->ritorna_gruppo(0),3000,50);
        p.show();
        while(p.shown()){
          Fl::wait();
        }
      }
      return 1;

//     case 'y':
//       _la_molecola->rotate_selected_3d(true, M_PI/10);
//       redraw();
//       return 1;
//     case 'q':
//       _la_molecola->ruota(120,120,angl);
//       redraw();
//       return 1;
//       break;
//     case 'w':
//       _la_molecola->ruota(120,120,-angl);
//       redraw();
//       return 1;
//       break;			 
//     case 'i':
//       cout << "i pressed" << endl;
//       _la_molecola->PROVA_TRASLA_MULTILINE();
//       redraw();
//       return 1;
//     case 'r':
//       {
// 	int dx_scr=(__la_finestra->ritorna_mol_canvas())->x();
// 	int dy_scr=(__la_finestra->ritorna_mol_canvas())->y();
// 	_la_molecola->paste(Fl::event_x()-dx_scr,Fl::event_y()-dy_scr);
// 	redraw();
// 	return 1;
//       }
//     case 's':
//       {

// 	return 1;
//       }	

//     case 'd':
//       if(_la_molecola->prova_click_atomo(&_start_atom,Fl::event_x(),Fl::event_y())>=0){
// 	cout << "iio_start_atom " <<  _start_atom << endl;
	
//       }
      

//       {
	
// 	float alfa=__pref.getBond_fixedangle();
// 	float length=__pref.getBond_fixedlength();
// 	_x_mouse=Fl::event_x();
// 	_y_mouse=Fl::event_y();
// 	_x_added_atom=_x_mouse+length*cos(alfa);
// 	_y_added_atom=_y_mouse+length*sin(alfa);

// 	genera_catena(10,M_PI/2);
	
// 	// _la_molecola->scale(0.99);
// 	redraw();
// 	return 1;
//       }
 
//       
    default:
      return 0;
    }


  case FL_DRAG:
    switch(_action){
    case ACT_SEL_ATOM:
    case ACT_SEL_BOX:
      redraw();
      return 1;

    case ACT_SCALE_SELECTED:
      {
      float dy=Fl::event_y()-_y_mouse;
      _y_mouse=Fl::event_y();
      _la_molecola->scala_selected(dy>0 ? 1.02 : 0.98);
      redraw();
      return 1;
      }

    case ACT_ROTATE_SELECTED:
      {
	//float dx=Fl::event_x()-_x_mouse;
	int dy=static_cast<int>(rintf(Fl::event_y()-_y_mouse));
	//	int dx=static_cast<int>(rintf(Fl::event_x()-_x_mouse));
	float ang_rot=0.05;
	if(dy<-2){
	  ang_rot=-ang_rot;
	  _x_mouse=Fl::event_x();
	  _y_mouse=Fl::event_y();
	}else if (dy >= -2 && dy <=2) {
	  ang_rot=0;
	}else{
	  _x_mouse=Fl::event_x();
	  _y_mouse=Fl::event_y();
	}
	_la_molecola->ruota_selected(ang_rot ,_x_pivot,_y_pivot);

	redraw();
	return 1;
      }
    case ACT_3D_ROT:
      {
      int dy=static_cast<int>(rintf(Fl::event_y()-_y_mouse));
      int dx=static_cast<int>(rintf(Fl::event_x()-_x_mouse));
      float ang_rot=-0.05;
      
      if(dy<-2){
	ang_rot=-ang_rot;
	_x_mouse=Fl::event_x();
	_y_mouse=Fl::event_y();
      }else if (dy >= -2 && dy <=2) {
	ang_rot=0;
      }else{
	_x_mouse=Fl::event_x();
	_y_mouse=Fl::event_y();
      }
      _la_molecola->rotate_selected_3d(true, ang_rot);
      
      ang_rot=-0.05;
      if(dx<-2){
	ang_rot=-ang_rot;
	_x_mouse=Fl::event_x();
	_y_mouse=Fl::event_y();
      }else if (dx >= -2 && dx <=2) {
	ang_rot=0;
      }else{
	_x_mouse=Fl::event_x();
	_y_mouse=Fl::event_y();
      }
      
      _la_molecola->rotate_selected_3d(false, ang_rot);
      
      redraw();
      return 1;
      }
    case ACT_TRANSLATE_SELECTED:
      {
	int dx=Fl::event_x()-_x_mouse;
	int dy=Fl::event_y()-_y_mouse;
	_x_mouse=Fl::event_x();
	_y_mouse=Fl::event_y();
	_la_molecola->trasla_selected(dx,dy);
	redraw();
	return 1;
      }
    case ACT_DRAW_SINGLE_BOND:
    case ACT_DRAW_DOUBLE_BOND:
    case ACT_DRAW_TRIPLE_BOND:
      if(_la_molecola->prova_click_atomo(&_end_atom,Fl::event_x(),Fl::event_y())<0 ){
	_la_molecola->elimina_elem_selected();
	_la_molecola->elimina_legami_selected();
	_end_atom=0;
      }


      redraw();
     return 1;

    case ACT_DRAW_ARROW:
      redraw();
      return 1;
      

    case ACT_DRAW_ARC:
      {
	_arc_max_ax=Fl::event_x()-_x_arc_centr;
	_arc_min_ax=Fl::event_y()-_y_arc_centr;
	redraw();
	return 1;
      }

    case ACT_EDIT_CONTROL_POINT_CURVES:
      int dx=Fl::event_x()-_x_mouse;
      int dy=Fl::event_y()-_y_mouse;
      _x_mouse=Fl::event_x();
      _y_mouse=Fl::event_y();
      _la_molecola->translate_control_points(dx, dy);
      redraw();
      return 1;

    }
    
 
  case FL_RELEASE:
    switch(_action){
    case ACT_SEL_ATOM:
      if(_b_construct_box){
	_b_construct_box=false;
      
	_la_molecola->aggiungi_se_dentro_bb(_x_mouse, _y_mouse, 
					    Fl::event_x()-_x_mouse , 
					    Fl::event_y()-_y_mouse);
      }
      break;
    case ACT_SEL_BOX:
      _la_molecola->aggiungi_se_dentro_bb(_x_mouse, _y_mouse, 
					  Fl::event_x()-_x_mouse , 
					  Fl::event_y()-_y_mouse);
      _b_construct_box=false;
      _action=ACT_SEL_ATOM;
      return 1;

    case ACT_TRANSLATE_SELECTED:
      fl_cursor(FL_CURSOR_DEFAULT);
      _x_mouse=0;
      _y_mouse=0;
      _action=ACT_SEL_ATOM;
      break;
    case ACT_DRAW_SINGLE_BOND:
      return aggiungi_nuovo_legame(LEGAME_SINGOLO);
    case ACT_DRAW_DOUBLE_BOND:
     return aggiungi_nuovo_legame(LEGAME_DOPPIO);
    case ACT_DRAW_TRIPLE_BOND:
      return aggiungi_nuovo_legame(LEGAME_TRIPLO);
    case ACT_DRAW_ARROW:
      if(_b_arrow_added){
	reg_modified();
	int mag_x=Fl::event_x();
	int mag_y=Fl::event_y();
	//testing magnetic
	attract_mouse_to_magnetic_point(&mag_x,&mag_y);

	_la_molecola->crea_freccia_nuova(_x_mouse, _y_mouse,
					 mag_x,mag_y);
	_b_arrow_added=false;
      }
      
      return 1;
    case ACT_DRAW_ARC:
      if(_arc_max_ax){
	reg_modified();
	_la_molecola->crea_ellisse_nuova(_x_arc_centr,_y_arc_centr, _arc_max_ax, _arc_min_ax);
	_arc_max_ax=0;
	redraw();
      }
      return 1;
    case ACT_ROTATE_SELECTED:
      fl_cursor(FL_CURSOR_DEFAULT);
      return 1;
    case ACT_EDIT_CONTROL_POINT_CURVES:
      _la_molecola->unset_selected_control_points();
      _action=ACT_SEL_ATOM;
      return 1;
    }

    return 1;


  case FL_PUSH:
    {
      if(Fl::event_clicks()==1 && Fl::event_button()==FL_LEFT_MOUSE){
        d_click_bond();
        Fl::event_is_click(0);
      }else{
        /*
        _la_molecola->PROVA_TRASLA_MULTILINE();
        return 1;
        */
        if(action()==ACT_NOTHING){
          return 0;
        }
      
        if(Fl::event_button()==FL_RIGHT_MOUSE){
          reg_modified();

          if(!_la_molecola->cambia_prop_atomo(Fl::event_x(), Fl::event_y())){
            _la_molecola->cambia_prop_legami(Fl::event_x(), Fl::event_y());
          }
	
          if(_la_molecola->cambia_prop_bezier(Fl::event_x(), Fl::event_y())){
	  
          }else if(_la_molecola->cambia_prop_frecce(Fl::event_x(), Fl::event_y())){

          }else if(_la_molecola->cambia_prop_arc(Fl::event_x(), Fl::event_y())){

          }else if(_la_molecola->cambia_prop_etichetta(Fl::event_x(), Fl::event_y())){
	  
          }else{

          }

        }else if(Fl::event_button()==FL_MIDDLE_MOUSE){
          switch(_action){
          case ACT_SCALE_SELECTED:
            _x_mouse=Fl::event_x();
            _y_mouse=Fl::event_y();
            return 1;

          case ACT_ROTATE_SELECTED:
            _x_pivot=Fl::event_x();
            _y_pivot=Fl::event_y();
            redraw();
            return 1;
          }
        }else{ // left mouse button pressed
          //editor* ed=dynamic_cast<editor*>(__la_finestra);
          switch(_action){

          case ACT_ZOOM:
            zoom(0.1,x()-Fl::event_x(),y()-Fl::event_y());
            return 1;

          case ACT_UNZOOM:
            zoom(-0.1,x()-Fl::event_x(),y()-Fl::event_y());
            return 1;

          case ACT_FLIP_VER:
            _la_molecola->flip(Fl::event_x(),Fl::event_y(),false);
            return 1;

          case ACT_FLIP_HOR:
            _la_molecola->flip(Fl::event_x(),Fl::event_y());
            return 1;
          case ACT_PASTE:
            {
              reg_modified();
              int dx_scr=(__la_finestra->ritorna_mol_canvas())->x();
              int dy_scr=(__la_finestra->ritorna_mol_canvas())->y();
              _la_molecola->paste(Fl::event_x()-dx_scr,Fl::event_y()-dy_scr);
              redraw();
              return 1;
            }
	  
          case ACT_DRAW_CHAIN:
            {
              if(_num_atom_chain>1){
                reg_modified();
                /*
                  int dx=(__la_finestra->ritorna_mol_canvas())->x();
                  int dy=(__la_finestra->ritorna_mol_canvas())->y();
                */
                if(_la_molecola->prova_click_atomo(&_start_atom,Fl::event_x(),Fl::event_y())>=0){
                  //cout << "_start_atom " <<  _start_atom << endl;
                }else{
                  float alfa=__pref.getBond_fixedangle();
                  float length=scale_z(__pref.getBond_fixedlength()); //*__pref.getZoom();
                  _x_mouse=Fl::event_x();
                  _y_mouse=Fl::event_y();

                  //testing magnetic
                  attract_mouse_to_magnetic_point(&_x_mouse,&_y_mouse);
		
                  _x_added_atom=static_cast<int>(rintf(_x_mouse+length*cos(alfa)));
                  _y_added_atom=static_cast<int>(rintf(_y_mouse+length*sin(alfa)));
		
                }
                genera_catena(_num_atom_chain,_orient_chain);
                redraw();
              }
              return 1;
            }

          case ACT_FIXED_ROTATION:
            reg_modified();
            _x_pivot=Fl::event_x();
            _y_pivot=Fl::event_y();
            _la_molecola->ruota_selected(_fixed_rotation_degree,_x_pivot,_y_pivot);
            redraw();
            return 1;

          case ACT_DRAW_ORB:
            {
              reg_modified();
              int cntx=Fl::event_x();
              int cnty=Fl::event_y();

	    

              //testing magnetic
              attract_mouse_to_magnetic_point(&cntx,&cnty);

              float wo=scale_z(10);
              float ho=scale_z(20);
              vector< pair<float,float> > punti;
              pair<float,float> primo(cntx,cnty);
              punti.push_back(primo);

              primo.first=cntx-wo;
              primo.second=cnty+ho;
              punti.push_back(primo);

              primo.first=cntx+wo;
              primo.second=cnty+ho;
              punti.push_back(primo);

              primo.first=cntx+0.001;
              primo.second=cnty;
              punti.push_back(primo);

	    
              _la_molecola->crea_bezier_nuova(punti);

              punti[1].second=cnty-ho;
              punti[2].second=cnty-ho;

              _la_molecola->crea_bezier_nuova(punti);

              redraw();
              return 1;
            }
          case ACT_SCALE_SELECTED:
            reg_modified();
            return 1;
	  
          case ACT_ROTATE_SELECTED:
            fl_cursor(FL_CURSOR_NS);
            _x_mouse=Fl::event_x();
            _y_mouse=Fl::event_y();
            reg_modified();
            return 1;

          case ACT_TRANSLATE_SELECTED:
            set_action_translate_selected_push_handle();
            reg_modified();
            return 1;
          case ACT_DRAW_SINGLE_BOND:
          case ACT_DRAW_DOUBLE_BOND:
          case ACT_DRAW_TRIPLE_BOND:
            {
              reg_modified();
              int dx=(__la_finestra->ritorna_mol_canvas())->x();
              int dy=(__la_finestra->ritorna_mol_canvas())->y();
              _b_bond_added=false;
              if(_la_molecola->prova_click_atomo(&_start_atom,Fl::event_x(),Fl::event_y())>=0){
                //cout << "_start_atom " <<  _start_atom << endl;
                _y_mouse=static_cast<int>(rintf(_start_atom->pos_y()+dy));
                _x_mouse=static_cast<int>(rintf(_start_atom->pos_x()+dx));
              }else{

                _x_mouse=Fl::event_x();
                _y_mouse=Fl::event_y();

                //testing magnetic
                attract_mouse_to_magnetic_point(&_x_mouse,&_y_mouse);

              }
	    
              redraw();
            }
            return 1;

          case ACT_DRAW_ARROW:
            _x_mouse=Fl::event_x();
            _y_mouse=Fl::event_y();
            //testing magnetic
            attract_mouse_to_magnetic_point(&_x_mouse,&_y_mouse);
            _b_arrow_added=true;
            return 1;

          case ACT_DRAW_BEZIER:
            //	  cout << "_bezier_point " << _bezier_point.size() << endl;
            if(_bezier_point.size()<3){
              //cout << "kk"<< endl;
              pair<float,float> punti;
              int mag_x=Fl::event_x();
              int mag_y=Fl::event_y();
              //testing magnetic
              attract_mouse_to_magnetic_point(&mag_x,&mag_y);
	    
              punti.first=mag_x;
              punti.second=mag_y;
              _bezier_point.push_back(punti);
            }else{
              reg_modified();
              pair<float,float> punti;

              int mag_x=Fl::event_x();
              int mag_y=Fl::event_y();
              //testing magnetic
              attract_mouse_to_magnetic_point(&mag_x,&mag_y);
	    
              punti.first=mag_x;
              punti.second=mag_y;

              _bezier_point.push_back(punti);
              _la_molecola->crea_bezier_nuova(_bezier_point);
              _bezier_point.erase(_bezier_point.begin(),_bezier_point.end());

            }
            redraw();
            return 1;

          case ACT_DRAW_ARC:
            {
              int mag_x=Fl::event_x();
              int mag_y=Fl::event_y();
              //testing magnetic
              attract_mouse_to_magnetic_point(&mag_x,&mag_y);
              _x_arc_centr=mag_x;
              _y_arc_centr=mag_y;
            }
            return 1;
	  
          case ACT_DRAW_ETICH:
            {
              reg_modified();
              int dx=(__la_finestra->ritorna_mol_canvas())->x();
              int dy=(__la_finestra->ritorna_mol_canvas())->y();
              int mag_x=Fl::event_x();
              int mag_y=Fl::event_y();
              //testing magnetic
              attract_mouse_to_magnetic_point(&mag_x,&mag_y);
	    

              //etichetta* dummy=new multifont_label();
              //etichetta* dummy=new multiline_label();
              etichetta* dummy=new paragraph_text;
              dummy->x(descale(mag_x-dx));
              dummy->y(descale(mag_y-dy));
              _la_molecola->elimina_legami_selected();
              _la_molecola->elimina_elem_selected();

              _la_molecola->add_etich(dummy);
              _la_molecola->aggiungi_elem_selected(ETICHETTA,NO_VALID_GROUP,
                                                   _la_molecola->numero_etichetta()-1);
              _la_molecola->highlight_selected();
              //multiline_label_prop p(_la_molecola->ritorna_punt_etich(_la_molecola->numero_etichetta()-1) );

              paragraph_text_prop p(_la_molecola->ritorna_punt_etich(_la_molecola->numero_etichetta()-1) );
              p.show();
              while(p.shown()){
                Fl::wait();
              }

              _la_molecola->elimina_legami_selected();
              _la_molecola->elimina_elem_selected();
              break;
            }
          case ACT_SEL_BOX:
            _x_mouse=Fl::event_x();
            _y_mouse=Fl::event_y();
            _b_construct_box=true;
            return 1;
	  
          case ACT_SEL_ATOM:
            {
              bool has_hitted=false;
              bool no_incremental_sel=true;
              bool exists;
              if(_la_molecola->check_control_point_procedura_under_mouse(Fl::event_x(), 
                                                                         Fl::event_y())){ 
                // procedura control points editing

                //fl_cursor(FL_CURSOR_MOVE);
                _x_mouse=Fl::event_x();
                _y_mouse=Fl::event_y();
                reg_modified();
                _action=ACT_EDIT_CONTROL_POINT_CURVES;
              }else{
                if(_la_molecola->check_exists_in_elem_selected(Fl::event_x(), 
                                                               Fl::event_y(),exists)){
                  set_action_translate_selected_push_handle();
                }else{
		
                  if(Fl::event_key(FL_Control_L)){
                    no_incremental_sel=false;
                  }

                  has_hitted=_la_molecola->prova_click(Fl::event_x(), 
                                                       Fl::event_y(),
                                                       exists,
                                                       no_incremental_sel);
		
                  if(!has_hitted){
                    _x_mouse=Fl::event_x();
                    _y_mouse=Fl::event_y();
                    _b_construct_box=true;
                    _action=ACT_SEL_BOX;
                  }
                }
              }
              break;
            }
          case ACT_SEL_GROUP:
            {
              bool exists=true;
              if(_la_molecola->check_exists_in_elem_selected(Fl::event_x(), 
                                                             Fl::event_y(),exists)){
                set_action_translate_selected_push_handle();
              }else{
                _la_molecola->click_gruppo(Fl::event_x(), 
                                           Fl::event_y());
              }
              break;
            }
          case ACT_KILL:
            reg_modified();
            bool dummy;
            _la_molecola->prova_click(Fl::event_x(), 
                                      Fl::event_y(),
                                      dummy,true);
	  
            _la_molecola->cancella_elementi_selected();
            _la_molecola->elimina_elem_selected();
            _la_molecola->elimina_legami_selected();
	  
            break;
          }
        }
        return 1;
      }
    }
  default:
    return Fl_Widget::handle(e);
    break;
   
  }
}


void mol_canvas::draw_preview_bond(int tip){
  
  //#define LENGHT_BOND 15.0f
  
  /**
   *Angolo legame in radianti
   */
  
  //#define ANGL_BOND  .26179938779914943653f

  fl_color(COMP_R_EV,COMP_G_EV,COMP_B_EV);
  float length=static_cast<float>(__pref.getBond_fixedlength() * __pref.getZoom()); //LENGHT_BOND;
  float angl=static_cast<float>(__pref.getBond_fixedangle()); //ANGL_BOND;


  
  switch(tip){
  case ACT_DRAW_DOUBLE_BOND:
  case ACT_DRAW_SINGLE_BOND:
  case ACT_DRAW_TRIPLE_BOND:
    {
	
      float alfa_l=atan2(static_cast<float>(Fl::event_y()-_y_mouse),
			 static_cast<float>(Fl::event_x()-_x_mouse)
			 );
      int alfa_i=static_cast<int>(rintf(alfa_l/angl));
    
      alfa_l=alfa_i*angl;
      _x_added_atom=static_cast<int>(_x_mouse+rintf(length*cos(alfa_l)));
      _y_added_atom=static_cast<int>(_y_mouse+rintf(length*sin(alfa_l)));

      if(_end_atom==0){
	fl_line(_x_mouse, _y_mouse, _x_added_atom, _y_added_atom);
      }else{
	int dx_scr=(__la_finestra->ritorna_mol_canvas())->x();
	int dy_scr=(__la_finestra->ritorna_mol_canvas())->y();
	fl_line(_x_mouse, _y_mouse, 
		static_cast<int>(rintf(_end_atom->pos_x()+dx_scr)),
		static_cast<int>(rintf(_end_atom->pos_y()+dy_scr)));
      }
      break;
    }
  }

}


void mol_canvas::genera_catena(unsigned int n_carb, float orient){
  _la_molecola->elimina_elem_selected();
  _la_molecola->elimina_legami_selected();  

  //  cout << "iio" << _start_atom << endl;
  float alfa=__pref.getBond_fixedangle();
  float length=scale_z(__pref.getBond_fixedlength());

  if(_start_atom){
  
    bool sopra=true;
    float xpiv=_start_atom->pos_x();
    float ypiv=_start_atom->pos_y();
    float x_addtmp= static_cast<int>(rintf(_start_atom->pos_x()));
    float y_addtmp= static_cast<int>(rintf(_start_atom->pos_y()));

    
    for(unsigned int i=0;i<n_carb;i++){
      x_addtmp+=static_cast<int>(length*cos(alfa));
      y_addtmp+=static_cast<int>(length*sin(alfa));

      float x=x_addtmp-xpiv;
      float y=y_addtmp-ypiv;
      float xp=x*cos(orient)+y*sin(orient);
      float yp=y*cos(orient)-x*sin(orient);
      
      _x_added_atom=static_cast<int>(rintf(xp+xpiv));
      _y_added_atom=static_cast<int>(rintf(yp+ypiv));

      
      if(sopra){
	alfa-=__pref.getBond_fixedangle()*2;
	sopra=false;
      }else{
	alfa+=__pref.getBond_fixedangle()*2;
	sopra=true;
      }


      _start_atom=_la_molecola->crea_legame_nuovo(_start_atom, 
						  _x_added_atom, 
						  _y_added_atom,  
						  LEGAME_SINGOLO);
    }
    _start_atom=0;
  }else{

    float x= _x_added_atom-_x_mouse;
    float y=_y_added_atom-_y_mouse;
    float xp=x*cos(orient+alfa*2)+y*sin(orient+alfa*2);
    float yp=y*cos(orient+alfa*2)-x*sin(orient+alfa*2);
    
    _x_added_atom=static_cast<int>(rintf(xp+_x_mouse));
    _y_added_atom=static_cast<int>(rintf(yp+_y_mouse));
    
    
    _start_atom=_la_molecola->crea_legame_nuovo(_x_mouse, _y_mouse, 
						_x_added_atom, _y_added_atom, 
						LEGAME_SINGOLO);
    genera_catena(n_carb-2, orient);
  }

}




int mol_canvas::aggiungi_nuovo_legame(int tipo){

  if(!_b_bond_added){
    _la_molecola->elimina_elem_selected();
    _la_molecola->elimina_legami_selected();
    //float dx=Fl::event_x()-_x_mouse;
    //float dy=Fl::event_y()-_y_mouse;
    int dx_scr=(__la_finestra->ritorna_mol_canvas())->x();
    int dy_scr=(__la_finestra->ritorna_mol_canvas())->y();
    //float lung_att=sqrt( pow(static_cast<float>(dx),2)+
    //			 pow(static_cast<float>(dy),2)  );
    //float length=static_cast<float>(__pref.getBond_fixedlength()); //LENGHT_BOND;
	
    if(_start_atom){
      if(_end_atom){
	_la_molecola->crea_legame_nuovo(_start_atom, _end_atom, tipo);
      }else{
	_la_molecola->crea_legame_nuovo(_start_atom, 
					_x_added_atom-dx_scr, _y_added_atom-dy_scr,  
					tipo); 
      }
    }else{
      if(_end_atom){
	_la_molecola->crea_legame_nuovo(_end_atom, 
					_x_mouse-dx_scr, _y_mouse-dy_scr,  
					tipo); 
      }else{
	_la_molecola->crea_legame_nuovo(_x_mouse, _y_mouse, 
					_x_added_atom, _y_added_atom, tipo);
      }
    }
    _start_atom=0;
    _end_atom=0;
    _b_bond_added=true;
    redraw();
  }
  return 1;


}


void mol_canvas::reg_modified(){
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  //_la_molecola->elimina_elem_selected();
  //_la_molecola->elimina_legami_selected();
  ed->register_images_undo(_la_molecola);
  _la_molecola=__la_finestra->ritorna_immagine();
}


bist_plugin* mol_canvas::plugin(){
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  if(ed!=0){
    return ed->actual_plugin();
  }else{
    return 0;
  }
  
}

void mol_canvas::zoom(float entity,int traslx, int trasly){
  float nwzoom=__pref.getZoom()+entity;
  if(nwzoom>0 && 
     static_cast<int>(rintf(__pref.getPageWidth()*nwzoom)) > 30 &&
     static_cast<int>(rintf(__pref.getPageHeight()*nwzoom)) > 30){
    __pref.setZoom(__pref.getZoom()+entity);
    
    resize(x(),y(),
	   static_cast<int>(rintf(__pref.getPageWidth()*__pref.getZoom())),
	   static_cast<int>(rintf(__pref.getPageHeight()*__pref.getZoom())));
    
    if(w() > parent()->w() || h() > parent()->h()){
      position(parent()->w()/2+traslx,parent()->h()/2+trasly);
    }else{
      position(parent()->x(),parent()->y());
    }
  
    redraw();
    parent()->redraw();
  }
}

void mol_canvas::set_action_translate_selected_push_handle(){
  fl_cursor(FL_CURSOR_MOVE);
  _x_mouse=Fl::event_x();
  _y_mouse=Fl::event_y();
  reg_modified();
  _action=ACT_TRANSLATE_SELECTED;
}



void mol_canvas::d_click_bond(){
  reg_modified();
  bool dummy;
  _la_molecola->elimina_elem_selected();
  _la_molecola->elimina_legami_selected();


  _la_molecola->prova_click(Fl::event_x(), 
                            Fl::event_y(),
                            dummy,true);
  
  _la_molecola->shift_type_bond_selected();
  _la_molecola->elimina_elem_selected();
  _la_molecola->elimina_legami_selected();
	  

}


void mol_canvas::PROVAMULTIBYTE(){
  /*
  paragraph_text* p=new paragraph_text();
  multifont_label* p1=new multifont_label();
  p1->insert_string_in_curr_pos("p",ET_STR);
  p1->insert_string_in_curr_pos("i",ET_STR);
  p1->insert_string_in_curr_pos("p",ET_STR);
  p->add_line(p1);
 
  multifont_label* p2=new multifont_label();
  p2->insert_string_in_curr_pos("p",ET_STR);
  p2->insert_string_in_curr_pos("l",ET_STR);
  p2->insert_string_in_curr_pos("u",ET_STR);
  p->add_line(p2);
 
  _la_molecola->add_etich(p);  
  */
  /*
  return;
  multiline_label* p=new multiline_label();
  p->treat_as_a_whole(true);
  p->x(25);
  p->y(25);
  etichetta*  tmp=new etichetta();
  std::cerr << "creata " << tmp << std::endl;
  tmp->aggiungi("prova",ET_STR);
  etichetta*  tmp2=new etichetta();
  std::cerr << "creata " << tmp2 << std::endl;
  tmp2->aggiungi("prova2",ET_STR);
  
  etichetta*  tmp3=new etichetta();
  std::cerr << "creata " << tmp3 << std::endl;
  tmp3->aggiungi("prova3",ET_STR);
  
  
  etichetta*  tmp4=new etichetta();
  std::cerr << "creata " << tmp4 << std::endl;
  tmp4->aggiungi("prova4",ET_STR);
  
  
  p->add_line(tmp);
  p->add_line(tmp2);
  p->add_line(tmp3);
  p->add_line(tmp4);
  
  _la_molecola->add_etich(p);
  */  
}
