/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
// generated by Fast Light User Interface Designer (fluid) version 1.0104

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Help_Dialog.H>





#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>


#include <bezier_prop.hpp>

#include <finestra_pr.hpp>
#include <editor.hpp>


extern finestra_pr* __la_finestra;



void bezier_prop_type_cb(Fl_Widget* w, void* d){
  bezier_prop* arrp=dynamic_cast<bezier_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  Fl_Menu_Button* the_menu=dynamic_cast<Fl_Menu_Button*>(w);
  const Fl_Menu_Item* the_type=the_menu->mvalue();
  BEZIER_PROP_SIZE_USER_DATA_MENU type_arrow=reinterpret_cast<BEZIER_PROP_SIZE_USER_DATA_MENU>(the_type->user_data());
  arrp->_bezier->punte(type_arrow);
  ed->redraw();
}

void bezier_prop_color_cb(Fl_Widget* w, void* d){
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  bezier_prop* propr=dynamic_cast<bezier_prop*>(w->parent());
  if(pushd){
    propr->_bezier->cr(r);
    propr->_bezier->cg(g);
    propr->_bezier->cb(b);
    ed->redraw();
  }
}

void bezier_prop_ok_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();

}

void bezier_prop_cancel_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();
}

void bezier_prop_width_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  bezier_prop* arrp=dynamic_cast<bezier_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arrp->_bezier->spessore(static_cast<int>(sl->value()));
  ed->redraw();
}

void bezier_prop_tick_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  bezier_prop* arrp=dynamic_cast<bezier_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arrp->_bezier->dash(static_cast<int>(sl->value()));
  ed->redraw();
}


void bezier_prop_width_arr_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  bezier_prop* arrp=dynamic_cast<bezier_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arrp->_bezier->arr_w(static_cast<int>(sl->value()));
  ed->redraw();
}


void bezier_prop_height_arr_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  bezier_prop* arrp=dynamic_cast<bezier_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arrp->_bezier->arr_h(static_cast<int>(sl->value()));
  ed->redraw();
}

void bezier_prop_gap_arr_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  bezier_prop* arrp=dynamic_cast<bezier_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arrp->_bezier->arr_gap(sl->value());
  ed->redraw();
}

bezier_prop::~bezier_prop(){

}

/*
   _arrow(arr),
   _tipo(0)
 {
      
   { 
     Fl_Box* o = new Fl_Box(5, 20, 345, 200, _("Arrow properties"));
     o->box(FL_ENGRAVED_BOX);
     o->align(FL_ALIGN_TOP_LEFT);
   }
   
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(110, 25, 210, 25, _("Tickness:"));
     o->type(FL_HORIZONTAL);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 30);
     o->precision(0);
     o->value(_arrow->dash());
     o->callback(arrow_prop_tick_cb);
   }
    
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(110, 52, 210, 25, _("Width:"));
     o->type(FL_HORIZONTAL);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 10);
     o->precision(0);
     o->value(_arrow->spessore());
     o->callback(arrow_prop_width_cb);
   }

   


   Fl_Button* tipo=new Fl_Button(122, 170, 55, 30, _("Type"));
   tipo->callback(arrow_prop_type_cb);
   add(tipo);

   
   

   colore->callback(arrow_prop_color_cb);
   add(colore);
   

   ok->callback(arrow_prop_ok_cb);
   add(ok);


   annulla->callback(arrow_prop_cancel_cb);
   add(annulla);
   
   end();
   set_modal();


*/


bezier_prop::bezier_prop(proc_bezier* arr)
  :Fl_Double_Window(455, 275),
   _bezier(arr)
 {
      
   { Fl_Box* o = new Fl_Box(5, 20, 445, 200, _("Bezier properties"));
   o->box(FL_ENGRAVED_BOX);
   o->align(FL_ALIGN_TOP_LEFT);
   }
   
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(200, 25, 210, 25, _("Dash step:"));
     o->type(1);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 30);
     o->precision(0);
     o->value(_bezier->dash());
     o->callback(bezier_prop_tick_cb);
   }
    
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(200, 52, 210, 25, _("Thickness:"));
     o->type(1);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 10);
     o->precision(0);
     o->value(_bezier->spessore());
     o->callback(bezier_prop_width_cb);
   }

   
   Fl_Value_Slider* arr_w = new Fl_Value_Slider(200, 79, 210, 25, _("Arrow width:"));
   arr_w->type(FL_HORIZONTAL);
   arr_w->step(1);
   arr_w->align(FL_ALIGN_LEFT);
   arr_w->range(0, 50);
   arr_w->precision(0);
   arr_w->value(_bezier->arr_w());
   arr_w->callback(bezier_prop_width_arr_cb);
   

   Fl_Value_Slider* arr_h = new Fl_Value_Slider(200, 107, 210, 25, _("Arrow height:"));
   arr_h->type(FL_HORIZONTAL);
   arr_h->step(1);
   arr_h->align(FL_ALIGN_LEFT);
   arr_h->range(0, 50);
   arr_h->precision(0);
   arr_h->value(_bezier->arr_h());
   arr_h->callback(bezier_prop_height_arr_cb);

   Fl_Value_Slider* arr_gap = new Fl_Value_Slider(200, 134, 210, 25, _("Arrow gap:"));
   arr_gap->type(FL_HORIZONTAL);
   arr_gap->step(0.01);
   arr_gap->align(FL_ALIGN_LEFT);
   arr_gap->range(0, 0.99);
   arr_gap->precision(2);
   arr_gap->value(_bezier->arr_gap());
   arr_gap->callback(bezier_prop_gap_arr_cb);


   /*
     #define ARR_NO_PUNT      1
     #define ARR_OMOL_PUNT    2
     #define ARR_ETEROL_PUNT  3
     #define ARR_DOUBLE       4
     #define ARR_BLOC         5
     #define ARR_EQ           6
     
   */

   Fl_Menu_Item bezier_prop_type_of_arrow_menu_item[] = {
     {_("none"), 0, 0, reinterpret_cast<void*>(ARR_NO_PUNT)},
     {_("homolitic"), 0, 0, reinterpret_cast<void*>(ARR_OMOL_PUNT)},
     {_("heterolitic"), 0, 0, reinterpret_cast<void*>(ARR_ETEROL_PUNT)},
     {_("double"), 0, 0, reinterpret_cast<void*>(ARR_DOUBLE)},
     {0}
   };

   Fl_Menu_Button* type_arr=new Fl_Menu_Button(w()/2-77, 170, 77, 30, _("Type"));
   type_arr->copy(bezier_prop_type_of_arrow_menu_item);
   type_arr->callback(bezier_prop_type_cb);
   type_arr->align(FL_ALIGN_LEFT | FL_ALIGN_INSIDE);
   add(type_arr);

   
   Fl_Button* colore=new Fl_Button(w()/2, 170, 55, 30, _("Color"));
   colore->callback(bezier_prop_color_cb);
   add(colore);
   
   Fl_Return_Button* ok=new Fl_Return_Button(w()/2-65/2, 235, 65, 30, _("OK"));
   ok->callback(bezier_prop_ok_cb);
   add(ok);

   /*
   Fl_Button* annulla=new Fl_Button(182, 235, 65, 30, _("Cancel"));
   annulla->callback(bezier_prop_cancel_cb);
   add(annulla);
   */
   end();
   set_modal();
}

void bezier_win(proc_bezier* at){
  bezier_prop p(at);
  p.show();
  Fl::run();
  
}
