/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// generated by Fast Light User Interface Designer (fluid) version 1.0104

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Help_Dialog.H>




#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>


#include <arc_prop.hpp>

#include <finestra_pr.hpp>
#include <editor.hpp>


extern finestra_pr* __la_finestra;


void arc_prop_color_cb(Fl_Widget* w, void* d){
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arc_prop* propr=dynamic_cast<arc_prop*>(w->parent());
  if(pushd){
    propr->_arc->cr(r);
    propr->_arc->cg(g);
    propr->_arc->cb(b);
    ed->redraw();
  }
}

void arc_prop_ok_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();

}

void arc_prop_cancel_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();
}

void arc_prop_width_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  arc_prop* arrp=dynamic_cast<arc_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arrp->_arc->spessore(static_cast<int>(sl->value()));
  ed->redraw();
}

void arc_prop_tick_cb(Fl_Widget* w, void* d){

  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  arc_prop* arrp=dynamic_cast<arc_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(__la_finestra);
  arrp->_arc->dash(static_cast<int>(sl->value()));
  ed->redraw();
}

arc_prop::~arc_prop(){

}

arc_prop::arc_prop(proc_arc* arr)
  :Fl_Double_Window(310, 171),
   _arc(arr)
 {
      
   { Fl_Box* o = new Fl_Box(5, 20, 300, 110, _("Arc properties"));
   o->box(FL_ENGRAVED_BOX);
   o->align(FL_ALIGN_TOP_LEFT);
   }
   
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(80, 25, 210, 25, _("Thickness:"));
     o->type(1);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 30);
     o->precision(0);
     o->value(_arc->dash());
     o->callback(arc_prop_tick_cb);
   }
    
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(80, 52, 210, 25, _("Width:"));
     o->type(1);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 10);
     o->precision(0);
     o->value(_arc->spessore());
     o->callback(arc_prop_width_cb);
   }

   
   Fl_Button* colore=new Fl_Button(132, 92, 54, 30, _("Color"));
   colore->callback(arc_prop_color_cb);
   add(colore);
   
   Fl_Button* ok=new Fl_Button(95, 135, 65, 30, _("OK"));
   ok->callback(arc_prop_ok_cb);
   add(ok);

   Fl_Button* annulla=new Fl_Button(160, 135, 65, 30, _("Cancel"));
   annulla->callback(arc_prop_cancel_cb);
   add(annulla);
   
   end();
   set_modal();
}

void arc_win(proc_arc* at){
  arc_prop p(at);
  p.show();
  Fl::run();
  
}
