/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/**
 *Questa  classe  rappresenta  l'interfaccia  che tutte  le  classi  che
 *disegnano qualcosa devono implementare.
 *
 */


class disegnabile {

public:
  /**
   *Disegna l'oggetto PARAMETRI DA DEFINIRE!!!!!!
   */


  virtual ~disegnabile(){ };

  virtual void disegna()=0;

  /**
   *Scala l'oggetto
   *
   *\param sc il fattore di scala
   */

  virtual void scale(float sc)=0;

  /**
   *Ruota l'oggetto in senso orario.
   *
   *\param angl l'angolo di rotazione in radianti in senso orario
   *\param xpivot ascissa relativa all'asse di rotazione
   *\param ypivot ordinata relativa all'asse di rotazione
   *
   */

  virtual void ruota(float xpiv, float ypiv,float angl)=0;

  /**
   *Trasla l'oggetto.
   *
   *\param dx entita' dello spostamento lungo l'ascissa
   *\param dy entita' dello spostamento lungo l'ordinata
   */

  virtual void trasla(float dx, float dy)=0;

};


/**
 *Rappresenta un'oggetto selezionabile
 *
 */

class selezionabile {

public:

  virtual ~selezionabile(){ }
  /**
   *
   *\param x ascissa dell'angolo in alto a sinistra della bounding box
   *\param y ordinata dell'angolo in alto a sinistra della bounding box
   *\param w larghezza della bounding box
   *\param h altezza della bounding box
   *\return  true se  l'oggetto e'  dentro la  bounding  box specificata
   *false altrimenti.
   */

  virtual bool dentro_bb(float x, float y, float w , float h)=0;

  /**
   *
   *\param posx_m ascissa del puntatore
   *\param ordinata del puntatore
   *\return l'id di questo oggetto se il mouse si trova all'interno della
   *sua bounding box, -1 altrimenti.
   */
  virtual int sotto_mouse(int posx_m, int posy_m)=0;

};


/**
 *Rappresenta un'oggetto che e' identificabile univocamente
 */

class identificabile {

public:
  virtual ~identificabile(){ }
  virtual int id()=0;

};

/**
 *Rappresenta un'oggetto che possiede un genitore
 */

class genitore {

public:
  genitore();
  genitore(const genitore& altro);
  genitore(const genitore* altro);
  genitore& operator=(const genitore& altro);

  virtual ~genitore(){ }
  virtual void aggiungi_genitore(genitore* gtr);
  virtual genitore* ritorna_genitore();
protected:
  genitore* _il_genitore;

};


