/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __METADATA_DEFINES_H__
#define __METADATA_DEFINES_H__

#define METADATA_TYPE "type"

#define METADATA_FILE_URI "uri"
#define METADATA_FILE_SIZE "size"
#define METADATA_FILE_MTIME "mtime"
#define METADATA_FILE_MIMETYPE "mimetype"

#define METADATA_IMAGE_MAKE "make"
#define METADATA_IMAGE_MODEL "model"
#define METADATA_IMAGE_DATE_TIME "datetime"
#define METADATA_IMAGE_DATE_TIME_ORIGINAL "datetimeoriginal"
#define METADATA_IMAGE_DATE_TIME_DIGITIZED "datetimedigitized"
#define METADATA_IMAGE_ORIENTATION "orientation"
#define METADATA_IMAGE_EXPOSURE_TIME "exposure"
#define METADATA_IMAGE_APERTURE_VALUE "aperture"
#define METADATA_IMAGE_METERING_MODE "meteringmode"
#define METADATA_IMAGE_FLASH "flash"
#define METADATA_IMAGE_FOCAL_LENGTH "focallength"
#define METADATA_IMAGE_SHUTTER_SPEED "shutterspeed"
#define METADATA_IMAGE_ISO "iso"
#define METADATA_IMAGE_SOFTWARE "software"
#define METADATA_IMAGE_TITLE "title"
#define METADATA_IMAGE_COMMENT "comment"
#define METADATA_IMAGE_USER_COMMENT "usercomment"
#define METADATA_IMAGE_AUTHOR "author"
#define METADATA_IMAGE_COPYRIGHT "copyright"
#define METADATA_IMAGE_KEYWORDS "keywords"
#define METADATA_IMAGE_SUBJECT "subject"
#define METADATA_IMAGE_WIDTH "width"
#define METADATA_IMAGE_HEIGHT "height"

#define METADATA_AUDIO_TITLE "title"
#define METADATA_AUDIO_ARTIST "artist"
#define METADATA_AUDIO_ALBUM "album"
#define METADATA_AUDIO_GENRE "genre"
#define METADATA_AUDIO_YEAR "year"
#define METADATA_AUDIO_COMMENT "comment"
#define METADATA_AUDIO_DURATION "duration"
#define METADATA_AUDIO_TRACK "track"
#define METADATA_AUDIO_TOTAL_TRACKS "totaltracks"
#define METADATA_AUDIO_DISC "disc"
#define METADATA_AUDIO_TOTAL_DISCS "totaldiscs"
#define METADATA_AUDIO_PERFORMERS "performers"
#define METADATA_AUDIO_COPYRIGHT "copyright"
#define METADATA_AUDIO_LICENSE "license"
#define METADATA_AUDIO_ORGANISATION "organisation"
#define METADATA_AUDIO_CONTACT "contact"
#define METADATA_AUDIO_ISRC "isrc"
#define METADATA_AUDIO_CONDUCTOR "conductor"
#define METADATA_AUDIO_COMPOSER "composer"
#define METADATA_AUDIO_ARTIST_IMAGE "artistimage"

#define METADATA_VIDEO_TITLE "title"
#define METADATA_VIDEO_DIRECTOR "director"
#define METADATA_VIDEO_SERIES_NAME "series"
#define METADATA_VIDEO_SEASON "season"
#define METADATA_VIDEO_EPISODE "episode"
#define METADATA_VIDEO_YEAR "year"
#define METADATA_VIDEO_WIDTH "width"
#define METADATA_VIDEO_HEIGHT "height"
#define METADATA_VIDEO_SERIES_IMAGE "seriesimage"
#define METADATA_VIDEO_DISC "disc"

#define METADATA_EXTENDED_DATE_INDEXED "indexed-on"
#define METADATA_EXTENDED_THUMBNAIL "thumbnail"

#define METADATA_BROKEN_REASON "reason"

#define AUDIO_TYPE "audio"
#define IMAGE_TYPE "image"
#define VIDEO_TYPE "video"
#define BROKEN_TYPE "broken"
#define PLAYLIST_TYPE "playlist"

#endif
