/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_SOURCE_H__
#define __BKL_SOURCE_H__

#include <kozo.h>

#include <bickley/bkl-db.h>
#include <bickley/bkl-item.h>

G_BEGIN_DECLS

#define BKL_TYPE_SOURCE (bkl_source_get_type())
#define BKL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BKL_TYPE_SOURCE, BklSource))
#define BKL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BKL_TYPE_SOURCE, BklSourceClass))
#define IS_BKL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BKL_TYPE_SOURCE))
#define IS_BKL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BKL_TYPE_SOURCE))
#define BKL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BKL_TYPE_SOURCE, BklSourceClass))

typedef struct _BklSource BklSource;
struct _BklSource {
    GObject parent;

    BklDB *db;
    char *name;
    gboolean more_work;

    gboolean working;
};

typedef struct _BklSourceClass {
    GObjectClass parent_class;

    /* Methods */
    gboolean (*do_work) (BklSource *source);
    void (*investigate_files) (BklSource *source,
                               GPtrArray *files);
    void (*remove_files) (BklSource *source,
                          GPtrArray *files);
    gboolean (*add_item) (BklSource  *source,
                          const char *uri,
                          BklItem    *item,
                          GError    **error);
    void (*destroy) (BklSource *source);
} BklSourceClass;

GType bkl_source_get_type (void);
gboolean bkl_source_do_work (BklSource *source);
void bkl_source_investigate_files (BklSource *source,
                                   GPtrArray *files);
void bkl_source_remove_files (BklSource *source,
                              GPtrArray *files);
gboolean bkl_source_add_item (BklSource  *source,
                              const char *uri,
                              BklItem    *item,
                              GError    **error);
void bkl_source_destroy (BklSource *source);

void bkl_source_uri_changed (BklSource  *source,
                             const char *uri);
void bkl_source_uri_added (BklSource  *source,
                           const char *uri);
void bkl_source_uri_deleted (BklSource  *source,
                             const char *uri);
void bkl_source_in_progress (BklSource *source);
void bkl_source_completed (BklSource *source);
void bkl_source_index_changed (BklSource *source,
                               GPtrArray *added,
                               GPtrArray *removed);

G_END_DECLS

#endif
